/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository;

import java.util.Collection;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.squashtest.tm.domain.project.AutomationWorkflowType;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.service.annotation.EmptyCollectionGuard;
import org.squashtest.tm.service.internal.repository.CustomTestCaseDao;

public interface TestCaseDao
extends JpaRepository<TestCase, Long>,
CustomTestCaseDao {
    @Query(value="select distinct callStep.calledTestCase.id\nfrom CallTestStep callStep\nwhere callStep.testCase.id = :id")
    public List<Long> findAllDistinctTestCasesIdsCalledByTestCase(@Param(value="id") long var1);

    @Query(value="select tc.id\nfrom TestCase tc\njoin tc.milestones stones\nwhere tc.id in (:nodeIds)\ngroup by tc.id\nhaving count(stones) > 1")
    @EmptyCollectionGuard
    public List<Long> findNodeIdsHavingMultipleMilestones(@Param(value="nodeIds") Collection<Long> var1);

    @Query(value="select tc.id\nfrom TestCase tc\nwhere tc.id in (:nodeIds)\nand tc.id not in (select tcs.id from Milestone m join m.testCases tcs where m.id = :milestoneId)")
    @EmptyCollectionGuard
    public List<Long> findNonBoundTestCases(@Param(value="nodeIds") Collection<Long> var1, @Param(value="milestoneId") Long var2);

    @Query(value="select distinct tc.id\nfrom TestCase tc\njoin tc.milestones milestones\nwhere milestones.id in (:milestoneIds)")
    @EmptyCollectionGuard
    public List<Long> findAllTestCasesLibraryNodeForMilestone(@Param(value="milestoneIds") Collection<Long> var1);

    @Query(value="update TestCase tc\nset tc.scmRepository = (select r from ScmRepository r where r.id = :scmRepositoryId)\nwhere tc.id = :testCaseId")
    @Modifying(clearAutomatically=true)
    public void bindScmRepository(@Param(value="testCaseId") long var1, @Param(value="scmRepositoryId") long var3);

    @Query(value="update TestCase tc\nset tc.scmRepository = null\nwhere tc.id = :testCaseId")
    @Modifying
    public void unbindScmRepository(@Param(value="testCaseId") long var1);

    @Query(value="select tc.project.automationWorkflowType\nfrom TestCase tc\nwhere tc.id = :id")
    public AutomationWorkflowType findProjectAutomationWorkflowByTestCaseId(@Param(value="id") Long var1);
}

