/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.project;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooq.CommonTableExpression;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record1;
import org.jooq.SelectField;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.api.template.TemplateConfigurablePlugin;
import org.squashtest.tm.api.wizard.SynchronisationPlugin;
import org.squashtest.tm.domain.actionword.ActionWordLibrary;
import org.squashtest.tm.domain.bugtracker.BugtrackerProject;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.environmenttag.AutomationEnvironmentTag;
import org.squashtest.tm.domain.environmenttag.AutomationEnvironmentTagHolder;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.project.ProjectTemplate;
import org.squashtest.tm.domain.requirement.RequirementLibrary;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.exception.NoBugTrackerBindingException;
import org.squashtest.tm.exception.library.CannotDeleteProjectException;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.records.ProjectRecord;
import org.squashtest.tm.service.bugtracker.CustomBugTrackerModificationService;
import org.squashtest.tm.service.customfield.CustomFieldModelService;
import org.squashtest.tm.service.infolist.InfoListModelService;
import org.squashtest.tm.service.internal.display.dto.ProjectDataInfo;
import org.squashtest.tm.service.internal.display.dto.TemplateConfigurablePluginBindingDto;
import org.squashtest.tm.service.internal.dto.CustomFieldBindingModel;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.internal.dto.json.JsonInfoList;
import org.squashtest.tm.service.internal.dto.json.JsonMilestone;
import org.squashtest.tm.service.internal.dto.json.JsonProject;
import org.squashtest.tm.service.internal.project.ProjectDeletionHandler;
import org.squashtest.tm.service.internal.repository.BugtrackerProjectDao;
import org.squashtest.tm.service.internal.repository.GenericProjectDao;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.ProjectTemplateDao;
import org.squashtest.tm.service.internal.repository.TemplateConfigurablePluginBindingDao;
import org.squashtest.tm.service.internal.servers.ManageableTokenAuthCredentials;
import org.squashtest.tm.service.milestone.MilestoneModelService;
import org.squashtest.tm.service.project.CustomProjectFinder;
import org.squashtest.tm.service.project.CustomProjectModificationService;
import org.squashtest.tm.service.project.GenericProjectCopyParameter;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.servers.StoredCredentialsManager;
import org.squashtest.tm.service.templateplugin.TemplateConfigurablePluginBindingService;
import org.squashtest.tm.service.templateplugin.TemplateConfigurablePluginService;
import org.squashtest.tm.service.user.UserAccountService;

@Service(value="CustomProjectModificationService")
@Transactional
public class CustomProjectModificationServiceImpl
implements CustomProjectModificationService {
    private final ProjectDeletionHandler projectDeletionHandler;
    private final ProjectTemplateDao projectTemplateDao;
    private final GenericProjectManagerService genericProjectManager;
    private final ProjectDao projectDao;
    private final PermissionEvaluationService permissionEvaluationService;
    private final GenericProjectDao genericProjectDao;
    private final UserAccountService userAccountService;
    private final DSLContext dsl;
    private final MilestoneModelService milestoneModelService;
    private final CustomFieldModelService customFieldModelService;
    private final InfoListModelService infoListModelService;
    private final TemplateConfigurablePluginBindingService templatePluginBindingService;
    private final TemplateConfigurablePluginService templateConfigurablePluginService;
    private final StoredCredentialsManager storedCredentialsManager;
    private final CustomProjectFinder customProjectFinder;
    private final BugtrackerProjectDao bugtrackerProjectDao;
    private final CustomBugTrackerModificationService customBugTrackerModificationService;
    private final TemplateConfigurablePluginBindingDao templateConfigurablePluginBindingDao;
    @PersistenceContext
    EntityManager entityManager;
    @Autowired(required=false)
    private Collection<SynchronisationPlugin> synchronisationPlugins = Collections.emptyList();

    public CustomProjectModificationServiceImpl(ProjectDeletionHandler projectDeletionHandler, ProjectTemplateDao projectTemplateDao, GenericProjectManagerService genericProjectManager, ProjectDao projectDao, PermissionEvaluationService permissionEvaluationService, GenericProjectDao genericProjectDao, UserAccountService userAccountService, DSLContext dsl, MilestoneModelService milestoneModelService, CustomFieldModelService customFieldModelService, InfoListModelService infoListModelService, TemplateConfigurablePluginBindingService templatePluginBindingService, TemplateConfigurablePluginService templateConfigurablePluginService, StoredCredentialsManager storedCredentialsManager, CustomProjectFinder customProjectFinder, BugtrackerProjectDao bugtrackerProjectDao, CustomBugTrackerModificationService customBugTrackerModificationService, TemplateConfigurablePluginBindingDao templateConfigurablePluginBindingDao) {
        this.projectDeletionHandler = projectDeletionHandler;
        this.projectTemplateDao = projectTemplateDao;
        this.genericProjectManager = genericProjectManager;
        this.projectDao = projectDao;
        this.permissionEvaluationService = permissionEvaluationService;
        this.genericProjectDao = genericProjectDao;
        this.userAccountService = userAccountService;
        this.dsl = dsl;
        this.milestoneModelService = milestoneModelService;
        this.customFieldModelService = customFieldModelService;
        this.infoListModelService = infoListModelService;
        this.templatePluginBindingService = templatePluginBindingService;
        this.templateConfigurablePluginService = templateConfigurablePluginService;
        this.storedCredentialsManager = storedCredentialsManager;
        this.customProjectFinder = customProjectFinder;
        this.bugtrackerProjectDao = bugtrackerProjectDao;
        this.customBugTrackerModificationService = customBugTrackerModificationService;
        this.templateConfigurablePluginBindingDao = templateConfigurablePluginBindingDao;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteProject(long projectId) {
        if (this.hasProjectData(projectId)) {
            throw new CannotDeleteProjectException();
        }
        this.projectDeletionHandler.deleteProject(projectId);
    }

    @Override
    public boolean hasProjectData(long projectId) {
        return !this.getProjectData(projectId).isEmpty();
    }

    @Override
    public List<ProjectDataInfo.NotEmptyWorkspace> getProjectData(long projectId) {
        return this.projectDeletionHandler.getNonEmptyWorkspacesInProject(projectId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void updateBugTrackerProjectNames(long projectId, List<String> projectBugTrackerNames) {
        GenericProject project = this.genericProjectDao.getProjectWithBugtrackerProjects(projectId);
        if (!project.isBoundToBugtracker()) {
            throw new NoBugTrackerBindingException("No bugtracker is linked to the project with id: " + projectId);
        }
        this.bugtrackerProjectDao.deleteAllByProjectId(projectId);
        CustomProjectModificationServiceImpl.addBugtrackerProjects(new LinkedHashSet<String>(projectBugTrackerNames), project);
        this.customBugTrackerModificationService.refreshCacheForProject(projectId);
    }

    private static void addBugtrackerProjects(Set<String> projectBugTrackerNames, GenericProject project) {
        ArrayList<BugtrackerProject> newBugtrackerProjects = new ArrayList<BugtrackerProject>();
        int counter = 0;
        for (String name : projectBugTrackerNames) {
            newBugtrackerProjects.add(new BugtrackerProject(name, project, counter++));
        }
        project.addBugtrackerProjects(newBugtrackerProjects);
    }

    @Override
    public Project addProjectFromTemplate(Project newProject, long templateId, GenericProjectCopyParameter params) throws NameAlreadyInUseException {
        this.genericProjectManager.persist((GenericProject)newProject);
        ProjectTemplate projectTemplate = (ProjectTemplate)this.projectTemplateDao.getReferenceById(templateId);
        if (params.isKeepTemplateBinding()) {
            newProject.setTemplate(projectTemplate);
            this.makeParamsConsistent(params);
        }
        this.genericProjectManager.synchronizeGenericProject((GenericProject)newProject, (GenericProject)projectTemplate, params);
        this.createPluginBindings(newProject, projectTemplate, params);
        this.genericProjectManager.createAttachmentFromDescription((GenericProject)newProject);
        return newProject;
    }

    private void createPluginBindings(Project newProject, ProjectTemplate projectTemplate, GenericProjectCopyParameter params) {
        Long projectId = newProject.getId();
        Long templateId = projectTemplate.getId();
        if (params.isKeepPluginsBinding()) {
            GenericProject sourceProject = this.genericProjectManager.findById(projectTemplate.getId());
            ArrayList<String> pluginsToBind = new ArrayList<String>(sourceProject.getRequirementLibrary().getEnabledPlugins());
            this.forceAddSyncPlugins(pluginsToBind);
            List<TemplateConfigurablePluginBindingDto> alreadyBoundPlugins = this.templateConfigurablePluginBindingDao.findAll(templateId, projectId, pluginsToBind);
            pluginsToBind.removeIf(plugin -> alreadyBoundPlugins.stream().anyMatch(binding -> binding.getPluginId().equals(plugin)));
            List<TemplateConfigurablePlugin> plugins = this.templateConfigurablePluginService.findByIds(pluginsToBind);
            this.templatePluginBindingService.createTemplateConfigurablePluginBindings(projectTemplate, newProject, plugins);
        }
    }

    private void forceAddSyncPlugins(List<String> pluginsToBind) {
        this.synchronisationPlugins.forEach(synchronisationPlugin -> {
            String syncId = synchronisationPlugin.getId();
            if (!pluginsToBind.contains(syncId)) {
                pluginsToBind.add(syncId);
            }
        });
    }

    private void makeParamsConsistent(GenericProjectCopyParameter params) {
        params.setCopyCUF(true);
        params.setCopyInfolists(true);
        params.setCopyAllowTcModifFromExec(true);
        params.setCopyOptionalExecStatuses(true);
    }

    @Override
    public List<GenericProject> findAllICanManage() {
        List projects = this.genericProjectDao.findAll();
        ArrayList<GenericProject> manageableProjects = new ArrayList<GenericProject>();
        for (GenericProject project : projects) {
            if (!this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.MANAGE_PROJECT.name(), project)) continue;
            manageableProjects.add(project);
        }
        return manageableProjects;
    }

    @Override
    public List<String> findProjectNamesByIds(List<Long> projectIds) {
        return this.projectDao.findProjectNamesByIds(projectIds);
    }

    @Override
    public List<Long> findAllReadableIds(UserDto userDto) {
        return this.findAllIdsByPermission(userDto, Permissions.READ.getMask());
    }

    @Override
    public CommonTableExpression<Record1<Long>> findAllReadableIdsCte(UserDto userDto) {
        return this.findAllIdsByPermissionCte(userDto, Permissions.READ.getMask());
    }

    @Override
    public boolean checkHasAtLeastOneReadableId(CommonTableExpression<Record1<Long>> projectIdsCte) {
        return this.projectDao.checkHasAtLeastOneReadableId(projectIdsCte);
    }

    @Override
    public List<Long> findReadableProjectIdsOnRequirementLibrary() {
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        return this.findAllReadableIdsByLibraryClassName(currentUser, RequirementLibrary.class.getName(), (TableField<ProjectRecord, Long>)Tables.PROJECT.RL_ID);
    }

    @Override
    public List<Long> findReadableProjectIdsOnTestCaseLibrary() {
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        return this.findAllReadableIdsByLibraryClassName(currentUser, TestCaseLibrary.class.getName(), (TableField<ProjectRecord, Long>)Tables.PROJECT.TCL_ID);
    }

    @Override
    public List<Long> findReadableProjectIdsOnCampaignLibrary() {
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        return this.findAllReadableIdsByLibraryClassName(currentUser, CampaignLibrary.class.getName(), (TableField<ProjectRecord, Long>)Tables.PROJECT.CL_ID);
    }

    @Override
    public List<Long> findReadableProjectIdsOnActionWordLibrary() {
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        return this.findAllReadableIdsByLibraryClassName(currentUser, ActionWordLibrary.class.getName(), (TableField<ProjectRecord, Long>)Tables.PROJECT.AWL_ID);
    }

    @Override
    public List<Long> findAllReadableIdsByLibraryClassName(UserDto userDto, String libraryClassName, TableField<ProjectRecord, Long> libraryColumnField) {
        if (userDto.isAdmin()) {
            return this.projectDao.findAllProjectIds();
        }
        return this.projectDao.findAllProjectIdsByPermissionMaskAndClassName(userDto.getPartyIds(), Permissions.READ.getMask(), libraryClassName, libraryColumnField);
    }

    @Override
    public List<Long> findAllManageableIds(UserDto userDto) {
        return this.findAllIdsByPermission(userDto, Permissions.MANAGE_PROJECT.getMask());
    }

    @Override
    public List<Long> findAllMilestoneManageableIds(UserDto userDto) {
        return this.findAllIdsByPermission(userDto, Permissions.MANAGE_MILESTONE.getMask());
    }

    @Override
    @PreAuthorize(value="hasPermission(#libraryId, 'org.squashtest.tm.domain.requirement.RequirementLibrary', 'READ')  or hasRole('ROLE_ADMIN')")
    public Long findByRequirementLibraryId(long libraryId) {
        return this.projectDao.findByRequirementLibraryId(libraryId);
    }

    @Override
    public List<Long> findAllProjectIdsByEligibleTCPermission(UserDto userDto, int permission) {
        if (userDto.isAdmin()) {
            return this.projectDao.findAllProjectIds();
        }
        return this.projectDao.findAllProjectIdsByEligibleTCPermission(userDto.getPartyIds(), permission);
    }

    private List<Long> findAllIdsByPermission(UserDto userDto, int permission) {
        if (userDto.isAdmin()) {
            return this.projectDao.findAllProjectIds();
        }
        return this.projectDao.findAllProjectIdsByPermission(userDto.getPartyIds(), permission);
    }

    private CommonTableExpression<Record1<Long>> findAllIdsByPermissionCte(UserDto userDto, int permission) {
        if (userDto.isAdmin()) {
            return this.projectDao.findAllProjectIdsCte();
        }
        return this.projectDao.findAllProjectIdsByPermissionCte(userDto.getPartyIds(), permission);
    }

    @Override
    public List<Long> findAllExportableIdsOnGivenLibrary(UserDto userDto, String libraryClassname, TableField<ProjectRecord, Long> libraryColumnField) {
        if (userDto.isAdmin()) {
            return this.projectDao.findAllProjectIds();
        }
        return this.projectDao.findAllProjectIdsByPermissionMaskAndClassName(userDto.getPartyIds(), Permissions.EXPORT.getMask(), libraryClassname, libraryColumnField);
    }

    @Override
    public List<Long> findAllReadableIdsForAutomationWriter() {
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        if (currentUser.isAdmin()) {
            return this.projectDao.findAllProjectIds();
        }
        return this.projectDao.findAllProjectIdsForAutomationWriter(currentUser.getPartyIds());
    }

    @Override
    public List<Long> findAllReadableIdsForAutomationHelper() {
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        if (currentUser.isAdmin()) {
            return this.projectDao.findAllProjectIds();
        }
        return this.projectDao.findAllProjectIdsForAutomationHelper(currentUser.getPartyIds());
    }

    @Override
    public List<Long> findAllReadableIds() {
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        return this.findAllReadableIds(currentUser);
    }

    @Override
    public List<Long> findAllManageableIds() {
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        return this.findAllManageableIds(currentUser);
    }

    @Override
    public List<Long> findAllProjectIdsByEligibleTCPermission(int permission) {
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        return this.findAllProjectIdsByEligibleTCPermission(currentUser, permission);
    }

    @Override
    public List<Long> findAllProjectIdsOrderedByName(List<Long> projectIds) {
        return this.projectDao.findAllProjectIdsInListOrderedByName(projectIds);
    }

    @Override
    public boolean canReadAtLeastOneProject() {
        return !this.findAllReadableIds().isEmpty();
    }

    @Override
    public List<Project> findAllOrderedByName() {
        List<Long> readableProjectIds = this.customProjectFinder.findAllReadableIds();
        return readableProjectIds.isEmpty() ? new ArrayList() : this.projectDao.findByIdInOrderByName(readableProjectIds);
    }

    @Override
    public Collection<JsonProject> findAllProjects(List<Long> readableProjectIds, UserDto currentUser) {
        Map<Long, JsonProject> jsonProjects = this.doFindAllProjects(readableProjectIds);
        return jsonProjects.values();
    }

    @Override
    public Integer countProjectsAllowAutomationWorkflow() {
        return this.projectDao.countProjectsAllowAutomationWorkflow();
    }

    protected Map<Long, JsonProject> doFindAllProjects(List<Long> readableProjectIds) {
        Map<Long, JsonInfoList> infoListMap = this.infoListModelService.findUsedInfoList(readableProjectIds);
        Map<Long, JsonProject> jsonProjectMap = this.findJsonProjects(readableProjectIds, infoListMap);
        Map<Long, Map<String, List<CustomFieldBindingModel>>> customFieldsBindingsByProject = this.customFieldModelService.findCustomFieldsBindingsByProject(readableProjectIds);
        Map<Long, List<JsonMilestone>> milestoneByProjectId = this.milestoneModelService.findMilestoneByProject(readableProjectIds);
        jsonProjectMap.forEach((projectId, jsonProject) -> {
            if (customFieldsBindingsByProject.containsKey(projectId)) {
                Map bindingsByEntityType = (Map)customFieldsBindingsByProject.get(projectId);
                jsonProject.setCustomFieldBindings(bindingsByEntityType);
            }
            if (milestoneByProjectId.containsKey(projectId)) {
                List jsonMilestone = (List)milestoneByProjectId.get(projectId);
                jsonProject.setMilestones(new HashSet<JsonMilestone>(jsonMilestone));
            }
        });
        return jsonProjectMap;
    }

    private Map<Long, JsonProject> findJsonProjects(List<Long> readableProjectIds, Map<Long, JsonInfoList> infoListMap) {
        return this.dsl.select((SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.PROJECT.NAME, (SelectField)Tables.PROJECT.REQ_CATEGORIES_LIST, (SelectField)Tables.PROJECT.TC_NATURES_LIST, (SelectField)Tables.PROJECT.TC_TYPES_LIST).from((TableLike)Tables.PROJECT).where(Tables.PROJECT.PROJECT_ID.in(readableProjectIds)).and(Tables.PROJECT.PROJECT_TYPE.eq((Object)"P")).orderBy((OrderField)Tables.PROJECT.PROJECT_ID).stream().map(r -> {
            Long projectId = (Long)r.get((Field)Tables.PROJECT.PROJECT_ID);
            JsonProject jsonProject = new JsonProject(projectId, (String)r.get((Field)Tables.PROJECT.NAME));
            jsonProject.setRequirementCategories((JsonInfoList)infoListMap.get(r.get((Field)Tables.PROJECT.REQ_CATEGORIES_LIST)));
            jsonProject.setTestCaseNatures((JsonInfoList)infoListMap.get(r.get((Field)Tables.PROJECT.TC_NATURES_LIST)));
            jsonProject.setTestCaseTypes((JsonInfoList)infoListMap.get(r.get((Field)Tables.PROJECT.TC_TYPES_LIST)));
            return jsonProject;
        }).collect(Collectors.toMap(JsonProject::getId, Function.identity(), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
    }

    @Override
    public void overrideEnvironmentTags(long projectId, List<String> tags) {
        Optional maybeProject = this.genericProjectDao.findById(projectId);
        if (maybeProject.isPresent()) {
            GenericProject project = (GenericProject)maybeProject.get();
            project.setEnvironmentTags(tags.stream().map(tag -> new AutomationEnvironmentTag(tag, AutomationEnvironmentTagHolder.PROJECT)).toList());
            project.setInheritsEnvironmentTags(false);
        } else {
            this.throwProjectNotFoundException(projectId);
        }
    }

    @Override
    public void clearEnvironmentTagOverrides(long projectId) {
        this.genericProjectManager.clearEnvironmentTagOverrides(projectId);
    }

    @Override
    public void setTestAutomationServerTokenOverride(long projectId, long serverId, String token) {
        this.assertProjectExists(projectId);
        this.assertTAServerExists(serverId);
        ManageableTokenAuthCredentials tokenAuthCredentials = new ManageableTokenAuthCredentials(token);
        this.storedCredentialsManager.storeProjectCredentials(serverId, projectId, tokenAuthCredentials);
        this.clearEnvironmentTagOverrides(projectId);
    }

    @Override
    public void clearTestAutomationServerTokenOverride(long projectId, long serverId) {
        this.assertProjectExists(projectId);
        this.storedCredentialsManager.deleteProjectCredentials(serverId, projectId);
        this.clearEnvironmentTagOverrides(projectId);
    }

    private void assertProjectExists(long projectId) {
        Optional maybeProject = this.genericProjectDao.findById(projectId);
        if (maybeProject.isEmpty()) {
            this.throwProjectNotFoundException(projectId);
        }
    }

    private void throwProjectNotFoundException(long projectId) {
        throw new IllegalArgumentException(String.format("Project with id %d was not found", projectId));
    }

    private void assertTAServerExists(long projectId) {
        TestAutomationServer maybeServer = (TestAutomationServer)this.entityManager.find(TestAutomationServer.class, (Object)projectId);
        if (maybeServer == null) {
            throw new IllegalArgumentException(String.format("Test automation server with id %d was not found", projectId));
        }
    }
}

