/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.domain.requirement.RequirementVersionLinkType;
import org.squashtest.tm.service.internal.dto.pivotdefinition.RequirementLinkTypePivot;
import org.squashtest.tm.service.internal.dto.projectimporter.ImportWarningEntry;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotMetaDataModel;
import org.squashtest.tm.service.internal.library.CompareFieldStringEntity;
import org.squashtest.tm.service.internal.library.LibraryUtils;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.AbstractPivotImport;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotFormatLoggerHelper;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotImportStrategy;
import org.squashtest.tm.service.internal.repository.RequirementVersionLinkTypeDao;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.InfoListPivotImporterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.RequirementLinkTypeImporterService;

@Service
public class RequirementLinkTypeTypeImporterServiceImpl
extends AbstractPivotImport
implements RequirementLinkTypeImporterService {
    private static final String ROLE_1_FIELD = "role1";
    private static final String ROLE_2_FIELD = "role2";
    private static final String CODE_ROLE_1_FIELD = "role1Code";
    private static final String CODE_ROLE_2_FIELD = "role2Code";
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoListPivotImporterService.class);
    private final AdminPivotConverterService adminPivotConverterService;
    private final RequirementVersionLinkTypeDao requirementVersionLinkTypeDao;
    @PersistenceContext
    private EntityManager entityManager;

    public RequirementLinkTypeTypeImporterServiceImpl(AdminPivotConverterService adminPivotConverterService, RequirementVersionLinkTypeDao requirementVersionLinkTypeDao) {
        super(LOGGER);
        this.adminPivotConverterService = adminPivotConverterService;
        this.requirementVersionLinkTypeDao = requirementVersionLinkTypeDao;
    }

    @Override
    public <I extends InputStream> void validationRequirementLinkType(I zis, PivotMetaDataModel pivotMetaDataModel) {
        ArrayList<RequirementLinkTypePivot> requirementLinkTypePivots = new ArrayList<RequirementLinkTypePivot>();
        this.parseEntities(zis, JsonImportFile.REQUIREMENT_LINK_TYPES, JsonImportFile.REQUIREMENT_LINK_TYPES.getJsonFieldKind(), RequirementLinkTypePivot.class, requirementLinkTypePivots::add);
        this.checkConflictRequirementLinkType(requirementLinkTypePivots, pivotMetaDataModel);
    }

    private void checkConflictRequirementLinkType(List<RequirementLinkTypePivot> requirementLinkTypePivots, PivotMetaDataModel pivotMetaDataModel) {
        CompareFieldStringEntity<RequirementVersionLinkType> compareFields = new CompareFieldStringEntity<RequirementVersionLinkType>(this.requirementVersionLinkTypeDao.getAllRequirementVersionLinkTypes(), this.getFieldExtractors());
        requirementLinkTypePivots.forEach(requirementLinkTypePivot -> {
            CompareLinks compareLinks = new CompareLinks((RequirementLinkTypePivot)requirementLinkTypePivot, compareFields);
            if (compareLinks.hasSameRoles() || compareLinks.hasNoMatch()) {
                return;
            }
            RequirementVersionLinkType requirementVersionLinkType = compareLinks.getUniqueMatchedLink((RequirementLinkTypePivot)requirementLinkTypePivot);
            pivotMetaDataModel.addRequirementLinkConflict((RequirementLinkTypePivot)requirementLinkTypePivot, requirementVersionLinkType);
        });
    }

    @Override
    public void importRequirementLinkTypesFromZipArchive(ZipFile zipFile, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        PivotImportStrategy<RequirementLinkTypePivot> requirementLinkTypePivotPivotImportStrategy = this.getRequirementLinkTypePivotImporterStrategy(pivotImportMetadata, pivotFormatImport);
        this.importEntitiesFromZipArchive(zipFile, JsonImportFile.REQUIREMENT_LINK_TYPES, pivotFormatImport, pivotImportMetadata, "requirements link", "requirement link", requirementLinkTypePivotPivotImportStrategy);
    }

    private PivotImportStrategy<RequirementLinkTypePivot> getRequirementLinkTypePivotImporterStrategy(final PivotImportMetadata pivotImportMetadata, final PivotFormatImport pivotFormatImport) {
        return new PivotImportStrategy<RequirementLinkTypePivot>(){

            @Override
            public Class<RequirementLinkTypePivot> getPivotClazz() {
                return RequirementLinkTypePivot.class;
            }

            @Override
            public void create(List<RequirementLinkTypePivot> entities) {
                RequirementLinkTypeTypeImporterServiceImpl.this.createRequirementLinkTypes(entities, pivotFormatImport, pivotImportMetadata);
            }
        };
    }

    private void createRequirementLinkTypes(List<RequirementLinkTypePivot> requirementLinkTypePivots, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        this.requirementVersionLinkTypeDao.getAllRequirementVersionLinkTypes();
        Map<String, Long> requirementLinkTypeToReused = pivotImportMetadata.getPivotOptions().getRequirementLinkTypeToReused();
        CompareFieldStringEntity<RequirementVersionLinkType> compareFields = new CompareFieldStringEntity<RequirementVersionLinkType>(this.requirementVersionLinkTypeDao.getAllRequirementVersionLinkTypes(), this.getFieldExtractors());
        for (RequirementLinkTypePivot requirementLinkTypePivot : requirementLinkTypePivots) {
            if (requirementLinkTypeToReused.containsKey(requirementLinkTypePivot.getPivotId())) {
                Long requirementVersionLinkTypeId = requirementLinkTypeToReused.get(requirementLinkTypePivot.getPivotId());
                this.attachExistingLink(requirementLinkTypePivot, requirementVersionLinkTypeId, pivotImportMetadata, pivotFormatImport);
                continue;
            }
            CompareLinks compareLinks = new CompareLinks(requirementLinkTypePivot, compareFields);
            if (compareLinks.hasSameRoles()) {
                RequirementVersionLinkType requirementVersionLinkType = compareLinks.getUniqueMatchedLink(requirementLinkTypePivot);
                this.attachExistingLink(requirementLinkTypePivot, requirementVersionLinkType.getId(), pivotImportMetadata, pivotFormatImport);
                continue;
            }
            this.createRequirementLink(requirementLinkTypePivot, compareLinks, pivotFormatImport, pivotImportMetadata);
        }
        requirementLinkTypePivots.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void attachExistingLink(RequirementLinkTypePivot requirementLinkTypePivot, Long requirementVersionLinkTypeId, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        pivotImportMetadata.getRequirementLinkTypeIdsMap().put(requirementLinkTypePivot.getPivotId(), requirementVersionLinkTypeId);
        PivotFormatLoggerHelper.logEntitiesAlreadyExistsInSquash(LOGGER, "requirement link", requirementLinkTypePivot.getLabel(), requirementLinkTypePivot.getPivotId(), pivotFormatImport);
    }

    private void createRequirementLink(RequirementLinkTypePivot requirementLinkTypePivot, CompareLinks compareLinks, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        PivotFormatLoggerHelper.logEntityCreationStarted(LOGGER, "requirement link", requirementLinkTypePivot.getPivotId(), pivotFormatImport);
        try {
            RequirementVersionLinkType requirementVersionLinkType = this.adminPivotConverterService.pivotToRequirementVersionLinkType(requirementLinkTypePivot);
            this.handleRoleCodeOnNewLink(requirementLinkTypePivot, compareLinks, requirementVersionLinkType, pivotImportMetadata);
            this.entityManager.persist((Object)requirementVersionLinkType);
            pivotImportMetadata.getRequirementLinkTypeIdsMap().put(requirementLinkTypePivot.getPivotId(), requirementVersionLinkType.getId());
            PivotFormatLoggerHelper.logEntityCreatedSuccessfully(LOGGER, "requirement link", requirementLinkTypePivot.getLabel(), requirementLinkTypePivot.getPivotId(), pivotFormatImport);
        }
        catch (Exception e) {
            PivotFormatLoggerHelper.handleEntityCreationFailed(LOGGER, "requirement link", requirementLinkTypePivot.getLabel(), requirementLinkTypePivot.getPivotId(), pivotFormatImport, e);
        }
    }

    private void handleRoleCodeOnNewLink(RequirementLinkTypePivot requirementLinkTypePivot, CompareLinks compareLinks, RequirementVersionLinkType requirementVersionLinkType, PivotImportMetadata pivotImportMetadata) {
        if (compareLinks.hasSameCodeRoles()) {
            pivotImportMetadata.addImportWarningEntry(ImportWarningEntry.requirementLinkTypeCodeDuplication(requirementLinkTypePivot.getPivotId()));
            this.setUniqueRoleCode(requirementLinkTypePivot.getRoleCode1(), compareLinks.compareCodeRole1.clashingNames(), arg_0 -> ((RequirementVersionLinkType)requirementVersionLinkType).setRole1Code(arg_0));
            compareLinks.compareCodeRole2.clashingNames().add(requirementVersionLinkType.getRole1Code());
            this.setUniqueRoleCode(requirementLinkTypePivot.getRoleCode2(), compareLinks.compareCodeRole2.clashingNames(), arg_0 -> ((RequirementVersionLinkType)requirementVersionLinkType).setRole2Code(arg_0));
            return;
        }
        if (compareLinks.compareCodeRole1.isMatched()) {
            pivotImportMetadata.addImportWarningEntry(ImportWarningEntry.requirementLinkTypeCodeAlreadyUsed(requirementLinkTypePivot.getPivotId(), requirementLinkTypePivot.getRoleCode1()));
            this.setUniqueRoleCode(requirementLinkTypePivot.getRoleCode1(), compareLinks.compareCodeRole1.clashingNames(), arg_0 -> ((RequirementVersionLinkType)requirementVersionLinkType).setRole1Code(arg_0));
        }
        if (compareLinks.compareCodeRole2.isMatched()) {
            pivotImportMetadata.addImportWarningEntry(ImportWarningEntry.requirementLinkTypeCodeAlreadyUsed(requirementLinkTypePivot.getPivotId(), requirementLinkTypePivot.getRoleCode2()));
            this.setUniqueRoleCode(requirementLinkTypePivot.getRoleCode2(), compareLinks.compareCodeRole2.clashingNames(), arg_0 -> ((RequirementVersionLinkType)requirementVersionLinkType).setRole2Code(arg_0));
        }
    }

    private void setUniqueRoleCode(String roleCode, Collection<String> siblings, Consumer<String> setRoleCode) {
        String code = LibraryUtils.generateNonClashingName(roleCode, siblings, 30);
        setRoleCode.accept(code);
    }

    private Map<String, Function<RequirementVersionLinkType, String>> getFieldExtractors() {
        HashMap<String, Function<RequirementVersionLinkType, String>> fieldExtractors = new HashMap<String, Function<RequirementVersionLinkType, String>>();
        fieldExtractors.put(ROLE_1_FIELD, RequirementVersionLinkType::getRole1);
        fieldExtractors.put(ROLE_2_FIELD, RequirementVersionLinkType::getRole2);
        fieldExtractors.put(CODE_ROLE_1_FIELD, RequirementVersionLinkType::getRole1Code);
        fieldExtractors.put(CODE_ROLE_2_FIELD, RequirementVersionLinkType::getRole2Code);
        return fieldExtractors;
    }

    private record CompareLinks(CompareFieldStringEntity.Comparison<RequirementVersionLinkType> compareRole1, CompareFieldStringEntity.Comparison<RequirementVersionLinkType> compareRole2, CompareFieldStringEntity.Comparison<RequirementVersionLinkType> compareCodeRole1, CompareFieldStringEntity.Comparison<RequirementVersionLinkType> compareCodeRole2) {
        CompareLinks(RequirementLinkTypePivot requirementLinkTypePivot, CompareFieldStringEntity<RequirementVersionLinkType> compareFields) {
            this(compareFields.checkField(RequirementLinkTypeTypeImporterServiceImpl.ROLE_1_FIELD, requirementLinkTypePivot.getRole1()), compareFields.checkField(RequirementLinkTypeTypeImporterServiceImpl.ROLE_2_FIELD, requirementLinkTypePivot.getRole2()), compareFields.checkField(RequirementLinkTypeTypeImporterServiceImpl.CODE_ROLE_1_FIELD, requirementLinkTypePivot.getRoleCode1()), compareFields.checkField(RequirementLinkTypeTypeImporterServiceImpl.CODE_ROLE_2_FIELD, requirementLinkTypePivot.getRoleCode2()));
        }

        private boolean hasSameRoles() {
            return this.compareRole1.isMatched() && this.compareRole2.isMatched();
        }

        private boolean hasSameCodeRoles() {
            return this.compareCodeRole1.isMatched() && this.compareCodeRole2.isMatched();
        }

        private boolean hasNoMatch() {
            return !this.compareRole1.isMatched() && !this.compareRole2.isMatched() && !this.compareCodeRole1.isMatched() && !this.compareCodeRole2.isMatched();
        }

        private RequirementVersionLinkType getUniqueMatchedLink(RequirementLinkTypePivot requirementLinkTypePivot) {
            Optional<Map.Entry> result = Stream.of(this.compareRole1, this.compareRole2, this.compareCodeRole1, this.compareCodeRole2).filter(CompareFieldStringEntity.Comparison::isMatched).flatMap(c -> c.entities().stream()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().max(Map.Entry.comparingByValue().thenComparing(entry -> -((RequirementVersionLinkType)entry.getKey()).getId().longValue()));
            return result.map(Map.Entry::getKey).orElseThrow(() -> new IllegalStateException("No requirement version link type found with the role1 '%s' and role2 '%s'".formatted(requirementLinkTypePivot.getRole1(), requirementLinkTypePivot.getRole2())));
        }
    }
}

