/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter.dao;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooq.CommonTableExpression;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Record2;
import org.jooq.Record9;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectOnConditionStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.attachment.AttachmentEntity;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.InfoListItem;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AttachmentPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.CustomFieldValuePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.MilestonePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.TestCasePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.ActionStepPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.DatasetParamPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.DatasetPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.KeywordPivot;
import org.squashtest.tm.service.internal.jooq.SubElementRecordProcessor;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.AbstractPivotDao;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.EntityBindingField;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.converters.TestCasePivotConverterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.CustomFieldPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.TestCasePivotDao;

@Repository
public class TestCasePivotDaoImpl
extends AbstractPivotDao<TestCasePivot>
implements TestCasePivotDao {
    private final CustomFieldPivotDao customFieldPivotDao;
    private final TestCasePivotConverterService testCasePivotConverterService;

    public TestCasePivotDaoImpl(AdminPivotConverterService adminPivotConverterService, DSLContext dsl, CustomFieldPivotDao customFieldPivotDao, TestCasePivotConverterService testCasePivotConverterService) {
        super(dsl, adminPivotConverterService);
        this.customFieldPivotDao = customFieldPivotDao;
        this.testCasePivotConverterService = testCasePivotConverterService;
    }

    @Override
    public boolean hasTestCase(Long projectId) {
        boolean hasTestCaseInsideProject = this.dsl.fetchExists((Select)this.dsl.selectOne().from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).join((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId).and(ConditionsConstants.TCLN_NOT_IN_BIN)));
        if (hasTestCaseInsideProject) {
            return true;
        }
        return this.hasTestCaseOutsideProject(projectId);
    }

    @Override
    public boolean hasTestCaseOutsideProject(Long projectId) {
        return this.dsl.fetchExists((Select)DSL.selectOne().from(this.getAllTestCaseWithOutside(projectId)));
    }

    private Table<?> getAllTestCaseWithOutside(Long projectId) {
        return DSL.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId).and(ConditionsConstants.TCLN_NOT_IN_BIN)).union((Select)DSL.select((SelectField)Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_CASE_ID).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CAMPAIGN_TEST_PLAN_ITEM).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN_TEST_PLAN_ITEM.CAMPAIGN_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).and(ConditionsConstants.TCLN_NOT_IN_BIN)).union((Select)DSL.select((SelectField)Tables.TEST_PLAN_ITEM.TCLN_ID).from((TableLike)Tables.TEST_PLAN_ITEM).join((TableLike)Tables.TEST_PLAN).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN.TEST_PLAN_ID)).join((TableLike)Tables.PROJECT).on(Tables.TEST_PLAN.CL_ID.eq((Field)Tables.PROJECT.CL_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId)).and(ConditionsConstants.TCLN_NOT_IN_BIN)).asTable();
    }

    @Override
    public CommonTableExpression<Record1<Long>> getCteTestCaseWithNonProjectTcByProjectId(Long projectId) {
        Table<?> allTestCase = this.getAllTestCaseWithOutside(projectId);
        return DSL.name((String)"recursive_cte").fields(TestCasePivotDao.TEST_CASE_CTE_TCLN_ID.getName()).as((ResultQuery)DSL.select((SelectField)allTestCase.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).from(allTestCase).union((Select)DSL.select((SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID).from(DSL.name((String)"recursive_cte")).join((TableLike)Tables.TEST_CASE_STEPS).on(DSL.field(TestCasePivotDao.TEST_CASE_CTE_TCLN_ID).eq((Field)Tables.TEST_CASE_STEPS.TEST_CASE_ID)).join((TableLike)Tables.CALL_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.CALL_TEST_STEP.TEST_STEP_ID))));
    }

    private Table<Record2<Long, String>> getTestCaseCoverageTable(Long projectId) {
        return DSL.select((SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID, (SelectField)DSL.groupConcat((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID).separator(",").as(TestCasePivotDao.TEST_CASE_COVERAGE_REQ_VERSION_IDS)).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).join((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).join((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).and(ConditionsConstants.TCLN_NOT_IN_BIN).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID}).asTable();
    }

    private Table<Record2<Long, String>> getTestStepCoverageTable(Long projectId) {
        return DSL.select((SelectField)Tables.VERIFYING_STEPS.TEST_STEP_ID, (SelectField)DSL.groupConcat((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID).separator(",").as(TestCasePivotDao.TEST_STEP_COVERAGE_REQ_VERSION_IDS)).from((TableLike)Tables.VERIFYING_STEPS).join((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.VERIFYING_STEPS.REQUIREMENT_VERSION_COVERAGE_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID)).join((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).join((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).and(ConditionsConstants.TCLN_NOT_IN_BIN).groupBy(new GroupField[]{Tables.VERIFYING_STEPS.TEST_STEP_ID}).asTable();
    }

    private Table<?> getKeywordStepTable() {
        return DSL.select((SelectField)Tables.KEYWORD_TEST_STEP.TEST_STEP_ID, (SelectField)Tables.KEYWORD_TEST_STEP.KEYWORD, (SelectField)Tables.KEYWORD_TEST_STEP.DATATABLE, (SelectField)Tables.KEYWORD_TEST_STEP.DOCSTRING, (SelectField)Tables.KEYWORD_TEST_STEP.COMMENT, (SelectField)DSL.groupConcat((Field)DSL.case_().when(Tables.ACTION_WORD_TEXT.TEXT.isNotNull(), (Field)Tables.ACTION_WORD_TEXT.TEXT).otherwise((Field)Tables.ACTION_WORD_PARAMETER_VALUE.VALUE)).orderBy(new OrderField[]{Tables.ACTION_WORD_FRAGMENT.FRAGMENT_ORDER}).separator("").as(TestCasePivotDao.KEYWORD_STEP_VALUE)).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).join((TableLike)Tables.TEST_CASE_STEPS).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE_STEPS.TEST_CASE_ID)).join((TableLike)Tables.KEYWORD_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.KEYWORD_TEST_STEP.TEST_STEP_ID)).join((TableLike)Tables.ACTION_WORD_FRAGMENT).on(Tables.ACTION_WORD_FRAGMENT.ACTION_WORD_ID.eq((Field)Tables.KEYWORD_TEST_STEP.ACTION_WORD_ID)).leftJoin((TableLike)Tables.ACTION_WORD_TEXT).on(Tables.ACTION_WORD_FRAGMENT.ACTION_WORD_FRAGMENT_ID.eq((Field)Tables.ACTION_WORD_TEXT.ACTION_WORD_FRAGMENT_ID)).leftJoin((TableLike)Tables.ACTION_WORD_PARAMETER_VALUE).on(Tables.ACTION_WORD_FRAGMENT.ACTION_WORD_FRAGMENT_ID.eq((Field)Tables.ACTION_WORD_PARAMETER_VALUE.ACTION_WORD_FRAGMENT_ID)).where(ConditionsConstants.TCLN_NOT_IN_BIN).groupBy(new GroupField[]{Tables.KEYWORD_TEST_STEP.TEST_STEP_ID}).asTable();
    }

    private ResultQuery<? extends Record> getTestCaseByProjectIdQuery(Long projectId) {
        CommonTableExpression<Record1<Long>> cteTestCaseWithNonProjectTc = this.getCteTestCaseWithNonProjectTcByProjectId(projectId);
        Table<Record2<Long, String>> testCaseCoverage = this.getTestCaseCoverageTable(projectId);
        Table<Record2<Long, String>> testStepCoverage = this.getTestStepCoverageTable(projectId);
        Table<?> keywordStepTable = this.getKeywordStepTable();
        InfoListItem infoListItemNature = InfoListItem.INFO_LIST_ITEM.as("INFO_LIST_ITEM_NATURE");
        InfoListItem infoListItemType = InfoListItem.INFO_LIST_ITEM.as("INFO_LIST_ITEM_TYPE");
        return this.dsl.withRecursive(new CommonTableExpression[]{cteTestCaseWithNonProjectTc}).select(new SelectFieldOrAsterisk[]{Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, Tables.TEST_CASE_LIBRARY_NODE.NAME, Tables.TEST_CASE_LIBRARY_NODE.DESCRIPTION, Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID, Tables.TEST_CASE_LIBRARY_NODE.CREATED_BY, Tables.TEST_CASE_LIBRARY_NODE.CREATED_ON, Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_BY, Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_ON, Tables.TEST_CASE.REFERENCE, Tables.TEST_CASE.IMPORTANCE, Tables.TEST_CASE.TC_STATUS, infoListItemNature.CODE.as(TestCasePivotDao.TC_NATURE), infoListItemType.CODE.as(TestCasePivotDao.TC_TYPE), Tables.TEST_CASE.PREREQUISITE, Tables.TCLN_RELATIONSHIP.ANCESTOR_ID, DSL.when((Condition)Tables.SCRIPTED_TEST_CASE.TCLN_ID.isNotNull(), (Object)TestCaseKind.GHERKIN.name()).when(Tables.EXPLORATORY_TEST_CASE.TCLN_ID.isNotNull(), (Object)TestCaseKind.EXPLORATORY.name()).when(Tables.KEYWORD_TEST_CASE.TCLN_ID.isNotNull(), (Object)TestCaseKind.KEYWORD.name()).otherwise((Object)TestCaseKind.STANDARD.name()).as(TestCasePivotDao.TC_KIND), Tables.SCRIPTED_TEST_CASE.SCRIPT, Tables.EXPLORATORY_TEST_CASE.CHARTER, Tables.EXPLORATORY_TEST_CASE.SESSION_DURATION, Tables.TEST_CASE_STEPS.STEP_ID, Objects.requireNonNull(keywordStepTable.field((Field)Tables.KEYWORD_TEST_STEP.KEYWORD)).as((Field)Tables.KEYWORD_TEST_STEP.KEYWORD), Objects.requireNonNull(keywordStepTable.field((Field)Tables.KEYWORD_TEST_STEP.DATATABLE)).as((Field)Tables.KEYWORD_TEST_STEP.DATATABLE), Objects.requireNonNull(keywordStepTable.field((Field)Tables.KEYWORD_TEST_STEP.DOCSTRING)).as((Field)Tables.KEYWORD_TEST_STEP.DOCSTRING), Objects.requireNonNull(keywordStepTable.field((Field)Tables.KEYWORD_TEST_STEP.COMMENT)).as((Field)Tables.KEYWORD_TEST_STEP.COMMENT), TestCasePivotDao.KEYWORD_STEP_VALUE, Tables.ACTION_TEST_STEP.TEST_STEP_ID, Tables.ACTION_TEST_STEP.ACTION, Tables.ACTION_TEST_STEP.EXPECTED_RESULT, TestCasePivotDao.TEST_CASE_COVERAGE_REQ_VERSION_IDS, TestCasePivotDao.TEST_STEP_COVERAGE_REQ_VERSION_IDS}).from(cteTestCaseWithNonProjectTc).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(TestCasePivotDao.TEST_CASE_CTE_TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).join((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)infoListItemNature).on(Tables.TEST_CASE.TC_NATURE.eq((Field)infoListItemNature.ITEM_ID)).leftJoin((TableLike)infoListItemType).on(Tables.TEST_CASE.TC_TYPE.eq((Field)infoListItemType.ITEM_ID)).leftJoin((TableLike)Tables.TCLN_RELATIONSHIP).on(Tables.TCLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).leftJoin((TableLike)Tables.SCRIPTED_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.SCRIPTED_TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.EXPLORATORY_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.EXPLORATORY_TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.KEYWORD_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.KEYWORD_TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_STEPS.TEST_CASE_ID)).leftJoin(keywordStepTable).on(Tables.TEST_CASE_STEPS.STEP_ID.eq(keywordStepTable.field((Field)Tables.KEYWORD_TEST_STEP.TEST_STEP_ID))).leftJoin((TableLike)Tables.ACTION_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.ACTION_TEST_STEP.TEST_STEP_ID)).leftJoin(testStepCoverage).on(Tables.ACTION_TEST_STEP.TEST_STEP_ID.eq(testStepCoverage.field((Field)Tables.VERIFYING_STEPS.TEST_STEP_ID))).leftJoin(testCaseCoverage).on(Tables.TEST_CASE.TCLN_ID.eq(testCaseCoverage.field((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID))).orderBy((OrderField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (OrderField)Tables.TEST_CASE_STEPS.STEP_ORDER).fetchSize(50);
    }

    private ResultQuery<? extends Record> getDatasetWithParamValueByProjectIdQuery(Long projectId) {
        CommonTableExpression<Record1<Long>> cteTestCaseWithNonProjectTc = this.getCteTestCaseWithNonProjectTcByProjectId(projectId);
        return this.dsl.withRecursive(new CommonTableExpression[]{cteTestCaseWithNonProjectTc}).select(TestCasePivotDao.TEST_CASE_CTE_TCLN_ID, (SelectField)Tables.DATASET.DATASET_ID, (SelectField)Tables.DATASET.NAME, (SelectField)Tables.DATASET_PARAM_VALUE.DATASET_ID, (SelectField)Tables.DATASET_PARAM_VALUE.PARAM_ID, (SelectField)Tables.DATASET_PARAM_VALUE.PARAM_VALUE).from(cteTestCaseWithNonProjectTc).join((TableLike)Tables.DATASET).on(TestCasePivotDao.TEST_CASE_CTE_TCLN_ID.eq((Field)Tables.DATASET.TEST_CASE_ID)).leftJoin((TableLike)Tables.DATASET_PARAM_VALUE).on(Tables.DATASET.DATASET_ID.eq((Field)Tables.DATASET_PARAM_VALUE.DATASET_ID)).orderBy(TestCasePivotDao.TEST_CASE_CTE_TCLN_ID, (OrderField)Tables.DATASET.DATASET_ID).fetchSize(50);
    }

    private ResultQuery<? extends Record> getParameterByProjectIdQuery(Long projectId) {
        CommonTableExpression<Record1<Long>> cteTestCaseWithNonProjectTc = this.getCteTestCaseWithNonProjectTcByProjectId(projectId);
        return this.dsl.withRecursive(new CommonTableExpression[]{cteTestCaseWithNonProjectTc}).select(TestCasePivotDao.TEST_CASE_CTE_TCLN_ID, (SelectField)Tables.PARAMETER.PARAM_ID, (SelectField)Tables.PARAMETER.NAME, (SelectField)Tables.PARAMETER.DESCRIPTION).from(cteTestCaseWithNonProjectTc).join((TableLike)Tables.PARAMETER).on(TestCasePivotDao.TEST_CASE_CTE_TCLN_ID.eq((Field)Tables.PARAMETER.TEST_CASE_ID)).orderBy(TestCasePivotDao.TEST_CASE_CTE_TCLN_ID, (OrderField)Tables.PARAMETER.PARAM_ORDER).fetchSize(50);
    }

    private ResultQuery<? extends Record> getCustomFieldByProjectIdQuery(Long projectId) {
        Field stepOrder = DSL.field((Name)DSL.name((String)"step_order"), Integer.class);
        Table<Record9<Long, Long, Long, String, String, String, String, String, String>> cufTestCaseTable = this.customFieldPivotDao.getCustomFieldValuesTableByProjectIdAndBindableEntity(projectId, BindableEntity.TEST_CASE);
        Table<Record9<Long, Long, Long, String, String, String, String, String, String>> cufTestStepTable = this.customFieldPivotDao.getCustomFieldValuesTableByProjectIdAndBindableEntity(projectId, BindableEntity.TEST_STEP);
        return this.dsl.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (SelectField)DSL.val(null, Integer.class).as(stepOrder), CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID, CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_TYPE, CustomFieldPivotDao.CFV_TABLE_CF_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).join(cufTestCaseTable).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq(CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId).and(ConditionsConstants.TCLN_NOT_IN_BIN)).unionAll((Select)DSL.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (SelectField)Tables.TEST_CASE_STEPS.STEP_ORDER.as(stepOrder), CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID, CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_TYPE, CustomFieldPivotDao.CFV_TABLE_CF_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).join((TableLike)Tables.TEST_CASE_STEPS).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE_STEPS.TEST_CASE_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).join(cufTestStepTable).on(Tables.TEST_CASE_STEPS.STEP_ID.eq(CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId))).orderBy((OrderField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (OrderField)stepOrder).fetchSize(50);
    }

    private ResultQuery<? extends Record> getAttachmentByProjectIdQuery(Long projectId) {
        Field stepOrder = DSL.field((Name)DSL.name((String)"step_order"), Integer.class);
        CommonTableExpression<Record1<Long>> cteTestCaseWithNonProjectTc = this.getCteTestCaseWithNonProjectTcByProjectId(projectId);
        SelectOnConditionStep testCaseQuery = this.dsl.withRecursive(new CommonTableExpression[]{cteTestCaseWithNonProjectTc}).select(TestCasePivotDao.TEST_CASE_CTE_TCLN_ID, (SelectField)DSL.val(null, Integer.class).as(stepOrder), (SelectField)TestCasePivotDao.TEST_CASE_CTE_TCLN_ID.as(TestCasePivotDao.ATTACHMENT_HOLDER_ID), (SelectField)DSL.val((String)AttachmentEntity.TEST_CASE.toString()).as(TestCasePivotDao.ATTACHMENT_HOLDER_TYPE), (SelectField)Tables.ATTACHMENT.ATTACHMENT_LIST_ID, (SelectField)Tables.ATTACHMENT.ATTACHMENT_ID, (SelectField)Tables.ATTACHMENT.NAME, (SelectField)Tables.ATTACHMENT.TYPE, (SelectField)Tables.ATTACHMENT.ADDED_ON, (SelectField)Tables.ATTACHMENT.LAST_MODIFIED_ON, (SelectField)Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID, (SelectField)Tables.ATTACHMENT_CONTENT.STREAM_CONTENT).from(cteTestCaseWithNonProjectTc).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(TestCasePivotDao.TEST_CASE_CTE_TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).join((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).join((TableLike)Tables.ATTACHMENT).on(Tables.ATTACHMENT.ATTACHMENT_LIST_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.ATTACHMENT_LIST_ID)).join((TableLike)Tables.ATTACHMENT_CONTENT).on(Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID.eq((Field)Tables.ATTACHMENT.CONTENT_ID));
        SelectOnConditionStep testStepQuery = this.dsl.select(TestCasePivotDao.TEST_CASE_CTE_TCLN_ID, (SelectField)Tables.TEST_CASE_STEPS.STEP_ORDER.as(stepOrder), (SelectField)Tables.ACTION_TEST_STEP.TEST_STEP_ID.as(TestCasePivotDao.ATTACHMENT_HOLDER_ID), (SelectField)DSL.val((String)AttachmentEntity.TEST_STEP.toString()).as(TestCasePivotDao.ATTACHMENT_HOLDER_TYPE), (SelectField)Tables.ATTACHMENT.ATTACHMENT_LIST_ID, (SelectField)Tables.ATTACHMENT.ATTACHMENT_ID, (SelectField)Tables.ATTACHMENT.NAME, (SelectField)Tables.ATTACHMENT.TYPE, (SelectField)Tables.ATTACHMENT.ADDED_ON, (SelectField)Tables.ATTACHMENT.LAST_MODIFIED_ON, (SelectField)Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID, (SelectField)Tables.ATTACHMENT_CONTENT.STREAM_CONTENT).from(cteTestCaseWithNonProjectTc).join((TableLike)Tables.TEST_CASE_STEPS).on(TestCasePivotDao.TEST_CASE_CTE_TCLN_ID.eq((Field)Tables.TEST_CASE_STEPS.TEST_CASE_ID)).join((TableLike)Tables.ACTION_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.ACTION_TEST_STEP.TEST_STEP_ID)).join((TableLike)Tables.ATTACHMENT).on(Tables.ATTACHMENT.ATTACHMENT_LIST_ID.eq((Field)Tables.ACTION_TEST_STEP.ATTACHMENT_LIST_ID)).join((TableLike)Tables.ATTACHMENT_CONTENT).on(Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID.eq((Field)Tables.ATTACHMENT.CONTENT_ID));
        return testCaseQuery.unionAll((Select)testStepQuery).orderBy((OrderField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (OrderField)Tables.TEST_CASE_STEPS.STEP_ORDER).fetchSize(50);
    }

    private ResultQuery<? extends Record> getMilestoneByProjectIdQuery(Long projectId) {
        return this.dsl.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (SelectField)Tables.MILESTONE_TEST_CASE.MILESTONE_ID).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).join((TableLike)Tables.MILESTONE_TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.MILESTONE_TEST_CASE.TEST_CASE_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).and(ConditionsConstants.TCLN_NOT_IN_BIN).orderBy((OrderField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID);
    }

    @Override
    public void getTestCaseByProjectId(Long projectId, Consumer<TestCasePivot> writingToJsonConsumer, Consumer<AttachmentPivot> writingAttachmentConsumer) {
        this.convertRecordAndWritingPivot(this.getTestCaseByProjectIdQuery(projectId), projectId, EntityBindingField.TEST_CASE, writingToJsonConsumer, writingAttachmentConsumer);
    }

    @Override
    protected TestCasePivot getNewPivotObject(Record record, Long projectId, EntityBindingField entityBindingField) {
        TestCasePivot testCasePivot = this.testCasePivotConverterService.testCaseRecordToTestCasePivot(record, projectId);
        this.appendSteps(record, testCasePivot);
        return testCasePivot;
    }

    private void appendSteps(Record record, TestCasePivot testCasePivot) {
        switch (testCasePivot.getTestCaseKind()) {
            case STANDARD: {
                if (record.get((Field)Tables.ACTION_TEST_STEP.TEST_STEP_ID) == null) {
                    return;
                }
                ActionStepPivot actionStepPivot = this.testCasePivotConverterService.actionStepRecordToActionStepPivot(record);
                testCasePivot.addActionSteps(actionStepPivot);
                break;
            }
            case KEYWORD: {
                if (record.get((Field)Tables.TEST_CASE_STEPS.STEP_ID) == null) {
                    return;
                }
                KeywordPivot keywordPivot = this.testCasePivotConverterService.keywordStepRecordToKeywordPivot(record);
                testCasePivot.getKeywordSteps().add(keywordPivot);
                break;
            }
        }
    }

    @Override
    protected void fillPivotObject(TestCasePivot pivotObject, Record record) {
        this.appendSteps(record, pivotObject);
    }

    @Override
    protected List<SubElementRecordProcessor<? extends AbstractPivotObject>> getSubElementRecordProcessors(Long projectId, EntityBindingField entityBindingField) {
        return List.of(this.getCufTestCasePivotContainer(projectId), this.getDatasetPivotContainer(projectId), this.getDatasetParamPivotContainer(projectId), this.getMilestoneTestCasePivotContainer(projectId), this.getAttachmentPivotContainer(this.getAttachmentByProjectIdQuery(projectId), TestCasePivotDao.TEST_CASE_CTE_TCLN_ID, (Record record) -> this.adminPivotConverterService.recordToAttachmentPivot((Record)record, TestCasePivotDao.ATTACHMENT_HOLDER_ID, TestCasePivotDao.ATTACHMENT_HOLDER_TYPE)));
    }

    private SubElementRecordProcessor<DatasetParamPivot> getDatasetParamPivotContainer(Long projectId) {
        return new SubElementRecordProcessor<DatasetParamPivot>(this.getParameterByProjectIdQuery(projectId), (Field<Long>)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (Field<Long>)Tables.PARAMETER.PARAM_ID, this.testCasePivotConverterService::datasetParamRecordToDatasetParamPivot, DatasetParamPivot.class);
    }

    private SubElementRecordProcessor<DatasetPivot> getDatasetPivotContainer(Long projectId) {
        return new SubElementRecordProcessor<DatasetPivot>(this.getDatasetWithParamValueByProjectIdQuery(projectId), (Field<Long>)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (Field<Long>)Tables.DATASET.DATASET_ID, this.testCasePivotConverterService::datasetRecordToDatasetPivot, this::appendParamValueToDatasetPivot, DatasetPivot.class);
    }

    private void appendParamValueToDatasetPivot(DatasetPivot datasetPivot, Record record) {
        DatasetPivot.ParamValue paramValue = this.testCasePivotConverterService.datasetParamValueRecordToDatasetParamValuePivot(record);
        if (paramValue != null) {
            datasetPivot.addParamValues(paramValue);
        }
    }

    private SubElementRecordProcessor<CustomFieldValuePivot> getCufTestCasePivotContainer(Long projectId) {
        return new SubElementRecordProcessor<CustomFieldValuePivot>(this.getCustomFieldByProjectIdQuery(projectId), (Field<Long>)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE_ID, this.customFieldPivotDao::cufValueRecordToCufValuePivot, CustomFieldValuePivot.class);
    }

    private SubElementRecordProcessor<MilestonePivot> getMilestoneTestCasePivotContainer(Long projectId) {
        return new SubElementRecordProcessor<MilestonePivot>(this.getMilestoneByProjectIdQuery(projectId), (Field<Long>)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (Field<Long>)Tables.MILESTONE_TEST_CASE.MILESTONE_ID, record -> this.adminPivotConverterService.recordToBindingMilestonePivot((Record)record, (Field<Long>)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (Field<Long>)Tables.MILESTONE_TEST_CASE.MILESTONE_ID), MilestonePivot.class);
    }

    @Override
    protected void appendSubElementsToPivotObject(TestCasePivot pivotObject, Map<Class<? extends AbstractPivotObject>, List<? extends AbstractPivotObject>> subElementsByClazz, Consumer<AttachmentPivot> writingAttachmentConsumer) {
        pivotObject.addAllDatasets(this.getSubElement(DatasetPivot.class, subElementsByClazz));
        pivotObject.addAllDatasetParams(this.getSubElement(DatasetParamPivot.class, subElementsByClazz));
        this.appendCufAndAttachment(pivotObject, this.getSubElement(CustomFieldValuePivot.class, subElementsByClazz), this.getSubElement(AttachmentPivot.class, subElementsByClazz), writingAttachmentConsumer);
        this.getSubElement(MilestonePivot.class, subElementsByClazz).forEach(milestonePivot -> pivotObject.addMilestone(milestonePivot.getPivotId()));
    }

    private void appendCufAndAttachment(TestCasePivot testCasePivot, List<CustomFieldValuePivot> customFieldValuePivots, List<AttachmentPivot> attachmentPivots, Consumer<AttachmentPivot> writingAttachmentConsumer) {
        if (customFieldValuePivots.isEmpty() && attachmentPivots.isEmpty()) {
            return;
        }
        Map<Long, ActionStepPivot> actionStepByStepId = testCasePivot.getActionSteps().stream().collect(Collectors.toMap(AbstractPivotObject::pivotIdToSquashId, Function.identity()));
        this.appendCufPivot(actionStepByStepId, testCasePivot, customFieldValuePivots);
        this.addAndWriteAttachmentPivot(testCasePivot, attachmentPivots, actionStepByStepId, writingAttachmentConsumer);
    }

    private void appendCufPivot(Map<Long, ActionStepPivot> actionStepByStepId, TestCasePivot testCasePivot, List<CustomFieldValuePivot> customFieldValuePivots) {
        customFieldValuePivots.forEach(customFieldValuePivot -> {
            if (BindableEntity.TEST_CASE.equals((Object)customFieldValuePivot.getBindableEntity())) {
                testCasePivot.addCustomField((CustomFieldValuePivot)customFieldValuePivot);
                return;
            }
            actionStepByStepId.computeIfPresent(customFieldValuePivot.getBindableId(), (k, v) -> {
                v.addCustomField((CustomFieldValuePivot)customFieldValuePivot);
                return v;
            });
        });
    }

    private void addAndWriteAttachmentPivot(TestCasePivot testCasePivot, List<AttachmentPivot> attachmentPivots, Map<Long, ActionStepPivot> actionStepByStepId, Consumer<AttachmentPivot> writingAttachmentConsumer) {
        this.addAndWriteAttachmentPivot(attachmentPivots, testCasePivot, AttachmentEntity.TEST_CASE, Map.of(AttachmentEntity.TEST_STEP, actionStepByStepId), writingAttachmentConsumer);
    }
}

