/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter.dao;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jooq.CommonTableExpression;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Record2;
import org.jooq.Record9;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.CampaignFolder;
import org.squashtest.tm.jooq.domain.tables.SprintGroup;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AttachmentPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.FolderPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.PivotAttachmentEntity;
import org.squashtest.tm.service.internal.jooq.SubElementRecordProcessor;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.AbstractPivotDao;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.EntityBindingField;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.converters.FolderPivotConverterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.CustomFieldPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.FolderPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.TestCasePivotDao;

@Repository
public class FolderPivotDaoImpl
extends AbstractPivotDao<FolderPivot>
implements FolderPivotDao {
    private static final Field<Short> MAX_DEPTH = DSL.field((String)"max_depth", Short.class);
    private final CustomFieldPivotDao customFieldPivotDao;
    private final FolderPivotConverterService folderPivotConverterService;
    private final TestCasePivotDao testCasePivotDao;

    public FolderPivotDaoImpl(DSLContext dsl, AdminPivotConverterService adminPivotConverterService, CustomFieldPivotDao customFieldPivotDao, TestCasePivotDao testCasePivotDao, FolderPivotConverterService folderPivotConverterService) {
        super(dsl, adminPivotConverterService);
        this.customFieldPivotDao = customFieldPivotDao;
        this.testCasePivotDao = testCasePivotDao;
        this.folderPivotConverterService = folderPivotConverterService;
    }

    @Override
    public boolean hasRequirementFolders(Long projectId) {
        return this.dsl.fetchExists((Select)DSL.selectOne().from((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).join((TableLike)Tables.REQUIREMENT_FOLDER).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT_FOLDER.RLN_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)));
    }

    @Override
    public boolean hasTestCaseFolders(Long projectId) {
        boolean hasTestCaseFolder = this.dsl.fetchExists((Select)DSL.selectOne().from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).join((TableLike)Tables.TEST_CASE_FOLDER).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE_FOLDER.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)));
        if (hasTestCaseFolder) {
            return true;
        }
        return this.testCasePivotDao.hasTestCaseOutsideProject(projectId);
    }

    @Override
    public boolean hasCampaignFolderOrSprintGroup(Long projectId) {
        return this.dsl.fetchExists((Select)DSL.selectOne().from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).leftJoin((TableLike)Tables.CAMPAIGN_FOLDER).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN_FOLDER.CLN_ID)).leftJoin((TableLike)Tables.SPRINT_GROUP).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.SPRINT_GROUP.CLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).and(Tables.CAMPAIGN_FOLDER.CLN_ID.isNotNull().or(Tables.SPRINT_GROUP.CLN_ID.isNotNull())));
    }

    private ResultQuery<Record2<Long, String>> getNonProjectRequirementFolderQuery(Long projectId) {
        return this.dsl.select((SelectField)Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID, (SelectField)Tables.PROJECT.NAME).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_ID)).join((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.SPRINT_REQ_VERSION.REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).join((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).join((TableLike)Tables.PROJECT).on(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.notEqual((Object)projectId)).groupBy(new GroupField[]{Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID, Tables.PROJECT.PROJECT_ID, Tables.PROJECT.NAME}).orderBy((OrderField)Tables.PROJECT.PROJECT_ID).fetchSize(50);
    }

    @Override
    public void getRequirementFoldersByProjectId(Long projectId, Consumer<FolderPivot> writingToJsonConsumer, Consumer<AttachmentPivot> writingAttachmentConsumer) {
        Table<Record9<Long, Long, Long, String, String, String, String, String, String>> customFieldValuesTable = this.customFieldPivotDao.getCustomFieldValuesTableByProjectIdAndBindableEntity(projectId, BindableEntity.REQUIREMENT_FOLDER);
        Table<Record2<Long, Short>> maxDepthDescendantTable = this.getMaxDepthRequirementRelationshipClosure(projectId);
        ResultQuery resultQuery = this.dsl.select((SelectField)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, (SelectField)Tables.RESOURCE.NAME, (SelectField)Tables.RESOURCE.DESCRIPTION, (SelectField)Tables.RESOURCE.CREATED_BY, (SelectField)Tables.RESOURCE.CREATED_ON, (SelectField)Tables.RESOURCE.LAST_MODIFIED_BY, (SelectField)Tables.RESOURCE.LAST_MODIFIED_ON, (SelectField)Tables.RLN_RELATIONSHIP.ANCESTOR_ID, CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID, CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_TYPE, CustomFieldPivotDao.CFV_TABLE_CF_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE).from((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).join((TableLike)Tables.REQUIREMENT_FOLDER).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT_FOLDER.RLN_ID)).join((TableLike)Tables.RESOURCE).on(Tables.REQUIREMENT_FOLDER.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).leftJoin((TableLike)Tables.RLN_RELATIONSHIP).on(Tables.RLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.REQUIREMENT_FOLDER.RLN_ID)).join(maxDepthDescendantTable).on(Tables.REQUIREMENT_FOLDER.RLN_ID.eq(maxDepthDescendantTable.field((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID))).leftJoin(customFieldValuesTable).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq(CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy(MAX_DEPTH, (OrderField)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID).fetchSize(50);
        this.generateFolderNonProjectEntity(this.getNonProjectRequirementFolderQuery(projectId), writingToJsonConsumer, EntityType.REQUIREMENT_LIBRARY, EntityType.REQUIREMENT_FOLDER, (Field<Long>)Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID);
        this.convertRecordAndWritingPivot(resultQuery, projectId, EntityBindingField.REQUIREMENT_FOLDER, writingToJsonConsumer, writingAttachmentConsumer);
    }

    private ResultQuery<Record2<Long, String>> getNonProjectTestCaseFolderQuery(Long projectId) {
        CommonTableExpression<Record1<Long>> cteTestCaseWithCalledByProjectId = this.testCasePivotDao.getCteTestCaseWithNonProjectTcByProjectId(projectId);
        return this.dsl.withRecursive(new CommonTableExpression[]{cteTestCaseWithCalledByProjectId}).select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID, (SelectField)Tables.PROJECT.NAME).from(cteTestCaseWithCalledByProjectId).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(TestCasePivotDao.TEST_CASE_CTE_TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).join((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.notEqual((Object)projectId)).groupBy(new GroupField[]{Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID, Tables.PROJECT.PROJECT_ID, Tables.PROJECT.NAME}).orderBy((OrderField)Tables.PROJECT.PROJECT_ID).fetchSize(50);
    }

    @Override
    public void getTestCaseFoldersByProjectId(Long projectId, Consumer<FolderPivot> writingToJsonConsumer, Consumer<AttachmentPivot> writingAttachmentConsumer) {
        Table<Record9<Long, Long, Long, String, String, String, String, String, String>> customFieldValuesTable = this.customFieldPivotDao.getCustomFieldValuesTableByProjectIdAndBindableEntity(projectId, BindableEntity.TESTCASE_FOLDER);
        Table<Record2<Long, Short>> maxDepthDescendantTable = this.getMaxDepthTestCaseRelationshipClosure(projectId);
        ResultQuery resultQuery = this.dsl.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.DESCRIPTION, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.CREATED_BY, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.CREATED_ON, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_BY, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_ON, (SelectField)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID, CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID, CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_TYPE, CustomFieldPivotDao.CFV_TABLE_CF_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).join((TableLike)Tables.TEST_CASE_FOLDER).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE_FOLDER.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).leftJoin((TableLike)Tables.TCLN_RELATIONSHIP).on(Tables.TCLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_FOLDER.TCLN_ID)).join(maxDepthDescendantTable).on(Tables.TEST_CASE_FOLDER.TCLN_ID.eq(maxDepthDescendantTable.field((Field)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID))).leftJoin(customFieldValuesTable).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq(CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy(MAX_DEPTH, (OrderField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).fetchSize(50);
        this.generateFolderNonProjectEntity(this.getNonProjectTestCaseFolderQuery(projectId), writingToJsonConsumer, EntityType.TEST_CASE_LIBRARY, EntityType.TEST_CASE_FOLDER, (Field<Long>)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID);
        this.convertRecordAndWritingPivot(resultQuery, projectId, EntityBindingField.TEST_CASE_FOLDER, writingToJsonConsumer, writingAttachmentConsumer);
    }

    private void generateFolderNonProjectEntity(ResultQuery<Record2<Long, String>> resultQuery, Consumer<FolderPivot> writingToJsonConsumer, EntityType libraryType, EntityType kind, Field<Long> projectIdField) {
        Throwable throwable = null;
        Object var7_8 = null;
        try (Stream stream = resultQuery.fetchStream();){
            Iterator iterator = stream.iterator();
            if (iterator.hasNext()) {
                writingToJsonConsumer.accept(this.folderPivotConverterService.generateMainFolderNonProjectEntity(kind, libraryType));
            }
            while (iterator.hasNext()) {
                Record record = (Record)iterator.next();
                FolderPivot folderPivot = this.folderPivotConverterService.generatedFolderRecordToFolderPivot(record, projectIdField, kind);
                writingToJsonConsumer.accept(folderPivot);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void getCampaignFoldersAndSprintGroupsByProjectId(Long projectId, Consumer<FolderPivot> writingToJsonConsumer, Consumer<AttachmentPivot> writingAttachmentConsumer) {
        Table<Record9<Long, Long, Long, String, String, String, String, String, String>> customFieldValuesTable = this.customFieldPivotDao.getCustomFieldValuesTableByProjectIdAndBindableEntity(projectId, BindableEntity.CAMPAIGN_FOLDER, BindableEntity.SPRINT_GROUP);
        Table<Record2<Long, Short>> maxDepthDescendantTable = this.getMaxDepthCampaignRelationshipClosure(projectId);
        CampaignFolder parentTypeCampaignFolder = Tables.CAMPAIGN_FOLDER.as("PARENT_TYPE_CAMPAIGN_FOLDER");
        SprintGroup parentTypeSprintGroup = Tables.SPRINT_GROUP.as("PARENT_TYPE_SPRINT_GROUP");
        ResultQuery resultQuery = this.dsl.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.NAME, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.DESCRIPTION, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CREATED_BY, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CREATED_ON, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.LAST_MODIFIED_BY, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.LAST_MODIFIED_ON, (SelectField)Tables.CLN_RELATIONSHIP.ANCESTOR_ID, (SelectField)DSL.when((Condition)Tables.CAMPAIGN_FOLDER.CLN_ID.isNotNull(), (Object)EntityType.CAMPAIGN_FOLDER.name()).otherwise((Object)EntityType.SPRINT_GROUP.name()).as(FolderPivotDao.CAMPAIGN_KIND), (SelectField)DSL.when((Condition)parentTypeCampaignFolder.CLN_ID.isNotNull(), (Object)EntityType.CAMPAIGN_FOLDER.name()).when(parentTypeSprintGroup.CLN_ID.isNotNull(), (Object)EntityType.SPRINT_GROUP.name()).otherwise((Object)EntityType.CAMPAIGN_LIBRARY.name()).as(FolderPivotDao.CAMPAIGN_PARENT_TYPE), CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID, CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_TYPE, CustomFieldPivotDao.CFV_TABLE_CF_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join(maxDepthDescendantTable).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq(maxDepthDescendantTable.field((Field)Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID))).leftJoin((TableLike)Tables.CAMPAIGN_FOLDER).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN_FOLDER.CLN_ID)).leftJoin((TableLike)Tables.SPRINT_GROUP).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.SPRINT_GROUP.CLN_ID)).leftJoin((TableLike)Tables.CLN_RELATIONSHIP).on(Tables.CLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)parentTypeCampaignFolder).on(Tables.CLN_RELATIONSHIP.ANCESTOR_ID.eq((Field)parentTypeCampaignFolder.CLN_ID)).leftJoin((TableLike)parentTypeSprintGroup).on(Tables.CLN_RELATIONSHIP.ANCESTOR_ID.eq((Field)parentTypeSprintGroup.CLN_ID)).leftJoin(customFieldValuesTable).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq(CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).and(Tables.CAMPAIGN_FOLDER.CLN_ID.isNotNull().or(Tables.SPRINT_GROUP.CLN_ID.isNotNull())).orderBy(MAX_DEPTH, (OrderField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID).fetchSize(50);
        this.convertRecordAndWritingPivot(resultQuery, projectId, EntityBindingField.CAMPAIGN_FOLDER, writingToJsonConsumer, writingAttachmentConsumer);
    }

    private Table<Record2<Long, Short>> getMaxDepthRequirementRelationshipClosure(Long projectId) {
        return DSL.select((SelectField)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, (SelectField)DSL.max((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH).as(MAX_DEPTH)).from((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).join((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).groupBy(new GroupField[]{Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID}).asTable();
    }

    private Table<Record2<Long, Short>> getMaxDepthTestCaseRelationshipClosure(Long projectId) {
        return DSL.select((SelectField)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, (SelectField)DSL.max((Field)Tables.TCLN_RELATIONSHIP_CLOSURE.DEPTH).as(MAX_DEPTH)).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).groupBy(new GroupField[]{Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID}).asTable();
    }

    private Table<Record2<Long, Short>> getMaxDepthCampaignRelationshipClosure(Long projectId) {
        return DSL.select((SelectField)Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, (SelectField)DSL.max((Field)Tables.CLN_RELATIONSHIP_CLOSURE.DEPTH).as(MAX_DEPTH)).from((TableLike)Tables.CLN_RELATIONSHIP_CLOSURE).join((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).groupBy(new GroupField[]{Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID}).asTable();
    }

    private ResultQuery<? extends Record> getRequirementFolderAttachment(Long projectId) {
        Table<Record2<Long, Short>> maxDepthDescendantTable = this.getMaxDepthRequirementRelationshipClosure(projectId);
        return this.dsl.select((SelectField)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, (SelectField)Tables.REQUIREMENT_FOLDER.RES_ID, (SelectField)Tables.ATTACHMENT.ATTACHMENT_LIST_ID, (SelectField)Tables.ATTACHMENT.ATTACHMENT_ID, (SelectField)Tables.ATTACHMENT.NAME, (SelectField)Tables.ATTACHMENT.TYPE, (SelectField)Tables.ATTACHMENT.ADDED_ON, (SelectField)Tables.ATTACHMENT.LAST_MODIFIED_ON, (SelectField)Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID, (SelectField)Tables.ATTACHMENT_CONTENT.STREAM_CONTENT).from((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).join((TableLike)Tables.REQUIREMENT_FOLDER).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT_FOLDER.RLN_ID)).join((TableLike)Tables.RESOURCE).on(Tables.REQUIREMENT_FOLDER.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).join((TableLike)Tables.ATTACHMENT).on(Tables.ATTACHMENT.ATTACHMENT_LIST_ID.eq((Field)Tables.RESOURCE.ATTACHMENT_LIST_ID)).join((TableLike)Tables.ATTACHMENT_CONTENT).on(Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID.eq((Field)Tables.ATTACHMENT.CONTENT_ID)).join(maxDepthDescendantTable).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq(maxDepthDescendantTable.field((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID))).orderBy(MAX_DEPTH, (OrderField)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID).fetchSize(50);
    }

    private ResultQuery<? extends Record> getTestCaseFolderAttachment(Long projectId) {
        Table<Record2<Long, Short>> maxDepthDescendantTable = this.getMaxDepthTestCaseRelationshipClosure(projectId);
        return this.dsl.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (SelectField)Tables.ATTACHMENT.ATTACHMENT_LIST_ID, (SelectField)Tables.ATTACHMENT.ATTACHMENT_ID, (SelectField)Tables.ATTACHMENT.NAME, (SelectField)Tables.ATTACHMENT.TYPE, (SelectField)Tables.ATTACHMENT.ADDED_ON, (SelectField)Tables.ATTACHMENT.LAST_MODIFIED_ON, (SelectField)Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID, (SelectField)Tables.ATTACHMENT_CONTENT.STREAM_CONTENT).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).join((TableLike)Tables.TEST_CASE_FOLDER).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE_FOLDER.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).join((TableLike)Tables.ATTACHMENT).on(Tables.ATTACHMENT.ATTACHMENT_LIST_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.ATTACHMENT_LIST_ID)).join((TableLike)Tables.ATTACHMENT_CONTENT).on(Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID.eq((Field)Tables.ATTACHMENT.CONTENT_ID)).join(maxDepthDescendantTable).on(Tables.TEST_CASE_FOLDER.TCLN_ID.eq(maxDepthDescendantTable.field((Field)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID))).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy(MAX_DEPTH, (OrderField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).fetchSize(50);
    }

    private ResultQuery<? extends Record> getCampaignFolderAndSprintGroupFolder(Long projectId) {
        Table<Record2<Long, Short>> maxDepthDescendantTable = this.getMaxDepthCampaignRelationshipClosure(projectId);
        return this.dsl.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (SelectField)Tables.ATTACHMENT.ATTACHMENT_LIST_ID, (SelectField)Tables.ATTACHMENT.ATTACHMENT_ID, (SelectField)DSL.when((Condition)Tables.CAMPAIGN_FOLDER.CLN_ID.isNotNull(), (Object)EntityType.CAMPAIGN_FOLDER.name()).otherwise((Object)EntityType.SPRINT_GROUP.name()).as(TestCasePivotDao.ATTACHMENT_HOLDER_TYPE), (SelectField)Tables.ATTACHMENT.NAME, (SelectField)Tables.ATTACHMENT.TYPE, (SelectField)Tables.ATTACHMENT.ADDED_ON, (SelectField)Tables.ATTACHMENT.LAST_MODIFIED_ON, (SelectField)Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID, (SelectField)Tables.ATTACHMENT_CONTENT.STREAM_CONTENT).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).leftJoin((TableLike)Tables.CAMPAIGN_FOLDER).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN_FOLDER.CLN_ID)).leftJoin((TableLike)Tables.SPRINT_GROUP).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.SPRINT_GROUP.CLN_ID)).join((TableLike)Tables.ATTACHMENT).on(Tables.ATTACHMENT.ATTACHMENT_LIST_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.ATTACHMENT_LIST_ID)).join((TableLike)Tables.ATTACHMENT_CONTENT).on(Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID.eq((Field)Tables.ATTACHMENT.CONTENT_ID)).join(maxDepthDescendantTable).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq(maxDepthDescendantTable.field((Field)Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID))).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).and(Tables.CAMPAIGN_FOLDER.CLN_ID.isNotNull().or(Tables.SPRINT_GROUP.CLN_ID.isNotNull())).orderBy(MAX_DEPTH, (OrderField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID).fetchSize(50);
    }

    @Override
    protected FolderPivot getNewPivotObject(Record record, Long projectId, EntityBindingField entityBindingField) {
        FolderPivot folderPivot = this.folderPivotConverterService.folderRecordToFolderPivot(record, entityBindingField.getEntityType());
        this.customFieldPivotDao.appendCustomFieldValuesFromRecord(folderPivot.getCustomFields(), record);
        return folderPivot;
    }

    @Override
    protected void fillPivotObject(FolderPivot pivotObject, Record record) {
        this.customFieldPivotDao.appendCustomFieldValuesFromRecord(pivotObject.getCustomFields(), record);
    }

    @Override
    protected List<SubElementRecordProcessor<? extends AbstractPivotObject>> getSubElementRecordProcessors(Long projectId, EntityBindingField entityBindingField) {
        return List.of(this.getAttachmentPivotContainer(projectId, entityBindingField));
    }

    private SubElementRecordProcessor<AttachmentPivot> getAttachmentPivotContainer(Long projectId, EntityBindingField entityBindingField) {
        return switch (entityBindingField) {
            case EntityBindingField.REQUIREMENT_FOLDER -> this.getAttachmentPivotContainer(this.getRequirementFolderAttachment(projectId), (Field<Long>)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, (Field<Long>)Tables.REQUIREMENT_FOLDER.RES_ID);
            case EntityBindingField.TEST_CASE_FOLDER -> this.getAttachmentPivotContainer(this.getTestCaseFolderAttachment(projectId), (Field<Long>)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID);
            case EntityBindingField.CAMPAIGN_FOLDER -> this.getAttachmentPivotContainer(this.getCampaignFolderAndSprintGroupFolder(projectId), (Field<Long>)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (Record record) -> this.adminPivotConverterService.recordToAttachmentPivot((Record)record, (Field<Long>)Tables.ATTACHMENT.ATTACHMENT_ID, TestCasePivotDao.ATTACHMENT_HOLDER_TYPE));
            default -> throw new UnsupportedOperationException();
        };
    }

    @Override
    protected void appendSubElementsToPivotObject(FolderPivot pivotObject, Map<Class<? extends AbstractPivotObject>, List<? extends AbstractPivotObject>> subElementsByClazz, Consumer<AttachmentPivot> writingAttachmentConsumer) {
        this.addAndWriteAttachmentPivot(this.getSubElement(AttachmentPivot.class, subElementsByClazz), (PivotAttachmentEntity)pivotObject, writingAttachmentConsumer);
    }
}

