/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.library;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.squashtest.tm.service.internal.library.LibraryUtils;

public class CompareFieldStringEntity<T> {
    private final Map<String, FieldIndex<T>> fieldIndexes = new HashMap<String, FieldIndex<T>>();

    public CompareFieldStringEntity(List<T> items, Map<String, Function<T, String>> fieldExtractors) {
        items.forEach(item -> fieldExtractors.forEach((fieldName, extractor) -> this.fieldIndexes.computeIfAbsent((String)fieldName, k -> new FieldIndex()).buildIndex(item, extractor)));
    }

    public Comparison<T> checkField(String fieldName, String fieldValue) {
        FieldIndex<T> index = this.fieldIndexes.get(fieldName);
        if (index != null) {
            return index.checkSimilarities(fieldValue);
        }
        return new Comparison(false, Collections.emptySet(), Collections.emptySet());
    }

    public record Comparison<U>(boolean isMatched, Set<U> entities, Set<String> clashingNames) {
        private Comparison(Set<U> entities, Set<String> clashingNames) {
            this(!entities.isEmpty(), entities, clashingNames);
        }
    }

    private static final class FieldIndex<U> {
        private final Map<String, Set<U>> exactMatches = new HashMap<String, Set<U>>();
        private final Map<String, Set<String>> clashingNamesMatches = new HashMap<String, Set<String>>();

        private FieldIndex() {
        }

        private void buildIndex(U item, Function<U, String> fieldExtractor) {
            String fieldValue = fieldExtractor.apply(item);
            if (fieldValue != null) {
                this.exactMatches.computeIfAbsent(fieldValue, k -> new HashSet()).add(item);
                String baseName = LibraryUtils.removeTokenPart(fieldValue);
                this.addClashingName(baseName, fieldValue);
            }
        }

        private void addClashingName(String baseName, String fullName) {
            if (this.clashingNamesMatches.containsKey(baseName)) {
                this.clashingNamesMatches.get(baseName).add(fullName);
                return;
            }
            Set<String> keyMatching = this.clashingNamesMatches.keySet().stream().filter(existingValues -> existingValues.contains(baseName)).collect(Collectors.toSet());
            if (!keyMatching.isEmpty()) {
                keyMatching.forEach(existingKey -> {
                    boolean bl = this.clashingNamesMatches.get(existingKey).add(fullName);
                });
            }
            this.clashingNamesMatches.computeIfAbsent(fullName, k -> new HashSet(keyMatching)).add(fullName);
        }

        private Comparison<U> checkSimilarities(String searchField) {
            Set matchedLinks = this.exactMatches.getOrDefault(searchField, Collections.emptySet());
            Set<String> similarities = this.clashingNamesMatches.getOrDefault(LibraryUtils.removeTokenPart(searchField), Collections.emptySet());
            return new Comparison(matchedLinks, similarities);
        }
    }
}

