/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractAuditablePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AttachmentPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.CustomFieldValuePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.DenormalizedValuePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.InfoListItemPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.PivotBoundEntity;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.ExecutionStepPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.SessionEventPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.SessionNotePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.AbstractTestCasePivot;

public class ExecutionPivot
extends AbstractAuditablePivot
implements PivotBoundEntity {
    @JsonProperty(value="test_plan_item_id")
    private String testPlanItemId;
    @JsonProperty(value="execution_order")
    private Integer executionOrder;
    @JsonProperty(value="status")
    private ExecutionStatus status;
    @JsonProperty(value="comment")
    private String comment;
    @JsonProperty(value="last_executed_by")
    private String lastExecutedBy;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss.SSS")
    @JsonProperty(value="last_executed_on")
    private Date lastExecutedOn;
    @JsonProperty(value="execution_steps")
    private List<ExecutionStepPivot> executionSteps = new ArrayList<ExecutionStepPivot>();
    @JsonProperty(value="reviewed")
    private Boolean reviewed;
    @JsonProperty(value="task_division")
    private String taskDivision;
    @JsonProperty(value="session_notes")
    private List<SessionNotePivot> sessionNotePivots = new ArrayList<SessionNotePivot>();
    @JsonProperty(value="session_events")
    private List<SessionEventPivot> sessionEventPivots = new ArrayList<SessionEventPivot>();
    @JsonProperty(value="test_case_denormalized")
    private TestCasePivotDenormalize testCase;
    @JsonProperty(value="denormalized_values")
    private List<DenormalizedValuePivot> denormalizedValues = new ArrayList<DenormalizedValuePivot>();
    @JsonProperty(value="custom_fields")
    private List<CustomFieldValuePivot> customFields = new ArrayList<CustomFieldValuePivot>();
    @JsonProperty(value="attachments")
    private List<AttachmentPivot> attachments = new ArrayList<AttachmentPivot>();

    @Override
    public String getBasePivotId() {
        return "EX";
    }

    public String getTestPlanItemId() {
        return this.testPlanItemId;
    }

    public void setTestPlanItemId(String testPlanItemId) {
        this.testPlanItemId = testPlanItemId;
    }

    public void setTestPlanItemId(Long testPlanItemId) {
        this.testPlanItemId = ExecutionPivot.getPivotId("TPI", testPlanItemId);
    }

    public Integer getExecutionOrder() {
        return this.executionOrder;
    }

    public void setExecutionOrder(Integer executionOrder) {
        this.executionOrder = executionOrder;
    }

    public ExecutionStatus getStatus() {
        return this.status;
    }

    public void setStatus(ExecutionStatus status) {
        this.status = status;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getLastExecutedBy() {
        return this.lastExecutedBy;
    }

    public void setLastExecutedBy(String lastExecutedBy) {
        this.lastExecutedBy = lastExecutedBy;
    }

    public Date getLastExecutedOn() {
        return this.lastExecutedOn;
    }

    public void setLastExecutedOn(Date lastExecutedOn) {
        this.lastExecutedOn = lastExecutedOn;
    }

    public List<ExecutionStepPivot> getExecutionSteps() {
        return this.executionSteps;
    }

    public void setExecutionSteps(List<ExecutionStepPivot> executionSteps) {
        this.executionSteps = executionSteps;
    }

    public void addExecutionSteps(ExecutionStepPivot executionStep) {
        this.executionSteps.add(executionStep);
    }

    public Boolean isReviewed() {
        return this.reviewed;
    }

    public void setReviewed(Boolean reviewed) {
        this.reviewed = reviewed;
    }

    public String getTaskDivision() {
        return this.taskDivision;
    }

    public void setTaskDivision(String taskDivision) {
        this.taskDivision = taskDivision;
    }

    public List<SessionNotePivot> getSessionNotePivots() {
        return this.sessionNotePivots;
    }

    public void setSessionNotePivots(List<SessionNotePivot> sessionNotePivots) {
        this.sessionNotePivots = sessionNotePivots;
    }

    public void addSessionNotePivot(SessionNotePivot sessionNotePivot) {
        this.sessionNotePivots.add(sessionNotePivot);
    }

    public List<SessionEventPivot> getSessionEventPivots() {
        return this.sessionEventPivots;
    }

    public void setSessionEventPivots(List<SessionEventPivot> sessionEventPivots) {
        this.sessionEventPivots = sessionEventPivots;
    }

    public void addAllSessionEvent(List<SessionEventPivot> sessionEventPivots) {
        this.sessionEventPivots.addAll(sessionEventPivots);
    }

    public List<DenormalizedValuePivot> getDenormalizedValues() {
        return this.denormalizedValues;
    }

    public void setDenormalizedValues(List<DenormalizedValuePivot> denormalizedValues) {
        this.denormalizedValues = denormalizedValues;
    }

    public void addDenormalizedValue(DenormalizedValuePivot denormalizedValue) {
        this.denormalizedValues.add(denormalizedValue);
    }

    @Override
    public List<CustomFieldValuePivot> getCustomFields() {
        return this.customFields;
    }

    @Override
    public void setCustomFields(List<CustomFieldValuePivot> customFields) {
        this.customFields = customFields;
    }

    @Override
    public void addCustomField(CustomFieldValuePivot customFieldValue) {
        this.customFields.add(customFieldValue);
    }

    @Override
    public void addAllCustomFields(List<CustomFieldValuePivot> customFields) {
        this.customFields.addAll(customFields);
    }

    @Override
    public List<AttachmentPivot> getAttachments() {
        return this.attachments;
    }

    @Override
    public void setAttachments(List<AttachmentPivot> attachments) {
        this.attachments = attachments;
    }

    @Override
    public void addAttachment(AttachmentPivot attachment) {
        this.attachments.add(attachment);
    }

    public TestCasePivotDenormalize getTestCase() {
        return this.testCase;
    }

    public void setTestCase(TestCasePivotDenormalize testCase) {
        this.testCase = testCase;
    }

    public static class TestCasePivotDenormalize
    extends AbstractTestCasePivot {
        @JsonProperty(value="dataset_label")
        private String datasetLabel;
        @JsonProperty(value="nature")
        private InfoListItemPivot nature;
        @JsonProperty(value="type")
        private InfoListItemPivot type;

        public String getDatasetLabel() {
            return this.datasetLabel;
        }

        public void setDatasetLabel(String datasetLabel) {
            this.datasetLabel = datasetLabel;
        }

        public InfoListItemPivot getNature() {
            return this.nature;
        }

        public void setNature(InfoListItemPivot nature) {
            this.nature = nature;
        }

        public InfoListItemPivot getType() {
            return this.type;
        }

        public void setType(InfoListItemPivot type) {
            this.type = type;
        }
    }
}

