/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.trash;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.display.trash.TestCaseBinService;
import org.squashtest.tm.service.internal.deletion.NodeScope;
import org.squashtest.tm.service.internal.repository.hibernate.TestCaseBinDao;
import org.squashtest.tm.service.internal.testcase.TestCaseNodeDeletionHandler;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service
@Transactional
public class TestCaseBinServiceImpl
implements TestCaseBinService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCaseBinServiceImpl.class);
    private final PermissionEvaluationService permissionEvaluationService;
    private final TestCaseNodeDeletionHandler deletionHandler;
    private final TestCaseBinDao testCaseBinDao;

    public TestCaseBinServiceImpl(PermissionEvaluationService permissionEvaluationService, TestCaseNodeDeletionHandler deletionHandler, TestCaseBinDao testCaseBinDao) {
        this.permissionEvaluationService = permissionEvaluationService;
        this.deletionHandler = deletionHandler;
        this.testCaseBinDao = testCaseBinDao;
    }

    @Override
    public List<String> restoreDeletedNodes(NodeScope scope) {
        this.checkPermission(scope);
        OperationReport report = this.deletionHandler.restoreDeletedNodes(scope);
        LOGGER.info("Restored {} nodes, {} renames.", new Object[]{report.getRestored().size(), report.getRenamed().size()});
        return this.findAncestorsToRefresh(scope);
    }

    @Override
    public List<String> hardDeleteNodes(NodeScope scope) {
        this.checkPermission(scope);
        NodeScope parentScope = this.retrieveParentNodeScope(scope);
        OperationReport report = this.deletionHandler.hardDeleteNodes(scope);
        LOGGER.info("Hard deleted {} test case nodes.", new Object[]{report.getRemoved().size()});
        return this.findAncestorsToRefresh(parentScope);
    }

    private NodeScope retrieveParentNodeScope(NodeScope scope) {
        Set<NodeReference> parents = this.testCaseBinDao.getParentReferences(scope.getNodeIds());
        Set libraries = scope.getLibraryIds().stream().map(library -> new NodeReference(NodeType.TEST_CASE_LIBRARY, library)).collect(Collectors.toSet());
        parents.addAll(libraries);
        return new NodeScope(parents);
    }

    private List<String> findAncestorsToRefresh(NodeScope scope) {
        Set<Long> nodeIds = scope.getNodeIds();
        Map<Long, Long> ancestorHavingDeletedNodeByNodeId = this.testCaseBinDao.findFirstAncestorsWithDeletedDescendants(nodeIds);
        Set<Long> nodesWithAncestorHavingDeletedNodes = ancestorHavingDeletedNodeByNodeId.keySet();
        List<Long> nodesWithoutAncestorHavingDeletedNodes = nodeIds.stream().filter(id -> !nodesWithAncestorHavingDeletedNodes.contains(id)).toList();
        HashSet<Long> libraryIds = new HashSet<Long>(scope.getLibraryIds());
        if (!nodesWithoutAncestorHavingDeletedNodes.isEmpty()) {
            libraryIds.addAll(this.testCaseBinDao.findLibraryIdsByNodeIds(nodesWithoutAncestorHavingDeletedNodes));
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Long libraryId : libraryIds) {
            result.add(TestCaseLibrary.class.getSimpleName() + "-" + String.valueOf(libraryId));
        }
        for (Long folderId : ancestorHavingDeletedNodeByNodeId.values()) {
            result.add(TestCaseFolder.class.getSimpleName() + "-" + String.valueOf(folderId));
        }
        return result;
    }

    private void checkPermission(NodeScope scope) {
        List<Long> projectIds = this.testCaseBinDao.getProjectIdsFromScope(scope);
        if (projectIds.isEmpty()) {
            throw new IllegalArgumentException("No project found for the given scope.");
        }
        this.permissionEvaluationService.checkPermission(projectIds, Permissions.MANAGE_PROJECT.name(), Project.class.getName());
    }
}

