/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.campaign;

import java.sql.Timestamp;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Record2;
import org.jooq.Record6;
import org.jooq.Record8;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOnConditionStep;
import org.jooq.impl.DSL;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.records.TestPlanItemRecord;
import org.squashtest.tm.service.internal.display.grid.campaign.AbstractTestPlanGrid;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;

public class SprintReqVersionTestPlanGrid
extends AbstractTestPlanGrid<TestPlanItemRecord> {
    private final long sprintReqVersionId;

    public SprintReqVersionTestPlanGrid(long sprintReqVersionId, String userLoginToRestrictTo) {
        super(userLoginToRestrictTo);
        this.sprintReqVersionId = sprintReqVersionId;
    }

    @Override
    protected TableOnConditionStep<Record> getItemTable() {
        return Tables.TEST_PLAN_ITEM.innerJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID));
    }

    @Override
    protected TableField<TestPlanItemRecord, Long> getItemIdColumn() {
        return Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID;
    }

    @Override
    protected Condition getItemFilterCondition() {
        return Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.eq((Object)this.sprintReqVersionId);
    }

    @Override
    protected TableField<TestPlanItemRecord, Long> getAssigneeIdColumn() {
        return Tables.TEST_PLAN_ITEM.ASSIGNEE_ID;
    }

    @Override
    protected TableField<TestPlanItemRecord, String> getExecutorLoginColumn() {
        return Tables.TEST_PLAN_ITEM.LAST_EXECUTED_BY;
    }

    @Override
    protected TableField<TestPlanItemRecord, Long> getTestCaseIdColumn() {
        return Tables.TEST_PLAN_ITEM.TCLN_ID;
    }

    @Override
    protected List<GridColumn> getSpecificColumns() {
        return List.of(new GridColumn(Tables.TEST_PLAN_ITEM.ITEM_ORDER.as("TEST_PLAN_ITEM_ORDER")), new GridColumn(DSL.field((Name)DSL.name((String[])new String[]{"INFERRED_EXECUTION_MODE", "INFERRED_EXECUTION_MODE"})).as("INFERRED_EXECUTION_MODE")), new GridColumn(this.selectRequirementVersionCoverageId().isNotNull().as("LINKED_TO_REQUIREMENT")));
    }

    @Override
    protected Table<?> getTable() {
        Table<Record8<Long, String, Long, String, String, String, String, String>> testCaseKind = this.getTestCaseTable();
        Table<Record> userTable = this.getUser();
        Table<Record> executorTable = this.getExecutorTable();
        Table<Record2<Long, String>> inferredExecutionModeTable = this.getAutomationFields();
        Table<Record6<Long, Long, String, String, Timestamp, String>> latestExecutionTable = this.getLatestExecutionTable();
        Table<Record1<Long>> hasExecutableSteps = this.getHasExecutableSteps();
        return Tables.TEST_PLAN_ITEM.innerJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID)).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.SPRINT_REQ_VERSION.SPRINT_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin(testCaseKind).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(testCaseKind.field("ITEM_ID", Long.class))).leftJoin(userTable).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(userTable.field("ITEM_ID", Long.class))).leftJoin(executorTable).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(executorTable.field("ITEM_ID", Long.class))).leftJoin(inferredExecutionModeTable).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(inferredExecutionModeTable.field("ITEM_ID", Long.class))).leftJoin(latestExecutionTable).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(latestExecutionTable.field("ITEM_ID", Long.class))).leftJoin(hasExecutableSteps).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(hasExecutableSteps.field("ITEM_ID", Long.class))).leftJoin((TableLike)Tables.DATASET).on(Tables.DATASET.DATASET_ID.eq((Field)Tables.TEST_PLAN_ITEM.DATASET_ID)).leftJoin((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).on(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.eq((Field)Tables.TEST_PLAN_ITEM.OVERVIEW_ID));
    }

    private SelectConditionStep<Record1<Long>> selectRequirementVersionCoverageId() {
        return DSL.select((SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).leftJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT_REQ_VERSION.REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID)).where(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq(DSL.field((Name)DSL.name((String[])new String[]{"TEST_CASE", "TEST_CASE_ID"}), Long.class)).and(Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.eq((Object)this.sprintReqVersionId)));
    }

    @Override
    protected Field<?> getIdentifier() {
        return DSL.field((String)"TEST_PLAN_ITEM_ID");
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return DSL.field((String)"PROJECT_ID");
    }

    @Override
    protected SortField<?> getDefaultOrder() {
        return DSL.field((String)"TEST_PLAN_ITEM_ORDER").asc();
    }
}

