/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.automation;

import java.util.Arrays;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.domain.project.AutomationWorkflowType;
import org.squashtest.tm.domain.testcase.SuggestionStatus;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.TclnRelationshipClosure;
import org.squashtest.tm.service.internal.display.grid.AbstractGrid;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;

public class AutomationEligibleTestsRequestGrid
extends AbstractGrid {
    private final List<Long> projectIds;

    public AutomationEligibleTestsRequestGrid(List<Long> projectIds) {
        this.projectIds = projectIds;
    }

    @Override
    protected List<GridColumn> getColumns() {
        return Arrays.asList(new GridColumn(DSL.field((String)"TCLN_ID")), new GridColumn(DSL.field((String)"PROJECT_NAME")), new GridColumn(DSL.field((String)"NAME")), new GridColumn(DSL.field((String)"REFERENCE")), new GridColumn(DSL.field((String)"KIND")), new GridColumn(DSL.field((String)"PRIORITY")), new GridColumn(DSL.field((String)"TEST_CASE_PATH")));
    }

    @Override
    protected Table<?> getTable() {
        SelectHavingStep<?> testCasePath = this.getTestCasePath();
        SelectHavingStep manualEligibleTests = DSL.select((SelectField)Tables.TEST_CASE.TCLN_ID.as("TCLN_ID"), (SelectField)Tables.PROJECT.NAME.as("PROJECT_NAME"), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME.as("NAME"), (SelectField)Tables.TEST_CASE.REFERENCE.as("REFERENCE"), (SelectField)Tables.SCRIPTED_TEST_CASE.TCLN_ID.as("SCRIPTED_TEST_CASE_ID"), (SelectField)Tables.KEYWORD_TEST_CASE.TCLN_ID.as("KEYWORD_TEST_CASE_ID"), (SelectField)Tables.AUTOMATION_REQUEST.AUTOMATION_PRIORITY.as("PRIORITY"), (SelectField)DSL.when((Condition)Tables.SCRIPTED_TEST_CASE.TCLN_ID.isNotNull(), (Object)"GHERKIN").when(Tables.KEYWORD_TEST_CASE.TCLN_ID.isNotNull(), (Object)"KEYWORD").otherwise((Object)"STANDARD").as("KIND"), (SelectField)this.generateConcatenatedTestCasePath().as("TEST_CASE_PATH")).from((TableLike)Tables.TEST_CASE).join((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.TEST_CASE.AUTOMATION_REQUEST_ID.eq((Field)Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).join((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.SCRIPTED_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.SCRIPTED_TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.KEYWORD_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.KEYWORD_TEST_CASE.TCLN_ID)).leftJoin(testCasePath).on(Tables.TEST_CASE.TCLN_ID.eq(testCasePath.field("TCLN_ID", Long.class))).where(Tables.TEST_CASE.AUTOMATABLE.eq((Object)TestCaseAutomatable.Y.name()).and(Tables.PROJECT.AUTOMATION_WORKFLOW_TYPE.ne((Object)AutomationWorkflowType.NONE.name())).and(Tables.TEST_CASE.AUTOMATED_TEST_REFERENCE.isNull()).and(Tables.PROJECT.PROJECT_ID.in(this.projectIds))).groupBy(new GroupField[]{Tables.TEST_CASE.TCLN_ID, Tables.PROJECT.NAME, Tables.TEST_CASE_LIBRARY_NODE.NAME, Tables.TEST_CASE.REFERENCE, Tables.SCRIPTED_TEST_CASE.TCLN_ID, Tables.KEYWORD_TEST_CASE.TCLN_ID, Tables.AUTOMATION_REQUEST.AUTOMATION_PRIORITY, Tables.PROJECT.AUTOMATION_WORKFLOW_TYPE});
        SelectConditionStep manualTestIds = DSL.select((SelectField)Tables.TEST_CASE.TCLN_ID).from((TableLike)Tables.TEST_CASE).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).join((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).join((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.TEST_CASE.AUTOMATION_REQUEST_ID.eq((Field)Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID)).where(Tables.TEST_CASE.AUTOMATABLE.eq((Object)TestCaseAutomatable.Y.name()).and(Tables.PROJECT.AUTOMATION_WORKFLOW_TYPE.ne((Object)AutomationWorkflowType.NONE.name())).and(Tables.TEST_CASE.AUTOMATED_TEST_REFERENCE.isNull()).and(Tables.PROJECT.PROJECT_ID.in(this.projectIds)));
        SelectHavingStep approvedTests = DSL.select((SelectField)Tables.TEST_CASE.TCLN_ID.as("TCLN_ID"), (SelectField)Tables.PROJECT.NAME.as("PROJECT_NAME"), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME.as("NAME"), (SelectField)Tables.TEST_CASE.REFERENCE.as("REFERENCE"), (SelectField)Tables.SCRIPTED_TEST_CASE.TCLN_ID.as("SCRIPTED_TEST_CASE_ID"), (SelectField)Tables.KEYWORD_TEST_CASE.TCLN_ID.as("KEYWORD_TEST_CASE_ID"), (SelectField)Tables.TEST_AUTOMATION_CANDIDATE.DECIDED_PRIORITY.as("PRIORITY"), (SelectField)DSL.when((Condition)Tables.SCRIPTED_TEST_CASE.TCLN_ID.isNotNull(), (Object)"GHERKIN").when(Tables.KEYWORD_TEST_CASE.TCLN_ID.isNotNull(), (Object)"KEYWORD").otherwise((Object)"STANDARD").as("KIND"), (SelectField)this.generateConcatenatedTestCasePath().as("TEST_CASE_PATH")).from((TableLike)Tables.TEST_AUTOMATION_CANDIDATE).join((TableLike)Tables.TEST_CASE).on(Tables.TEST_AUTOMATION_CANDIDATE.TEST_CASE_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).join((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.TEST_CASE.AUTOMATION_REQUEST_ID.eq((Field)Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID)).leftJoin((TableLike)Tables.SCRIPTED_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.SCRIPTED_TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.KEYWORD_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.KEYWORD_TEST_CASE.TCLN_ID)).leftJoin(testCasePath).on(Tables.TEST_CASE.TCLN_ID.eq(testCasePath.field("TCLN_ID", Long.class))).where(Tables.TEST_AUTOMATION_CANDIDATE.SUGGESTION_STATUS.eq((Object)SuggestionStatus.APPROVED.name()).and(Tables.TEST_CASE.AUTOMATED_TEST_REFERENCE.isNull()).and(Tables.PROJECT.PROJECT_ID.in(this.projectIds)).and(Tables.TEST_CASE.TCLN_ID.notIn((Select)manualTestIds))).groupBy(new GroupField[]{Tables.TEST_CASE.TCLN_ID, Tables.PROJECT.NAME, Tables.TEST_CASE_LIBRARY_NODE.NAME, Tables.TEST_CASE.REFERENCE, Tables.SCRIPTED_TEST_CASE.TCLN_ID, Tables.KEYWORD_TEST_CASE.TCLN_ID, Tables.TEST_AUTOMATION_CANDIDATE.DECIDED_PRIORITY, Tables.PROJECT.AUTOMATION_WORKFLOW_TYPE});
        return manualEligibleTests.unionAll((Select)approvedTests).asTable();
    }

    @Override
    protected Field<?> getIdentifier() {
        return DSL.field((String)"TCLN_ID");
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return null;
    }

    private SelectHavingStep<?> getTestCasePath() {
        TclnRelationshipClosure children = Tables.TCLN_RELATIONSHIP_CLOSURE.as("CHILDREN");
        return DSL.select((SelectField)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.as("TCLN_ID"), (SelectField)Tables.TCLN_RELATIONSHIP_CLOSURE.DEPTH.as("DEPTH"), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME.as("NAME")).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).join((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).join((TableLike)children).on(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)children.ANCESTOR_ID)).leftJoin((TableLike)Tables.TEST_CASE_FOLDER).on(Tables.TEST_CASE_FOLDER.TCLN_ID.eq((Field)children.DESCENDANT_ID)).where(Tables.TEST_CASE_FOLDER.TCLN_ID.isNull()).and(Tables.TCLN_RELATIONSHIP_CLOSURE.DEPTH.ne((Object)0));
    }

    private Field<String> generateConcatenatedTestCasePath() {
        SelectHavingStep<?> testCasePath = this.getTestCasePath();
        Field nodePath = DSL.concat((Field[])new Field[]{Tables.PROJECT.NAME, DSL.val((String)" / "), DSL.groupConcat((Field)testCasePath.field("NAME", String.class)).orderBy(new OrderField[]{testCasePath.field("DEPTH", Integer.class).desc()}).separator(" / ")});
        return DSL.when((Condition)DSL.count((Field)testCasePath.field("NAME", String.class)).ne((Object)0), (Field)nodePath).otherwise((Field)Tables.PROJECT.NAME);
    }
}

