/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.automation;

import java.util.List;
import org.jooq.DSLContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.service.display.automation.AutomationHelperRequestDisplayService;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.automation.AutomationCandidatesRequestGrid;
import org.squashtest.tm.service.internal.display.grid.automation.AutomationEligibleTestsRequestGrid;
import org.squashtest.tm.service.project.ProjectFinder;

@Service
@Transactional(readOnly=true)
public class AutomationHelperRequestDisplayServiceImpl
implements AutomationHelperRequestDisplayService {
    private final ProjectFinder projectFinder;
    private final DSLContext dslContext;

    public AutomationHelperRequestDisplayServiceImpl(ProjectFinder projectFinder, DSLContext dslContext) {
        this.projectFinder = projectFinder;
        this.dslContext = dslContext;
    }

    @Override
    public GridResponse findAutomationCandidatesRequests(GridRequest request) {
        List<Long> readableProjectIds = this.projectFinder.findAllReadableIdsForAutomationHelper();
        AutomationCandidatesRequestGrid grid = new AutomationCandidatesRequestGrid(readableProjectIds);
        return grid.getRows(request, this.dslContext);
    }

    @Override
    public GridResponse findAutomationEligibleTestsRequests(GridRequest request) {
        List<Long> readableProjectIds = this.projectFinder.findAllReadableIdsForAutomationHelper();
        AutomationEligibleTestsRequestGrid grid = new AutomationEligibleTestsRequestGrid(readableProjectIds);
        return grid.getRows(request, this.dslContext);
    }
}

