/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;

public class NodeScope {
    private static final Set<NodeType> NODES = Set.of(NodeType.TEST_CASE_FOLDER, NodeType.TEST_CASE);
    private static final Set<NodeType> LIBRARIES = Set.of(NodeType.TEST_CASE_LIBRARY);
    private final Set<Long> libraryIds = new HashSet<Long>();
    private final Set<Long> nodeIds = new HashSet<Long>();
    private final Set<String> ids = new HashSet<String>();

    public NodeScope(List<String> sources) {
        this(NodeScope.convertToReferences(sources));
    }

    public NodeScope(Set<NodeReference> references) {
        Objects.requireNonNull(references, "references cannot be null");
        references.forEach(nodeReference -> {
            NodeType nodeType = nodeReference.getNodeType();
            if (NODES.contains(nodeType)) {
                this.nodeIds.add(nodeReference.getId());
            } else if (LIBRARIES.contains(nodeType)) {
                this.libraryIds.add(nodeReference.getId());
            } else {
                throw new IllegalArgumentException("Unsupported node type: " + String.valueOf(nodeType));
            }
            this.ids.add(nodeReference.toNodeId());
        });
    }

    private static Set<NodeReference> convertToReferences(List<String> sources) {
        Objects.requireNonNull(sources, "sources cannot be null");
        return sources.stream().map(NodeReference::fromNodeId).collect(Collectors.toSet());
    }

    public Set<Long> getNodeIds() {
        return this.nodeIds;
    }

    public Set<Long> getLibraryIds() {
        return this.libraryIds;
    }

    public boolean hasLibraries() {
        return !this.libraryIds.isEmpty();
    }

    public boolean hasNodes() {
        return !this.nodeIds.isEmpty();
    }

    public Set<String> getIds() {
        return this.ids;
    }

    public boolean isEmpty() {
        return this.libraryIds.isEmpty() && this.nodeIds.isEmpty();
    }
}

