/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign.export;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.squashtest.tm.domain.customfield.BindableEntity;

public enum CampaignExportHeader {
    CPG_SCHEDULED_START_ON("CPG_SCHEDULED_START_ON", true, true, true),
    CPG_SCHEDULED_END_ON("CPG_SCHEDULED_END_ON", true, true, true),
    CPG_ACTUAL_START_ON("CPG_ACTUAL_START_ON", true, true, true),
    CPG_ACTUAL_END_ON("CPG_ACTUAL_END_ON", true, true, true),
    ITERATION("ITERATION", true, false, false),
    IT_ID("IT_ID", false, true, true),
    IT_NUM("IT_NUM", false, true, true),
    IT_NAME("IT_NAME", false, true, true),
    IT_MILESTONE("IT_MILESTONE", true, true, true),
    IT_SCHEDULED_START_ON("IT_SCHEDULED_START_ON", true, true, true),
    IT_SCHEDULED_END_ON("IT_SCHEDULED_END_ON", true, true, true),
    IT_ACTUAL_START_ON("IT_ACTUAL_START_ON", true, true, true),
    IT_ACTUAL_END_ON("IT_ACTUAL_END_ON", true, true, true),
    TEST_CASE("TEST_CASE", true, false, false),
    TC_ID("TC_ID", false, true, true),
    TC_NAME("TC_NAME", true, true, true),
    TC_PROJECT_ID("TC_PROJECT_ID", false, false, true),
    TC_PROJECT("TC_PROJECT", true, true, true),
    TC_MILESTONE("TC_MILESTONE", true, true, true),
    TC_WEIGHT("TC_WEIGHT", true, true, true),
    TEST_SUITE("TEST_SUITE", true, true, true),
    COUNT_EXECUTIONS("#_EXECUTIONS", true, true, true),
    COUNT_TC_COVERAGE("#_REQUIREMENTS", true, true, true),
    COUNT_EXEC_ISSUES("#_ISSUES", true, true, true),
    DATASET("DATASET", true, true, true),
    EXEC_STATUS("EXEC_STATUS", true, true, true),
    EXEC_USER("EXEC_USER", true, true, true),
    EXEC_SUCCESS_RATE("EXEC_SUCCESS_RATE", true, false, false),
    EXECUTION_DATE("EXECUTION_DATE", true, true, true),
    DESCRIPTION("DESCRIPTION", true, false, false),
    TC_REF("TC_REF", true, true, true),
    TC_NATURE("TC_NATURE", true, true, true),
    TC_TYPE("TC_TYPE", true, true, true),
    TC_STATUS("TC_STATUS", true, true, true),
    PREREQUISITE("PREREQUISITE", true, false, false),
    STEP_ID("STEP_ID", false, false, true),
    STEP_NUM("STEP_NUM", false, false, true),
    COUNT_STEP_COVERAGE("STEP_#_REQ", false, false, true),
    EXEC_STEP_STATUS("EXEC_STEP_STATUS", false, false, true),
    EXEC_STEP_DATE("EXEC_STEP_DATE", false, false, true),
    EXEC_STEP_USER("EXEC_STEP_USER", false, false, true),
    COUNT_EXEC_STEP_ISSUES("EXEC_STEP_#_ISSUES", false, false, true),
    EXEC_STEP_COMMENT("EXEC_STEP_COMMENT", false, false, true),
    CPG_CUF("CPG_CUF_", true, true, true),
    IT_CUF("IT_CUF_", true, true, true),
    TC_CUF("TC_CUF_", true, true, true),
    EXEC_CUF("EXEC_CUF_", true, false, true),
    STEP_CUF("STEP_CUF_", false, false, true);

    private final String headerName;
    private final boolean standardExport;
    private final boolean lightExport;
    private final boolean fullExport;

    private CampaignExportHeader(String headerName, boolean standardExport, boolean lightExport, boolean fullExport) {
        this.headerName = headerName;
        this.standardExport = standardExport;
        this.lightExport = lightExport;
        this.fullExport = fullExport;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public static List<CampaignExportHeader> getFullExportHeaders() {
        return CampaignExportHeader.getCampaignExportHeaders(header -> header.fullExport);
    }

    private static List<CampaignExportHeader> getCampaignExportHeaders(Predicate<CampaignExportHeader> filterFunction) {
        return Stream.of(CampaignExportHeader.values()).filter(filterFunction).collect(Collectors.toCollection(LinkedList::new));
    }

    public static CampaignExportHeader fromBindableEntity(BindableEntity bindableEntity) {
        return switch (bindableEntity) {
            case BindableEntity.CAMPAIGN -> CPG_CUF;
            case BindableEntity.ITERATION -> IT_CUF;
            case BindableEntity.TEST_CASE -> TC_CUF;
            case BindableEntity.EXECUTION -> EXEC_CUF;
            case BindableEntity.EXECUTION_STEP -> STEP_CUF;
            default -> throw new IllegalArgumentException("Unsupported bindable entity: " + String.valueOf(bindableEntity));
        };
    }
}

