/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.artificialintelligence.testcasegeneration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.io.StringTemplateSource;
import com.github.jknack.handlebars.io.TemplateSource;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.Result;
import jakarta.persistence.EntityManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.aspect.validation.CleanHtmlAspect;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.aiserver.AiProvider;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.promptset.Prompt;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.servers.TokenAuthCredentials;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.RequirementVersionCoverage;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.exception.artificialintelligence.server.AiServerCouldNotExecuteRequestException;
import org.squashtest.tm.exception.artificialintelligence.server.AiServerJsonResponseParsingException;
import org.squashtest.tm.exception.artificialintelligence.server.MaxTokenLimitReachedException;
import org.squashtest.tm.exception.artificialintelligence.testcasegeneration.AiServerBadPayloadTemplateException;
import org.squashtest.tm.exception.artificialintelligence.testcasegeneration.AiServerInitializeRemoteActionException;
import org.squashtest.tm.exception.artificialintelligence.testcasegeneration.AiServerMalformedUrlException;
import org.squashtest.tm.exception.artificialintelligence.testcasegeneration.AiServerNotConfiguredException;
import org.squashtest.tm.exception.artificialintelligence.testcasegeneration.AiServerResponseInoperableException;
import org.squashtest.tm.exception.artificialintelligence.testcasegeneration.AiServerWrongTokenException;
import org.squashtest.tm.exception.artificialintelligence.testcasegeneration.AiServerWrongUrlException;
import org.squashtest.tm.exception.artificialintelligence.testcasegeneration.RemoteAiServerActionException;
import org.squashtest.tm.exception.artificialintelligence.testcasegeneration.UnextractableAiServerResponseException;
import org.squashtest.tm.service.annotation.IsUltimateLicenseAvailable;
import org.squashtest.tm.service.artificialintelligence.testcasegeneration.AiTestCaseGenerationService;
import org.squashtest.tm.service.internal.artificialintelligence.server.AiAssistant;
import org.squashtest.tm.service.internal.artificialintelligence.server.ChatModelProviderHelper;
import org.squashtest.tm.service.internal.artificialintelligence.testcasegeneration.AiTestCaseGenerationServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.artificialintelligence.testcasegeneration.AiTestCaseGenerationServiceImpl$AjcClosure3;
import org.squashtest.tm.service.internal.artificialintelligence.testcasegeneration.AiTestCaseGenerationServiceImpl$AjcClosure5;
import org.squashtest.tm.service.internal.artificialintelligence.testcasegeneration.AiTestCaseGenerationServiceImpl$AjcClosure7;
import org.squashtest.tm.service.internal.display.dto.PromptDto;
import org.squashtest.tm.service.internal.display.dto.aiserver.AiServerConfiguration;
import org.squashtest.tm.service.internal.display.dto.aiserver.AiServerDto;
import org.squashtest.tm.service.internal.display.dto.aiserver.CustomAiServerConfiguration;
import org.squashtest.tm.service.internal.dto.ActionTestStepFromAiDto;
import org.squashtest.tm.service.internal.dto.TestCaseFromAiDto;
import org.squashtest.tm.service.internal.dto.TestCasesCreationFromAiDto;
import org.squashtest.tm.service.internal.repository.AiTestCaseGenerationDao;
import org.squashtest.tm.service.internal.repository.PromptDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionDao;
import org.squashtest.tm.service.internal.repository.display.PromptDisplayDao;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.servers.StoredCredentialsManager;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;

@Service
@Transactional
public class AiTestCaseGenerationServiceImpl
implements AiTestCaseGenerationService {
    private static final Logger LOGGER;
    private static final String NO_RESPONSE_FROM_SERVER = "sqtm-core.exception.artificial-intelligence.generate-test-case.cannot-get-response";
    private static final String NO_RESPONSE_MESSAGE_FROM_SERVER = "sqtm-core.exception.artificial-intelligence.generate-test-case.cannot-get-response-message";
    private static final String REQUIREMENT = "requirement";
    private final EntityManager entityManager;
    private final RequirementVersionDao requirementVersionDao;
    private final TestCaseLibraryNavigationService testCaseLibraryNavigationService;
    private final AiTestCaseGenerationDao aiTestCaseGenerationDao;
    private final ActiveMilestoneHolder activeMilestoneHolder;
    private final StoredCredentialsManager credentialsManager;
    private final PromptDisplayDao promptDisplayDao;
    private final PromptDao promptDao;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        AiTestCaseGenerationServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(AiTestCaseGenerationServiceImpl.class);
    }

    public AiTestCaseGenerationServiceImpl(EntityManager entityManager, RequirementVersionDao requirementVersionDao, TestCaseLibraryNavigationService testCaseLibraryNavigationService, AiTestCaseGenerationDao aiTestCaseGenerationDao, ActiveMilestoneHolder activeMilestoneHolder, StoredCredentialsManager credentialsManager, PromptDisplayDao promptDisplayDao, PromptDao promptDao) {
        this.entityManager = entityManager;
        this.requirementVersionDao = requirementVersionDao;
        this.testCaseLibraryNavigationService = testCaseLibraryNavigationService;
        this.aiTestCaseGenerationDao = aiTestCaseGenerationDao;
        this.activeMilestoneHolder = activeMilestoneHolder;
        this.credentialsManager = credentialsManager;
        this.promptDisplayDao = promptDisplayDao;
        this.promptDao = promptDao;
    }

    @Override
    @IsUltimateLicenseAvailable
    public Long findTargetTestCaseLibraryId(Long projectId) {
        return this.aiTestCaseGenerationDao.findTargetTestCaseLibraryId(projectId);
    }

    @Override
    @IsUltimateLicenseAvailable
    public String generateTestCaseFromRequirementUsingAiUserSide(long requirementVersionId, String userMessage, Long promptId) {
        Long projectIdLinkedToRequirement = this.requirementVersionDao.findProjectIdByRequirementVersionId(requirementVersionId);
        AiServerDto aiServerDto = this.aiTestCaseGenerationDao.findAiServerDtoByProjectId(projectIdLinkedToRequirement);
        AiTestCaseGenerationServiceImpl.checkIfAiServerIsConfigured(aiServerDto);
        String parsedUserMessage = HTMLCleanupUtils.htmlToLayoutAwareText(userMessage, true);
        return this.generateTestCaseFromRequirementUsingAi(aiServerDto, parsedUserMessage, promptId);
    }

    private static void checkIfAiServerIsConfigured(AiServerDto aiServerDto) {
        AiProvider provider = aiServerDto.getProvider();
        switch (provider) {
            case NONE: {
                AiTestCaseGenerationServiceImpl.validateNoneProviderConfiguration(aiServerDto);
                break;
            }
            case CUSTOM: {
                AiTestCaseGenerationServiceImpl.validateCustomProviderConfiguration(aiServerDto);
                break;
            }
            case GOOGLE_VERTEX_AI: {
                AiTestCaseGenerationServiceImpl.validateGoogleVertexAiProviderConfiguration(aiServerDto);
                break;
            }
            default: {
                AiTestCaseGenerationServiceImpl.validateGenericProviderConfiguration(aiServerDto);
            }
        }
    }

    private static void validateNoneProviderConfiguration(AiServerDto aiServerDto) {
        if (AiTestCaseGenerationServiceImpl.isMissingPayloadOrJsonPath(aiServerDto)) {
            AiTestCaseGenerationServiceImpl.handleServerNotConfiguredException();
        }
    }

    private static void handleServerNotConfiguredException() {
        LOGGER.error("The AI server is not properly configured", new Object[0]);
        throw new AiServerNotConfiguredException();
    }

    private static boolean isMissingPayloadOrJsonPath(AiServerDto dto) {
        return AiTestCaseGenerationServiceImpl.isBlank(dto.getPayloadTemplate()) || AiTestCaseGenerationServiceImpl.isBlank(dto.getJsonPath());
    }

    private static void validateCustomProviderConfiguration(AiServerDto aiServerDto) {
        CustomAiServerConfiguration conf = (CustomAiServerConfiguration)aiServerDto.getConfiguration();
        if (AiTestCaseGenerationServiceImpl.isBlank(conf.getPayloadTemplate()) || AiTestCaseGenerationServiceImpl.isBlank(conf.getGeneratedTextJsonPath())) {
            AiTestCaseGenerationServiceImpl.handleServerNotConfiguredException();
        }
    }

    private static void validateGoogleVertexAiProviderConfiguration(AiServerDto aiServerDto) {
        AiServerConfiguration conf = (AiServerConfiguration)aiServerDto.getConfiguration();
        if (AiTestCaseGenerationServiceImpl.isBlank(aiServerDto.getModelName()) || AiTestCaseGenerationServiceImpl.isBlank(conf.getRegion()) || AiTestCaseGenerationServiceImpl.isBlank(conf.getProjectId())) {
            AiTestCaseGenerationServiceImpl.handleServerNotConfiguredException();
        }
    }

    private static void validateGenericProviderConfiguration(AiServerDto aiServerDto) {
        if (AiTestCaseGenerationServiceImpl.isBlank(aiServerDto.getModelName())) {
            AiTestCaseGenerationServiceImpl.handleServerNotConfiguredException();
        }
    }

    private static boolean isBlank(String str) {
        return StringUtils.isBlank((CharSequence)str);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public String testAiServerConfiguration(long serverId, String requirement) {
        AiServerDto aiServerDto = this.aiTestCaseGenerationDao.findAiServerDtoByAiServerId(serverId);
        return this.generateTestCaseFromRequirementUsingAi(aiServerDto, requirement, null);
    }

    private String generateTestCaseFromRequirementUsingAi(AiServerDto aiServerDto, String userMessage, Long promptId) {
        if (AiProvider.NONE.equals((Object)aiServerDto.getProvider())) {
            return this.generateTestCaseFromRequirementUsingAiLegacy(aiServerDto, userMessage);
        }
        return this.generateTestCaseFromRequirementUsingLangchain4j(aiServerDto, userMessage, promptId);
    }

    private String generateTestCaseFromRequirementUsingLangchain4j(AiServerDto aiServerDto, String userMessage, Long promptId) {
        Result<String> response;
        Prompt prompt = (Prompt)this.promptDao.findById(promptId).orElseThrow(() -> new IllegalArgumentException("Prompt not found"));
        TokenAuthCredentials credentials = (TokenAuthCredentials)this.credentialsManager.unsecuredFindAppLevelCredentials(aiServerDto.getId());
        ChatModel model = ChatModelProviderHelper.buildChatModelForAiServer(aiServerDto, credentials);
        AiAssistant aiAssistant = (AiAssistant)AiServices.builder(AiAssistant.class).systemMessageProvider(chatMemoryId -> prompt.getSystemPromptTemplate()).chatModel(model).build();
        try {
            LOGGER.info("Starting to generate test cases from requirement", new Object[0]);
            response = aiAssistant.doChat(userMessage);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while generating test cases from AI server", (Throwable)e);
            throw new AiServerCouldNotExecuteRequestException(e.getMessage());
        }
        AiTestCaseGenerationServiceImpl.checkIfMaxLimitTokenReached(response);
        return this.cleanServerResponse((String)response.content(), (String)response.content());
    }

    private static void checkIfMaxLimitTokenReached(Result<String> response) {
        if (StringUtils.isBlank((CharSequence)((CharSequence)response.content())) && FinishReason.LENGTH == response.finishReason()) {
            throw new MaxTokenLimitReachedException();
        }
    }

    private String generateTestCaseFromRequirementUsingAiLegacy(AiServerDto aiServerDto, String requirementDescription) {
        int responseCode;
        TokenAuthCredentials credentials = (TokenAuthCredentials)this.credentialsManager.unsecuredFindAppLevelCredentials(aiServerDto.getId());
        HttpURLConnection connection = AiTestCaseGenerationServiceImpl.prepareConnection(credentials, aiServerDto.getUrl());
        String jsonPayload = this.generateTemplateWithRequirementDescription(JSONObject.escape((String)requirementDescription), aiServerDto.getPayloadTemplate());
        StringBuilder response = AiTestCaseGenerationServiceImpl.buildAndSendRequest(jsonPayload, connection);
        try {
            responseCode = connection.getResponseCode();
        }
        catch (IOException e) {
            LOGGER.error("Cannot get response code from server", (Throwable)e);
            throw new RemoteAiServerActionException(e.getMessage(), response.toString());
        }
        if (responseCode == 200 || responseCode == 201) {
            String extractedServerResponse = this.extractServerResponse(aiServerDto.getJsonPath(), response.toString());
            return this.cleanServerResponse(response.toString(), extractedServerResponse);
        }
        LOGGER.error("Expected code 200. Response received is: {}", new Object[]{response});
        throw new RemoteAiServerActionException(String.valueOf(responseCode), response.toString());
    }

    public String cleanServerResponse(String originalResponse, String extractedServerResponse) {
        String testCasesPattern;
        Pattern patternTestCases;
        Matcher matcherForTestCases;
        Pattern patternMarkDown = Pattern.compile("```json\\s*\\n([^`]*)```", 32);
        Matcher matcherMarkDown = patternMarkDown.matcher(extractedServerResponse);
        if (matcherMarkDown.find()) {
            extractedServerResponse = matcherMarkDown.group(1);
        }
        if ((matcherForTestCases = (patternTestCases = Pattern.compile(testCasesPattern = "\\{\\s*\"testCases\"\\s*:\\s*\\[.*]\\s*}", 32)).matcher(extractedServerResponse)).find()) {
            return matcherForTestCases.group();
        }
        LOGGER.error("Server response does not contain test cases: {}", new Object[]{originalResponse});
        throw new AiServerResponseInoperableException(originalResponse);
    }

    public String extractServerResponse(String jsonPath, String originalServerResponse) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode responseRoot = objectMapper.readTree(originalServerResponse);
            String transformedJsonPath = this.transformToJsonPointer(jsonPath);
            JsonNode result = responseRoot.at(transformedJsonPath);
            if (!result.isMissingNode()) {
                return result.asText();
            }
            throw new UnextractableAiServerResponseException(originalServerResponse);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Cannot parse the response into a JSON tree structure", (Throwable)e);
            throw new AiServerJsonResponseParsingException(originalServerResponse);
        }
    }

    public String transformToJsonPointer(String jsonPath) {
        String firstChar = "[".equals(jsonPath.substring(0, 1)) ? "" : "/";
        return firstChar + jsonPath.replace(".", "/").replace("[", "/").replace("]", "");
    }

    private static HttpURLConnection prepareConnection(TokenAuthCredentials credentials, String apiUrl) {
        URL url;
        try {
            url = new URI(apiUrl).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            LOGGER.error("The URl is not correctly formed.", (Throwable)e);
            throw new AiServerMalformedUrlException();
        }
        return AiTestCaseGenerationServiceImpl.getHttpUrlConnection(credentials, url);
    }

    private static HttpURLConnection getHttpUrlConnection(TokenAuthCredentials credentials, URL url) {
        HttpURLConnection connection;
        try {
            connection = (HttpURLConnection)url.openConnection();
        }
        catch (IOException e) {
            LOGGER.error("Cannot open https connection.", (Throwable)e);
            throw new AiServerInitializeRemoteActionException();
        }
        try {
            connection.setRequestMethod("POST");
        }
        catch (IOException e) {
            LOGGER.error("Cannot set the POST method for the request.", (Throwable)e);
            throw new AiServerInitializeRemoteActionException();
        }
        connection.setDoOutput(true);
        if (credentials != null) {
            connection.setRequestProperty("Authorization", "Bearer " + credentials.getToken());
        }
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.name());
        connection.setRequestProperty("Accept", "application/json");
        return connection;
    }

    public String generateTemplateWithRequirementDescription(String requirementDescription, String template) {
        Map<String, Handlebars.SafeString> scope = Collections.singletonMap(REQUIREMENT, new Handlebars.SafeString((CharSequence)requirementDescription));
        Handlebars handlebars = new Handlebars();
        try {
            Template generatedTemplate = handlebars.compile((TemplateSource)new StringTemplateSource("template", template));
            return generatedTemplate.apply(scope);
        }
        catch (IOException e) {
            LOGGER.error("Failed to generate the template with requirement description", (Throwable)e);
            throw new UncheckedIOException("Failed to generate the template with requirement description", e);
        }
    }

    private static StringBuilder buildAndSendRequest(String jsonPayload, HttpURLConnection connection) {
        byte[] input = jsonPayload.getBytes(StandardCharsets.UTF_8);
        connection.setRequestProperty("Content-Length", String.valueOf(input.length));
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (OutputStream os = connection.getOutputStream();){
                os.write(input, 0, input.length);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("Cannot send the request to the remote server", (Throwable)e);
            throw new AiServerInitializeRemoteActionException();
        }
        int responseCode = AiTestCaseGenerationServiceImpl.getResponseCode(connection);
        String responseMessage = AiTestCaseGenerationServiceImpl.getResponseMessage(connection, responseCode);
        StringBuilder response = new StringBuilder();
        if (responseCode >= 400) {
            AiTestCaseGenerationServiceImpl.handleErrorResponseFromServer(connection, response, responseCode, responseMessage);
        } else {
            AiTestCaseGenerationServiceImpl.handleServerResponse(connection, response, responseCode, responseMessage);
        }
        return response;
    }

    private static int getResponseCode(HttpURLConnection connection) {
        int responseCode;
        try {
            responseCode = connection.getResponseCode();
        }
        catch (IOException e) {
            LOGGER.error("Error getting response code from the server", (Throwable)e);
            throw new RemoteAiServerActionException(NO_RESPONSE_FROM_SERVER, null);
        }
        return responseCode;
    }

    private static String getResponseMessage(HttpURLConnection connection, int responseCode) {
        String responseMessage;
        try {
            responseMessage = connection.getResponseMessage();
        }
        catch (IOException e) {
            LOGGER.error("Error getting response message from the server", (Throwable)e);
            throw new RemoteAiServerActionException(NO_RESPONSE_MESSAGE_FROM_SERVER, String.valueOf(responseCode));
        }
        return responseMessage;
    }

    private static void handleErrorResponseFromServer(HttpURLConnection connection, StringBuilder response, int responseCode, String responseMessage) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8));){
                String errorLine;
                while ((errorLine = errorReader.readLine()) != null) {
                    response.append(errorLine);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("Error reading the error response from the server", (Throwable)e);
            throw new RemoteAiServerActionException(responseCode + " " + responseMessage, response.toString());
        }
        LOGGER.error("Error response from the server. HTTP Status Code: {}. Error message: {}. Server response: {}", new Object[]{responseCode, responseMessage, response.toString()});
        switch (responseCode) {
            case 401: {
                throw new AiServerWrongTokenException(responseCode + " " + responseMessage, response.toString());
            }
            case 404: {
                throw new AiServerWrongUrlException(responseCode + " " + responseMessage, response.toString());
            }
            case 400: {
                throw new AiServerBadPayloadTemplateException(responseCode + " " + responseMessage, response.toString());
            }
        }
        throw new RemoteAiServerActionException(responseCode + " " + responseMessage, response.toString());
    }

    private static void handleServerResponse(HttpURLConnection connection, StringBuilder response, int responseCode, String responseMessage) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("Remote server cannot finalize the request", (Throwable)e);
            throw new RemoteAiServerActionException(responseCode + " " + responseMessage, response.toString());
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#targetLibraryId, 'org.squashtest.tm.domain.testcase.TestCaseLibrary' , 'CREATE' ) or hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void persistTestCaseFromAi(long targetLibraryId, Long requirementVersionId, TestCasesCreationFromAiDto testCasesData) {
        EntityReference destinationEntityReference = EntityReference.fromNodeId((String)testCasesData.getDestinationFolderId());
        List<TestCase> generatedTestCases = this.generateTestCases(testCasesData, destinationEntityReference);
        this.addTestCasesToNode(destinationEntityReference, generatedTestCases);
        RequirementVersion requirementVersion = this.requirementVersionDao.loadForCoverageAddition(requirementVersionId);
        for (TestCase testCase : generatedTestCases) {
            RequirementVersionCoverage coverage = new RequirementVersionCoverage(requirementVersion, testCase);
            this.entityManager.persist((Object)coverage);
        }
    }

    @Override
    @IsUltimateLicenseAvailable
    public List<PromptDto> findAllPromptsByRequirementVersionId(Long requirementVersionId) {
        List<PromptDto> prompts = this.promptDisplayDao.findAllForClassicTcGenerationByReqVersionId(requirementVersionId);
        String requirementDescription = String.format("<br><br>%s", this.requirementVersionDao.findDescription(requirementVersionId));
        prompts.forEach(prompt -> {
            PromptDto promptDto = prompt;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)promptDto);
            Object[] objectArray = new Object[]{this, promptDto, joinPoint};
            AiTestCaseGenerationServiceImpl$AjcClosure7 aiTestCaseGenerationServiceImpl$AjcClosure7 = new AiTestCaseGenerationServiceImpl$AjcClosure7(objectArray);
            String generatedUserPrompt = this.generateTemplateWithRequirementDescription(requirementDescription, (String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(aiTestCaseGenerationServiceImpl$AjcClosure7.linkClosureAndJoinPoint(4112)));
            prompt.setUserPromptTemplate(generatedUserPrompt);
        });
        return prompts;
    }

    private void addTestCasesToNode(EntityReference destinationEntityReference, List<TestCase> generatedTestCases) {
        List<Long> milestoneIds = this.findMilestoneIds();
        Long parentId = destinationEntityReference.getId();
        switch (destinationEntityReference.getType()) {
            case TEST_CASE_LIBRARY: {
                this.testCaseLibraryNavigationService.addTestCasesToLibrary(parentId, generatedTestCases, milestoneIds);
                break;
            }
            case TEST_CASE_FOLDER: {
                this.testCaseLibraryNavigationService.addTestCasesToFolder(parentId, generatedTestCases, milestoneIds);
                break;
            }
            default: {
                throw new IllegalArgumentException("This entity type is not handled " + String.valueOf(destinationEntityReference.getType()));
            }
        }
    }

    private List<TestCase> generateTestCases(TestCasesCreationFromAiDto testCasesData, EntityReference destinationEntityReference) {
        ArrayList<String> contentNames = new ArrayList<String>(this.getContentNames(destinationEntityReference));
        return testCasesData.getTestCasesFromAi().stream().map(testCaseFromAiDto -> this.getNewTestCase((TestCaseFromAiDto)testCaseFromAiDto, (List<String>)contentNames)).toList();
    }

    private List<String> getContentNames(EntityReference destinationEntityReference) {
        Long parentId = destinationEntityReference.getId();
        return switch (destinationEntityReference.getType()) {
            case EntityType.TEST_CASE_LIBRARY -> this.testCaseLibraryNavigationService.findContentNamesByLibraryId(parentId);
            case EntityType.TEST_CASE_FOLDER -> this.testCaseLibraryNavigationService.findContentNamesByFolderIds(Collections.singletonList(parentId)).getOrDefault(parentId, new ArrayList());
            default -> throw new IllegalArgumentException("This entity type is not handled " + String.valueOf(destinationEntityReference.getType()));
        };
    }

    private TestCase getNewTestCase(TestCaseFromAiDto testCaseFromAiDto, List<String> parentContentNames) {
        TestCase newTestCase = new TestCase();
        AiTestCaseGenerationServiceImpl.fixTestCaseDuplicationNames(newTestCase, testCaseFromAiDto.getName(), parentContentNames);
        TestCaseFromAiDto testCaseFromAiDto2 = testCaseFromAiDto;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)testCaseFromAiDto2);
        Object[] objectArray = new Object[]{this, testCaseFromAiDto2, joinPoint};
        AiTestCaseGenerationServiceImpl$AjcClosure1 aiTestCaseGenerationServiceImpl$AjcClosure1 = new AiTestCaseGenerationServiceImpl$AjcClosure1(objectArray);
        newTestCase.setDescription((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(aiTestCaseGenerationServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112)));
        newTestCase.setPrerequisite(testCaseFromAiDto.getPrerequisites());
        for (ActionTestStepFromAiDto actionStep : testCaseFromAiDto.getSteps()) {
            ActionTestStep newStep = new ActionTestStep();
            ActionTestStepFromAiDto actionTestStepFromAiDto = actionStep;
            JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)actionTestStepFromAiDto);
            Object[] objectArray2 = new Object[]{this, actionTestStepFromAiDto, joinPoint2};
            AiTestCaseGenerationServiceImpl$AjcClosure3 aiTestCaseGenerationServiceImpl$AjcClosure3 = new AiTestCaseGenerationServiceImpl$AjcClosure3(objectArray2);
            newStep.setAction((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(aiTestCaseGenerationServiceImpl$AjcClosure3.linkClosureAndJoinPoint(4112)));
            ActionTestStepFromAiDto actionTestStepFromAiDto2 = actionStep;
            JoinPoint joinPoint3 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)actionTestStepFromAiDto2);
            Object[] objectArray3 = new Object[]{this, actionTestStepFromAiDto2, joinPoint3};
            AiTestCaseGenerationServiceImpl$AjcClosure5 aiTestCaseGenerationServiceImpl$AjcClosure5 = new AiTestCaseGenerationServiceImpl$AjcClosure5(objectArray3);
            newStep.setExpectedResult((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(aiTestCaseGenerationServiceImpl$AjcClosure5.linkClosureAndJoinPoint(4112)));
            newTestCase.addStep(actionStep.getIndex(), (TestStep)newStep);
        }
        newTestCase.setDraftedByAi(true);
        return newTestCase;
    }

    private static void fixTestCaseDuplicationNames(TestCase testCase, String name, List<String> parentContentNames) {
        int i = 0;
        Object uniqueName = name;
        while (parentContentNames.contains(uniqueName)) {
            uniqueName = name + "(" + ++i + ")";
        }
        testCase.setName((String)uniqueName);
        parentContentNames.add((String)uniqueName);
    }

    private List<Long> findMilestoneIds() {
        ArrayList<Long> milestoneIds = new ArrayList<Long>();
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        activeMilestone.ifPresent(milestone -> {
            boolean bl = milestoneIds.add(milestone.getId());
        });
        return milestoneIds;
    }

    static final /* synthetic */ String getDescription_aroundBody0(AiTestCaseGenerationServiceImpl aiTestCaseGenerationServiceImpl, TestCaseFromAiDto testCaseFromAiDto, JoinPoint joinPoint) {
        return testCaseFromAiDto.getDescription();
    }

    static final /* synthetic */ String getAction_aroundBody2(AiTestCaseGenerationServiceImpl aiTestCaseGenerationServiceImpl, ActionTestStepFromAiDto actionTestStepFromAiDto, JoinPoint joinPoint) {
        return actionTestStepFromAiDto.getAction();
    }

    static final /* synthetic */ String getExpectedResult_aroundBody4(AiTestCaseGenerationServiceImpl aiTestCaseGenerationServiceImpl, ActionTestStepFromAiDto actionTestStepFromAiDto, JoinPoint joinPoint) {
        return actionTestStepFromAiDto.getExpectedResult();
    }

    static final /* synthetic */ String getUserPromptTemplate_aroundBody6(AiTestCaseGenerationServiceImpl aiTestCaseGenerationServiceImpl, PromptDto promptDto, JoinPoint joinPoint) {
        return promptDto.getUserPromptTemplate();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AiTestCaseGenerationServiceImpl.java", AiTestCaseGenerationServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getDescription", "org.squashtest.tm.service.internal.dto.TestCaseFromAiDto", "", "", "", "java.lang.String"), 612);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getAction", "org.squashtest.tm.service.internal.dto.ActionTestStepFromAiDto", "", "", "", "java.lang.String"), 616);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getExpectedResult", "org.squashtest.tm.service.internal.dto.ActionTestStepFromAiDto", "", "", "", "java.lang.String"), 617);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getUserPromptTemplate", "org.squashtest.tm.service.internal.display.dto.PromptDto", "", "", "", "java.lang.String"), 558);
    }
}

