/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.deletion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.service.deletion.NodeRenaming;
import org.squashtest.tm.service.internal.deletion.NodeScope;
import org.squashtest.tm.service.internal.library.LibraryUtils;
import org.squashtest.tm.service.internal.repository.NodeRestoreNameResolverDao;

public class NodeRestoreNameResolver {
    private final NodeRestoreNameResolverDao resolverDao;

    public NodeRestoreNameResolver(NodeRestoreNameResolverDao resolverDao) {
        this.resolverDao = resolverDao;
    }

    public Map<NodeType, List<NodeRenaming>> resolveDuplicateNamesInScope(NodeScope scope) {
        Map<NodeReference, List<Long>> duplicateChildrenByParent = this.resolverDao.findParentsWithDuplicateChildNames(scope);
        if (duplicateChildrenByParent.isEmpty()) {
            return Map.of();
        }
        Map<NodeReference, List<Long>> scopeAncestorsWithDeletedChild = this.resolverDao.findAncestorsWithDeletedChild(scope.getNodeIds());
        return this.applyDuplicateNameResolution(duplicateChildrenByParent, scopeAncestorsWithDeletedChild);
    }

    private Map<NodeType, List<NodeRenaming>> applyDuplicateNameResolution(Map<NodeReference, List<Long>> duplicateChildrenByParent, Map<NodeReference, List<Long>> ancestorsWithDeletedChild) {
        DuplicateRegistry registry = new DuplicateRegistry(duplicateChildrenByParent, ancestorsWithDeletedChild);
        if (registry.isEmpty()) {
            return Map.of();
        }
        HashMap<NodeType, List<NodeRenaming>> result = new HashMap<NodeType, List<NodeRenaming>>();
        registry.duplicates.forEach((parentType, container) -> {
            if (container.hasDuplicateInDescendant()) {
                container.addContentNames(this.resolverDao.findContentNames((NodeType)parentType, (Collection<Long>)container.duplicateDescendantNodes.keySet()));
            }
            if (container.hasDuplicateInAncestor()) {
                List<Long> deletedChildIds = ancestorsWithDeletedChild.entrySet().stream().filter(entry -> parentType.equals((Object)((NodeReference)entry.getKey()).getNodeType())).flatMap(entry -> ((List)entry.getValue()).stream()).toList();
                container.addContentNames(this.resolverDao.findActiveContentNames((NodeType)parentType, (Collection<Long>)container.duplicateAncestorNodes.keySet(), (Collection<Long>)deletedChildIds));
            }
            container.addNodeNames(this.resolverDao.getNodeNamesByIds(container.getAllDuplicateNodeIds()));
            List<NodeRenaming> renamedNodes = container.resolveChildNameConflicts();
            result.put((NodeType)parentType, renamedNodes);
        });
        return result;
    }

    private static final class DuplicateRegistry {
        private final Map<NodeType, DuplicateContainer> duplicates = new HashMap<NodeType, DuplicateContainer>();

        public DuplicateRegistry(Map<NodeReference, List<Long>> duplicateChildrenByParent, Map<NodeReference, List<Long>> ancestorsWithDeletedChild) {
            Objects.requireNonNull(duplicateChildrenByParent, "duplicate children by parent map is null");
            Objects.requireNonNull(ancestorsWithDeletedChild, "ancestors with deleted child map is null");
            duplicateChildrenByParent.forEach((parentRef, childIds) -> {
                if (ancestorsWithDeletedChild.containsKey(parentRef)) {
                    this.addDuplicateNodeInAncestor((NodeReference)parentRef, (List<Long>)childIds);
                } else {
                    this.addDuplicateNodeInDescendant((NodeReference)parentRef, (List<Long>)childIds);
                }
            });
        }

        public boolean isEmpty() {
            return this.duplicates.isEmpty();
        }

        private void addDuplicateNodeInDescendant(NodeReference parent, List<Long> duplicateChildIds) {
            this.duplicates.computeIfAbsent(parent.getNodeType(), k -> new DuplicateContainer()).addInDescendant(parent.getId(), duplicateChildIds);
        }

        private void addDuplicateNodeInAncestor(NodeReference parent, List<Long> duplicateChildIds) {
            this.duplicates.computeIfAbsent(parent.getNodeType(), k -> new DuplicateContainer()).addInAncestor(parent.getId(), duplicateChildIds);
        }

        private static final class DuplicateContainer {
            private final Map<Long, List<Long>> duplicateDescendantNodes = new HashMap<Long, List<Long>>();
            private final Map<Long, List<Long>> duplicateAncestorNodes = new HashMap<Long, List<Long>>();
            private final Map<Long, List<String>> contentNamesByParentId = new HashMap<Long, List<String>>();
            private final Map<Long, NodeRenaming> duplicateNodeById = new HashMap<Long, NodeRenaming>();

            private DuplicateContainer() {
            }

            void addInDescendant(Long parentId, List<Long> childIds) {
                this.duplicateDescendantNodes.put(parentId, childIds);
            }

            void addInAncestor(Long parentId, List<Long> childIds) {
                this.duplicateAncestorNodes.put(parentId, childIds);
            }

            void addContentNames(Map<Long, List<String>> namesByParentId) {
                this.contentNamesByParentId.putAll(namesByParentId);
            }

            public Set<Long> getAllDuplicateNodeIds() {
                return Stream.concat(this.duplicateDescendantNodes.values().stream(), this.duplicateAncestorNodes.values().stream()).flatMap(Collection::stream).collect(Collectors.toSet());
            }

            public boolean hasDuplicateInDescendant() {
                return !this.duplicateDescendantNodes.isEmpty();
            }

            public boolean hasDuplicateInAncestor() {
                return !this.duplicateAncestorNodes.isEmpty();
            }

            public Map<Long, List<Long>> getAllDuplicateNodes() {
                return Stream.concat(this.duplicateDescendantNodes.entrySet().stream(), this.duplicateAncestorNodes.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> {
                    ArrayList mergedList = new ArrayList(a);
                    mergedList.addAll(b);
                    mergedList.sort(Comparator.reverseOrder());
                    return mergedList;
                }));
            }

            public void addNodeNames(Map<Long, NodeRenaming> nodeNamesByIds) {
                this.duplicateNodeById.putAll(nodeNamesByIds);
            }

            List<NodeRenaming> resolveChildNameConflicts() {
                Map<Long, List<Long>> duplicateNodesByParentId = this.getAllDuplicateNodes();
                for (Map.Entry<Long, List<Long>> entry : duplicateNodesByParentId.entrySet()) {
                    Long parentId = entry.getKey();
                    List<Long> childIds = entry.getValue();
                    List childNames = this.contentNamesByParentId.getOrDefault(parentId, new ArrayList());
                    for (Long childId : childIds) {
                        NodeRenaming node = this.duplicateNodeById.get(childId);
                        if (node == null) continue;
                        DuplicateContainer.ensureUniqueName(node, childNames);
                    }
                }
                return this.duplicateNodeById.values().stream().toList();
            }

            private static void ensureUniqueName(NodeRenaming node, List<String> childNames) {
                String currentName = node.getName();
                long occurrences = childNames.stream().filter(name -> name.equals(currentName)).count();
                if (occurrences > 1L) {
                    String newName = LibraryUtils.generateNonClashingName(currentName, childNames, 255);
                    node.setName(newName);
                    int index = childNames.indexOf(currentName);
                    if (index != -1) {
                        childNames.set(index, newName);
                    }
                }
            }
        }
    }
}

