/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service;

import com.zaxxer.hikari.HikariDataSource;
import jakarta.persistence.EntityManagerFactory;
import jakarta.validation.ValidatorFactory;
import javax.sql.DataSource;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.listener.logging.DefaultQueryLogEntryCreator;
import net.ttddyy.dsproxy.listener.logging.QueryLogEntryCreator;
import net.ttddyy.dsproxy.listener.logging.SLF4JLogLevel;
import net.ttddyy.dsproxy.listener.logging.SystemOutQueryLoggingListener;
import net.ttddyy.dsproxy.support.ProxyDataSourceBuilder;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.internal.Formatter;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.ExecuteListener;
import org.jooq.ExecuteListenerProvider;
import org.jooq.SQLDialect;
import org.jooq.TransactionProvider;
import org.jooq.conf.RenderNameCase;
import org.jooq.impl.DefaultConfiguration;
import org.jooq.impl.DefaultExecuteListenerProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizer;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.AdviceMode;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Role;
import org.springframework.context.annotation.aspectj.SpringConfiguredConfiguration;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.aspectj.AspectJTransactionManagementConfiguration;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.internal.api.repository.JooqSessionGuard;

@org.springframework.context.annotation.Configuration
@ComponentScan(basePackages={"org.squashtest.tm.service.internal.repository", "org.squashtest.tm.service.internal.api"}, excludeFilters={@ComponentScan.Filter(value={org.springframework.context.annotation.Configuration.class})})
@EnableTransactionManagement(order=-2147483548, mode=AdviceMode.PROXY, proxyTargetClass=false)
@Import(value={SpringConfiguredConfiguration.class, AspectJTransactionManagementConfiguration.class})
@EntityScan(value={"org.squashtest.tm.service.internal.repository.hibernate", "org.squashtest.tm.service.internal.hibernate", "org.squashtest.tm.domain", "org.squashtest.csp.core.bugtracker.domain"})
@EnableJpaRepositories(value={"org.squashtest.tm.service.internal.repository"})
public class RepositoryConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryConfig.class);
    private final Environment env;

    public RepositoryConfig(Environment env) {
        this.env = env;
    }

    @Bean
    @ConfigurationProperties(value="spring.datasource")
    @Primary
    public DataSourceProperties dataSourceProperties() {
        return new DataSourceProperties();
    }

    @Bean
    @ConditionalOnProperty(value={"squash.datasource.enable.proxy"}, havingValue="true")
    @ConfigurationProperties(prefix="spring.datasource.hikari")
    public DataSource actualDataSource(DataSourceProperties dataSourceProperties) {
        return dataSourceProperties.initializeDataSourceBuilder().type(HikariDataSource.class).build();
    }

    @Bean
    @Primary
    @ConditionalOnProperty(value={"squash.datasource.enable.proxy"}, havingValue="true")
    public DataSource dataSource(DataSource actualDataSource) {
        PrettyQueryEntryCreator creator = new PrettyQueryEntryCreator();
        creator.setMultiline(true);
        SystemOutQueryLoggingListener listener = new SystemOutQueryLoggingListener();
        listener.setQueryLogEntryCreator((QueryLogEntryCreator)creator);
        return ProxyDataSourceBuilder.create((DataSource)actualDataSource).name("Main DataSource").listener((QueryExecutionListener)listener).logQueryBySlf4j(SLF4JLogLevel.DEBUG, LOGGER.getName()).afterQuery((execInfo, queryInfoList) -> LOGGER.debug("Query took {} ms", new Object[]{execInfo.getElapsedTime()})).build();
    }

    @Bean
    public DefaultLobHandler lobHandler() {
        LOGGER.info("init lobHandler", new Object[0]);
        return new DefaultLobHandler();
    }

    @Bean
    @Role(value=2)
    public static ValidatorFactory validatorFactory() {
        LOGGER.info("init LocalValudatorFactory", new Object[0]);
        return new LocalValidatorFactoryBean();
    }

    @Bean
    @DependsOn(value={"org.springframework.context.config.internalBeanConfigurerAspect"})
    @Role(value=2)
    public TransactionManagerCustomizer<PlatformTransactionManager> platformTransactionManagerCustomize() {
        return manager -> {};
    }

    @Bean
    public JooqSessionGuard jooqSessionGuard(EntityManagerFactory entityManagerFactory) {
        return new JooqSessionGuard(entityManagerFactory);
    }

    @Bean
    public Configuration jooqConfiguration(TransactionProvider transactionProvider, ConnectionProvider connectionProvider, DefaultExecuteListenerProvider defaultExecuteListenerProvider, JooqSessionGuard jooqSelectSessionGuard) {
        LOGGER.info("init JooqConfiguration", new Object[0]);
        DefaultConfiguration defaultConfiguration = this.getJooqConfiguration();
        defaultConfiguration.set(connectionProvider);
        defaultConfiguration.set(transactionProvider);
        defaultConfiguration.set(new ExecuteListenerProvider[]{defaultExecuteListenerProvider});
        defaultConfiguration.set(new ExecuteListener[]{jooqSelectSessionGuard});
        return defaultConfiguration;
    }

    public DefaultConfiguration getJooqConfiguration() {
        DefaultConfiguration defaultConfiguration = new DefaultConfiguration();
        String sqlDialect = this.env.getRequiredProperty("jooq.sql.dialect");
        SQLDialect dialect = SQLDialect.valueOf((String)sqlDialect);
        defaultConfiguration.set(dialect);
        defaultConfiguration.settings().withRenderCatalog(Boolean.valueOf(false));
        defaultConfiguration.settings().withRenderSchema(Boolean.valueOf(false));
        switch (dialect) {
            case MARIADB: {
                defaultConfiguration.settings().setRenderGroupConcatMaxLenSessionVariable(Boolean.valueOf(false));
            }
            case H2: {
                defaultConfiguration.settings().setRenderNameCase(RenderNameCase.UPPER);
                break;
            }
            case POSTGRES: {
                defaultConfiguration.settings().setRenderNameCase(RenderNameCase.LOWER);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid jOOQ dialect. Use H2, MARIADB or POSTGRES ");
            }
        }
        return defaultConfiguration;
    }

    private static class PrettyQueryEntryCreator
    extends DefaultQueryLogEntryCreator {
        private final Formatter formatter = FormatStyle.BASIC.getFormatter();

        private PrettyQueryEntryCreator() {
        }

        protected String formatQuery(String query) {
            return this.formatter.format(query);
        }
    }
}

