/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.security.acls.domain.objectidentity.retrievers;

import java.io.Serializable;
import java.util.Optional;
import org.jooq.DSLContext;
import org.jooq.Record1;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.model.ObjectIdentity;
import org.squashtest.tm.service.security.acls.domain.DatabaseBackedObjectIdentityGeneratorStrategy;
import org.squashtest.tm.service.security.acls.domain.objectidentity.retrievers.OptimizedObjectIdentityRetriever;

public abstract class AbstractOptimizedObjectIdentityRetriever
implements OptimizedObjectIdentityRetriever {
    protected final DSLContext jooq;

    protected AbstractOptimizedObjectIdentityRetriever(DSLContext jooq) {
        this.jooq = jooq;
    }

    @Override
    public ObjectIdentity createObjectIdentity(Serializable id) {
        Optional<Record1<Long>> libraryId = this.getLibraryIdRecord((Long)id);
        if (libraryId.isPresent()) {
            return new ObjectIdentityImpl(this.getLibraryClassName(), (Serializable)libraryId.get().value1());
        }
        return new DatabaseBackedObjectIdentityGeneratorStrategy.UnknownObjectIdentity(this.getLibraryClassName());
    }

    abstract String getLibraryClassName();

    abstract Optional<Record1<Long>> getLibraryIdRecord(Long var1);
}

