/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.scm.ScmRepository;
import org.squashtest.tm.domain.servers.BasicAuthenticationCredentials;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.TokenAuthCredentials;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.service.internal.testautomation.ParametersBuilder;
import org.squashtest.tm.service.internal.testautomation.ScopedParametersBuilder;

@Component
@Scope(value="prototype")
public class TaParametersBuilder
implements ParametersBuilder {
    private final ScopedParametersBuilder<TestCase> testCaseScopeBuilder = new CustomTestCaseScopedParametersBuilder();
    private final ScopedParametersBuilder<Campaign> campaignScopeBuilder = new ChildScopedParametersBuilder<Campaign>(this){

        @Override
        protected void doAddEntity(Campaign entity) {
        }

        @Override
        protected String getCustomFieldPrefix() {
            return "CPG";
        }
    };
    private final ScopedParametersBuilder<Iteration> iterationScopeBuilder = new ChildScopedParametersBuilder<Iteration>(this){

        @Override
        protected void doAddEntity(Iteration entity) {
        }

        @Override
        protected String getCustomFieldPrefix() {
            return "IT";
        }
    };
    private final ScopedParametersBuilder<TestSuite> testSuiteScopeBuilder = new ChildScopedParametersBuilder<TestSuite>(this){

        @Override
        protected void doAddEntity(TestSuite entity) {
        }

        @Override
        protected String getCustomFieldPrefix() {
            return "TS";
        }
    };
    private final ScopedParametersBuilder<Dataset> datasetScopeBuilder = new CustomDatasetScopedParametersBuilder();
    private final ScopedParametersBuilder<ScmRepository> scmRepositoryScopeBuilder = new CustomScmRepositoryScopedParametersBuilder();
    private final ScopedParametersBuilder<Credentials> scmRepositoryCredentialsScopeBuilder = new CustomCredentialsScopedParametersBuilder();
    private Map<String, Object> params = new HashMap<String, Object>();

    @Override
    public ScopedParametersBuilder<TestCase> testCase() {
        return this.testCaseScopeBuilder;
    }

    @Override
    public ScopedParametersBuilder<Iteration> iteration() {
        return this.iterationScopeBuilder;
    }

    @Override
    public ScopedParametersBuilder<Campaign> campaign() {
        return this.campaignScopeBuilder;
    }

    @Override
    public ScopedParametersBuilder<TestSuite> testSuite() {
        return this.testSuiteScopeBuilder;
    }

    @Override
    public ScopedParametersBuilder<Dataset> dataset() {
        return this.datasetScopeBuilder;
    }

    @Override
    public ScopedParametersBuilder<ScmRepository> scmRepository() {
        return this.scmRepositoryScopeBuilder;
    }

    @Override
    public ScopedParametersBuilder<Credentials> scmRepositoryCredentials() {
        return this.scmRepositoryCredentialsScopeBuilder;
    }

    @Override
    public Map<String, Object> build() {
        Map<String, Object> res = this.params;
        this.params = Collections.unmodifiableMap(res);
        return res;
    }

    private abstract class ChildScopedParametersBuilder<E>
    implements ScopedParametersBuilder<E> {
        private ChildScopedParametersBuilder() {
        }

        @Override
        public ScopedParametersBuilder<TestCase> testCase() {
            return TaParametersBuilder.this.testCase();
        }

        @Override
        public ScopedParametersBuilder<Iteration> iteration() {
            return TaParametersBuilder.this.iteration();
        }

        @Override
        public ScopedParametersBuilder<Campaign> campaign() {
            return TaParametersBuilder.this.campaign();
        }

        @Override
        public ScopedParametersBuilder<TestSuite> testSuite() {
            return TaParametersBuilder.this.testSuite();
        }

        @Override
        public ScopedParametersBuilder<Dataset> dataset() {
            return TaParametersBuilder.this.dataset();
        }

        @Override
        public ScopedParametersBuilder<ScmRepository> scmRepository() {
            return TaParametersBuilder.this.scmRepository();
        }

        @Override
        public ScopedParametersBuilder<Credentials> scmRepositoryCredentials() {
            return TaParametersBuilder.this.scmRepositoryCredentials();
        }

        @Override
        public Map<String, Object> build() {
            return TaParametersBuilder.this.build();
        }

        @Override
        public ScopedParametersBuilder<E> addEntity(E entity) {
            this.doAddEntity(entity);
            return this;
        }

        protected abstract void doAddEntity(E var1);

        @Override
        public ScopedParametersBuilder<E> addCustomFields(Collection<CustomFieldValue> fields) {
            String codePrefix = this.getCustomFieldPrefix() + "_CUF_";
            this.addCustomFields(codePrefix, fields);
            return this;
        }

        protected abstract String getCustomFieldPrefix();

        private void addCustomFields(String codePrefix, Collection<CustomFieldValue> fields) {
            for (CustomFieldValue field : fields) {
                String val = field.getValue();
                if (val == null) continue;
                String code = codePrefix + field.getBinding().getCustomField().getCode();
                TaParametersBuilder.this.params.put(code, val);
            }
        }
    }

    private class CustomCredentialsScopedParametersBuilder
    extends ChildScopedParametersBuilder<Credentials> {
        private CustomCredentialsScopedParametersBuilder() {
        }

        @Override
        protected void doAddEntity(Credentials entity) {
            if (entity != null) {
                this.addScmRepositoryCredentials(entity);
            }
        }

        @Override
        protected String getCustomFieldPrefix() {
            return null;
        }

        private void addScmRepositoryCredentials(Credentials scmRepositoryCredentials) {
            String credentialsAsString = null;
            if (scmRepositoryCredentials instanceof BasicAuthenticationCredentials) {
                BasicAuthenticationCredentials basicAuthCredentials = (BasicAuthenticationCredentials)scmRepositoryCredentials;
                char[] password = basicAuthCredentials.getPassword();
                byte[] passwordbytes = new String(password).getBytes(StandardCharsets.UTF_8);
                credentialsAsString = String.format("%s:%s", basicAuthCredentials.getUsername(), Base64.getEncoder().encodeToString(passwordbytes));
            } else if (scmRepositoryCredentials instanceof TokenAuthCredentials) {
                TokenAuthCredentials tokenAuthCredentials = (TokenAuthCredentials)scmRepositoryCredentials;
                credentialsAsString = tokenAuthCredentials.getToken();
            }
            if (credentialsAsString != null) {
                TaParametersBuilder.this.params.put("AUTOM_SOURCE_CODE_REPOSITORY_AUTHENTICATION", credentialsAsString);
            }
        }
    }

    private class CustomDatasetScopedParametersBuilder
    extends ChildScopedParametersBuilder<Dataset> {
        private CustomDatasetScopedParametersBuilder() {
        }

        @Override
        protected void doAddEntity(Dataset entity) {
            if (entity != null) {
                this.addDataset(entity);
            }
        }

        @Override
        protected String getCustomFieldPrefix() {
            return null;
        }

        private void addDataset(Dataset dataset) {
            if (dataset != null) {
                String datasetName = dataset.getName();
                TaParametersBuilder.this.params.put("DSNAME", datasetName);
                dataset.getParameterValues().forEach(paramValue -> {
                    String parameterName = paramValue.getParameter().getName();
                    String value = paramValue.getParamValue();
                    if (!value.isEmpty()) {
                        TaParametersBuilder.this.params.put(String.format("DS_%s", parameterName), value);
                    }
                });
            }
        }
    }

    private class CustomScmRepositoryScopedParametersBuilder
    extends ChildScopedParametersBuilder<ScmRepository> {
        private CustomScmRepositoryScopedParametersBuilder() {
        }

        @Override
        protected void doAddEntity(ScmRepository entity) {
            if (entity != null) {
                this.addScmRepository(entity);
            }
        }

        @Override
        protected String getCustomFieldPrefix() {
            return null;
        }

        private void addScmRepository(ScmRepository repository) {
            String scrType = repository.getScmServer().getKind();
            TaParametersBuilder.this.params.put("AUTOM_SOURCE_CODE_REPOSITORY_TYPE", scrType);
            String scrUrl = repository.getFullUrl();
            TaParametersBuilder.this.params.put("AUTOM_SOURCE_CODE_REPOSITORY_URL", scrUrl);
            String scrBranch = repository.getWorkingBranch();
            TaParametersBuilder.this.params.put("AUTOM_SOURCE_CODE_REPOSITORY_BRANCH", scrBranch);
            String scrAuthenticationType = repository.getScmServer().getAuthenticationProtocol().name();
            TaParametersBuilder.this.params.put("AUTOM_SOURCE_CODE_REPOSITORY_AUTHENTICATION_TYPE", scrAuthenticationType);
        }
    }

    private class CustomTestCaseScopedParametersBuilder
    extends ChildScopedParametersBuilder<TestCase> {
        private CustomTestCaseScopedParametersBuilder() {
        }

        @Override
        protected void doAddEntity(TestCase entity) {
            this.addTestCase(entity);
        }

        @Override
        protected String getCustomFieldPrefix() {
            return "TC";
        }

        private void addTestCase(TestCase testCase) {
            String value = testCase.getReference();
            String uuid = testCase.getUuid();
            String autoTestRef = testCase.getAutomatedTestReference();
            this.nullSafePut("TC_REFERENCE", value);
            TaParametersBuilder.this.params.put("TC_UUID", uuid);
            this.nullSafePut("AUTOM_AUTOMATED_TEST_REFERENCE", autoTestRef);
            if (testCase.getAutomatedTestTechnology() != null) {
                String automatedTestTechnologyActionProviderKey = testCase.getAutomatedTestTechnology().getActionProviderKey();
                TaParametersBuilder.this.params.put("AUTOM_AUTOMATED_TEST_TECHNOLOGY_ACTION_PROVIDER_KEY", automatedTestTechnologyActionProviderKey);
            }
        }

        private void nullSafePut(String key, String value) {
            if (value != null) {
                TaParametersBuilder.this.params.put(key, value);
            }
        }
    }
}

