/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.requirement;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.Paging;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.core.foundation.collection.PagingBackedPagedCollectionHolder;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.requirement.LinkedRequirementVersion;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.requirement.RequirementVersionLink;
import org.squashtest.tm.domain.requirement.RequirementVersionLinkType;
import org.squashtest.tm.domain.resource.Resource;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.exception.requirement.AbstractVerifiedRequirementException;
import org.squashtest.tm.exception.requirement.link.AbstractLinkedRequirementVersionException;
import org.squashtest.tm.exception.requirement.link.AlreadyLinkedRequirementVersionException;
import org.squashtest.tm.exception.requirement.link.SameRequirementLinkedRequirementVersionException;
import org.squashtest.tm.exception.requirement.link.UnlinkableLinkedRequirementVersionException;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.audit.AuditModificationService;
import org.squashtest.tm.service.internal.repository.LibraryNodeDao;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionLinkDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionLinkTypeDao;
import org.squashtest.tm.service.internal.requirement.LinkedRequirementVersionManagerServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.requirement.LinkedRequirementVersionManagerServiceImpl$AjcClosure3;
import org.squashtest.tm.service.internal.requirement.LinkedRequirementVersionManagerServiceImpl$AjcClosure5;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.requirement.LinkedRequirementVersionManagerService;
import org.squashtest.tm.service.requirement.VerifiedRequirementsManagerService;
import org.squashtest.tm.service.testcase.VerifyingTestCaseManagerService;

@Service(value="squashtest.tm.service.LinkedRequirementVersionManagerService")
@Transactional
public class LinkedRequirementVersionManagerServiceImpl
implements LinkedRequirementVersionManagerService {
    private static final Logger LOGGER;
    @Inject
    private RequirementVersionDao reqVersionDao;
    @Inject
    private RequirementVersionLinkDao reqVersionLinkDao;
    @Inject
    private RequirementVersionLinkTypeDao reqVersionLinkTypeDao;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    private RequirementDao requirementDao;
    @Inject
    @Qualifier(value="squashtest.tm.repository.RequirementLibraryNodeDao")
    private LibraryNodeDao<RequirementLibraryNode> requirementLibraryNodeDao;
    @Inject
    private VerifyingTestCaseManagerService verifyingTestCaseManagerService;
    @Inject
    private VerifiedRequirementsManagerService verifiedRequirementsManagerService;
    @Inject
    private AuditModificationService auditModificationService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    static {
        LinkedRequirementVersionManagerServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(LinkedRequirementVersionManagerService.class);
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion' , 'READ') or hasRole('ROLE_ADMIN')")
    @Transactional(readOnly=true)
    public PagedCollectionHolder<List<LinkedRequirementVersion>> findAllByRequirementVersion(long requirementVersionId, PagingAndSorting pagingAndSorting) {
        long totalNumberOfItems = this.reqVersionDao.countRequirementVersionLink(requirementVersionId);
        List requirementVersionLinksList = this.reqVersionLinkDao.findAllByReqVersionId(requirementVersionId, pagingAndSorting);
        ArrayList<LinkedRequirementVersion> linkedReqVersionsList = new ArrayList<LinkedRequirementVersion>();
        for (RequirementVersionLink reqVerLink : requirementVersionLinksList) {
            linkedReqVersionsList.add(reqVerLink.getRelatedLinkedRequirementVersion());
        }
        return new PagingBackedPagedCollectionHolder((Paging)pagingAndSorting, totalNumberOfItems, linkedReqVersionsList);
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'LINK') or hasRole('ROLE_ADMIN')")
    public void removeLinkedRequirementVersionsFromRequirementVersion(long requirementVersionId, List<Long> requirementVersionIdsToUnlink) {
        ArrayList<Long> impactedVersionIds = new ArrayList<Long>(requirementVersionIdsToUnlink);
        impactedVersionIds.add(requirementVersionId);
        ArrayList<Long> arrayList = impactedVersionIds;
        RequirementVersionDao requirementVersionDao = this.reqVersionDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)requirementVersionDao, arrayList);
        Object[] objectArray = new Object[]{this, requirementVersionDao, arrayList, joinPoint};
        LinkedRequirementVersionManagerServiceImpl$AjcClosure1 linkedRequirementVersionManagerServiceImpl$AjcClosure1 = new LinkedRequirementVersionManagerServiceImpl$AjcClosure1(objectArray);
        List impactedVersions = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(linkedRequirementVersionManagerServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
        this.auditModificationService.updateRelatedToRequirementLinkAuditableEntity(impactedVersions);
        this.reqVersionLinkDao.deleteAllLinks(requirementVersionId, requirementVersionIdsToUnlink);
    }

    @Override
    public Collection<AbstractLinkedRequirementVersionException> addLinkedReqVersionsToReqVersion(Long mainReqVersionId, List<Long> otherReqVersionsIds) {
        List<RequirementVersion> requirementVersions = this.findRequirementVersions(otherReqVersionsIds);
        ArrayList<AbstractLinkedRequirementVersionException> rejections = new ArrayList<AbstractLinkedRequirementVersionException>();
        RequirementVersion mainReqVersion = (RequirementVersion)this.reqVersionDao.getReferenceById(mainReqVersionId);
        Map existingLinkCountMap = this.reqVersionLinkDao.countExistingLinkById(mainReqVersionId, requirementVersions.stream().map(Resource::getId).toList());
        for (RequirementVersion otherRequirementVersion : requirementVersions) {
            try {
                this.checkIfLinkAlreadyExists(existingLinkCountMap, otherRequirementVersion);
                this.checkIfSameRequirement(mainReqVersion, otherRequirementVersion);
                this.checkIfVersionsAreLinkable(mainReqVersion, otherRequirementVersion);
            }
            catch (AbstractLinkedRequirementVersionException exception) {
                rejections.add(exception);
            }
        }
        if (rejections.isEmpty()) {
            RequirementVersionLinkType defaultRequirementVersionLinkType = this.reqVersionLinkTypeDao.getDefaultRequirementVersionLinkType();
            for (RequirementVersion otherRequirementVersion : requirementVersions) {
                try {
                    RequirementVersionLink newReqVerLink = new RequirementVersionLink(mainReqVersion, otherRequirementVersion, defaultRequirementVersionLinkType, false);
                    this.reqVersionLinkDao.addLink(newReqVerLink);
                }
                catch (AbstractLinkedRequirementVersionException exception) {
                    rejections.add(exception);
                }
            }
        }
        return rejections;
    }

    @Override
    @PreAuthorize(value="hasPermission(#reqVersionNodeId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'LINK') or hasRole('ROLE_ADMIN')")
    public Collection<AbstractLinkedRequirementVersionException> addDefaultLinkWithNodeIds(Long reqVersionNodeId, Long relatedReqVersionNodeId) {
        ArrayList<Long> reqVerNodeIds = new ArrayList<Long>(1);
        reqVerNodeIds.add(reqVersionNodeId);
        ArrayList<Long> relatedReqVerNodeIds = new ArrayList<Long>(1);
        relatedReqVerNodeIds.add(relatedReqVersionNodeId);
        List<RequirementVersion> requirementVersions = this.findRequirementVersions(reqVerNodeIds);
        return this.addLinkedReqVersionsToReqVersion(requirementVersions.get(0).getId(), relatedReqVerNodeIds);
    }

    @Override
    @PreAuthorize(value="hasPermission(#sourceVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'LINK') or hasRole('ROLE_ADMIN')")
    public void addOrUpdateRequirementLink(Long sourceVersionId, Long destVersionId, String destRole) {
        RequirementVersionLinkType type = this.reqVersionLinkTypeDao.findByRoleCode(destRole);
        boolean outboundDirection = !type.getRole2Code().equals(destRole);
        RequirementVersion source = (RequirementVersion)this.reqVersionDao.getReferenceById(sourceVersionId);
        RequirementVersion dest = (RequirementVersion)this.reqVersionDao.getReferenceById(destVersionId);
        this.checkIfSameRequirement(source, dest);
        this.checkIfVersionsAreLinkable(source, dest);
        RequirementVersionLink outboundLink = this.reqVersionLinkDao.findByReqVersionsIds(sourceVersionId, destVersionId);
        if (outboundLink == null) {
            outboundLink = new RequirementVersionLink(source, dest, type, outboundDirection);
            this.reqVersionLinkDao.addLink(outboundLink);
        } else {
            RequirementVersionLink inboundLink = this.reqVersionLinkDao.findByReqVersionsIds(destVersionId, sourceVersionId);
            outboundLink.setLinkType(type);
            outboundLink.setLinkDirection(outboundDirection);
            inboundLink.setLinkType(type);
            inboundLink.setLinkDirection(!outboundDirection);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'LINK') or hasRole('ROLE_ADMIN')")
    public void updateLinkTypeAndDirection(long requirementVersionId, long relatedReqNodeId, boolean isRelatedIdANodeId, long linkTypeId, boolean linkDirection) {
        long relatedVersionId = relatedReqNodeId;
        if (isRelatedIdANodeId) {
            ArrayList<Long> reqVerNodeIds = new ArrayList<Long>();
            reqVerNodeIds.add(relatedReqNodeId);
            List<RequirementVersion> list = this.findRequirementVersions(reqVerNodeIds);
            RequirementVersion relatedReqVersion = list.get(0);
            relatedVersionId = relatedReqVersion.getId();
        }
        RequirementVersionLink linkToUpdate = this.reqVersionLinkDao.findByReqVersionsIds(requirementVersionId, relatedVersionId);
        RequirementVersionLink symmetricalLinkToUpdate = this.reqVersionLinkDao.findByReqVersionsIds(relatedVersionId, requirementVersionId);
        List<Long> list = Arrays.asList(requirementVersionId, relatedVersionId);
        RequirementVersionDao requirementVersionDao = this.reqVersionDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)requirementVersionDao, list);
        Object[] objectArray = new Object[]{this, requirementVersionDao, list, joinPoint};
        LinkedRequirementVersionManagerServiceImpl$AjcClosure3 linkedRequirementVersionManagerServiceImpl$AjcClosure3 = new LinkedRequirementVersionManagerServiceImpl$AjcClosure3(objectArray);
        List requirementVersions = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(linkedRequirementVersionManagerServiceImpl$AjcClosure3.linkClosureAndJoinPoint(4112));
        RequirementVersionLinkType newLinkType = (RequirementVersionLinkType)this.reqVersionLinkTypeDao.getReferenceById(linkTypeId);
        linkToUpdate.setLinkType(newLinkType);
        linkToUpdate.setLinkDirection(linkDirection);
        symmetricalLinkToUpdate.setLinkType(newLinkType);
        symmetricalLinkToUpdate.setLinkDirection(!linkDirection);
        this.auditModificationService.updateRelatedToRequirementLinkAuditableEntity(requirementVersions);
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'LINK') or hasRole('ROLE_ADMIN')")
    public Collection<AbstractLinkedRequirementVersionException> addLinkWithNodeIds(Long requirementVersionId, Long relatedReqVersionNodeId, long reqVersionLinkTypeId, boolean reqVersionLinkTypeDirection) {
        List<Long> requirementVersions = Collections.singletonList(relatedReqVersionNodeId);
        RequirementVersionLinkType type = (RequirementVersionLinkType)this.reqVersionLinkTypeDao.getReferenceById(reqVersionLinkTypeId);
        boolean outboundDirection = reqVersionLinkTypeDirection;
        return this.addLinkedReqVersionsToReqVersion(requirementVersionId, requirementVersions, type, outboundDirection);
    }

    @Override
    public void copyRequirementVersionLinks(RequirementVersion previousVersion, RequirementVersion newVersion) {
        for (RequirementVersionLink reqVerLink : previousVersion.getRequirementVersionLinks()) {
            try {
                this.addDetailedReqVersionLink(newVersion.getId(), reqVerLink.getRelatedLinkedRequirementVersion().getId(), reqVerLink.getLinkType().getId(), reqVerLink.getLinkDirection());
            }
            catch (AbstractLinkedRequirementVersionException exception) {
                LOGGER.info("RequirementVersion {} could not be linked to RequirementVersion {}", new Object[]{previousVersion.getName(), newVersion.getName(), exception});
            }
        }
    }

    @Override
    public RequirementVersionLink addDetailedReqVersionLink(long reqVersionId, long relatedReqVersionId, long linkTypeId, boolean linkDirection) throws AbstractLinkedRequirementVersionException {
        RequirementVersion reqVersion = (RequirementVersion)this.reqVersionDao.getReferenceById(reqVersionId);
        RequirementVersion relatedReqVersion = (RequirementVersion)this.reqVersionDao.getReferenceById(relatedReqVersionId);
        this.checkIfLinkAlreadyExists(reqVersion.getId(), relatedReqVersion.getId());
        this.checkIfSameRequirement(reqVersion, relatedReqVersion);
        this.checkIfVersionsAreLinkable(reqVersion, relatedReqVersion);
        RequirementVersionLinkType linkType = (RequirementVersionLinkType)this.reqVersionLinkTypeDao.getReferenceById(linkTypeId);
        RequirementVersionLink newLink = new RequirementVersionLink(reqVersion, relatedReqVersion, linkType, linkDirection);
        this.reqVersionLinkDao.addLink(newLink);
        return newLink;
    }

    @Override
    public List<RequirementVersionLinkType> getAllReqVersionLinkTypes() {
        return this.reqVersionLinkTypeDao.getAllRequirementVersionLinkTypes();
    }

    @Override
    public Set<String> findAllRoleCodes() {
        List<RequirementVersionLinkType> allTypes = this.getAllReqVersionLinkTypes();
        HashSet<String> codes = new HashSet<String>();
        for (RequirementVersionLinkType type : allTypes) {
            codes.add(type.getRole1Code());
            codes.add(type.getRole2Code());
        }
        return codes;
    }

    @Override
    public List<RequirementVersionLinkType> findAllRequirementVersionLinkType() {
        return this.getAllReqVersionLinkTypes();
    }

    @Override
    public void postponeTestCaseToNewRequirementVersion(RequirementVersion previousVersion, RequirementVersion newVersion) {
        for (TestCase testCaseToPostpone : this.verifyingTestCaseManagerService.findAllByRequirementVersion(previousVersion.getId())) {
            try {
                this.verifiedRequirementsManagerService.changeVerifiedRequirementVersionOnTestCase(previousVersion.getId(), newVersion.getId(), testCaseToPostpone.getId());
            }
            catch (AbstractVerifiedRequirementException exception) {
                LOGGER.info("Could not change VerifiedRequirementVersion of VerifyingTestCase {}", new Object[]{testCaseToPostpone.getName(), exception});
            }
        }
    }

    @Override
    public PagedCollectionHolder<List<RequirementVersionLinkType>> getAllPagedAndSortedReqVersionLinkTypes(PagingAndSorting pagingAndSorting) {
        List reqLinkTypesList = this.reqVersionLinkTypeDao.getAllPagedAndSortedReqVersionLinkTypes(pagingAndSorting);
        return new PagingBackedPagedCollectionHolder((Paging)pagingAndSorting, (long)reqLinkTypesList.size(), (Collection)reqLinkTypesList);
    }

    private void checkIfLinkAlreadyExists(Map<Long, Long> map, RequirementVersion relatedReqVersion) {
        Long count = map.get(relatedReqVersion.getId());
        if (count != null && count > 0L) {
            throw new AlreadyLinkedRequirementVersionException();
        }
    }

    private void checkIfLinkAlreadyExists(Long mainReqId, Long relatedReqVersionId) {
        if (this.reqVersionLinkDao.linkAlreadyExists(mainReqId, relatedReqVersionId)) {
            throw new AlreadyLinkedRequirementVersionException();
        }
    }

    @Override
    public void checkIfSameRequirement(RequirementVersion reqVersion, RequirementVersion relatedReqVersion) {
        if (reqVersion.getRequirement().getId().equals(relatedReqVersion.getRequirement().getId())) {
            throw new SameRequirementLinkedRequirementVersionException();
        }
    }

    @Override
    public void checkIfVersionsAreLinkable(RequirementVersion reqVersion, RequirementVersion relatedReqVersion) {
        if (!reqVersion.isLinkable() || !relatedReqVersion.isLinkable()) {
            throw new UnlinkableLinkedRequirementVersionException();
        }
    }

    @Override
    public Map<String, String> getRequirementVersionInformation(List<Long> requirementVersionids, boolean isRelatedIdANodeId) {
        List requirementVersions;
        if (isRelatedIdANodeId) {
            requirementVersions = this.findRequirementVersions(requirementVersionids);
        } else {
            List<Long> list = requirementVersionids;
            RequirementVersionDao requirementVersionDao = this.reqVersionDao;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)requirementVersionDao, list);
            Object[] objectArray = new Object[]{this, requirementVersionDao, list, joinPoint};
            LinkedRequirementVersionManagerServiceImpl$AjcClosure5 linkedRequirementVersionManagerServiceImpl$AjcClosure5 = new LinkedRequirementVersionManagerServiceImpl$AjcClosure5(objectArray);
            requirementVersions = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(linkedRequirementVersionManagerServiceImpl$AjcClosure5.linkClosureAndJoinPoint(4112));
        }
        Object name = "";
        HashMap<String, String> versionInfosMap = new HashMap<String, String>();
        for (RequirementVersion relatedId : requirementVersions) {
            name = ((String)name).isEmpty() ? (String)name + HtmlUtils.htmlEscape((String)relatedId.getName()) : (String)name + ", " + HtmlUtils.htmlEscape((String)relatedId.getName());
        }
        versionInfosMap.put("versionName", (String)name);
        return versionInfosMap;
    }

    private Collection<AbstractLinkedRequirementVersionException> addLinkedReqVersionsToReqVersion(Long mainReqVersionId, List<Long> otherReqVersionsIds, RequirementVersionLinkType requirementVersionLinkType, boolean linkDirection) {
        List<RequirementVersion> requirementVersions = this.findRequirementVersions(otherReqVersionsIds);
        RequirementVersion mainReqVersion = (RequirementVersion)this.reqVersionDao.getReferenceById(mainReqVersionId);
        Map map = this.reqVersionLinkDao.countExistingLinkById(mainReqVersionId, requirementVersions.stream().map(Resource::getId).toList());
        ArrayList<AbstractLinkedRequirementVersionException> rejections = new ArrayList<AbstractLinkedRequirementVersionException>();
        for (RequirementVersion otherRequirementVersion : requirementVersions) {
            try {
                this.checkIfLinkAlreadyExists(map, otherRequirementVersion);
                this.checkIfSameRequirement(mainReqVersion, otherRequirementVersion);
                this.checkIfVersionsAreLinkable(mainReqVersion, otherRequirementVersion);
            }
            catch (AbstractLinkedRequirementVersionException exception) {
                rejections.add(exception);
            }
        }
        if (rejections.isEmpty()) {
            for (RequirementVersion otherRequirementVersion : requirementVersions) {
                try {
                    RequirementVersionLink newReqVerLink = new RequirementVersionLink(mainReqVersion, otherRequirementVersion, requirementVersionLinkType, linkDirection);
                    this.reqVersionLinkDao.addLink(newReqVerLink);
                }
                catch (AbstractLinkedRequirementVersionException exception) {
                    rejections.add(exception);
                }
            }
        }
        return rejections;
    }

    private List<RequirementVersion> findRequirementVersions(List<Long> requirementNodesIds) {
        List<Requirement> requirements = this.requirementDao.findRequirementsNodeRootAndInFolderByNodeIds(requirementNodesIds);
        if (!requirements.isEmpty()) {
            return this.extractVersions(requirements);
        }
        return Collections.emptyList();
    }

    private List<RequirementVersion> extractVersions(List<Requirement> requirements) {
        ArrayList<RequirementVersion> rvs = new ArrayList<RequirementVersion>(requirements.size());
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        for (Requirement requirement : requirements) {
            if (activeMilestone.isEmpty()) {
                rvs.add(requirement.getResource());
                continue;
            }
            rvs.add(requirement.findByMilestone(activeMilestone.get()));
        }
        return rvs;
    }

    static final /* synthetic */ List findAllById_aroundBody0(LinkedRequirementVersionManagerServiceImpl linkedRequirementVersionManagerServiceImpl, RequirementVersionDao requirementVersionDao, Iterable iterable, JoinPoint joinPoint) {
        return requirementVersionDao.findAllById(iterable);
    }

    static final /* synthetic */ List findAllById_aroundBody2(LinkedRequirementVersionManagerServiceImpl linkedRequirementVersionManagerServiceImpl, RequirementVersionDao requirementVersionDao, Iterable iterable, JoinPoint joinPoint) {
        return requirementVersionDao.findAllById(iterable);
    }

    static final /* synthetic */ List findAllById_aroundBody4(LinkedRequirementVersionManagerServiceImpl linkedRequirementVersionManagerServiceImpl, RequirementVersionDao requirementVersionDao, Iterable iterable, JoinPoint joinPoint) {
        return requirementVersionDao.findAllById(iterable);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("LinkedRequirementVersionManagerServiceImpl.java", LinkedRequirementVersionManagerServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "findAllById", "org.squashtest.tm.service.internal.repository.RequirementVersionDao", "java.lang.Iterable", "arg0", "", "java.util.List"), 126);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "findAllById", "org.squashtest.tm.service.internal.repository.RequirementVersionDao", "java.lang.Iterable", "arg0", "", "java.util.List"), 265);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "findAllById", "org.squashtest.tm.service.internal.repository.RequirementVersionDao", "java.lang.Iterable", "arg0", "", "java.util.List"), 420);
    }
}

