/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.service.internal.repository.TestStepDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;
import org.squashtest.tm.service.internal.repository.hibernate.SetQueryParametersCallback;

@Repository
public class HibernateTestStepDao
extends HibernateEntityDao<TestStep>
implements TestStepDao {
    private static final String FIND_BY_TC_AND_POSITION = "testStep.findByTestCaseAndPosition";

    @Override
    public List<TestStep> findListById(List<Long> testStepIds) {
        TestStepIdsQueryParametersCallback callback = new TestStepIdsQueryParametersCallback(testStepIds);
        return this.executeListNamedQuery("testStep.findOrderedListById", callback);
    }

    @Override
    public int findPositionOfStep(Long testStepId) {
        TypedQuery query = this.entityManager.createNamedQuery("testStep.findPositionOfStep", Integer.class);
        query.setParameter("stepId", (Object)testStepId);
        return (Integer)query.getSingleResult();
    }

    @Override
    public ActionTestStep findActionTestStepById(long testStepId) {
        return (ActionTestStep)this.entityManager.find(ActionTestStep.class, (Object)testStepId);
    }

    @Override
    public boolean stringIsFoundInStepsOfTestCase(String stringToFind, long testCaseId) {
        TypedQuery query = this.entityManager.createNamedQuery("testStep.stringIsFoundInStepsOfTestCase", Long.class);
        query.setParameter("testCaseId", (Object)testCaseId);
        query.setParameter("stringToFind", (Object)("%" + stringToFind + "%"));
        return (Long)query.getSingleResult() > 0L;
    }

    @Override
    public boolean stringIsFoundInStepsOfKeywordTestCase(String stringToFind, long testCaseId) {
        TypedQuery query = this.entityManager.createNamedQuery("testStep.stringIsFoundInStepsOfKeywordTestCase", Long.class);
        query.setParameter("testCaseId", (Object)testCaseId);
        query.setParameter("stringToFind", (Object)stringToFind);
        return (Long)query.getSingleResult() > 0L;
    }

    @Override
    public List<TestStep> findByIdOrderedByIndex(List<Long> testStepIds) {
        TypedQuery query = this.entityManager.createNamedQuery("testStep.findByIdOrderedByIndex", TestStep.class);
        query.setParameter("testStepIds", testStepIds);
        return query.getResultList();
    }

    @Override
    public TestCase findTestCaseFromActionTestStep(long testStepId) {
        TypedQuery query = this.entityManager.createNamedQuery("testStep.findTestCaseFromActionTestStep", TestCase.class);
        query.setParameter("testStepId", (Object)testStepId);
        return (TestCase)query.getSingleResult();
    }

    @Override
    public List<Object[]> findTestStepsDetails(Collection<Long> testCaseIds) {
        return this.entityManager.createQuery("select tc.id,\ncase when st.class = ActionTestStep then 'ACTION' else 'CALL' end as steptype,\ncase when st.class = CallTestStep then st.calledTestCase.id else null end as calledTC,\ncase when st.class=CallTestStep then st.delegateParameterValues else false end as delegates\nfrom TestCase tc join tc.steps st where tc.id in :ids order by index(st)", Object[].class).setParameter("ids", testCaseIds).getResultList();
    }

    @Override
    public TestStep findByTestCaseAndPosition(Long testCaseId, Integer index) {
        return (TestStep)this.entityManager.createNamedQuery(FIND_BY_TC_AND_POSITION, TestStep.class).setParameter("testCaseId", (Object)testCaseId).setParameter("position", (Object)index).getSingleResult();
    }

    private static final class TestStepIdsQueryParametersCallback
    implements SetQueryParametersCallback {
        private List<Long> testStepIds;

        private TestStepIdsQueryParametersCallback(List<Long> testStepIds) {
            this.testStepIds = testStepIds;
        }

        @Override
        public void setQueryParameters(Query query) {
            query.setParameter("testStepIds", this.testStepIds);
        }
    }
}

