/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.inject.Provider;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.Query;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.internal.copier.ChildEntityDtoResult;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.RequirementFolderDao;
import org.squashtest.tm.service.internal.repository.hibernate.ContainerIdNameStartParameterCallback;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;
import org.squashtest.tm.service.internal.repository.hibernate.SetNodeContentParameter;
import org.squashtest.tm.service.internal.repository.hibernate.SetQueryParametersCallback;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.NestedEntityGraphQueryBuilder;

@Repository
public class HibernateRequirementFolderDao
extends HibernateEntityDao<RequirementFolder>
implements RequirementFolderDao {
    private final Provider<RequirementDao> requirementDaoProvider;

    public HibernateRequirementFolderDao(Provider<RequirementDao> requirementDaoProvider) {
        this.requirementDaoProvider = requirementDaoProvider;
    }

    @Override
    public RequirementFolder findByContent(RequirementLibraryNode node) {
        SetNodeContentParameter callback = new SetNodeContentParameter((LibraryNode)node);
        return (RequirementFolder)this.executeEntityNamedQuery("requirementFolder.findByContent", callback);
    }

    @Override
    public List<String> findNamesInLibraryStartingWith(long libraryId, String nameStart) {
        ContainerIdNameStartParameterCallback newCallBack1 = new ContainerIdNameStartParameterCallback(libraryId, nameStart);
        return this.executeListNamedQuery("requirementFolder.findNamesInLibraryStartingWith", newCallBack1);
    }

    @Override
    public List<String> findNamesInNodeStartingWith(long nodeId, String nameStart) {
        ContainerIdNameStartParameterCallback newCallBack1 = new ContainerIdNameStartParameterCallback(nodeId, nameStart);
        return this.executeListNamedQuery("requirementLibraryNode.findNamesInNodeStartingWith", newCallBack1);
    }

    @Override
    public RequirementFolder findByIdWithContent(Long id) {
        EntityGraph graph = this.entityManager.createEntityGraph(RequirementFolder.class);
        graph.addSubgraph("content", RequirementLibraryNode.class);
        return (RequirementFolder)this.entityManager.createQuery("SELECT rf FROM RequirementFolder rf  WHERE rf.id = :id", RequirementFolder.class).setHint("jakarta.persistence.fetchgraph", (Object)graph).setParameter("id", (Object)id).getSingleResult();
    }

    @Override
    public RequirementFolder loadContainerForPaste(long id) {
        return (RequirementFolder)this.loadContainersForPaste(Collections.singleton(id)).stream().findFirst().orElseThrow(() -> new IllegalArgumentException("No Requirement folder found for id: " + id));
    }

    @Override
    public List<RequirementFolder> loadContainersForPaste(Collection<Long> ids) {
        List requirementFolders = this.entityManager.createQuery("    select f from RequirementFolder f\n    left join fetch f.requirementFolderSyncExtender\n    left join fetch f.content c\n    left join fetch f.project p\n    where f.id in :ids\n", RequirementFolder.class).setParameter("ids", ids).getResultList();
        List projects = this.entityManager.createQuery("select p from RequirementFolder f\njoin f.project p\nleft join fetch p.requirementCategories rC\nleft join fetch rC.items\nwhere f.id in :ids\n", Project.class).setParameter("ids", ids).getResultList();
        NestedEntityGraphQueryBuilder.of(this.entityManager, Project.class, "select p from Project p where p in :ids", NestedEntityGraphQueryBuilder.GraphDefinition.graphDefinition(NestedEntityGraphQueryBuilder.GraphDefinition.attr("milestones"))).executeDistinctList(Map.of("ids", projects));
        return requirementFolders;
    }

    @Override
    public List<RequirementFolder> loadNodeForPaste(Collection<Long> ids) {
        return this.entityManager.createQuery("    select f from RequirementFolder f\n    left join fetch f.requirementFolderSyncExtender\n    left join fetch f.resource r\n    left join fetch r.attachmentList al\n    left join fetch al.attachments a\n    left join fetch a.content\n    where f.id in :ids\n", RequirementFolder.class).setParameter("ids", ids).getResultList();
    }

    @Override
    public ChildEntityDtoResult loadChildForPaste(Collection<Long> ids, int maxResult, int offset, ClipboardPayload clipboardPayload) {
        return this.getChildEntityDtoForPaste("select rc, f.id from RequirementFolder f join f.content rc left join fetch treat(rc as Requirement).syncExtender where f.id in :ids", ids, maxResult, offset, clipboardPayload, (k, v) -> {
            switch (k) {
                case REQUIREMENT: {
                    ((RequirementDao)this.requirementDaoProvider.get()).loadNodeForPaste((Collection<Long>)v);
                    break;
                }
                case REQUIREMENT_FOLDER: {
                    this.loadNodeForPaste((Collection<Long>)v);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported entity type: " + String.valueOf(k));
                }
            }
        });
    }

    @Override
    public List<RequirementFolder> loadNodeForTestCasePaste(Collection<Long> ids) {
        return this.entityManager.createQuery("select f from RequirementFolder f where f.id in :ids", RequirementFolder.class).setParameter("ids", ids).getResultList();
    }

    @Override
    public ChildEntityDtoResult loadChildForTestCasePaste(Collection<Long> ids, int maxResult, int offset, ClipboardPayload clipboardPayload) {
        return this.getChildEntityDtoForPaste("select rc, f.id from RequirementFolder f join f.content rc left join fetch treat(rc as Requirement).syncExtender where f.id in :ids", ids, maxResult, offset, clipboardPayload, (k, v) -> {
            switch (k) {
                case REQUIREMENT: {
                    ((RequirementDao)this.requirementDaoProvider.get()).loadNodeForTestCasePaste((Collection<Long>)v);
                    break;
                }
                case REQUIREMENT_FOLDER: {
                    this.loadNodeForTestCasePaste((Collection<Long>)v);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported entity type: " + String.valueOf(k));
                }
            }
        });
    }

    @Override
    public RequirementFolder loadForNodeAddition(Long folderId) {
        return (RequirementFolder)this.entityManager.createQuery("select folder from RequirementFolder folder\njoin fetch folder.project project\njoin fetch project.requirementCategories\nleft join fetch folder.requirementFolderSyncExtender\nleft join fetch folder.content content\nleft join fetch content.syncExtender\nleft join fetch content.requirementFolderSyncExtender\nwhere folder.id = :id", RequirementFolder.class).setParameter("id", (Object)folderId).getSingleResult();
    }

    @Override
    public List<RequirementFolder> loadForNodeAddition(Collection<Long> folderIds) {
        return this.entityManager.createQuery("select distinct folder from RequirementFolder folder\njoin fetch folder.project project\njoin fetch project.requirementCategories\nleft join fetch folder.requirementFolderSyncExtender\nleft join fetch folder.content content\nleft join fetch content.syncExtender\nleft join fetch content.requirementFolderSyncExtender\nwhere folder.id in :ids", RequirementFolder.class).setParameter("ids", folderIds).getResultList();
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<Long[]> findPairedContentForList(List<Long> ids) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<Long> findContentForList(List<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        List queryResults = this.entityManager.createNativeQuery("select * from RLN_RELATIONSHIP where ancestor_id in (:folderIds)").setParameter("folderIds", ids).getResultList();
        return queryResults.stream().map(row -> ((Number)row[1]).longValue()).toList();
    }

    @Override
    public RequirementFolder findParentOf(Long id) {
        ContentIdParametterCallback newCallBack = new ContentIdParametterCallback(id);
        return (RequirementFolder)this.executeEntityNamedQuery("requirementFolder.findParentOf", newCallBack);
    }

    private static final class ContentIdParametterCallback
    implements SetQueryParametersCallback {
        private long contentId;

        private ContentIdParametterCallback(long contentId) {
            this.contentId = contentId;
        }

        @Override
        public void setQueryParameters(Query query) {
            query.setParameter("contentId", (Object)this.contentId);
        }
    }
}

