/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.AdministrationStatistics;
import org.squashtest.tm.service.internal.repository.AdministrationDao;

@Repository
public class HibernateAdministrationDao
implements AdministrationDao {
    private static final String DATABASE_LABEL_MYSQL = "mysql";
    private static final String DATABASE_LABEL_MARIADB = "mariadb";
    private static final String DATABASE_LABEL_POSTGRESQL = "postgresql";
    private static final String REQ_DATABASE_SIZE_MARIADB = "select sum((data_length + index_length) / 1024 / 1024) from information_schema.tables where table_schema = database()";
    private static final String REQ_DATABASE_SIZE_POSTGRESQL = "select pg_database_size(current_database()) / 1024 / 1024";
    @PersistenceContext
    EntityManager entityManager;
    @Inject
    private DataSourceProperties dataSourceProperties;

    @Override
    public AdministrationStatistics findAdministrationStatistics() {
        Object[] result = (Object[])this.entityManager.createNamedQuery("administration.findAdministrationStatistics").getSingleResult();
        Long databaseSize = 0L;
        String url = this.dataSourceProperties.getUrl();
        if (url.contains(DATABASE_LABEL_MYSQL) || url.contains(DATABASE_LABEL_MARIADB)) {
            databaseSize = this.getDatabaseSizeForMariaDB();
        }
        if (url.contains(DATABASE_LABEL_POSTGRESQL)) {
            databaseSize = this.getDatabaseSizeForPostgresql();
        }
        return new AdministrationStatistics(result, databaseSize);
    }

    private Long getDatabaseSizeForMariaDB() {
        return (Long)this.entityManager.createNativeQuery(REQ_DATABASE_SIZE_MARIADB, Long.class).getSingleResult();
    }

    private Long getDatabaseSizeForPostgresql() {
        return (Long)this.entityManager.createNativeQuery(REQ_DATABASE_SIZE_POSTGRESQL).getSingleResult();
    }
}

