/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.xrayimporter.topivot;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Record2;
import org.jooq.Record3;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.sanitizehtml.HTMLSanitizeUtils;
import org.squashtest.tm.exception.pivot.projectimporter.xrayimporter.ImportXrayException;
import org.squashtest.tm.service.internal.dto.projectimporterxray.jooq.dto.AbstractGenericItem;
import org.squashtest.tm.service.internal.dto.projectimporterxray.jooq.dto.ItemXrayDto;
import org.squashtest.tm.service.internal.dto.projectimporterxray.mapping.XrayPriority;
import org.squashtest.tm.service.internal.dto.projectimporterxray.mapping.XrayStatus;
import org.squashtest.tm.service.internal.dto.projectimporterxray.model.XrayItemStatus;
import org.squashtest.tm.service.pivot.projectimporter.xrayimporter.SquashRules;
import org.squashtest.tm.service.pivot.projectimporter.xrayimporter.XrayTablesDao;

@Service
public class SquashRulesImpl
implements SquashRules {
    private static final Pattern DATASET_NAME_REGEX = Pattern.compile("[^\\sA-Za-z0-9_-]");
    private final XrayTablesDao xrayTablesDao;

    public SquashRulesImpl(XrayTablesDao xrayTablesDao) {
        this.xrayTablesDao = xrayTablesDao;
    }

    @Override
    public void handleDuplicateName(Stream<Record2<Long, String>> recordSelectDuplicate) {
        ArrayList<Query> queries = new ArrayList<Query>();
        recordSelectDuplicate.collect(Collectors.groupingBy(record2 -> (String)record2.get(this.xrayTablesDao.getItemTable().SUMMARY))).forEach((key, value) -> {
            if (value.size() > 1) {
                this.updateDuplicateName((List)value, (List<Query>)queries);
            }
        });
        this.xrayTablesDao.executeBatchQueries(queries);
    }

    @Override
    public void handleDuplicateNameWithParentType(Stream<Record3<Long, String, String>> recordSelectDuplicate) {
        ArrayList<Query> queries = new ArrayList<Query>();
        recordSelectDuplicate.collect(Collectors.groupingBy(record2 -> {
            String summary = (String)record2.get(this.xrayTablesDao.getItemTable().SUMMARY);
            String path = (String)record2.get(this.xrayTablesDao.getCustomFieldTable().VALUE);
            return String.format("%s_%s", summary, path);
        })).forEach((key, value) -> {
            if (value.size() > 1) {
                this.updateDuplicateName((List)value, (List<Query>)queries);
            }
        });
        this.xrayTablesDao.executeBatchQueries(queries);
    }

    private <T extends Record> void updateDuplicateName(List<T> listDuplicateNameRecord, List<Query> queries) {
        if (queries.size() > 50) {
            this.xrayTablesDao.executeBatchQueries(queries);
            queries.clear();
        }
        IntStream.range(1, listDuplicateNameRecord.size()).boxed().forEach(i -> this.xrayTablesDao.addQueryUpdateItemName((Long)((Record)listDuplicateNameRecord.get((int)i)).get(this.xrayTablesDao.getItemTable().ID), String.format("%s (%s)", ((Record)listDuplicateNameRecord.get((int)i)).get(this.xrayTablesDao.getItemTable().SUMMARY), i), queries));
    }

    @Override
    public <T extends AbstractGenericItem> void markWithErrorAndThrow(T item, String message) {
        item.setItemStatus(XrayItemStatus.FAILURE);
        item.setMessageOnError(String.format("%s - FAIL - %s", item.getKey(), message));
        throw new ImportXrayException(String.format("Error during generation of the %s : %s", item.getKey(), message));
    }

    @Override
    public <T extends AbstractGenericItem> void markWithSuccessIfStatusIsNull(T item) {
        if (Objects.isNull((Object)item.getItemStatus())) {
            item.setItemStatus(XrayItemStatus.SUCCESS);
            item.setMessageOnSuccess(String.format("%s - SUCCESS", item.getKey()));
        }
    }

    @Override
    public <T extends AbstractGenericItem> void markWithWarning(T item, String message) {
        item.setItemStatus(XrayItemStatus.WARNING);
        item.getMessagesOnWarn().add(String.format("%s - WARNING - %s", item.getKey(), message));
    }

    @Override
    public void validateMandatoryCommonField(ItemXrayDto itemXrayDto) {
        this.checkMandatoryField(itemXrayDto, itemXrayDto.getSummary(), "Summary");
        itemXrayDto.setSummary(this.checkFieldLength(itemXrayDto, itemXrayDto.getSummary(), "Summary"));
        this.checkMandatoryField(itemXrayDto, itemXrayDto.getKey(), "Key");
    }

    @Override
    public <T extends AbstractGenericItem, R> void checkMandatoryField(T item, R value, String fieldName) {
        if (Objects.isNull(value)) {
            this.markWithErrorAndThrow(item, String.format("The field %s is null", fieldName));
        }
        if (value instanceof String && StringUtils.isBlank((CharSequence)((String)value))) {
            this.markWithErrorAndThrow(item, String.format("The field %s is empty", fieldName));
        }
    }

    @Override
    public String checkSanitizer(ItemXrayDto itemXrayDto, String elementToCheck, String fieldName) {
        List errorMessages = HTMLSanitizeUtils.checkHtml((String)elementToCheck);
        if (!errorMessages.isEmpty()) {
            String messageOnWarn = String.format("%s is not a valid HTML (Formatting has been applied). Errors : %s", fieldName, StringUtils.join((Iterable)errorMessages, (String)", "));
            this.markWithWarning(itemXrayDto, messageOnWarn);
            return HTMLSanitizeUtils.cleanHtml((String)elementToCheck);
        }
        return elementToCheck;
    }

    @Override
    public String checkDatasetName(ItemXrayDto itemXrayDto, String datasetParam) {
        if (StringUtils.isBlank((CharSequence)datasetParam)) {
            return datasetParam;
        }
        datasetParam = this.checkDatasetName(datasetParam, (String datasetParamRaw) -> this.markWithWarning(itemXrayDto, String.format("Dataset parameter '%s' contains invalid characters (Must be alphanumeric). These characters will be ignored.", datasetParamRaw)));
        datasetParam = this.checkFieldLength(itemXrayDto, datasetParam, "Dataset parameter");
        return datasetParam;
    }

    @Override
    public String checkDatasetNameInsideStep(String datasetParam) {
        if (StringUtils.isBlank((CharSequence)datasetParam)) {
            return datasetParam;
        }
        if ((datasetParam = this.checkDatasetName(datasetParam, (String datasetParamRaw) -> {})).length() > 255) {
            return datasetParam.substring(0, 255);
        }
        return datasetParam;
    }

    private String checkDatasetName(String datasetParamRaw, Consumer<String> markTestCase) {
        datasetParamRaw = StringUtils.stripAccents((String)datasetParamRaw);
        datasetParamRaw = datasetParamRaw.replaceAll("\\s+", "_");
        String datasetParamName = datasetParamRaw = datasetParamRaw.replace("\u00df", "ss");
        Matcher matcher = DATASET_NAME_REGEX.matcher(datasetParamName);
        if (matcher.find()) {
            datasetParamName = matcher.replaceAll("");
            markTestCase.accept(datasetParamRaw);
        }
        return datasetParamName;
    }

    @Override
    public String checkFieldLength(ItemXrayDto itemXrayDto, String string, String fieldName) {
        if (string.length() > 255) {
            this.markWithWarning(itemXrayDto, String.format("The field %s is too long (Max 255 characters)", fieldName));
            return string.substring(0, 255);
        }
        return string;
    }

    @Override
    public XrayStatus checkStatus(ItemXrayDto itemXrayDto, String status) {
        return this.checkField(itemXrayDto, "status", status, XrayStatus.DEFAULT, XrayStatus::getStatus, XrayStatus::getXrayFieldMapping);
    }

    @Override
    public XrayPriority checkPriority(ItemXrayDto itemXrayDto, String priority) {
        return this.checkField(itemXrayDto, "priority", priority, XrayPriority.DEFAULT, XrayPriority::getPriority, XrayPriority::getXrayFieldMapping);
    }

    private <T extends Enum<T>> T checkField(ItemXrayDto itemXrayDto, String fieldName, String value, T defaultValue, Function<String, T> getField, Supplier<String> getFieldMapping) {
        Enum field = (Enum)getField.apply(value);
        if (field.equals(defaultValue)) {
            this.markWithWarning(itemXrayDto, String.format("The %s value '%s' does not match any of the allowed values: %s. The default will be used.", fieldName, value, getFieldMapping.get()));
        }
        return (T)field;
    }
}

