/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.zip.ZipFile;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.domain.requirement.RequirementVersionLinkType;
import org.squashtest.tm.service.internal.dto.pivotdefinition.RequirementLinkTypePivot;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.library.LibraryUtils;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.AbstractPivotImport;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotFormatLoggerHelper;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotImportStrategy;
import org.squashtest.tm.service.internal.repository.RequirementVersionLinkTypeDao;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.InfoListPivotImporterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.RequirementLinkImporterService;

@Service
public class RequirementLinkImporterServiceImpl
extends AbstractPivotImport
implements RequirementLinkImporterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoListPivotImporterService.class);
    private final AdminPivotConverterService adminPivotConverterService;
    private final RequirementVersionLinkTypeDao requirementVersionLinkTypeDao;
    @PersistenceContext
    private EntityManager entityManager;

    public RequirementLinkImporterServiceImpl(AdminPivotConverterService adminPivotConverterService, RequirementVersionLinkTypeDao requirementVersionLinkTypeDao) {
        super(LOGGER);
        this.adminPivotConverterService = adminPivotConverterService;
        this.requirementVersionLinkTypeDao = requirementVersionLinkTypeDao;
    }

    @Override
    public void importRequirementLinksFromZipArchive(ZipFile zipFile, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        PivotImportStrategy<RequirementLinkTypePivot> requirementLinkTypePivotPivotImportStrategy = this.getRequirementLinkTypePivotImporterStrategy(pivotImportMetadata, pivotFormatImport);
        this.importEntitiesFromZipArchive(zipFile, JsonImportFile.REQUIREMENT_LINK_TYPES, pivotFormatImport, pivotImportMetadata, "requirements link", "requirement link", requirementLinkTypePivotPivotImportStrategy);
    }

    private PivotImportStrategy<RequirementLinkTypePivot> getRequirementLinkTypePivotImporterStrategy(final PivotImportMetadata pivotImportMetadata, final PivotFormatImport pivotFormatImport) {
        return new PivotImportStrategy<RequirementLinkTypePivot>(){

            @Override
            public Class<RequirementLinkTypePivot> getPivotClazz() {
                return RequirementLinkTypePivot.class;
            }

            @Override
            public void create(List<RequirementLinkTypePivot> entities) {
                RequirementLinkImporterServiceImpl.this.createRequirementLinks(entities, pivotFormatImport, pivotImportMetadata);
            }
        };
    }

    private void createRequirementLinks(List<RequirementLinkTypePivot> requirementLinkTypePivots, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        List<RequirementVersionLinkType> existingRequirementLinkTypes = this.requirementVersionLinkTypeDao.getAllRequirementVersionLinkTypes();
        for (RequirementLinkTypePivot requirementLinkTypePivot : requirementLinkTypePivots) {
            RequirementLinkComparison code1Similarities = this.checkLinkSimilarities(requirementLinkTypePivot.getRole1(), existingRequirementLinkTypes, RequirementVersionLinkType::getRole1);
            RequirementLinkComparison code2Similarities = this.checkLinkSimilarities(requirementLinkTypePivot.getRole1(), existingRequirementLinkTypes, RequirementVersionLinkType::getRole1);
            if (code1Similarities.isSame() && code2Similarities.isSame()) {
                PivotFormatLoggerHelper.logEntitiesAlreadyExistsInSquash(LOGGER, "requirement link", requirementLinkTypePivot.getPivotId(), requirementLinkTypePivot.getLabel(), pivotFormatImport);
                pivotImportMetadata.getRequirementLinkTypeIdsMap().put(requirementLinkTypePivot.getPivotId(), code1Similarities.requirementVersionLinkType().getId());
                continue;
            }
            this.createRequirementLink(requirementLinkTypePivot, code1Similarities, code2Similarities, pivotFormatImport, pivotImportMetadata);
        }
        requirementLinkTypePivots.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void createRequirementLink(RequirementLinkTypePivot requirementLinkTypePivot, RequirementLinkComparison code1Similarities, RequirementLinkComparison code2Similarities, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        PivotFormatLoggerHelper.logEntityCreationStarted(LOGGER, "requirement link", requirementLinkTypePivot.getPivotId(), pivotFormatImport);
        try {
            RequirementVersionLinkType requirementVersionLinkType = this.adminPivotConverterService.pivotToRequirementVersionLinkType(requirementLinkTypePivot);
            if (code1Similarities.isSame()) {
                String code = LibraryUtils.generateNonClashingName(requirementVersionLinkType.getRole1Code(), code1Similarities.codeSimilarities(), 30);
                requirementVersionLinkType.setRole1(code);
            } else if (code2Similarities.isSame()) {
                String code = LibraryUtils.generateNonClashingName(requirementVersionLinkType.getRole2Code(), code2Similarities.codeSimilarities(), 30);
                requirementVersionLinkType.setRole2(code);
            }
            this.entityManager.persist((Object)requirementVersionLinkType);
            pivotImportMetadata.getRequirementLinkTypeIdsMap().put(requirementLinkTypePivot.getPivotId(), requirementVersionLinkType.getId());
            PivotFormatLoggerHelper.logEntityCreatedSuccessfully(LOGGER, "requirement link", requirementLinkTypePivot.getLabel(), requirementLinkTypePivot.getPivotId(), pivotFormatImport);
        }
        catch (Exception e) {
            PivotFormatLoggerHelper.handleEntityCreationFailed(LOGGER, "requirement link", requirementLinkTypePivot.getLabel(), requirementLinkTypePivot.getPivotId(), pivotFormatImport, e);
        }
    }

    private RequirementLinkComparison checkLinkSimilarities(String code, List<RequirementVersionLinkType> existingLinks, Function<RequirementVersionLinkType, String> getLinkCode) {
        ArrayList<RequirementVersionLinkType> matchedLinks = new ArrayList<RequirementVersionLinkType>();
        HashSet<String> codeSimilarities = new HashSet<String>();
        existingLinks.forEach(link -> {
            String linkCode = (String)getLinkCode.apply((RequirementVersionLinkType)link);
            if (code.equals(linkCode)) {
                matchedLinks.add((RequirementVersionLinkType)link);
                codeSimilarities.add(linkCode);
            } else if (linkCode.startsWith(code)) {
                codeSimilarities.add(linkCode);
            }
        });
        return new RequirementLinkComparison(!matchedLinks.isEmpty(), this.getUniqueRequirementVersionLinkType(matchedLinks, code), codeSimilarities);
    }

    private RequirementVersionLinkType getUniqueRequirementVersionLinkType(List<RequirementVersionLinkType> matchedLinks, String code) {
        return switch (matchedLinks.size()) {
            case 0 -> null;
            case 1 -> matchedLinks.getFirst();
            default -> {
                LOGGER.warn("Multiple requirement version link types found with the same code '%s'. Using the first one.".formatted(code), new Object[0]);
                yield matchedLinks.getFirst();
            }
        };
    }

    private record RequirementLinkComparison(boolean isSame, RequirementVersionLinkType requirementVersionLinkType, Set<String> codeSimilarities) {
    }
}

