/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.InfoListProjectBindingType;
import org.squashtest.tm.domain.infolist.SystemInfoListCode;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.service.infolist.InfoListManagerService;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.InfoListPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.ProjectPivot;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotMetaDataModel;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.AbstractPivotImport;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotFormatLoggerHelper;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotImportStrategy;
import org.squashtest.tm.service.internal.repository.InfoListDao;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.InfoListPivotImporterService;

@Service
public class InfoListPivotImporterServiceImpl
extends AbstractPivotImport
implements InfoListPivotImporterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoListPivotImporterService.class);
    private final InfoListDao infoListDao;
    private final AdminPivotConverterService adminPivotConverterService;
    private final InfoListManagerService infoListManagerService;
    @PersistenceContext
    private EntityManager entityManager;

    public InfoListPivotImporterServiceImpl(InfoListDao infoListDao, AdminPivotConverterService adminPivotConverterService, InfoListManagerService infoListManagerService) {
        super(LOGGER);
        this.infoListDao = infoListDao;
        this.adminPivotConverterService = adminPivotConverterService;
        this.infoListManagerService = infoListManagerService;
    }

    @Override
    public <I extends InputStream> List<InfoListPivot> getInfoListPivotListFromZis(I zis) throws IOException {
        ArrayList<InfoListPivot> infoListPivotList = new ArrayList<InfoListPivot>();
        this.parseEntities(zis, JsonImportFile.INFO_LISTS, JsonImportFile.INFO_LISTS.getJsonFieldKind(), InfoListPivot.class, infoListPivotList::add);
        return infoListPivotList;
    }

    @Override
    public void validateInfoList(List<InfoListPivot> infoListPivotList, ProjectPivot projectPivot, Long projectId, PivotMetaDataModel pivotMetaDataModel) {
        Map<InfoListProjectBindingType, String> importedInfoListCodeByBindingType = this.getImportedInfoListCodeByBindingType(infoListPivotList, projectPivot);
        Map infoListCodeByType = this.infoListDao.findAllUsedInfoListCodeByProjectId(projectId);
        infoListCodeByType.forEach((bindingType, infoListInfo) -> {
            String importedCode = (String)importedInfoListCodeByBindingType.get(bindingType);
            if (!Objects.equals(importedCode, infoListInfo.code())) {
                pivotMetaDataModel.addPivotReportInfoList((InfoListProjectBindingType)bindingType, infoListInfo.label(), infoListInfo.code(), SystemInfoListCode.isSystem((String)infoListInfo.code()));
            }
        });
    }

    private Map<InfoListProjectBindingType, String> getImportedInfoListCodeByBindingType(List<InfoListPivot> infoListPivotList, ProjectPivot projectPivot) {
        Map<String, String> infoListCodeByPivotId = infoListPivotList.stream().collect(Collectors.toMap(AbstractPivotObject::getPivotId, InfoListPivot::getCode));
        Map<InfoListProjectBindingType, String> infoListCodesByBindingType = projectPivot.getBoundInfoLists().entrySet().stream().filter(entry -> infoListCodeByPivotId.containsKey(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, entry -> (String)infoListCodeByPivotId.get(entry.getValue())));
        this.provideSystemInfoList(infoListCodesByBindingType, InfoListProjectBindingType.REQUIREMENT_CATEGORY);
        this.provideSystemInfoList(infoListCodesByBindingType, InfoListProjectBindingType.TEST_CASE_NATURE);
        this.provideSystemInfoList(infoListCodesByBindingType, InfoListProjectBindingType.TEST_CASE_TYPE);
        return infoListCodesByBindingType;
    }

    private void provideSystemInfoList(Map<InfoListProjectBindingType, String> infoListCodesByBindingType, InfoListProjectBindingType bindingType) {
        infoListCodesByBindingType.computeIfAbsent(bindingType, k -> bindingType.getSystemInfoListCode().getCode());
    }

    @Override
    public void importInfoListsFromZipArchive(ZipFile zipFile, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        PivotImportStrategy<InfoListPivot> infoListPivotStrategy = this.getInfoListPivotImporterStrategy(pivotImportMetadata, pivotFormatImport);
        this.importEntitiesFromZipArchive(zipFile, JsonImportFile.INFO_LISTS, pivotFormatImport, pivotImportMetadata, "info lists", "info list", infoListPivotStrategy);
    }

    private PivotImportStrategy<InfoListPivot> getInfoListPivotImporterStrategy(final PivotImportMetadata pivotImportMetadata, final PivotFormatImport pivotFormatImport) {
        return new PivotImportStrategy<InfoListPivot>(){

            @Override
            public Class<InfoListPivot> getPivotClazz() {
                return InfoListPivot.class;
            }

            @Override
            public void create(List<InfoListPivot> entities) {
                InfoListPivotImporterServiceImpl.this.createInfoLists(entities, pivotFormatImport, pivotImportMetadata);
            }
        };
    }

    private void createInfoLists(List<InfoListPivot> infoListPivotList, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        List<String> codes = infoListPivotList.stream().map(InfoListPivot::getCode).toList();
        List<InfoList> infoLists = this.infoListDao.findByCodes(codes);
        for (InfoListPivot infoListPivot : infoListPivotList) {
            InfoList existingInfoList = infoLists.stream().filter(infoList -> infoList.getCode().equals(infoListPivot.getCode())).findFirst().orElse(null);
            if (Objects.nonNull(existingInfoList)) {
                PivotFormatLoggerHelper.logEntitiesAlreadyExistsInSquash(LOGGER, "info list", infoListPivot.getPivotId(), infoListPivot.getLabel(), pivotFormatImport);
                pivotImportMetadata.getInfoListIdsMap().put(infoListPivot.getPivotId(), existingInfoList.getId());
                continue;
            }
            this.createInfoList(infoListPivot, pivotFormatImport, pivotImportMetadata);
        }
        infoListPivotList.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void createInfoList(InfoListPivot infoListPivot, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        PivotFormatLoggerHelper.logEntityCreationStarted(LOGGER, "info list", infoListPivot.getPivotId(), pivotFormatImport);
        try {
            InfoList infoList = this.adminPivotConverterService.pivotToInfoList(infoListPivot);
            this.infoListManagerService.persistUnsecured(infoList);
            infoList.setReadOnlyModifyAudit(infoListPivot.getLastModifiedBy(), infoListPivot.getLastModifiedOn());
            pivotImportMetadata.getInfoListIdsMap().put(infoListPivot.getPivotId(), infoList.getId());
            PivotFormatLoggerHelper.logEntityCreatedSuccessfully(LOGGER, "info list", infoListPivot.getLabel(), infoListPivot.getPivotId(), pivotFormatImport);
        }
        catch (Exception e) {
            PivotFormatLoggerHelper.handleEntityCreationFailed(LOGGER, "info list", infoListPivot.getLabel(), infoListPivot.getPivotId(), pivotFormatImport, e);
        }
    }
}

