/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FilenameUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.web.multipart.MultipartFile;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.domain.projectimporter.PivotFormatImportStatus;
import org.squashtest.tm.domain.projectimporter.PivotFormatImportType;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.exception.pivot.projectimporter.pivotimporter.NoDataImportedException;
import org.squashtest.tm.exception.projectimport.CannotDeleteImportStatusRunningException;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.service.internal.dto.pivotdefinition.InfoListPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.ProjectPivot;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportEntities;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotMetaDataModel;
import org.squashtest.tm.service.internal.dto.projectimporter.ProjectIdsReferences;
import org.squashtest.tm.service.internal.repository.PivotFormatImportDao;
import org.squashtest.tm.service.internal.repository.hibernate.CustomPivotFormatImportDao;
import org.squashtest.tm.service.internal.repository.hibernate.utils.HibernateConfig;
import org.squashtest.tm.service.pivot.PivotFileManager;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.CustomFieldPivotImporterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.CustomPivotImporterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.ExecutionWorkspacePivotImporterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.FolderPivotImporterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.GlobalProjectPivotImporterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.InfoListPivotImporterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.MilestoneImporterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.ProjectPivotImporterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.RequirementLinkImporterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.RequirementPivotImporterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.TestCasePivotImporterService;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.user.UserAccountService;

@Service
public class GlobalProjectPivotImporterServiceImpl
implements GlobalProjectPivotImporterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalProjectPivotImporterServiceImpl.class);
    private final PivotFileManager pivotFileManager;
    private final PivotFormatImportDao pivotFormatImportDao;
    private final CustomPivotFormatImportDao customPivotFormatImportDao;
    private final GenericProjectManagerService genericProjectManager;
    private final UserAccountService userAccountService;
    private final CustomFieldPivotImporterService customFieldImporterService;
    private final InfoListPivotImporterService infoListImporterService;
    private final FolderPivotImporterService folderImporterService;
    private final RequirementPivotImporterService requirementImporterService;
    private final TestCasePivotImporterService testCaseImporterService;
    private final ExecutionWorkspacePivotImporterService executionWorkspacePivotImporterService;
    private final PlatformTransactionManager transactionManager;
    private final PermissionEvaluationService permissionEvaluationService;
    private final ConfigurationService configurationService;
    private final CustomPivotImporterService customPivotImporterService;
    private final AttachmentManagerService attachmentManagerService;
    private final ProjectPivotImporterService projectPivotImporterService;
    private final MilestoneImporterService milestoneImporterService;
    private final RequirementLinkImporterService requirementLinkImporterService;
    private final ConcurrentMap<Long, PivotImportEntities> concurrentPivotEntities = new ConcurrentHashMap<Long, PivotImportEntities>();
    @PersistenceContext
    private EntityManager entityManager;

    public GlobalProjectPivotImporterServiceImpl(PivotFileManager pivotFileManager, PivotFormatImportDao pivotFormatImportDao, CustomPivotFormatImportDao customPivotFormatImportDao, GenericProjectManagerService genericProjectManager, UserAccountService userAccountService, CustomFieldPivotImporterService customFieldImporterService, InfoListPivotImporterService infoListImporterService, FolderPivotImporterService folderImporterService, RequirementPivotImporterService requirementImporterService, TestCasePivotImporterService testCaseImporterService, ExecutionWorkspacePivotImporterService executionWorkspacePivotImporterService, PlatformTransactionManager transactionManager, PermissionEvaluationService permissionEvaluationService, ConfigurationService configurationService, CustomPivotImporterService customPivotImporterService, AttachmentManagerService attachmentManagerService, ProjectPivotImporterService projectPivotImporterService, MilestoneImporterService milestoneImporterService, RequirementLinkImporterService requirementLinkImporterService) {
        this.pivotFileManager = pivotFileManager;
        this.pivotFormatImportDao = pivotFormatImportDao;
        this.customPivotFormatImportDao = customPivotFormatImportDao;
        this.genericProjectManager = genericProjectManager;
        this.userAccountService = userAccountService;
        this.customFieldImporterService = customFieldImporterService;
        this.infoListImporterService = infoListImporterService;
        this.folderImporterService = folderImporterService;
        this.requirementImporterService = requirementImporterService;
        this.testCaseImporterService = testCaseImporterService;
        this.executionWorkspacePivotImporterService = executionWorkspacePivotImporterService;
        this.transactionManager = transactionManager;
        this.permissionEvaluationService = permissionEvaluationService;
        this.configurationService = configurationService;
        this.customPivotImporterService = customPivotImporterService;
        this.attachmentManagerService = attachmentManagerService;
        this.projectPivotImporterService = projectPivotImporterService;
        this.milestoneImporterService = milestoneImporterService;
        this.requirementLinkImporterService = requirementLinkImporterService;
    }

    @Override
    public void validateImportFilePreconditions(long projectId, MultipartFile multipartFile, PivotMetaDataModel pivotMetaDataModel) {
        AtomicReference projectPivot = new AtomicReference();
        ArrayList<InfoListPivot> infoListPivotList = new ArrayList<InfoListPivot>();
        Set<ExecutionStatus> disabledExecutionStatuses = this.getDisabledExecutionStatus(projectId, pivotMetaDataModel);
        List<String> attachmentTypeWhiteList = this.getAttachmentTypeWhiteList();
        Long maxAttachmentSize = this.getMaxAttachmentSize();
        ArrayList pivotImportEntities = new ArrayList(this.concurrentPivotEntities.values());
        this.pivotFileManager.readPivotFile(multipartFile, (zis, entry) -> {
            if (!entry.getName().endsWith(".json")) {
                this.checkAttachment((ZipEntry)entry, (ZipInputStream)zis, attachmentTypeWhiteList, maxAttachmentSize, pivotMetaDataModel);
                return;
            }
            JsonImportFile jsonImportFile = JsonImportFile.fromFileName(entry.getName());
            switch (jsonImportFile) {
                case INFO_LISTS: {
                    infoListPivotList.addAll(this.infoListImporterService.getInfoListPivotListFromZis(zis));
                    break;
                }
                case EXECUTIONS: {
                    this.executionWorkspacePivotImporterService.validateExecutionStatusFromExecution(zis, disabledExecutionStatuses, pivotMetaDataModel);
                    break;
                }
                case ITERATIONS: {
                    this.executionWorkspacePivotImporterService.validateExecutionStatusFromIteration(zis, disabledExecutionStatuses, pivotMetaDataModel);
                    break;
                }
                case TEST_SUITES: {
                    this.executionWorkspacePivotImporterService.validateExecutionStatusFromTestSuite(zis, disabledExecutionStatuses, pivotMetaDataModel);
                    break;
                }
                case SPRINTS: {
                    this.executionWorkspacePivotImporterService.validateExecutionStatusFromSprint(zis, disabledExecutionStatuses, pivotMetaDataModel);
                    break;
                }
                case PROJECTS: {
                    projectPivot.set(this.projectPivotImporterService.getProjectPivotFromZis(zis));
                    break;
                }
                case MILESTONES: {
                    this.milestoneImporterService.validateMilestone(zis, pivotMetaDataModel, pivotImportEntities);
                    break;
                }
            }
        });
        this.infoListImporterService.validateInfoList(infoListPivotList, (ProjectPivot)projectPivot.get(), projectId, pivotMetaDataModel);
    }

    private Set<ExecutionStatus> getDisabledExecutionStatus(Long projectId, PivotMetaDataModel pivotMetaDataModel) {
        Set<ExecutionStatus> disabledExecutionStatuses = this.genericProjectManager.disabledExecutionStatuses(projectId);
        HashSet<ExecutionStatus> availableStatuses = new HashSet<ExecutionStatus>(Arrays.asList(ExecutionStatus.values()));
        availableStatuses.removeAll(disabledExecutionStatuses);
        availableStatuses.removeAll(ExecutionStatus.TA_STATUSES_ONLY);
        pivotMetaDataModel.addAllAvailableExecutionStatus(availableStatuses);
        return disabledExecutionStatuses;
    }

    private void checkAttachment(ZipEntry zipEntry, ZipInputStream zipInputStream, List<String> attachmentTypeWhiteList, Long maxAttachmentSize, PivotMetaDataModel pivotMetaDataModel) {
        Long attachmentSize;
        if (zipEntry.isDirectory() || !zipEntry.getName().contains("attachment")) {
            return;
        }
        pivotMetaDataModel.incrementAttachmentCount();
        String attachmentType = FilenameUtils.getExtension((String)zipEntry.getName());
        if (!attachmentTypeWhiteList.contains(attachmentType)) {
            pivotMetaDataModel.addUnauthorizedAttachmentType(attachmentType);
            pivotMetaDataModel.incrementUnauthorizedAttachmentTypesCount();
        }
        if ((attachmentSize = this.getAttachmentSize(zipEntry, zipInputStream)) > maxAttachmentSize) {
            pivotMetaDataModel.setAttachmentMaxSize(attachmentSize);
            pivotMetaDataModel.incrementAttachmentMaxSizeCount();
        }
    }

    private Long getAttachmentSize(ZipEntry zipEntry, ZipInputStream zis) {
        long attachmentSize = zipEntry.getSize();
        if (attachmentSize < 0L) {
            try {
                attachmentSize = zis.readAllBytes().length;
            }
            catch (IOException e) {
                LOGGER.error("Failed to get available size for attachment: {}", new Object[]{zipEntry.getName(), e});
            }
        }
        return attachmentSize;
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'IMPORT')  or hasRole('ROLE_ADMIN')")
    @Transactional
    public void createImportRequest(long projectId, MultipartFile multipartFile, String importName, PivotFormatImportType importType, PivotMetaDataModel pivotMetaDataModel) {
        User currentUser = this.userAccountService.findCurrentUser();
        PivotImportEntities pivotImportEntities = this.checkJsonFile(multipartFile);
        this.saveBaseServerUrl(pivotMetaDataModel);
        this.saveLocale(pivotMetaDataModel);
        this.saveCurrentUser(currentUser, pivotMetaDataModel);
        File importFile = this.pivotFileManager.createPivotImportFile(importType, multipartFile, pivotMetaDataModel);
        Long importId = this.savePivotImportRequest(projectId, importName, currentUser, importType, importFile);
        this.concurrentPivotEntities.put(importId, pivotImportEntities);
    }

    private PivotImportEntities checkJsonFile(MultipartFile multipartFile) {
        PivotImportEntities entities = new PivotImportEntities();
        this.pivotFileManager.readPivotFile(multipartFile, (zis, entry) -> {
            if (!entry.getName().endsWith(".json")) {
                return;
            }
            JsonImportFile jsonImportFile = JsonImportFile.fromFileName(entry.getName());
            if (JsonImportFile.MILESTONES.equals((Object)jsonImportFile)) {
                entities.addMilestonePivotInformation(this.milestoneImporterService.getMilestonePivots(zis));
            } else {
                this.pivotFileManager.checkJsonSyntaxError((ZipEntry)entry, (ZipInputStream)zis);
            }
        });
        return entities;
    }

    private void saveBaseServerUrl(PivotMetaDataModel pivotMetaDataModel) {
        pivotMetaDataModel.setBaseUrl(this.attachmentManagerService.getBaseFileUploadUrl());
    }

    private void saveLocale(PivotMetaDataModel pivotMetaDataModel) {
        Locale locale = LocaleContextHolder.getLocale();
        pivotMetaDataModel.setLocale(locale);
    }

    private void saveCurrentUser(User currentUser, PivotMetaDataModel pivotMetaDataModel) {
        pivotMetaDataModel.setAdmin(this.permissionEvaluationService.hasRole("ROLE_ADMIN"));
        pivotMetaDataModel.setCurrentUserid(currentUser.getId());
    }

    private Long savePivotImportRequest(long projectId, String importName, User currentUser, PivotFormatImportType importType, File importFile) {
        GenericProject project = this.genericProjectManager.findById(projectId);
        PivotFormatImport pivotFormatImport = new PivotFormatImport();
        pivotFormatImport.setName(importName);
        pivotFormatImport.setCreatedBy(currentUser);
        pivotFormatImport.setCreatedOn(new Date());
        pivotFormatImport.setType(importType);
        pivotFormatImport.setFilePath(importFile.getPath());
        pivotFormatImport.setProject((Project)project);
        return ((PivotFormatImport)this.pivotFormatImportDao.save(pivotFormatImport)).getId();
    }

    @Override
    public void removeOrphanPivotEntities(Long maxImportId) {
        this.concurrentPivotEntities.keySet().stream().filter(id -> id <= maxImportId).forEach(this.concurrentPivotEntities::remove);
    }

    @Override
    @Transactional
    public void deleteImportRequests(long projectId, List<Long> idImportRequests) {
        this.checkCanImportPermission(projectId);
        if (idImportRequests.isEmpty()) {
            return;
        }
        List pivotFormatImports = this.pivotFormatImportDao.findAllById(idImportRequests);
        for (PivotFormatImport pivotFormatImport : pivotFormatImports) {
            if (pivotFormatImport.getStatus() == PivotFormatImportStatus.RUNNING) {
                throw new CannotDeleteImportStatusRunningException(String.format("Cannot delete the import \"%s\" #%s because it is running", pivotFormatImport.getName(), pivotFormatImport.getId()), pivotFormatImport.getName());
            }
            this.pivotFormatImportDao.delete(pivotFormatImport);
            this.pivotFileManager.deleteImportFiles(pivotFormatImport);
            this.concurrentPivotEntities.remove(pivotFormatImport.getId());
        }
    }

    @Override
    public void importProject(PivotFormatImport pivotFormatImport) {
        Project existingProject = pivotFormatImport.getProject();
        this.checkCanImportPermission(existingProject.getId());
        PivotFormatImportStatus finalStatus = PivotFormatImportStatus.FAILURE;
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setPropagationBehavior(3);
        TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
        try {
            try {
                this.logImportStarted(pivotFormatImport);
                ProjectIdsReferences projectIdsReferences = new ProjectIdsReferences((GenericProject)existingProject);
                File importFile = new File(pivotFormatImport.getFilePath());
                Throwable throwable = null;
                Object var9_11 = null;
                try (ZipFile zipFile = new ZipFile(importFile);){
                    finalStatus = this.importEntitiesInProject(zipFile, projectIdsReferences, pivotFormatImport);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                this.transactionManager.commit(transaction);
            }
            catch (Exception e) {
                this.handleError(pivotFormatImport, transaction, e);
                this.saveFinalImportStatus(pivotFormatImport.getId(), finalStatus);
                this.concurrentPivotEntities.remove(pivotFormatImport.getId());
            }
        }
        finally {
            this.saveFinalImportStatus(pivotFormatImport.getId(), finalStatus);
            this.concurrentPivotEntities.remove(pivotFormatImport.getId());
        }
    }

    private void saveFinalImportStatus(Long importId, PivotFormatImportStatus finalStatus) {
        this.doInTransaction(() -> {
            LOGGER.info("GlobalProjectPivotImporterService - The import with id: {} has ended with status: {}", new Object[]{importId, finalStatus});
            this.customPivotFormatImportDao.updatePivotFormatImportStatus(importId, finalStatus);
            if (PivotFormatImportStatus.SUCCESS.equals((Object)finalStatus) || PivotFormatImportStatus.WARNING.equals((Object)finalStatus)) {
                this.customPivotFormatImportDao.updatePivotFormatImportSuccessfullyImportedOn(importId, new Date());
            }
        });
    }

    private void logImportStarted(PivotFormatImport pivotFormatImport) {
        this.doInTransaction(() -> {
            LOGGER.info("GlobalProjectPivotImporterService - Starting new import with id: {} for project: {}. Project id: {}", new Object[]{pivotFormatImport.getId(), pivotFormatImport.getProject().getName(), pivotFormatImport.getProject().getId()});
            this.customPivotFormatImportDao.updatePivotFormatImportStatus(pivotFormatImport.getId(), PivotFormatImportStatus.RUNNING);
        });
    }

    private void handleError(PivotFormatImport pivotFormatImport, TransactionStatus transaction, Throwable e) {
        this.transactionManager.rollback(transaction);
        String message = String.format(" Import id: %s - Failed to import data in existing project \"%s\" with id %s.", pivotFormatImport.getId(), pivotFormatImport.getProject().getName(), pivotFormatImport.getProject().getId());
        this.pivotFileManager.createErrorLogFile(pivotFormatImport, e);
        LOGGER.error(message, e);
    }

    @Override
    public String getImportLogFilePath(Long importId, PivotFormatImportType importType, boolean hasWarningStatus) {
        if (hasWarningStatus) {
            return this.pivotFileManager.getImportWarningLogFilePath(importId, importType);
        }
        return this.pivotFileManager.getImportErrorLogFilePath(importId, importType);
    }

    private PivotFormatImportStatus importEntitiesInProject(ZipFile zipFile, ProjectIdsReferences projectIdsReferences, PivotFormatImport pivotFormatImport) throws IOException {
        boolean importHasWarnings;
        HibernateConfig.enableBatch(this.entityManager, 50);
        PivotImportMetadata pivotImportMetadata = new PivotImportMetadata();
        pivotImportMetadata.setPivotMetaDataModel(this.customPivotImporterService.getPivotMetadataFromPivot(zipFile));
        pivotImportMetadata.setAttachmentTypeWhiteList(this.getAttachmentTypeWhiteList());
        pivotImportMetadata.setMaxAttachmentSize(this.getMaxAttachmentSize());
        this.customFieldImporterService.importCustomFieldsFromZipArchive(zipFile, pivotImportMetadata, pivotFormatImport);
        if (pivotImportMetadata.getPivotOptions().isImportInfoList()) {
            this.infoListImporterService.importInfoListsFromZipArchive(zipFile, pivotImportMetadata, pivotFormatImport);
        }
        this.milestoneImporterService.importMilestonesFromZipArchive(zipFile, pivotImportMetadata, pivotFormatImport);
        this.requirementLinkImporterService.importRequirementLinksFromZipArchive(zipFile, pivotImportMetadata, pivotFormatImport);
        this.projectPivotImporterService.importProjectInformationFromZipArchive(zipFile, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        this.folderImporterService.importFoldersByJsonFileName(zipFile, JsonImportFile.REQUIREMENT_FOLDERS, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        this.requirementImporterService.importRequirementsFromZipArchive(zipFile, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        this.folderImporterService.importFoldersByJsonFileName(zipFile, JsonImportFile.TEST_CASE_FOLDERS, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        this.testCaseImporterService.importTestCasesFromZipArchive(zipFile, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        this.testCaseImporterService.importCalledTestCasesFromZipArchive(zipFile, pivotImportMetadata, pivotFormatImport);
        this.folderImporterService.importFoldersByJsonFileName(zipFile, JsonImportFile.CAMPAIGN_FOLDERS_AND_SPRINT_GROUPS, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        this.executionWorkspacePivotImporterService.importCampaignsFromZipArchive(zipFile, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        this.executionWorkspacePivotImporterService.importIterationsFromZipArchive(zipFile, pivotImportMetadata, pivotFormatImport);
        this.executionWorkspacePivotImporterService.importTestSuitesFromZipArchive(zipFile, pivotImportMetadata, pivotFormatImport);
        this.executionWorkspacePivotImporterService.importSprintsFromZipArchive(zipFile, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        this.executionWorkspacePivotImporterService.importExecutionsFromZipArchive(zipFile, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        zipFile.close();
        this.checkIfImportHasImportedAtLeastOneEntity(pivotFormatImport, pivotImportMetadata);
        boolean bl = importHasWarnings = !pivotImportMetadata.getImportWarningEntries().isEmpty();
        if (importHasWarnings) {
            this.pivotFileManager.createWarningLogFile(pivotImportMetadata.getImportWarningEntries(), pivotFormatImport);
        }
        return importHasWarnings ? PivotFormatImportStatus.WARNING : PivotFormatImportStatus.SUCCESS;
    }

    private List<String> getAttachmentTypeWhiteList() {
        String whiteListStr = this.configurationService.findConfiguration("uploadfilter.fileExtensions.whitelist");
        return Arrays.stream(whiteListStr.split(",")).map(String::trim).toList();
    }

    private Long getMaxAttachmentSize() {
        String maxAttachmentSizeLimitStr = this.configurationService.findConfiguration("uploadfilter.upload.sizeLimitInBytes");
        return Long.valueOf(maxAttachmentSizeLimitStr);
    }

    private void checkIfImportHasImportedAtLeastOneEntity(PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        if (!pivotImportMetadata.isAtLeastOneEntity()) {
            String message = String.format("Import Id: %s - No data has been imported. Please check the import file and try again.", pivotFormatImport.getId());
            LOGGER.error(message, new Object[0]);
            throw new NoDataImportedException(message);
        }
    }

    private void doInTransaction(Runnable runnable) {
        TransactionStatus transaction = null;
        try {
            DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
            transactionDefinition.setPropagationBehavior(3);
            transaction = this.transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
            runnable.run();
            this.entityManager.flush();
            this.entityManager.clear();
            this.transactionManager.commit(transaction);
        }
        catch (Exception ex) {
            if (transaction != null) {
                this.transactionManager.rollback(transaction);
            }
            throw ex;
        }
    }

    private void checkCanImportPermission(long projectId) {
        this.permissionEvaluationService.checkPermission(Collections.singletonList(projectId), Permissions.IMPORT.name(), Project.class.getName());
    }
}

