/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.library;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.plugin.PluginType;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.service.internal.library.PathService;

@Service
@Transactional(readOnly=true)
public class HibernatePathService
implements PathService {
    public static final String PATH_SEPARATOR = "\u001f";
    @PersistenceContext
    private EntityManager em;

    @Override
    public String buildTestCasePath(long id) {
        return this.buildPath("TestCasePathEdge.findPathById", id);
    }

    @Override
    public List<String> buildTestCasesPaths(List<Long> ids) {
        return this.buildAllPaths("TestCasePathEdge.findPathsByIds", ids);
    }

    @Override
    public String buildTestCaseFoldersPath(long id) {
        return this.buildPath("TestCasePathEdge.findFoldersPathById", id);
    }

    @Override
    @UsedInPlugin(types={PluginType.API})
    public String buildRequirementPath(long id) {
        return this.buildPath("RequirementPathEdge.findPathById", id);
    }

    @Override
    public List<String> buildRequirementsPaths(List<Long> ids) {
        return this.buildAllPaths("RequirementPathEdge.findPathsByIds", ids);
    }

    @Override
    @UsedInPlugin(types={PluginType.API})
    public String buildCampaignPath(long id) {
        return this.buildPath("CampaignPathEdge.findPathById", id);
    }

    public static String escapePath(String fetchedPath) {
        return fetchedPath != null ? fetchedPath.replace("/", "\\/").replace(PATH_SEPARATOR, "/") : null;
    }

    public static String substituteSpecialPathSeparator(String path) {
        return path != null ? path.replace(PATH_SEPARATOR, "/") : null;
    }

    private String buildPath(String queryname, long id) {
        List<String> paths = this.findPathById(queryname, id);
        if (paths.isEmpty()) {
            return null;
        }
        return HibernatePathService.escapePath(paths.get(0));
    }

    private List<String> buildAllPaths(String queryname, List<Long> ids) {
        if (ids.isEmpty()) {
            return new ArrayList<String>();
        }
        List<Object[]> paths = this.findPathsByIds(queryname, ids);
        String[] res = new String[ids.size()];
        for (Object[] path : paths) {
            int pos = ids.indexOf(path[0]);
            res[pos] = HibernatePathService.escapePath((String)path[1]);
        }
        return Arrays.asList(res);
    }

    private List<String> findPathById(String queryname, long id) {
        return this.em.createNamedQuery(queryname, String.class).setParameter("nodeId", (Object)id).getResultList();
    }

    private List<Object[]> findPathsByIds(String queryname, List<Long> ids) {
        return this.em.createNamedQuery(queryname, Object[].class).setParameter("nodeIds", ids).getResultList();
    }
}

