/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.library;

import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.library.Folder;
import org.squashtest.tm.domain.library.Library;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.service.internal.library.NodeManagementService;
import org.squashtest.tm.service.internal.repository.EntityDao;
import org.squashtest.tm.service.internal.repository.FolderDao;
import org.squashtest.tm.service.internal.repository.LibraryDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.SecurityCheckableObject;

@Transactional
public class GenericNodeManagementService<MANAGED extends LibraryNode, NODE extends LibraryNode, FOLDER extends Folder<NODE>>
implements NodeManagementService<MANAGED, NODE, FOLDER> {
    private final PermissionEvaluationService permissionService;
    private final EntityDao<MANAGED> nodeDao;
    private final FolderDao<FOLDER, NODE> folderDao;
    private final LibraryDao<? extends Library<NODE>, NODE> libraryDao;

    public GenericNodeManagementService(PermissionEvaluationService permissionService, EntityDao<MANAGED> nodeDao, FolderDao<FOLDER, NODE> folderDao, LibraryDao<? extends Library<NODE>, NODE> libraryDao) {
        this.permissionService = permissionService;
        this.nodeDao = nodeDao;
        this.folderDao = folderDao;
        this.libraryDao = libraryDao;
    }

    @Override
    @Transactional(readOnly=true)
    @PostAuthorize(value="hasPermission(returnObject, 'READ') or hasRole('ROLE_ADMIN')")
    public MANAGED findNode(long nodeId) {
        return (MANAGED)((LibraryNode)this.nodeDao.findById(nodeId));
    }

    @Override
    public void removeNode(long nodeId) {
        MANAGED node = this.checkDeletableNode(nodeId);
        if (node == null) {
            return;
        }
        this.nodeDao.remove(node);
    }

    private MANAGED checkDeletableNode(long nodeId) {
        LibraryNode node = (LibraryNode)this.nodeDao.findById(nodeId);
        this.permissionService.checkPermission(new SecurityCheckableObject(node, Permissions.DELETE.name()));
        return (MANAGED)node;
    }

    private MANAGED checkWritableNode(long nodeId) {
        LibraryNode node = (LibraryNode)this.nodeDao.findById(nodeId);
        this.permissionService.checkPermission(new SecurityCheckableObject(node, Permissions.WRITE.name()));
        return (MANAGED)node;
    }

    @Override
    public void renameNode(long nodeId, String newName) throws DuplicateNameException {
        MANAGED node = this.checkWritableNode(nodeId);
        this.renameNode(newName, node);
    }

    private void renameNode(String newName, MANAGED node) {
        String trimedNewName = newName.trim();
        if (this.notCurrentNameOfNode(trimedNewName, node)) {
            this.forcedRenameNode(node, trimedNewName);
        }
    }

    @Override
    public void updateNodeDescription(long nodeId, String newDescription) {
        MANAGED node = this.checkWritableNode(nodeId);
        node.setDescription(newDescription);
    }

    private void forcedRenameNode(MANAGED node, String trimedNewName) {
        FOLDER parentFolder;
        Library<NODE> library = this.libraryDao.findByRootContent(node);
        if (node.allowIdenticalName()) {
            node.setName(trimedNewName);
            return;
        }
        if (library != null ? !library.isContentNameAvailable(trimedNewName) : (parentFolder = this.folderDao.findByContent(node)) != null && !parentFolder.isContentNameAvailable(trimedNewName)) {
            throw new DuplicateNameException(node.getName(), trimedNewName);
        }
        node.setName(trimedNewName);
    }

    private boolean notCurrentNameOfNode(String newName, MANAGED node) {
        return !node.getName().equals(newName);
    }
}

