/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.infolist;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.infolist.InfoListModelService;
import org.squashtest.tm.service.internal.dto.json.JsonInfoList;
import org.squashtest.tm.service.internal.dto.json.JsonInfoListItem;
import org.squashtest.tm.service.internal.utils.StreamUtils;

@Service
@Transactional(readOnly=true)
public class InfoListModelServiceImpl
implements InfoListModelService {
    @Inject
    private DSLContext dsl;
    @Inject
    private MessageSource messageSource;

    @Override
    public Map<Long, JsonInfoList> findUsedInfoList(List<Long> projectIds) {
        Set<Long> usedInfoListIds = this.findUsedInfoListIds(projectIds);
        return this.findInfoListMap(usedInfoListIds);
    }

    @Override
    public Map<String, String> findSystemInfoListItemLabels() {
        return this.dsl.select((SelectField)Tables.INFO_LIST_ITEM.LABEL).from((TableLike)Tables.INFO_LIST_ITEM).where(Tables.INFO_LIST_ITEM.ITEM_TYPE.eq((Object)"SYS")).fetch((Field)Tables.INFO_LIST_ITEM.LABEL, String.class).stream().collect(Collectors.toMap(Function.identity(), this::getMessage));
    }

    protected Set<Long> findUsedInfoListIds(List<Long> readableProjectIds) {
        HashSet<Long> ids = new HashSet<Long>();
        this.dsl.select((SelectField)Tables.PROJECT.REQ_CATEGORIES_LIST, (SelectField)Tables.PROJECT.TC_NATURES_LIST, (SelectField)Tables.PROJECT.TC_TYPES_LIST).from((TableLike)Tables.PROJECT).where(Tables.PROJECT.PROJECT_ID.in(readableProjectIds)).fetch().forEach(r -> {
            ids.add((Long)r.get((Field)Tables.PROJECT.REQ_CATEGORIES_LIST));
            ids.add((Long)r.get((Field)Tables.PROJECT.TC_NATURES_LIST));
            ids.add((Long)r.get((Field)Tables.PROJECT.TC_TYPES_LIST));
        });
        return ids;
    }

    protected Map<Long, JsonInfoList> findInfoListMap(Set<Long> usedInfoListIds) {
        Result result = this.dsl.select((SelectField)Tables.INFO_LIST.INFO_LIST_ID, (SelectField)Tables.INFO_LIST.CODE, (SelectField)Tables.INFO_LIST.LABEL, (SelectField)Tables.INFO_LIST.DESCRIPTION, (SelectField)Tables.INFO_LIST_ITEM.ITEM_ID, (SelectField)Tables.INFO_LIST_ITEM.CODE, (SelectField)Tables.INFO_LIST_ITEM.LABEL, (SelectField)Tables.INFO_LIST_ITEM.ICON_NAME, (SelectField)Tables.INFO_LIST_ITEM.IS_DEFAULT, (SelectField)Tables.INFO_LIST_ITEM.ITEM_TYPE, (SelectField)Tables.INFO_LIST_ITEM.ITEM_INDEX).from((TableLike)Tables.INFO_LIST).innerJoin((TableLike)Tables.INFO_LIST_ITEM).on(Tables.INFO_LIST.INFO_LIST_ID.eq((Field)Tables.INFO_LIST_ITEM.LIST_ID)).where(Tables.INFO_LIST.INFO_LIST_ID.in(usedInfoListIds)).fetch();
        Function<Record, JsonInfoList> infolistTransformer = this.getInfoListTransformer();
        Function<Record, JsonInfoListItem> infoListItemTransformer = this.getInfoListItemTransformer();
        return StreamUtils.performJoinAggregateIntoMap(infolistTransformer, infoListItemTransformer, JsonInfoList::setItems, new ArrayList(result));
    }

    private Function<Record, JsonInfoListItem> getInfoListItemTransformer() {
        return r -> {
            JsonInfoListItem jsonInfoListItem = new JsonInfoListItem();
            jsonInfoListItem.setId((Long)r.get((Field)Tables.INFO_LIST_ITEM.ITEM_ID));
            jsonInfoListItem.setCode(HtmlUtils.htmlEscape((String)((String)r.get((Field)Tables.INFO_LIST_ITEM.CODE))));
            jsonInfoListItem.setLabel(HtmlUtils.htmlEscape((String)((String)r.get((Field)Tables.INFO_LIST_ITEM.LABEL))));
            jsonInfoListItem.setIconName((String)r.get((Field)Tables.INFO_LIST_ITEM.ICON_NAME));
            jsonInfoListItem.setDefault((Boolean)r.get((Field)Tables.INFO_LIST_ITEM.IS_DEFAULT));
            jsonInfoListItem.setSystem(((String)r.get((Field)Tables.INFO_LIST_ITEM.ITEM_TYPE)).equals("SYS"));
            jsonInfoListItem.setItemIndex((Integer)r.get((Field)Tables.INFO_LIST_ITEM.ITEM_INDEX));
            jsonInfoListItem.setDenormalized(false);
            jsonInfoListItem.setFriendlyLabel(HtmlUtils.htmlEscape((String)this.messageSource.getMessage((String)r.get((Field)Tables.INFO_LIST_ITEM.LABEL), null, (String)r.get((Field)Tables.INFO_LIST_ITEM.LABEL), LocaleContextHolder.getLocale())));
            jsonInfoListItem.setUri("todo");
            return jsonInfoListItem;
        };
    }

    private Function<Record, JsonInfoList> getInfoListTransformer() {
        return r -> {
            Long id = (Long)r.get((Field)Tables.INFO_LIST.INFO_LIST_ID);
            String code = HtmlUtils.htmlEscape((String)((String)StringUtils.defaultIfBlank((CharSequence)((String)r.get((Field)Tables.INFO_LIST.CODE)), (CharSequence)"")));
            String label = HtmlUtils.htmlEscape((String)((String)StringUtils.defaultIfBlank((CharSequence)((String)r.get((Field)Tables.INFO_LIST.LABEL)), (CharSequence)"")));
            String description = HtmlUtils.htmlEscape((String)((String)StringUtils.defaultIfBlank((CharSequence)((String)r.get((Field)Tables.INFO_LIST.DESCRIPTION)), (CharSequence)"")));
            return new JsonInfoList(id, "todo", code, label, description);
        };
    }

    private String getMessage(String key) {
        Locale locale = LocaleContextHolder.getLocale();
        return this.messageSource.getMessage(key, null, locale);
    }
}

