/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.environmentvariable;

import jakarta.persistence.EntityExistsException;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.environmentvariable.EVBindableEntity;
import org.squashtest.tm.domain.environmentvariable.EVInputType;
import org.squashtest.tm.domain.environmentvariable.EnvironmentVariable;
import org.squashtest.tm.domain.environmentvariable.EnvironmentVariableBinding;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.environmentvariable.EnvironmentVariableBindingService;
import org.squashtest.tm.service.environmentvariable.EnvironmentVariableBindingValueService;
import org.squashtest.tm.service.internal.display.dto.BoundEnvironmentVariableDto;
import org.squashtest.tm.service.internal.display.dto.EnvironmentVariableDto;
import org.squashtest.tm.service.internal.environmentvariable.EnvironmentVariableBindingServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.repository.CustomEnvironmentVariableBindingDao;
import org.squashtest.tm.service.internal.repository.EnvironmentVariableBindingDao;
import org.squashtest.tm.service.internal.repository.EnvironmentVariableDao;
import org.squashtest.tm.service.internal.repository.display.EnvironmentVariableDisplayDao;
import org.squashtest.tm.service.internal.repository.display.ProjectDisplayDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service(value="squashtest.tm.service.EnvironmentVariableBindingService")
@Transactional
public class EnvironmentVariableBindingServiceImpl
implements EnvironmentVariableBindingService {
    private final EnvironmentVariableDao environmentVariableDao;
    private final EnvironmentVariableBindingDao environmentVariableBindingDao;
    private final EnvironmentVariableBindingValueService bindingValueService;
    private final CustomEnvironmentVariableBindingDao customEnvironmentVariableBindingDao;
    private final EnvironmentVariableDisplayDao environmentVariableDisplayDao;
    private final ProjectDisplayDao projectDisplayDao;
    private final PermissionEvaluationService permissionEvaluationService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public EnvironmentVariableBindingServiceImpl(EnvironmentVariableDao environmentVariableDao, EnvironmentVariableBindingDao environmentVariableBindingDao, EnvironmentVariableBindingValueService bindingValueService, CustomEnvironmentVariableBindingDao customEnvironmentVariableBindingDao, EnvironmentVariableDisplayDao environmentVariableDisplayDao, ProjectDisplayDao projectDisplayDao, PermissionEvaluationService permissionEvaluationService) {
        this.environmentVariableDao = environmentVariableDao;
        this.environmentVariableBindingDao = environmentVariableBindingDao;
        this.bindingValueService = bindingValueService;
        this.customEnvironmentVariableBindingDao = customEnvironmentVariableBindingDao;
        this.environmentVariableDisplayDao = environmentVariableDisplayDao;
        this.projectDisplayDao = projectDisplayDao;
        this.permissionEvaluationService = permissionEvaluationService;
    }

    @Override
    public void createNewBindings(Long entityId, EVBindableEntity entityType, List<Long> environmentVariableIds) {
        this.permissionEvaluationService.checkAtLeastOneProjectManagementPermissionOrAdmin();
        List<Long> list = environmentVariableIds;
        EnvironmentVariableDao environmentVariableDao = this.environmentVariableDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)environmentVariableDao, list);
        Object[] objectArray = new Object[]{this, environmentVariableDao, list, joinPoint};
        EnvironmentVariableBindingServiceImpl$AjcClosure1 environmentVariableBindingServiceImpl$AjcClosure1 = new EnvironmentVariableBindingServiceImpl$AjcClosure1(objectArray);
        List environmentVariables = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(environmentVariableBindingServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
        for (EnvironmentVariable environmentVariable : environmentVariables) {
            this.createBinding(entityId, entityType, environmentVariable);
            if (!this.isTestAutomationServerEntityType(entityType)) continue;
            this.bindNewServerVariableToAllLinkedProjects(entityId, environmentVariable);
        }
    }

    private boolean isTestAutomationServerEntityType(EVBindableEntity entityType) {
        return EVBindableEntity.TEST_AUTOMATION_SERVER.equals((Object)entityType);
    }

    private void bindNewServerVariableToAllLinkedProjects(Long serverId, EnvironmentVariable environmentVariable) {
        List<Long> projectsId = this.customEnvironmentVariableBindingDao.findProjectsLinkedToServerWhereVariableIsNotBound(serverId, environmentVariable);
        projectsId.forEach(id -> this.createBinding((Long)id, EVBindableEntity.PROJECT, environmentVariable));
    }

    @Override
    public void unbind(Long entityId, EVBindableEntity entityType, List<Long> evIds) {
        this.permissionEvaluationService.checkAtLeastOneProjectManagementPermissionOrAdmin();
        List<Long> bindingIds = this.customEnvironmentVariableBindingDao.findAllBindingIdsByEvIdsAndEntityIdType(evIds, entityId, entityType);
        this.environmentVariableBindingDao.deleteAllById(bindingIds);
    }

    @Override
    public void unbindByEnvironmentVariableId(Long environmentVariableId) {
        List<EnvironmentVariableBinding> bindings = this.environmentVariableBindingDao.findAllByEnvironmentVariable_Id(environmentVariableId);
        this.deleteAllBindings(bindings);
    }

    @Override
    public void unbindAllByEntityIdAndType(Long entityId, EVBindableEntity entityType) {
        List<EnvironmentVariableBinding> bindings = this.environmentVariableBindingDao.findAllByEntityIdAndEntityType(entityId, entityType);
        this.deleteAllBindings(bindings);
    }

    @Override
    public List<BoundEnvironmentVariableDto> getBoundEnvironmentVariablesByEntity(Long entityId, EVBindableEntity entityType) {
        List<BoundEnvironmentVariableDto> boundEnvironmentVariableDtos = this.customEnvironmentVariableBindingDao.findAllBoundEnvironmentVariables(entityId, entityType);
        this.setOptionValues(boundEnvironmentVariableDtos);
        return boundEnvironmentVariableDtos;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public List<BoundEnvironmentVariableDto> getBoundEnvironmentVariablesByTestAutomationServerId(Long testAutomationServerId) {
        return this.getBoundEnvironmentVariablesByEntity(testAutomationServerId, EVBindableEntity.TEST_AUTOMATION_SERVER);
    }

    private void setOptionValues(List<BoundEnvironmentVariableDto> boundEnvironmentVariables) {
        boundEnvironmentVariables.forEach(boundEnvironmentVariableDto -> {
            if (boundEnvironmentVariableDto.getInputType().equals(EVInputType.DROPDOWN_LIST.name())) {
                boundEnvironmentVariableDto.setOptions(this.environmentVariableDisplayDao.getEnvironmentVariableOptionListByEvId(boundEnvironmentVariableDto.getId()));
            }
        });
    }

    @Override
    public void bindServerEnvironmentVariablesToProject(Long taServerId, Long projectId) {
        Map<EnvironmentVariable, String> serverBindingValueByVariableMap = this.getVariablesToBindToProject(taServerId, projectId);
        ArrayList bindingsToCreate = new ArrayList();
        serverBindingValueByVariableMap.forEach((environmentVariable, serverBindingValue) -> {
            boolean bl = bindingsToCreate.add(new EnvironmentVariableBinding(environmentVariable, projectId, EVBindableEntity.PROJECT, serverBindingValue));
        });
        this.environmentVariableBindingDao.saveAll(bindingsToCreate);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public List<BoundEnvironmentVariableDto> getBoundEnvironmentVariableFromProjectView(Long projectId) {
        List<BoundEnvironmentVariableDto> boundEnvironmentVariableDtos = this.getBoundEnvironmentVariablesByEntity(projectId, EVBindableEntity.PROJECT);
        this.setIsEnvironmentVariableBoundToServer(projectId, boundEnvironmentVariableDtos);
        return boundEnvironmentVariableDtos;
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    public List<BoundEnvironmentVariableDto> getBoundEnvironmentVariableFromProjectViewByIteration(Long projectId, Long iterationId) {
        List<BoundEnvironmentVariableDto> boundEnvironmentVariableDtos = this.getBoundEnvironmentVariablesByEntity(projectId, EVBindableEntity.PROJECT);
        this.setIsEnvironmentVariableBoundToServer(projectId, boundEnvironmentVariableDtos);
        return boundEnvironmentVariableDtos;
    }

    private void setIsEnvironmentVariableBoundToServer(Long projectId, List<BoundEnvironmentVariableDto> boundEnvironmentVariableDtos) {
        Long taServerId = this.projectDisplayDao.getTaServerIdByProjectId(projectId);
        if (Objects.nonNull(taServerId)) {
            List<BoundEnvironmentVariableDto> serverBoundVariableDtos = this.getBoundEnvironmentVariablesByEntity(taServerId, EVBindableEntity.TEST_AUTOMATION_SERVER);
            List<Long> serverBoundEvIds = serverBoundVariableDtos.stream().map(EnvironmentVariableDto::getId).toList();
            boundEnvironmentVariableDtos.forEach(environmentVariable -> {
                if (serverBoundEvIds.contains(environmentVariable.getId())) {
                    environmentVariable.setIsBoundToServer(true);
                }
            });
        }
    }

    private Map<EnvironmentVariable, String> getVariablesToBindToProject(Long taServerId, Long projectId) {
        HashMap<EnvironmentVariable, String> serverBindingValueByVariableMap = new HashMap<EnvironmentVariable, String>();
        List<EnvironmentVariableBinding> projectBindings = this.environmentVariableBindingDao.findAllByEntityIdAndEntityType(projectId, EVBindableEntity.PROJECT);
        List<EnvironmentVariableBinding> serverBindings = this.environmentVariableBindingDao.findAllByEntityIdAndEntityType(taServerId, EVBindableEntity.TEST_AUTOMATION_SERVER);
        this.filterOutVariablesBoundToProject(serverBindingValueByVariableMap, projectBindings, serverBindings);
        return serverBindingValueByVariableMap;
    }

    private void filterOutVariablesBoundToProject(Map<EnvironmentVariable, String> serverBindingValueByVariableMap, List<EnvironmentVariableBinding> projectBindings, List<EnvironmentVariableBinding> serverBindings) {
        List<EnvironmentVariable> variablesAlreadyBoundToProject = projectBindings.stream().map(EnvironmentVariableBinding::getEnvironmentVariable).toList();
        serverBindings.stream().filter(binding -> !variablesAlreadyBoundToProject.contains(binding.getEnvironmentVariable())).forEach(binding -> {
            String string = serverBindingValueByVariableMap.put(binding.getEnvironmentVariable(), binding.getValue());
        });
    }

    private void deleteAllBindings(List<EnvironmentVariableBinding> bindings) {
        List<Long> bindingIds = bindings.stream().map(EnvironmentVariableBinding::getId).toList();
        this.environmentVariableBindingDao.deleteAllById(bindingIds);
    }

    private void createBinding(Long entityId, EVBindableEntity entityType, EnvironmentVariable environmentVariable) {
        EnvironmentVariableBinding environmentVariableBinding = new EnvironmentVariableBinding(environmentVariable, entityId, entityType);
        this.checkIfBindingExist(entityId, entityType, environmentVariable.getId());
        if (EVBindableEntity.PROJECT.equals((Object)entityType)) {
            this.bindingValueService.setProjectValueFromExistingServerValue(environmentVariableBinding);
        }
        this.environmentVariableBindingDao.save(environmentVariableBinding);
    }

    private void checkIfBindingExist(Long serverId, EVBindableEntity entityType, Long environmentVariableId) {
        EnvironmentVariableBinding environmentVariableBinding = this.environmentVariableBindingDao.findByEntityIdTypeAndEvId(serverId, entityType, environmentVariableId);
        if (environmentVariableBinding != null) {
            throw new EntityExistsException("Binding already exists.");
        }
    }

    static {
        EnvironmentVariableBindingServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ List findAllByIdIn_aroundBody0(EnvironmentVariableBindingServiceImpl environmentVariableBindingServiceImpl, EnvironmentVariableDao environmentVariableDao, List list, JoinPoint joinPoint) {
        return environmentVariableDao.findAllByIdIn(list);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EnvironmentVariableBindingServiceImpl.java", EnvironmentVariableBindingServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "findAllByIdIn", "org.squashtest.tm.service.internal.repository.EnvironmentVariableDao", "java.util.List", "arg0", "", "java.util.List"), 86);
    }
}

