/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.campaign.CampaignTestPlanItem;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.exception.execution.ExecutionHasNoStepsException;
import org.squashtest.tm.exception.execution.ExecutionWasDeleted;
import org.squashtest.tm.service.annotation.BatchPreventConcurrent;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.Ids;
import org.squashtest.tm.service.annotation.PreventConcurrent;
import org.squashtest.tm.service.annotation.PreventConcurrents;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.campaign.CustomCampaignModificationService;
import org.squashtest.tm.service.campaign.CustomIterationModificationService;
import org.squashtest.tm.service.campaign.ExecutionCreationService;
import org.squashtest.tm.service.campaign.IterationStatisticsService;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.copier.CampaignWorkspaceStrategyCopierService;
import org.squashtest.tm.service.execution.ExecutionDeletionService;
import org.squashtest.tm.service.internal.campaign.IterationTestPlanManager;
import org.squashtest.tm.service.internal.campaign.coercers.TestSuiteToIterationCoercerForArray;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.repository.CampaignDao;
import org.squashtest.tm.service.internal.repository.ExecutionDao;
import org.squashtest.tm.service.internal.repository.IterationDao;
import org.squashtest.tm.service.internal.repository.TestSuiteDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.statistics.campaign.StatisticsBundle;

@Service(value="CustomIterationModificationService")
@Transactional
public class CustomIterationModificationServiceImpl
implements CustomIterationModificationService,
IterationTestPlanManager {
    private static final String ITERATION_ID = "iterationId";
    @Inject
    private CampaignDao campaignDao;
    @Inject
    private CustomCampaignModificationService campaignModificationService;
    @Inject
    private IterationDao iterationDao;
    @Inject
    private TestSuiteDao suiteDao;
    @Inject
    private ExecutionDao executionDao;
    @Inject
    private PrivateCustomFieldValueService customFieldValueService;
    @Inject
    private IterationStatisticsService statisticsService;
    @Inject
    private ExecutionDeletionService executionDeletionService;
    @Inject
    private AttachmentManagerService attachmentManagerService;
    @Inject
    private IterationTestPlanManagerService iterationTestPlanManagerService;
    @Inject
    protected PermissionEvaluationService permissionService;
    @Inject
    private CampaignWorkspaceStrategyCopierService campaignWorkspaceStrategyCopierService;
    @Inject
    private ExecutionCreationService executionCreationService;

    @Override
    @PreventConcurrent(entityType=CampaignLibraryNode.class)
    @PreAuthorize(value="hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign', 'CREATE')  or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=Campaign.class)
    public Iteration addIterationToCampaign(Iteration iteration, @Id long campaignId, boolean copyTestPlan, Map<Long, RawValue> customFieldValues) {
        return this.addIterationToCampaignUnsecured(iteration, campaignId, copyTestPlan, customFieldValues);
    }

    @Override
    public Iteration addIterationToCampaignUnsecured(Iteration iteration, @Id long campaignId, boolean copyTestPlan, Map<Long, RawValue> customFieldValues) {
        this.addIterationToCampaignUnsecured(iteration, campaignId, copyTestPlan);
        this.customFieldValueService.initCustomFieldValues((BoundEntity)iteration, customFieldValues);
        return iteration;
    }

    @Override
    @PreventConcurrent(entityType=CampaignLibraryNode.class)
    public void addIterationToCampaignUnsecured(Iteration iteration, @Id long campaignId, boolean copyTestPlan) {
        Campaign campaign = (Campaign)this.campaignDao.findById(campaignId);
        if (copyTestPlan) {
            this.populateTestPlan(iteration, campaign.getTestPlan());
        }
        iteration.getTestPlan().setCampaignLibrary(campaign.getCampaignLibrary());
        this.iterationDao.persist(iteration);
        campaign.addContent(iteration);
        this.customFieldValueService.createAllCustomFieldValues((BoundEntity)iteration, (GenericProject)iteration.getProject());
        this.createIterationAttachments(iteration);
    }

    @Override
    @PreventConcurrent(entityType=CampaignLibraryNode.class)
    @PreAuthorize(value="hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign', 'CREATE')  or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=Campaign.class)
    public void createIterationWithItemCopies(@Id long campaignId, String name, String description, List<Long> itemTestPlanIds) {
        Iteration iteration = new Iteration();
        iteration.setName(name);
        iteration.setDescription(description);
        this.addIterationToCampaignUnsecured(iteration, campaignId, false, Collections.emptyMap());
        this.iterationTestPlanManagerService.copyTestPlanItems(itemTestPlanIds, iteration.getId());
    }

    private void createIterationAttachments(Iteration iteration) {
        String description = iteration.getDescription();
        if (description == null || description.isEmpty()) {
            return;
        }
        String html = this.attachmentManagerService.handleRichTextAttachments(description, iteration.getAttachmentList());
        if (!description.equals(html)) {
            iteration.setDescription(html);
        }
    }

    private void populateTestPlan(Iteration iteration, List<CampaignTestPlanItem> campaignTestPlan) {
        for (CampaignTestPlanItem campaignItem : campaignTestPlan) {
            TestCase testCase = campaignItem.getReferencedTestCase();
            Dataset dataset = campaignItem.getReferencedDataset();
            User assignee = campaignItem.getUser();
            iteration.getTestPlan().createAndAddTestPlanItem(testCase, dataset, assignee);
        }
    }

    @Override
    @PostAuthorize(value="hasPermission(returnObject, 'READ')  or hasRole('ROLE_ADMIN')")
    @Transactional(readOnly=true)
    public Iteration findById(long iterationId) {
        return (Iteration)this.iterationDao.findById(iterationId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'WRITE')  or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=Iteration.class)
    public void rename(@Id long iterationId, String newName) {
        Iteration iteration = (Iteration)this.iterationDao.findById(iterationId);
        List list = iteration.getCampaign().getIterations();
        String trimedName = newName.trim();
        if (!this.campaignModificationService.checkIterationNameAvailable(trimedName, list)) {
            throw new DuplicateNameException("Cannot rename iteration " + iteration.getName() + " : new name " + trimedName + " already exists in iteration " + String.valueOf(this.campaignModificationService));
        }
        iteration.setName(trimedName);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testPlanItemId, 'org.squashtest.tm.domain.campaign.testplan.TestPlanItem', 'EXECUTE')  or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestPlanItem.class)
    public Execution addManualExecution(@Id long testPlanItemId) {
        return this.addManualExecutionUnsecured(testPlanItemId);
    }

    @Override
    public Execution addManualExecutionUnsecured(@Id long testPlanItemId) {
        return this.executionCreationService.createManualExecution(testPlanItemId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'CREATE')  or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=Iteration.class)
    @CheckBlockingMilestone(entityType=Iteration.class)
    public void addTestSuite(@Id long iterationId, TestSuite suite) {
        Iteration iteration = (Iteration)this.iterationDao.findById(iterationId);
        this.addTestSuite(iteration, suite);
    }

    @Override
    @PreventConcurrent(entityType=Iteration.class)
    @CheckBlockingMilestone(entityType=Iteration.class)
    public void addTestSuiteUnsecuredWithoutMilestone(@Id long iterationId, TestSuite suite, Map<Long, RawValue> customFieldValues) {
        this.addTestSuiteUnsecuredWithoutMilestone(iterationId, suite);
        this.customFieldValueService.createAllCustomFieldValues((BoundEntity)suite, (GenericProject)suite.getProject(), customFieldValues);
    }

    @Override
    @PreventConcurrent(entityType=Iteration.class)
    public void addTestSuiteUnsecuredWithoutMilestone(@Id long iterationId, TestSuite suite) {
        Iteration iteration = (Iteration)this.iterationDao.findById(iterationId);
        this.addTestSuite(iteration, suite);
    }

    @Override
    public void addTestSuite(Iteration iteration, TestSuite suite) {
        this.suiteDao.save(suite);
        iteration.addContent(suite);
        this.customFieldValueService.createAllCustomFieldValues((BoundEntity)suite, (GenericProject)suite.getProject());
    }

    @Override
    @Transactional(readOnly=true)
    public List<NamedReference> findAllTestSuitesAsNamedReferences(long iterationId) {
        return this.iterationDao.findAllTestSuitesAsNamedReferences(iterationId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'LINK') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=Iteration.class)
    @CheckBlockingMilestone(entityType=Iteration.class)
    public void changeTestSuitePosition(@Id long iterationId, int newIndex, List<Long> itemIds) {
        Iteration iteration = this.iterationDao.loadWithTestSuites(iterationId);
        List items = this.suiteDao.findAllById(itemIds);
        Map itemMap = items.stream().collect(Collectors.toMap(TestSuite::getId, Function.identity()));
        List<TestSuite> orderedItems = itemIds.stream().map(itemMap::get).filter(Objects::nonNull).toList();
        iteration.moveTestSuites(newIndex, orderedItems);
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'CREATE')  or hasRole('ROLE_ADMIN')")
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=Iteration.class, paramName="iterationId")}, batchsLocks={@BatchPreventConcurrent(entityType=Iteration.class, paramName="testSuiteIds", coercer=TestSuiteToIterationCoercerForArray.class)})
    public void copyPasteTestSuitesToIteration(@Ids(value="testSuiteIds") Long[] testSuiteIds, @Id(value="iterationId") long iterationId, ClipboardPayload clipboardPayload) {
        NodeType nodePaste = this.campaignWorkspaceStrategyCopierService.verifyPermissionAndGetNodePaste(clipboardPayload);
        this.campaignWorkspaceStrategyCopierService.copyNodeToIteration(iterationId, clipboardPayload, nodePaste);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'READ') or hasRole('ROLE_ADMIN')")
    public List<Iteration> findIterationContainingTestCase(long testCaseId) {
        return this.iterationDao.findAllIterationContainingTestCase(testCaseId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration' , 'READ') or hasRole('ROLE_ADMIN')")
    public StatisticsBundle gatherIterationStatisticsBundle(long iterationId, boolean isLastExecutionScope) {
        return this.statisticsService.gatherIterationStatisticsBundle(Arrays.asList(iterationId), isLastExecutionScope);
    }

    @Override
    public Execution updateExecutionFromTc(long executionId) {
        Optional optExec = this.executionDao.findById(executionId);
        if (optExec.isEmpty()) {
            throw new ExecutionWasDeleted();
        }
        Execution exec = (Execution)optExec.get();
        if (exec.getReferencedTestCase() != null && exec.getReferencedTestCase().getSteps().isEmpty()) {
            throw new ExecutionHasNoStepsException();
        }
        int order = exec.getExecutionOrder();
        this.executionDeletionService.deleteExecutions(Collections.singletonList(executionId));
        TestPlanItem item = exec.getTestPlanItem();
        return this.executionCreationService.createManualExecution(item.getId(), order);
    }
}

