/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.requirement.dto;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.RequirementTarget;
import org.squashtest.tm.service.internal.batchimport.requirement.dto.RequirementImportDto;
import org.squashtest.tm.service.internal.batchimport.requirement.dto.RequirementVersionImportDto;
import org.squashtest.tm.service.internal.batchimport.requirement.tree.ImportedRequirementNode;
import org.squashtest.tm.service.internal.library.LibraryUtils;

public class RequirementFolderImportDto {
    private final RequirementFolder root;
    private final List<RequirementFolder> generatedFolders = new ArrayList<RequirementFolder>();
    private final List<RequirementVersionImportDto> generatedVersions = new ArrayList<RequirementVersionImportDto>();

    public RequirementFolderImportDto(RequirementFolder root) {
        this.root = root;
    }

    public static RequirementFolderImportDto fromRequirementNode(ImportedRequirementNode node, Map<RequirementTarget, List<RequirementVersionImportDto>> requirementTargetVersions, Project project) {
        RequirementFolder folder = RequirementFolderImportDto.createFolder(node);
        folder.notifyAssociatedWithProject(project);
        RequirementFolderImportDto root = new RequirementFolderImportDto(folder);
        RequirementFolderImportDto.addChildren(node, requirementTargetVersions, root, folder);
        return root;
    }

    private static RequirementFolder createFolder(ImportedRequirementNode node) {
        RequirementFolder folder = new RequirementFolder();
        folder.setName(node.getName());
        folder.setDescription("");
        return folder;
    }

    private static void addFolderChild(ImportedRequirementNode current, RequirementFolder parent, List<String> parentContentNames, Map<RequirementTarget, List<RequirementVersionImportDto>> requirementTargetVersions, RequirementFolderImportDto root) {
        RequirementFolder folder = RequirementFolderImportDto.createFolder(current);
        LibraryUtils.fixConflictNames(parentContentNames, (LibraryNode)folder);
        parent.addContent((RequirementLibraryNode)folder);
        RequirementFolderImportDto.addChildren(current, requirementTargetVersions, root, folder);
        root.addGeneratedFolder(folder);
    }

    private static void addChildren(ImportedRequirementNode current, Map<RequirementTarget, List<RequirementVersionImportDto>> requirementTargetVersions, RequirementFolderImportDto root, RequirementFolder folder) {
        if (current.getContents().isEmpty()) {
            return;
        }
        ArrayList<String> contentNames = new ArrayList<String>();
        for (ImportedRequirementNode child : current.getContents()) {
            if (child.isInstanceOfRequirement()) {
                RequirementFolderImportDto.addRequirementChild(child, folder, contentNames, requirementTargetVersions, root);
                continue;
            }
            RequirementFolderImportDto.addFolderChild(child, folder, contentNames, requirementTargetVersions, root);
        }
    }

    private static void addRequirementChild(ImportedRequirementNode current, RequirementFolder parentFolder, List<String> parentContentNames, Map<RequirementTarget, List<RequirementVersionImportDto>> requirementTargetVersions, RequirementFolderImportDto root) {
        RequirementImportDto requirementDto = RequirementImportDto.fromRequirementNode(current, requirementTargetVersions, parentFolder.getProject());
        LibraryUtils.fixConflictNames(parentContentNames, (LibraryNode)requirementDto.getRequirement());
        parentFolder.addContent((RequirementLibraryNode)requirementDto.getRequirement());
        root.addGeneratedVersions(requirementDto.getGeneratedVersions());
    }

    private void addGeneratedVersions(List<RequirementVersionImportDto> versions) {
        this.generatedVersions.addAll(versions);
    }

    private void addGeneratedFolder(RequirementFolder folder) {
        this.generatedFolders.add(folder);
    }

    public RequirementFolder getFolder() {
        return this.root;
    }

    public List<RequirementFolder> getGeneratedFolders() {
        return this.generatedFolders;
    }

    public List<RequirementVersionImportDto> getGeneratedVersions() {
        return this.generatedVersions;
    }
}

