/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.attachment;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.sql.Blob;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.rowset.serial.SerialBlob;
import org.apache.commons.io.IOUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.hibernate.JDBCException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.ForwardedHeaderUtils;
import org.springframework.web.util.UriComponents;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentContent;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.attachment.ExternalContentCoordinates;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.execution.ConsumerForExploratoryExecution;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.execution.ExecutionVisitor;
import org.squashtest.tm.domain.execution.ExploratoryExecutionRunningState;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.exception.attachment.AttachmentException;
import org.squashtest.tm.exception.campaign.SprintClosedException;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.CheckEntityExists;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.attachment.RawAttachment;
import org.squashtest.tm.service.attachment.UploadedData;
import org.squashtest.tm.service.audit.AuditModificationService;
import org.squashtest.tm.service.execution.ExploratoryExecutionService;
import org.squashtest.tm.service.internal.attachment.AttachmentManagerServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.attachment.AttachmentRepository;
import org.squashtest.tm.service.internal.display.dto.AttachmentDto;
import org.squashtest.tm.service.internal.repository.AttachmentContentDao;
import org.squashtest.tm.service.internal.repository.AttachmentDao;
import org.squashtest.tm.service.internal.repository.AttachmentListDao;
import org.squashtest.tm.service.internal.repository.MilestoneDao;
import org.squashtest.tm.service.internal.repository.display.SprintDisplayDao;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.EntityGraphQueryBuilder;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service(value="squashtest.tm.service.AttachmentManagerService")
@Transactional
public class AttachmentManagerServiceImpl
implements AttachmentManagerService {
    public static final Pattern ATTACHMENT_LIST_URL_PATTERN;
    private static final Logger LOGGER;
    private static final int EOF = -1;
    @PersistenceContext
    private EntityManager em;
    private final AttachmentDao attachmentDao;
    private final AttachmentListDao attachmentListDao;
    private final AttachmentContentDao attachmentContentDao;
    private final AttachmentRepository attachmentRepository;
    private final AuditModificationService auditModificationService;
    private final PermissionEvaluationService permissionEvaluationService;
    private final ExploratoryExecutionService exploratoryExecutionService;
    private final MilestoneDao milestoneDao;
    private final SprintDisplayDao sprintDisplayDao;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        AttachmentManagerServiceImpl.ajc$preClinit();
        ATTACHMENT_LIST_URL_PATTERN = Pattern.compile(AttachmentManagerServiceImpl.getAttachmentListUrl("(\\d+)", "(\\d+)"), 2);
        LOGGER = LoggerFactory.getLogger(AttachmentManagerServiceImpl.class);
    }

    public AttachmentManagerServiceImpl(AttachmentDao attachmentDao, AttachmentListDao attachmentListDao, AttachmentContentDao attachmentContentDao, AttachmentRepository attachmentRepository, AuditModificationService auditModificationService, PermissionEvaluationService permissionEvaluationService, ExploratoryExecutionService exploratoryExecutionService, MilestoneDao milestoneDao, SprintDisplayDao sprintDisplayDao) {
        this.attachmentDao = attachmentDao;
        this.attachmentListDao = attachmentListDao;
        this.attachmentContentDao = attachmentContentDao;
        this.attachmentRepository = attachmentRepository;
        this.auditModificationService = auditModificationService;
        this.permissionEvaluationService = permissionEvaluationService;
        this.exploratoryExecutionService = exploratoryExecutionService;
        this.milestoneDao = milestoneDao;
        this.sprintDisplayDao = sprintDisplayDao;
    }

    @Override
    public AttachmentDto addAttachment(long attachmentListId, RawAttachment rawAttachment, EntityReference permissionOwner, EntityType holderType) throws IOException {
        this.milestoneDao.checkBlockingMilestonesOnAttachmentList(holderType, attachmentListId);
        this.checkExploratorySessionSpecificCase(permissionOwner);
        this.checkCanAttach(permissionOwner.getId(), permissionOwner.getType().getEntityClass().getName());
        this.checkParentSprintStatus(permissionOwner);
        return this.addAttachment(attachmentListId, rawAttachment, holderType);
    }

    private AttachmentDto addAttachmentWithoutPermissionCheck(long attachmentListId, RawAttachment rawAttachment, EntityReference entityReference) throws IOException {
        return this.addAttachment(attachmentListId, rawAttachment, entityReference.getType());
    }

    @Override
    public <T extends AttachmentHolder & AuditableMixin> void importAttachmentWithoutPermissionCheck(T holder, RawAttachment rawAttachment) throws IOException {
        this.addAttachment(holder.getAttachmentList(), rawAttachment);
        this.auditModificationService.updateAuditable(holder);
    }

    @Override
    public <T extends AttachmentHolder & AuditableMixin> AttachmentDto addAttachment(T holder, RawAttachment rawAttachment, EntityType holderType) throws IOException {
        AttachmentDto result = this.addAttachment(holder.getAttachmentList(), rawAttachment);
        this.auditModificationService.updateRelatedToAttachmentAuditableEntity(holder.getAttachmentList().getId(), holderType);
        return result;
    }

    @Override
    public AttachmentDto addAttachment(long attachmentListId, RawAttachment rawAttachment, EntityType holderType) throws IOException {
        AttachmentList attachmentList = this.attachmentListDao.getOne(attachmentListId);
        AttachmentDto result = this.addAttachment(attachmentList, rawAttachment);
        this.auditModificationService.updateRelatedToAttachmentAuditableEntity(attachmentList.getId(), holderType);
        return result;
    }

    @Override
    public AttachmentDto addAttachment(AttachmentList attachmentList, RawAttachment rawAttachment) throws IOException {
        Attachment attachment = this.addAttachment(attachmentList, rawAttachment, new Date(), null);
        return new AttachmentDto(attachment);
    }

    @Override
    public Attachment addAttachment(AttachmentList attachmentList, RawAttachment rawAttachment, Date addedOn, Date lastModifiedOn) throws IOException {
        AttachmentContent content = this.getAttachmentRepository().createContent(rawAttachment, attachmentList.getId());
        Attachment attachment = new Attachment();
        attachmentList.addAttachment(attachment);
        attachment.setContent(content);
        attachment.setAddedOn(Optional.ofNullable(addedOn).orElse(new Date()));
        Optional.ofNullable(lastModifiedOn).ifPresent(arg_0 -> ((Attachment)attachment).setLastModifiedOn(arg_0));
        attachment.setName(rawAttachment.getName());
        attachment.setSize(Long.valueOf(rawAttachment.getSizeInBytes()));
        this.attachmentDao.save(attachment);
        return attachment;
    }

    @Override
    public Attachment addCopyAttachment(AttachmentList attachmentList, Attachment sourceAttachment, Date addedOn, Date lastModifiedOn) {
        Attachment attachment = sourceAttachment.shallowCopy();
        attachment.setAttachmentList(attachmentList);
        Optional.ofNullable(addedOn).ifPresent(arg_0 -> ((Attachment)attachment).setAddedOn(arg_0));
        Optional.ofNullable(lastModifiedOn).ifPresent(arg_0 -> ((Attachment)attachment).setLastModifiedOn(arg_0));
        this.attachmentDao.save(attachment);
        this.getAttachmentRepository().copyContent(attachment);
        return attachment;
    }

    @Override
    public AttachmentDto updateAttachmentContent(Attachment attachment, InputStream newContent) throws IOException {
        try {
            AttachmentContent content = attachment.getContent();
            byte[] byteArray = newContent.readAllBytes();
            SerialBlob newBlob = new SerialBlob(byteArray);
            content.setContent((Blob)newBlob);
            attachment.setContent(content);
            attachment.setLastModifiedOn(new Date());
            this.attachmentDao.save(attachment);
            return new AttachmentDto(attachment);
        }
        catch (SQLException e) {
            throw new JDBCException("Cannot read blob property as a stream", e);
        }
    }

    private void checkExploratorySessionSpecificCase(EntityReference permissionOwner) {
        Execution execution;
        boolean isExploratorySession;
        if (EntityType.EXECUTION.equals((Object)permissionOwner.getType()) && (isExploratorySession = TestCaseExecutionMode.EXPLORATORY.equals((Object)(execution = new EntityGraphQueryBuilder<Execution>(this.em, Execution.class, "SELECT e FROM Execution e WHERE e.id = :id").addSubGraph("automatedExecutionExtender", new String[0]).execute(Map.of("id", permissionOwner.getId()))).getExecutionMode()))) {
            this.checkExploratorySessionRunningState(execution);
        }
    }

    private void checkParentSprintStatus(EntityReference permissionOwner) {
        if (EntityType.EXECUTION.equals((Object)permissionOwner.getType())) {
            SprintStatus sprintStatus = this.sprintDisplayDao.getSprintStatusByExecutionId(permissionOwner.getId());
            this.checkSprintStatus(sprintStatus);
        } else if (EntityType.EXPLORATORY_SESSION_OVERVIEW.equals((Object)permissionOwner.getType())) {
            SprintStatus sprintStatus = this.sprintDisplayDao.getSprintStatusBySessionOverviewId(permissionOwner.getId());
            this.checkSprintStatus(sprintStatus);
        } else if (EntityType.SPRINT.equals((Object)permissionOwner.getType())) {
            SprintStatus sprintStatus = this.sprintDisplayDao.getSprintDtoById(permissionOwner.getId()).getStatus();
            this.checkSprintStatus(sprintStatus);
        }
    }

    private void checkSprintStatus(SprintStatus sprintStatus) {
        if (SprintStatus.CLOSED.equals((Object)sprintStatus)) {
            throw new SprintClosedException();
        }
    }

    private AttachmentRepository getAttachmentRepository() {
        return this.attachmentRepository;
    }

    @Override
    @CheckEntityExists(entityType=Attachment.class)
    public Attachment findAttachment(@Id Long attachmentId) throws AccessDeniedException {
        this.checkUserPermissionsOnProject(attachmentId);
        return this.findById(attachmentId);
    }

    private List<Attachment> findAttachmentsForDeletion(List<Long> attachmentIds) {
        return this.attachmentDao.findAttachmentsForDeletion(attachmentIds);
    }

    @Override
    public void checkReadPermissionOnProjectByAttachmentListId(Long attachmentListId) {
        boolean isAdmin = this.permissionEvaluationService.hasRole("ROLE_ADMIN");
        if (isAdmin) {
            return;
        }
        AttachmentHolder holder = this.attachmentListDao.findAttachmentHolder(attachmentListId);
        Long projectId = holder.getAttachmentHolderProjectId();
        this.permissionEvaluationService.checkPermission(Collections.singletonList(projectId), Permissions.READ.name(), Project.class.getName());
    }

    private Attachment findById(Long attachmentId) {
        return (Attachment)this.attachmentDao.getReferenceById(attachmentId);
    }

    private void checkUserPermissionsOnProject(Long attachmentId) throws AccessDeniedException {
        Long attachmentListId = this.attachmentListDao.findAttachmentListIdByAttachmentId(attachmentId);
        if (Objects.isNull(attachmentListId)) {
            String accessDenied = "Unauthorized access or non-existent attachment: " + attachmentId.toString();
            throw new IllegalArgumentException(accessDenied);
        }
        this.checkReadPermissionOnProjectByAttachmentListId(attachmentListId);
    }

    @Override
    public void removeListOfAttachments(@Id long attachmentListId, List<Long> attachmentIds, EntityReference permissionOwner, EntityType holderType) throws AccessDeniedException {
        this.milestoneDao.checkBlockingMilestonesOnAttachmentList(holderType, attachmentListId);
        this.checkExploratorySessionSpecificCase(permissionOwner);
        if (!EntityType.AUTOMATED_SUITE.equals((Object)permissionOwner.getType())) {
            this.checkCanAttach(permissionOwner.getId(), permissionOwner.getType().getEntityClass().getName());
        }
        this.checkParentSprintStatus(permissionOwner);
        ArrayList<ExternalContentCoordinates> externalContentCoordinates = new ArrayList<ExternalContentCoordinates>();
        List<Attachment> attachments = this.findAttachmentsForDeletion(attachmentIds);
        for (Attachment attachment : attachments) {
            Long attachmentContentId = attachment.getContent().getId();
            externalContentCoordinates.add(new ExternalContentCoordinates(Long.valueOf(attachmentListId), attachmentContentId));
        }
        this.attachmentDao.deleteAllByIdInBatch(attachmentIds);
        this.deleteContents(externalContentCoordinates);
        this.auditModificationService.updateRelatedToAttachmentAuditableEntity(attachmentListId, holderType);
    }

    private void checkExploratorySessionRunningState(Execution execution) {
        execution.accept((ExecutionVisitor)new ConsumerForExploratoryExecution(exploratoryExecution -> {
            ExploratoryExecutionRunningState currentState = this.exploratoryExecutionService.findExploratoryExecutionRunningState(exploratoryExecution.getId());
            this.exploratoryExecutionService.checkSessionIsNotStopped(currentState);
        }));
    }

    @Override
    @CheckBlockingMilestone(entityType=Attachment.class)
    public void renameAttachment(@Id long attachmentId, String newName) {
        Attachment attachment = (Attachment)this.attachmentDao.getReferenceById(attachmentId);
        AttachmentHolder holder = this.attachmentListDao.findAttachmentHolder(attachment.getAttachmentList().getId());
        EntityReference entityRef = holder.toEntityReference();
        this.checkCanAttach(entityRef.getId(), entityRef.getType().getEntityClass().getName());
        attachment.setShortName(newName);
    }

    @Override
    public Page<Attachment> findPagedAttachments(AttachmentHolder attached, Pageable pas) {
        return this.findPagedAttachments(attached.getAttachmentList().getId(), pas);
    }

    private Page<Attachment> findPagedAttachments(long attachmentListId, Pageable pageable) {
        return this.attachmentDao.findAllAttachmentsPagined(attachmentListId, pageable);
    }

    @Override
    public void writeContent(long attachmentId, OutputStream outStream) throws IOException {
        int readByte;
        InputStream is = this.getAttachmentRepository().getContentStream(attachmentId);
        do {
            if ((readByte = is.read()) == -1) continue;
            outStream.write(readByte);
        } while (readByte != -1);
        is.close();
    }

    @Override
    public void copyContent(Attachment attachment) {
        this.getAttachmentRepository().copyContent(attachment);
    }

    @Override
    public void copyContentsOnExternalRepository(AttachmentHolder attachmentHolder) {
        AttachmentList attachmentList = attachmentHolder.getAttachmentList();
        for (Attachment attachment : attachmentList.getAllAttachments()) {
            this.copyContent(attachment);
        }
    }

    @Override
    public void batchCopyContentsOnExternalRepository(List<AttachmentHolder> attachmentHolders) {
        this.em.flush();
        for (AttachmentHolder attachmentHolder : attachmentHolders) {
            AttachmentList attachmentList = attachmentHolder.getAttachmentList();
            for (Attachment attachment : attachmentList.getAllAttachments()) {
                this.copyContent(attachment);
            }
        }
    }

    private void removeContentFromFileSystem(long attachmentListId, long attachmentContentId) {
        this.attachmentRepository.removeContent(attachmentListId, attachmentContentId);
    }

    @Override
    public List<ExternalContentCoordinates> getListIDbyContentIdForAttachmentLists(List<Long> attachmentsList) {
        return this.attachmentContentDao.getListPairContentIDListIDFromAttachmentLists(attachmentsList);
    }

    @Override
    public void deleteContents(List<ExternalContentCoordinates> contentIdListIdList) {
        ArrayList<Long> contentIds = new ArrayList<Long>();
        for (ExternalContentCoordinates coord : contentIdListIdList) {
            contentIds.add(coord.getContentId());
        }
        this.removeOrphanAttachmentContents(contentIds);
        if (this.attachmentRepository.getClass().getSimpleName().contains("FileSystemAttachmentRepository")) {
            for (ExternalContentCoordinates externalCoord : contentIdListIdList) {
                this.removeContentFromFileSystem(externalCoord.getAttachmentListId(), externalCoord.getContentId());
            }
        }
    }

    private void removeOrphanAttachmentContents(List<Long> contentIds) {
        if (!contentIds.isEmpty()) {
            Set<Long> notOrphans = this.attachmentContentDao.findNotOrphanAttachmentContent(contentIds);
            contentIds.removeAll(notOrphans);
            if (!contentIds.isEmpty()) {
                this.attachmentContentDao.deleteByIds(contentIds);
            }
        }
    }

    @Override
    public void removeAttachmentsAndLists(List<Long> attachmentListIds) {
        if (!attachmentListIds.isEmpty()) {
            Set<Long> attachmentIds = this.attachmentDao.findAllAttachmentsFromLists(attachmentListIds);
            if (!attachmentIds.isEmpty()) {
                this.attachmentDao.removeAllAttachments(attachmentIds);
            }
            this.attachmentDao.removeAllAttachmentsLists(attachmentListIds);
        }
    }

    @Override
    public List<Long> getAttachmentsListsFromRequirementFolders(List<Long> requirementLibraryNodeIds) {
        return this.attachmentDao.findAttachmentsListsFromRequirementFolder(requirementLibraryNodeIds);
    }

    @Override
    public List<ExternalContentCoordinates> getListPairContentIDListIDForExecutionSteps(Collection<ExecutionStep> executionSteps) {
        ArrayList<Long> executionStepsIds = new ArrayList<Long>();
        for (ExecutionStep executionStep : executionSteps) {
            executionStepsIds.add(executionStep.getId());
        }
        return this.attachmentDao.getListPairContentIDListIDForExecutionSteps(executionStepsIds);
    }

    @Override
    public List<ExternalContentCoordinates> getListPairContentIDListIDForExecutionIds(Collection<Long> executionStepsIds) {
        Collection<Long> collection = executionStepsIds;
        AttachmentDao attachmentDao = this.attachmentDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)attachmentDao, collection);
        Object[] objectArray = new Object[]{this, attachmentDao, collection, joinPoint};
        AttachmentManagerServiceImpl$AjcClosure1 attachmentManagerServiceImpl$AjcClosure1 = new AttachmentManagerServiceImpl$AjcClosure1(objectArray);
        return (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(attachmentManagerServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
    }

    @Override
    public List<ExternalContentCoordinates> getListPairContentIDListIDForExecutionStepIds(Collection<Long> executionStepIds) {
        return this.attachmentDao.getListPairContentIDListIDForExecutionSteps(executionStepIds);
    }

    @Override
    public List<ExternalContentCoordinates> getListPairContentIDListIDForAutomatedSuiteIds(List<Long> automatedSuiteIds) {
        return this.attachmentDao.getListPairContentIDListIDForAutomatedSuiteIds(automatedSuiteIds);
    }

    @Override
    public String handleRichTextAttachments(String html, AttachmentList attachmentList) {
        Document document = Jsoup.parse((String)html);
        Elements elements = document.select("img");
        if (elements.isEmpty()) {
            return html;
        }
        elements.forEach(element -> {
            String imageSrc = element.attr("src");
            if (this.imageIsBase64(imageSrc)) {
                String imageName = this.getImageName((Element)element, imageSrc);
                this.addAttachmentFromBase64(attachmentList, (Element)element, imageSrc, imageName);
            }
        });
        return document.body().html();
    }

    @Override
    public String handleRichTextAttachmentsWithNewUrl(String html, AttachmentList attachmentList, Map<Long, Long> newAttachmentIdByOldAttachmentId, String baseUrl) {
        Document document = Jsoup.parse((String)html);
        Elements elements = document.select("img");
        if (elements.isEmpty()) {
            return html;
        }
        elements.forEach(element -> {
            String imageSrc = element.attr("src");
            if (this.imageIsBase64(imageSrc)) {
                String imageName = this.getImageName((Element)element, imageSrc);
                this.addAttachmentFromBase64(attachmentList, (Element)element, imageSrc, imageName, baseUrl);
            } else {
                this.updateRichTextWithNewUrl((Element)element, baseUrl, attachmentList, imageSrc, newAttachmentIdByOldAttachmentId);
            }
        });
        return document.body().html();
    }

    private void updateRichTextWithNewUrl(Element element, String baseUrl, AttachmentList attachmentList, String imageSrc, Map<Long, Long> newAttachmentIdByOldAttachmentId) {
        Matcher matcher = ATTACHMENT_LIST_URL_PATTERN.matcher(imageSrc);
        if (matcher.find()) {
            long oldAttachmentId = Long.parseLong(matcher.group(2));
            long newAttachmentId = newAttachmentIdByOldAttachmentId.getOrDefault(oldAttachmentId, oldAttachmentId);
            element.attr("src", this.buildFileUploadUrl(baseUrl, attachmentList.getId(), newAttachmentId));
        }
    }

    @Override
    public String copyAttachmentsFromRichText(String html, Long attachmentListId, Long copiedAttachmentListId, EntityReference entityReference) {
        Document document = Jsoup.parse((String)html);
        Elements elements = document.select("img");
        if (elements.isEmpty()) {
            return html;
        }
        elements.forEach(element -> {
            String imageSrc = element.attr("src");
            if (this.imageIsAttachment(imageSrc, copiedAttachmentListId)) {
                this.processCopyAttachmentImage((Element)element, imageSrc, attachmentListId, entityReference);
            }
        });
        return document.body().html();
    }

    private static String getAttachmentListUrl(String attachmentListId, String attachmentId) {
        return "/backend/attach-list/%s/attachments/download/%s".formatted(attachmentListId, attachmentId);
    }

    @Override
    public String handleRichTextAttachments(AttachmentList sourceAttachmentList, AttachmentList copyAttachmentList, String richText) {
        Long sourceAttachmentListId = sourceAttachmentList.getId();
        String attachmentListUrl = AttachmentManagerServiceImpl.getAttachmentListUrl(sourceAttachmentListId.toString(), "");
        if (richText != null && richText.contains(attachmentListUrl)) {
            String currentRichText = richText;
            StringBuilder richTextBuilder = new StringBuilder(richText);
            sourceAttachmentList.getAllAttachments().stream().filter(sourceAttachment -> AttachmentManagerServiceImpl.isSourcePresent(sourceAttachment, sourceAttachmentListId, currentRichText)).forEach(sourceAttachment -> copyAttachmentList.getAllAttachments().stream().filter(copyAttachment -> this.isTheCopiedAttachment(sourceAttachment.getId(), copyAttachment.getId())).forEach(copyAttachment -> this.replaceSourceUrl((Attachment)sourceAttachment, (Attachment)copyAttachment, attachmentListUrl, copyAttachmentList, richTextBuilder)));
            richText = richTextBuilder.toString();
        }
        return richText;
    }

    @Override
    public void removeAttachmentsAndContents(List<Long> attachmentListIds, List<ExternalContentCoordinates> externalContentCoordinates) {
        Set<Long> attachmentIds = this.attachmentDao.findAllAttachmentsFromLists(attachmentListIds);
        LOGGER.info("Starting pruning of %d attachments.".formatted(attachmentIds.size()), new Object[0]);
        LOGGER.debug("Attachments IDs: %s".formatted(attachmentIds), new Object[0]);
        Instant start = Instant.now();
        if (!attachmentIds.isEmpty()) {
            this.attachmentDao.removeAllAttachments(attachmentIds);
        }
        long elapsedMilliseconds = Duration.between(start, Instant.now()).toMillis();
        LOGGER.info("Pruning of %d attachments completed in %d ms.".formatted(attachmentIds.size(), elapsedMilliseconds), new Object[0]);
        this.deleteContents(externalContentCoordinates);
    }

    private void replaceSourceUrl(Attachment sourceAttachment, Attachment copyAttachment, String baseSourceUrl, AttachmentList copyAttachmentList, StringBuilder richTextBuilder) {
        String sourceUrl = baseSourceUrl + String.valueOf(sourceAttachment.getId());
        String copyURL = AttachmentManagerServiceImpl.getAttachmentListUrl(copyAttachmentList.getId().toString(), copyAttachment.getId().toString());
        int startIndex = richTextBuilder.indexOf(sourceUrl);
        if (startIndex != -1) {
            richTextBuilder.replace(startIndex, startIndex + sourceUrl.length(), copyURL);
        }
    }

    private static boolean isSourcePresent(Attachment sourceAttachment, Long sourceAttachmentListId, String richText) {
        String originalURL = AttachmentManagerServiceImpl.getAttachmentListUrl(sourceAttachmentListId.toString(), sourceAttachment.getId().toString());
        return richText.contains(originalURL);
    }

    private boolean isTheCopiedAttachment(Long sourceAttachmentId, Long copyAttachmentId) {
        try {
            return IOUtils.contentEquals((InputStream)this.attachmentRepository.getContentStream(sourceAttachmentId), (InputStream)this.attachmentRepository.getContentStream(copyAttachmentId));
        }
        catch (IOException e) {
            throw new AttachmentException((Throwable)e);
        }
    }

    private void processCopyAttachmentImage(Element element, String imageSrc, Long attachmentListId, EntityReference entityReference) {
        Long attId = this.extractAttachmentIdFromSrc(imageSrc);
        Attachment attachment = (Attachment)this.attachmentDao.getReferenceById(attId);
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (InputStream stream = attachment.getContent().getStream();){
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                stream.transferTo(baos);
                byte[] data = baos.toByteArray();
                UploadedData uploadedData = new UploadedData(new ByteArrayInputStream(data), attachment.getName(), data.length);
                AttachmentDto attachmentDto = this.addAttachmentWithoutPermissionCheck(attachmentListId, uploadedData, entityReference);
                element.attr("src", this.buildFileUploadUrl(this.getBaseFileUploadUrl(), attachmentListId, attachmentDto.getId()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new AttachmentException((Throwable)e);
        }
    }

    private Long extractAttachmentIdFromSrc(String imageSrc) {
        String idString = imageSrc.substring(imageSrc.lastIndexOf("/") + 1);
        return Long.parseLong(idString);
    }

    private boolean imageIsAttachment(String imageSrc, Long copiedAttachmentListId) {
        return imageSrc.contains(AttachmentManagerServiceImpl.getAttachmentListUrl(copiedAttachmentListId.toString(), ""));
    }

    private String getImageName(Element element, String imageBase64) {
        String imageName = element.attr("alt");
        if (imageName.isEmpty()) {
            return this.generateDefaultImageName(imageBase64);
        }
        return imageName;
    }

    private String generateDefaultImageName(String imageBase64) {
        String defaultImageName = "image.";
        String[] parts = imageBase64.split(",");
        String mediaType = parts[0];
        String extension = mediaType.substring("data:image/".length());
        if (extension.contains(";")) {
            extension = extension.substring(0, extension.indexOf(";"));
        }
        return defaultImageName + extension;
    }

    private void addAttachmentFromBase64(AttachmentList attachmentList, Element element, String imageSrc, String imageName, String baseUrl) {
        String base64Image = imageSrc.split(",")[1];
        byte[] imageBytes = Base64.getDecoder().decode(base64Image);
        ByteArrayInputStream targetStream = new ByteArrayInputStream(imageBytes);
        try {
            UploadedData uploadedData = new UploadedData(targetStream, imageName, ((InputStream)targetStream).available());
            AttachmentDto attachmentDto = this.addAttachment(attachmentList, uploadedData);
            element.attr("src", this.buildFileUploadUrl(baseUrl, attachmentList.getId(), attachmentDto.getId()));
        }
        catch (IOException e) {
            throw new AttachmentException((Throwable)e);
        }
    }

    private void addAttachmentFromBase64(AttachmentList attachmentList, Element element, String imageSrc, String imageName) {
        this.addAttachmentFromBase64(attachmentList, element, imageSrc, imageName, this.getBaseFileUploadUrl());
    }

    @Override
    public String getBaseFileUploadUrl() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        StringBuilder builder = new StringBuilder();
        ServletServerHttpRequest httpRequest = new ServletServerHttpRequest(request);
        UriComponents uriComponents = ForwardedHeaderUtils.adaptFromForwardedHeaders((URI)httpRequest.getURI(), (HttpHeaders)httpRequest.getHeaders()).build();
        builder.append(uriComponents.getScheme()).append("://").append(request.getServerName());
        int port = request.getServerPort();
        if (port != 80 && port != 443) {
            builder.append(":").append(port);
        }
        builder.append(request.getContextPath());
        return builder.toString();
    }

    private String buildFileUploadUrl(String baseUrl, Long attachmentListId, Long attachmentId) {
        return "%s%s".formatted(baseUrl, AttachmentManagerServiceImpl.getAttachmentListUrl(attachmentListId.toString(), attachmentId.toString()));
    }

    private boolean imageIsBase64(String imageSrc) {
        String regex = "^data:image\\/(png|jpeg|jpg|gif|svg|bmp);base64,([A-Za-z0-9+/]+={0,2})$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(imageSrc);
        return matcher.matches();
    }

    private void checkCanAttach(long entityId, String entityClassName) {
        String[] roles = new String[]{"ROLE_ADMIN", "ROLE_TA_API_CLIENT"};
        String permissionName = Project.class.getName().equals(entityClassName) ? Permissions.MANAGE_PROJECT.name() : Permissions.ATTACH.name();
        boolean permission = this.permissionEvaluationService.hasRoleOrPermissionOnObject(roles, permissionName, (Long)entityId, entityClassName);
        if (!permission) {
            throw new AccessDeniedException("Access is denied");
        }
    }

    static final /* synthetic */ List getListPairContentIDListIDForExecutions_aroundBody0(AttachmentManagerServiceImpl attachmentManagerServiceImpl, AttachmentDao attachmentDao, Collection collection, JoinPoint joinPoint) {
        return attachmentDao.getListPairContentIDListIDForExecutions(collection);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AttachmentManagerServiceImpl.java", AttachmentManagerServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "getListPairContentIDListIDForExecutions", "org.squashtest.tm.service.internal.repository.AttachmentDao", "java.util.Collection", "arg0", "", "java.util.List"), 529);
    }
}

