/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.assistance.analysis;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testautomation.AnalysisStatus;
import org.squashtest.tm.domain.testautomation.TestCandidateAnalysis;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.internal.dto.testautomation.TestAutomationInitResponse;
import org.squashtest.tm.service.internal.dto.testautomation.TestAutomationProjectAnalysisStatusDto;
import org.squashtest.tm.service.internal.dto.testautomation.TestCandidateAnalysisDto;
import org.squashtest.tm.service.internal.repository.TestAutomationCandidateDao;
import org.squashtest.tm.service.internal.repository.TestCandidateAnalysisDao;
import org.squashtest.tm.service.internal.repository.display.TestCandidateAnalysisDisplayDao;
import org.squashtest.tm.service.internal.testautomation.assistance.analysis.TestAutomationEvent;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.sse.ServerEventService;
import org.squashtest.tm.service.testautomation.assistance.analysis.TestCandidateAnalysisService;
import org.squashtest.tm.service.testautomation.assistance.candidate.TestCandidatePermissionEvaluationService;

@Service
public class TestCandidateAnalysisServiceImpl
implements TestCandidateAnalysisService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCandidateAnalysisServiceImpl.class);
    private static final String TEST_AUTOMATION_CANDIDATES_TASKS_ENDPOINT = "/backend/test-automation-candidates/tasks/";
    private final TestAutomationCandidateDao testAutomationCandidateDao;
    private final TestCandidateAnalysisDao testCandidateAnalysisDao;
    private final ServerEventService serverEventService;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final TestCandidateAnalysisDisplayDao testCandidateAnalysisDisplayDao;
    private final ProjectFinder projectFinder;
    private final TestCandidatePermissionEvaluationService testCandidatePermissionEvaluationService;

    public TestCandidateAnalysisServiceImpl(TestAutomationCandidateDao testAutomationCandidateDao, TestCandidateAnalysisDao testCandidateAnalysisDao, ServerEventService serverEventService, ApplicationEventPublisher applicationEventPublisher, TestCandidateAnalysisDisplayDao testCandidateAnalysisDisplayDao, ProjectFinder projectFinder, TestCandidatePermissionEvaluationService testCandidatePermissionEvaluationService) {
        this.testAutomationCandidateDao = testAutomationCandidateDao;
        this.testCandidateAnalysisDao = testCandidateAnalysisDao;
        this.serverEventService = serverEventService;
        this.applicationEventPublisher = applicationEventPublisher;
        this.testCandidateAnalysisDisplayDao = testCandidateAnalysisDisplayDao;
        this.projectFinder = projectFinder;
        this.testCandidatePermissionEvaluationService = testCandidatePermissionEvaluationService;
    }

    @Override
    @Transactional
    public TestAutomationInitResponse initiateTestAutomationScoring(List<Long> projectIds) {
        LOGGER.info("Initiating test automation scoring for projects: {}", new Object[]{projectIds});
        int totalTestCases = this.testAutomationCandidateDao.countEligibleTestCasesByProjectIds(projectIds);
        if (!this.testCandidatePermissionEvaluationService.hasPermissionOnProjects(projectIds)) {
            String errorMessage = String.format("Access denied: insufficient permissions to launch test automation scoring. The user lacks access rights to one or more projects with IDs: %s", projectIds);
            LOGGER.error(errorMessage, new Object[0]);
            throw new AccessDeniedException(errorMessage);
        }
        String currentUser = UserContextHolder.getUsername();
        TestCandidateAnalysis analysis = (TestCandidateAnalysis)this.testCandidateAnalysisDao.save(this.createTestCandidateAnalysis(projectIds, totalTestCases, currentUser));
        String statusUrl = TEST_AUTOMATION_CANDIDATES_TASKS_ENDPOINT + String.valueOf(analysis.getId());
        if (totalTestCases > 0) {
            LOGGER.trace("Publishing test automation event for analysis {} with {} test cases", new Object[]{analysis.getId(), totalTestCases});
            TestAutomationEvent event = new TestAutomationEvent(projectIds, analysis.getId(), currentUser);
            this.applicationEventPublisher.publishEvent((Object)event);
        } else {
            LOGGER.debug("No test cases to process, marking analysis {} as completed", new Object[]{analysis.getId()});
            analysis.setStatus(AnalysisStatus.COMPLETED);
            analysis.setTerminatedOn(new Date());
            this.testCandidateAnalysisDao.save(analysis);
            analysis.setNbOfProcessedTestCases(0);
            TestCandidateAnalysisDto progressDto = TestCandidateAnalysisDto.fromAnalysis(analysis);
            this.serverEventService.sendLastEvent(analysis.getId().toString(), progressDto);
        }
        LOGGER.info("Test automation scoring initiated successfully for analysis {}", new Object[]{analysis.getId()});
        return new TestAutomationInitResponse(analysis.getId(), statusUrl, totalTestCases, currentUser);
    }

    @Override
    public TestCandidateAnalysisDto getLastAnalysisForCurrentUser() {
        String currentUser = UserContextHolder.getUsername();
        LOGGER.debug("Retrieving test candidate analyses for user: {}", new Object[]{currentUser});
        TestCandidateAnalysis analysis = this.testCandidateAnalysisDao.findTopByCreatedByOrderByCreatedOnDescIdDesc(currentUser).orElse(null);
        if (analysis == null) {
            return null;
        }
        List projectNames = analysis.getProjectNames();
        return TestCandidateAnalysisDto.builder().withAnalysisId(analysis.getId()).withProjectNames(projectNames).withNbTotalCandidates(analysis.getNbOfTotalTestCases()).withNbProcessedCandidates(analysis.getNbOfProcessedTestCases()).withStatus(analysis.getStatus()).withEvaluatedBy(analysis.getCreatedBy()).withCreatedOn(analysis.getCreatedOn()).withTerminatedOn(analysis.getTerminatedOn()).build();
    }

    @Override
    public List<TestAutomationProjectAnalysisStatusDto> findAnalysisStatusForProjects() {
        List<Long> readableProjectIds = this.projectFinder.findAllReadableIdsForAutomationHelper();
        return this.testCandidateAnalysisDisplayDao.findAnalysisStatusByProjectIds(readableProjectIds);
    }

    @Override
    public void completeAnalysis(TestCandidateAnalysis analysis) {
        LOGGER.info("Completing analysis {}", new Object[]{analysis.getId()});
        analysis.setStatus(AnalysisStatus.COMPLETED);
        analysis.setTerminatedOn(new Date());
        analysis.setNbOfProcessedTestCases(analysis.getNbOfTotalTestCases());
        this.testCandidateAnalysisDao.save(analysis);
        TestCandidateAnalysisDto progressDto = TestCandidateAnalysisDto.fromAnalysis(analysis);
        this.serverEventService.sendLastEvent(analysis.getId().toString(), progressDto);
    }

    private TestCandidateAnalysis createTestCandidateAnalysis(List<Long> projectIds, int totalTestCases, String currentUser) {
        TestCandidateAnalysis analysis = new TestCandidateAnalysis();
        analysis.setNbOfTotalTestCases(totalTestCases);
        analysis.setCreatedBy(currentUser);
        Set<Project> projects = this.testCandidateAnalysisDao.findProjectsByIds(projectIds);
        analysis.setProjects(projects);
        return analysis;
    }
}

