/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.templateplugin;

import com.google.common.collect.Lists;
import jakarta.validation.constraints.NotBlank;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.squashtest.tm.api.template.TemplateConfigurablePlugin;
import org.squashtest.tm.service.templateplugin.TemplateConfigurablePluginService;

@Service
public class TemplateConfigurablePluginManagerImpl
implements TemplateConfigurablePluginService {
    @Autowired(required=false)
    private final Collection<TemplateConfigurablePlugin> plugins = Collections.emptyList();

    @Override
    public Optional<TemplateConfigurablePlugin> findById(@NotBlank @NonNull String id) {
        return this.plugins.stream().filter(plugin -> id.equals(plugin.getId())).findFirst();
    }

    @Override
    public List<TemplateConfigurablePlugin> findByIds(@NotBlank @NonNull List<String> ids) {
        return this.plugins.stream().filter(plugin -> ids.contains(plugin.getId())).toList();
    }

    @Override
    public List<TemplateConfigurablePlugin> findAll() {
        return Lists.newArrayList(this.plugins);
    }
}

