/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.spring;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.PrioritizedParameterNameDiscoverer;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;

public class CompositeDelegatingParameterNameDiscoverer
implements ParameterNameDiscoverer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeDelegatingParameterNameDiscoverer.class);
    private final PrioritizedParameterNameDiscoverer delegate = new PrioritizedParameterNameDiscoverer();

    public CompositeDelegatingParameterNameDiscoverer(List<ParameterNameDiscoverer> discoverers) {
        if (discoverers == null || discoverers.isEmpty()) {
            LOGGER.warn("CompositeDelegatingParameterNameDiscoverer initialized with an empty list of delegate", new Object[0]);
        } else {
            for (ParameterNameDiscoverer discoverer : discoverers) {
                LOGGER.info("Adding to CompositeDelegatingParameterNameDiscoverer a discoverer of type {}", new Object[]{discoverer.getClass()});
                this.delegate.addDiscoverer(discoverer);
            }
        }
    }

    public String[] getParameterNames(Method method) {
        return this.delegate.getParameterNames(method);
    }

    public String[] getParameterNames(Constructor ctor) {
        return this.delegate.getParameterNames(ctor);
    }
}

