/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.report.qualitativecoverage;

import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record3;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.SelectSeekStep1;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.Resource;
import org.squashtest.tm.service.internal.dto.qualitativecoverage.QuaCoverageCampaignDto;
import org.squashtest.tm.service.internal.dto.qualitativecoverage.QuaCoverageIterationDto;
import org.squashtest.tm.service.internal.dto.qualitativecoverage.QuaCoverageProjectDto;
import org.squashtest.tm.service.internal.dto.qualitativecoverage.QuaCoverageRequirementDto;
import org.squashtest.tm.service.internal.dto.qualitativecoverage.QuaCoverageTestSuiteDto;

@Service
public class QuaCoverageQueryFinder {
    private final DSLContext dsl;

    @Inject
    protected QuaCoverageQueryFinder(DSLContext dsl) {
        this.dsl = dsl;
    }

    public List<QuaCoverageCampaignDto> getCampaignsByProjectIds(List<Long> projectIds) {
        return this.dsl.selectDistinct((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.as("CAMPAIGN_ID"), (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.NAME.as("CAMPAIGN_NAME")).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).leftJoin((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.in(projectIds)).fetchInto(QuaCoverageCampaignDto.class);
    }

    public List<QuaCoverageCampaignDto> getCampaignsByProjectAndMilestoneIds(List<Long> projectIds, List<Integer> milestoneIds) {
        return this.dsl.selectDistinct((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.as("CAMPAIGN_ID"), (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.NAME.as("CAMPAIGN_NAME")).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).leftJoin((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).leftJoin((TableLike)Tables.MILESTONE_CAMPAIGN).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.in(projectIds)).and(Tables.MILESTONE_CAMPAIGN.MILESTONE_ID.in(milestoneIds)).fetchInto(QuaCoverageCampaignDto.class);
    }

    public Map<Long, List<QuaCoverageRequirementDto>> fetchCoverageByCampaigns(List<Long> campaignIds) {
        Table<Record3<Long, Integer, Long>> success = this.campaignStatusSubquery(campaignIds, ExecutionStatus.SUCCESS.toString(), List.of(ExecutionStatus.SUCCESS, ExecutionStatus.WARNING));
        Table<Record3<Long, Integer, Long>> failure = this.campaignStatusSubquery(campaignIds, ExecutionStatus.FAILURE.toString(), List.of(ExecutionStatus.FAILURE));
        Table<Record3<Long, Integer, Long>> untestable = this.campaignStatusSubquery(campaignIds, ExecutionStatus.UNTESTABLE.toString(), List.of(ExecutionStatus.UNTESTABLE));
        Table<Record3<Long, Integer, Long>> blocked = this.campaignStatusSubquery(campaignIds, ExecutionStatus.BLOCKED.toString(), List.of(ExecutionStatus.BLOCKED));
        Table<Record3<Long, Integer, Long>> settled = this.campaignStatusSubquery(campaignIds, ExecutionStatus.SETTLED.toString(), List.of(ExecutionStatus.SETTLED));
        Table<Record3<Long, Integer, Long>> running = this.campaignStatusSubquery(campaignIds, ExecutionStatus.RUNNING.toString(), List.of(ExecutionStatus.RUNNING));
        Table<Record3<Long, Integer, Long>> ready = this.campaignStatusSubquery(campaignIds, ExecutionStatus.READY.toString(), List.of(ExecutionStatus.READY));
        Resource rs = Tables.RESOURCE.as("rs");
        SelectSeekStep1 query = this.dsl.selectDistinct((SelectField)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.as("CAMPAIGN_ID"), (SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.as("REQUIREMENT_ID"), (SelectField)rs.field("NAME").as("REQUIREMENT_NAME"), (SelectField)Tables.REQUIREMENT_VERSION.REFERENCE.as("REQUIREMENT_REF"), (SelectField)Tables.REQUIREMENT_VERSION.VERSION_NUMBER.as("REQUIREMENT_VERSION_NUMBER"), (SelectField)Tables.REQUIREMENT_VERSION.CRITICALITY.as("CRITICALITY"), (SelectField)DSL.coalesce((Field)success.field("COUNTS", Integer.class), (Object)0).as(ExecutionStatus.SUCCESS.toString()), (SelectField)DSL.coalesce((Field)failure.field("COUNTS", Integer.class), (Object)0).as(ExecutionStatus.FAILURE.toString()), (SelectField)DSL.coalesce((Field)untestable.field("COUNTS", Integer.class), (Object)0).as(ExecutionStatus.UNTESTABLE.toString()), (SelectField)DSL.coalesce((Field)blocked.field("COUNTS", Integer.class), (Object)0).as(ExecutionStatus.BLOCKED.toString()), (SelectField)DSL.coalesce((Field)running.field("COUNTS", Integer.class), (Object)0).as(ExecutionStatus.RUNNING.toString()), (SelectField)DSL.coalesce((Field)ready.field("COUNTS", Integer.class), (Object)0).as(ExecutionStatus.READY.toString()), (SelectField)DSL.coalesce((Field)settled.field("COUNTS", Integer.class), (Object)0).as(ExecutionStatus.SETTLED.toString())).from((TableLike)Tables.REQUIREMENT_VERSION).join((TableLike)rs).on(Tables.REQUIREMENT_VERSION.RES_ID.eq(rs.field("RES_ID", Long.class))).join((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq(rs.field("RES_ID", Long.class))).join((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).join((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).leftJoin(success).on(success.field("ID", Integer.class).eq(rs.field("RES_ID", Integer.class)).and(success.field("CAMPAIGN_ID", Long.class).eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID))).leftJoin(failure).on(failure.field("ID", Integer.class).eq(rs.field("RES_ID", Integer.class)).and(failure.field("CAMPAIGN_ID", Long.class).eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID))).leftJoin(untestable).on(untestable.field("ID", Integer.class).eq(rs.field("RES_ID", Integer.class)).and(untestable.field("CAMPAIGN_ID", Long.class).eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID))).leftJoin(blocked).on(blocked.field("ID", Integer.class).eq(rs.field("RES_ID", Integer.class)).and(blocked.field("CAMPAIGN_ID", Long.class).eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID))).leftJoin(settled).on(settled.field("ID", Integer.class).eq(rs.field("RES_ID", Integer.class)).and(settled.field("CAMPAIGN_ID", Long.class).eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID))).leftJoin(running).on(running.field("ID", Integer.class).eq(rs.field("RES_ID", Integer.class)).and(running.field("CAMPAIGN_ID", Long.class).eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID))).leftJoin(ready).on(ready.field("ID", Integer.class).eq(rs.field("RES_ID", Integer.class)).and(ready.field("CAMPAIGN_ID", Long.class).eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID))).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.in(campaignIds)).orderBy((OrderField)rs.field("NAME"));
        List results = query.fetchInto(QuaCoverageRequirementDto.class);
        return results.stream().collect(Collectors.groupingBy(QuaCoverageRequirementDto::getCampaignId));
    }

    public Table<Record3<Long, Integer, Long>> campaignStatusSubquery(List<Long> campaignIds, String alias, List<ExecutionStatus> execStatuses) {
        List<String> statuses = execStatuses.stream().map(Enum::name).toList();
        Condition statusCondition = Tables.TEST_PLAN_ITEM.EXECUTION_STATUS.in(statuses);
        return this.dsl.selectDistinct((SelectField)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.as("CAMPAIGN_ID"), (SelectField)DSL.count().as("COUNTS"), (SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.as("ID")).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).leftJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID)).leftJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.ITERATION).on(Tables.ITERATION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).leftJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).where(statusCondition.and(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.in(campaignIds))).groupBy(new GroupField[]{Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID, Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID}).asTable(alias);
    }

    public List<QuaCoverageIterationDto> getIterationsByCampaignIds(List<Long> campaignIds) {
        return this.dsl.selectDistinct((SelectField)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID, (SelectField)Tables.CAMPAIGN_ITERATION.ITERATION_ID, (SelectField)Tables.ITERATION.NAME.as("ITERATION_NAME"), (SelectField)Tables.CAMPAIGN_ITERATION.ITERATION_ORDER).from((TableLike)Tables.CAMPAIGN_ITERATION).leftJoin((TableLike)Tables.ITERATION).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.in(campaignIds)).orderBy((OrderField)Tables.CAMPAIGN_ITERATION.ITERATION_ORDER).fetchInto(QuaCoverageIterationDto.class);
    }

    public Map<Long, List<QuaCoverageRequirementDto>> fetchCoverageByIterations(List<Long> iterationIds) {
        Table<Record3<Long, Integer, Long>> success = this.iterationStatusSubquery(iterationIds, ExecutionStatus.SUCCESS.toString(), List.of(ExecutionStatus.SUCCESS, ExecutionStatus.WARNING));
        Table<Record3<Long, Integer, Long>> failure = this.iterationStatusSubquery(iterationIds, ExecutionStatus.FAILURE.toString(), List.of(ExecutionStatus.FAILURE));
        Table<Record3<Long, Integer, Long>> untestable = this.iterationStatusSubquery(iterationIds, ExecutionStatus.UNTESTABLE.toString(), List.of(ExecutionStatus.UNTESTABLE));
        Table<Record3<Long, Integer, Long>> blocked = this.iterationStatusSubquery(iterationIds, ExecutionStatus.BLOCKED.toString(), List.of(ExecutionStatus.BLOCKED));
        Table<Record3<Long, Integer, Long>> settled = this.iterationStatusSubquery(iterationIds, ExecutionStatus.SETTLED.toString(), List.of(ExecutionStatus.SETTLED));
        Table<Record3<Long, Integer, Long>> running = this.iterationStatusSubquery(iterationIds, ExecutionStatus.RUNNING.toString(), List.of(ExecutionStatus.RUNNING));
        Table<Record3<Long, Integer, Long>> ready = this.iterationStatusSubquery(iterationIds, ExecutionStatus.READY.toString(), List.of(ExecutionStatus.READY));
        Resource rs = Tables.RESOURCE.as("rs");
        SelectSeekStep1 query = this.dsl.selectDistinct((SelectField)Tables.ITERATION.ITERATION_ID, (SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.as("REQUIREMENT_ID"), (SelectField)rs.field("NAME").as("REQUIREMENT_NAME"), (SelectField)Tables.REQUIREMENT_VERSION.REFERENCE.as("REQUIREMENT_REF"), (SelectField)Tables.REQUIREMENT_VERSION.VERSION_NUMBER.as("REQUIREMENT_VERSION_NUMBER"), (SelectField)Tables.REQUIREMENT_VERSION.CRITICALITY.as("CRITICALITY"), (SelectField)DSL.coalesce((Field)success.field("COUNTS", Integer.class), (Object)0).as(ExecutionStatus.SUCCESS.toString()), (SelectField)DSL.coalesce((Field)failure.field("COUNTS", Integer.class), (Object)0).as(ExecutionStatus.FAILURE.toString()), (SelectField)DSL.coalesce((Field)untestable.field("COUNTS", Integer.class), (Object)0).as(ExecutionStatus.UNTESTABLE.toString()), (SelectField)DSL.coalesce((Field)blocked.field("COUNTS", Integer.class), (Object)0).as(ExecutionStatus.BLOCKED.toString()), (SelectField)DSL.coalesce((Field)running.field("COUNTS", Integer.class), (Object)0).as(ExecutionStatus.RUNNING.toString()), (SelectField)DSL.coalesce((Field)ready.field("COUNTS", Integer.class), (Object)0).as(ExecutionStatus.READY.toString()), (SelectField)DSL.coalesce((Field)settled.field("COUNTS", Integer.class), (Object)0).as(ExecutionStatus.SETTLED.toString())).from((TableLike)Tables.REQUIREMENT_VERSION).join((TableLike)rs).on(Tables.REQUIREMENT_VERSION.RES_ID.eq(rs.field("RES_ID", Long.class))).join((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq(rs.field("RES_ID", Long.class))).join((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).leftJoin(success).on(success.field("ID", Integer.class).eq(rs.field("RES_ID", Integer.class)).and(success.field("ITERATION_ID", Long.class).eq((Field)Tables.ITERATION.ITERATION_ID))).leftJoin(failure).on(failure.field("ID", Integer.class).eq(rs.field("RES_ID", Integer.class)).and(failure.field("ITERATION_ID", Long.class).eq((Field)Tables.ITERATION.TEST_PLAN_ID))).leftJoin(untestable).on(untestable.field("ID", Integer.class).eq(rs.field("RES_ID", Integer.class)).and(untestable.field("ITERATION_ID", Long.class).eq((Field)Tables.ITERATION.ITERATION_ID))).leftJoin(blocked).on(blocked.field("ID", Integer.class).eq(rs.field("RES_ID", Integer.class)).and(blocked.field("ITERATION_ID", Long.class).eq((Field)Tables.ITERATION.ITERATION_ID))).leftJoin(settled).on(settled.field("ID", Integer.class).eq(rs.field("RES_ID", Integer.class)).and(settled.field("ITERATION_ID", Long.class).eq((Field)Tables.ITERATION.ITERATION_ID))).leftJoin(running).on(running.field("ID", Integer.class).eq(rs.field("RES_ID", Integer.class)).and(running.field("ITERATION_ID", Long.class).eq((Field)Tables.ITERATION.ITERATION_ID))).leftJoin(ready).on(ready.field("ID", Integer.class).eq(rs.field("RES_ID", Integer.class)).and(ready.field("ITERATION_ID", Long.class).eq((Field)Tables.ITERATION.ITERATION_ID))).where(Tables.ITERATION.ITERATION_ID.in(iterationIds)).orderBy((OrderField)rs.field("NAME"));
        List results = query.fetchInto(QuaCoverageRequirementDto.class);
        return results.stream().collect(Collectors.groupingBy(QuaCoverageRequirementDto::getIterationId));
    }

    public Table<Record3<Long, Integer, Long>> iterationStatusSubquery(List<Long> iterationIds, String alias, List<ExecutionStatus> execStatuses) {
        List<String> statuses = execStatuses.stream().map(Enum::toString).toList();
        Condition statusCondition = Tables.TEST_PLAN_ITEM.EXECUTION_STATUS.in(statuses);
        return this.dsl.selectDistinct((SelectField)Tables.ITERATION.ITERATION_ID, (SelectField)DSL.count().as("COUNTS"), (SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.as("ID")).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).leftJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID)).leftJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.ITERATION).on(Tables.ITERATION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).where(statusCondition.and(Tables.ITERATION.ITERATION_ID.in(iterationIds))).groupBy(new GroupField[]{Tables.ITERATION.ITERATION_ID, Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID}).asTable(alias);
    }

    public List<QuaCoverageProjectDto> getProjectsByIds(List<Long> projectIds) {
        return this.dsl.selectDistinct((SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.PROJECT.NAME.as("PROJECT_NAME")).from((TableLike)Tables.PROJECT).where(Tables.PROJECT.PROJECT_ID.in(projectIds)).and(Tables.PROJECT.PROJECT_TYPE.eq((Object)"P")).fetchInto(QuaCoverageProjectDto.class);
    }

    public Map<Long, List<String>> getDisabledExecutionStatus(List<Long> projectIds) {
        Result res = this.dsl.select((SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.DISABLED_EXECUTION_STATUS.EXECUTION_STATUS).from((TableLike)Tables.DISABLED_EXECUTION_STATUS).join((TableLike)Tables.PROJECT).on(Tables.DISABLED_EXECUTION_STATUS.CL_ID.eq((Field)Tables.PROJECT.CL_ID)).where(Tables.PROJECT.PROJECT_ID.in(projectIds)).fetch();
        return res.stream().collect(Collectors.groupingBy(r -> (Long)r.get((Field)Tables.PROJECT.PROJECT_ID), Collectors.mapping(r -> (String)r.get((Field)Tables.DISABLED_EXECUTION_STATUS.EXECUTION_STATUS), Collectors.toList())));
    }

    public List<Long> getProjectIdsByMilestoneIds(List<Integer> milestoneIds) {
        return this.dsl.selectDistinct((SelectField)Tables.PROJECT.PROJECT_ID).from((TableLike)Tables.PROJECT).leftJoin((TableLike)Tables.MILESTONE_BINDING).on(Tables.MILESTONE_BINDING.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_BINDING.MILESTONE_ID)).where(Tables.PROJECT.PROJECT_TYPE.eq((Object)"P")).and(Tables.MILESTONE.MILESTONE_ID.in(milestoneIds)).fetch().getValues((Field)Tables.PROJECT.PROJECT_ID);
    }

    public String getMilestoneLabel(Integer milestoneId) {
        return (String)this.dsl.select((SelectField)Tables.MILESTONE.LABEL).from((TableLike)Tables.MILESTONE).where(Tables.MILESTONE.MILESTONE_ID.eq((Object)milestoneId)).fetchOne((Field)Tables.MILESTONE.LABEL);
    }

    public List<QuaCoverageTestSuiteDto> getTestSuitesByIterationIds(List<Long> iterationIds) {
        return this.dsl.selectDistinct((SelectField)Tables.ITERATION_TEST_SUITE.ITERATION_ID, (SelectField)Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID, (SelectField)Tables.TEST_SUITE.NAME.as("TEST_SUITE_NAME"), (SelectField)Tables.ITERATION_TEST_SUITE.ITERATION_ID).from((TableLike)Tables.ITERATION_TEST_SUITE).leftJoin((TableLike)Tables.TEST_SUITE).on(Tables.TEST_SUITE.ID.eq((Field)Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID)).where(Tables.ITERATION_TEST_SUITE.ITERATION_ID.in(iterationIds)).fetchInto(QuaCoverageTestSuiteDto.class);
    }

    public Map<Long, List<QuaCoverageRequirementDto>> fetchCoverageByTestSuites(List<Long> testSuiteIds) {
        Table<Record3<Long, Integer, Long>> success = this.testSuiteStatusSubquery(testSuiteIds, ExecutionStatus.SUCCESS.toString(), List.of(ExecutionStatus.SUCCESS, ExecutionStatus.WARNING));
        Table<Record3<Long, Integer, Long>> failure = this.testSuiteStatusSubquery(testSuiteIds, ExecutionStatus.FAILURE.toString(), List.of(ExecutionStatus.FAILURE));
        Table<Record3<Long, Integer, Long>> untestable = this.testSuiteStatusSubquery(testSuiteIds, ExecutionStatus.UNTESTABLE.toString(), List.of(ExecutionStatus.UNTESTABLE));
        Table<Record3<Long, Integer, Long>> blocked = this.testSuiteStatusSubquery(testSuiteIds, ExecutionStatus.BLOCKED.toString(), List.of(ExecutionStatus.BLOCKED));
        Table<Record3<Long, Integer, Long>> settled = this.testSuiteStatusSubquery(testSuiteIds, ExecutionStatus.SETTLED.toString(), List.of(ExecutionStatus.SETTLED));
        Table<Record3<Long, Integer, Long>> running = this.testSuiteStatusSubquery(testSuiteIds, ExecutionStatus.RUNNING.toString(), List.of(ExecutionStatus.RUNNING));
        Table<Record3<Long, Integer, Long>> ready = this.testSuiteStatusSubquery(testSuiteIds, ExecutionStatus.READY.toString(), List.of(ExecutionStatus.READY));
        Resource rs = Tables.RESOURCE.as("rs");
        SelectSeekStep1 query = this.dsl.selectDistinct((SelectField)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID, (SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.as("REQUIREMENT_ID"), (SelectField)rs.field("NAME").as("REQUIREMENT_NAME"), (SelectField)Tables.REQUIREMENT_VERSION.REFERENCE.as("REQUIREMENT_REF"), (SelectField)Tables.REQUIREMENT_VERSION.VERSION_NUMBER.as("REQUIREMENT_VERSION_NUMBER"), (SelectField)Tables.REQUIREMENT_VERSION.CRITICALITY.as("CRITICALITY"), (SelectField)DSL.coalesce((Field)success.field("COUNTS", Integer.class), (Object)0).as(ExecutionStatus.SUCCESS.toString()), (SelectField)DSL.coalesce((Field)failure.field("COUNTS", Integer.class), (Object)0).as(ExecutionStatus.FAILURE.toString()), (SelectField)DSL.coalesce((Field)untestable.field("COUNTS", Integer.class), (Object)0).as(ExecutionStatus.UNTESTABLE.toString()), (SelectField)DSL.coalesce((Field)blocked.field("COUNTS", Integer.class), (Object)0).as(ExecutionStatus.BLOCKED.toString()), (SelectField)DSL.coalesce((Field)running.field("COUNTS", Integer.class), (Object)0).as(ExecutionStatus.RUNNING.toString()), (SelectField)DSL.coalesce((Field)ready.field("COUNTS", Integer.class), (Object)0).as(ExecutionStatus.READY.toString()), (SelectField)DSL.coalesce((Field)settled.field("COUNTS", Integer.class), (Object)0).as(ExecutionStatus.SETTLED.toString())).from((TableLike)Tables.REQUIREMENT_VERSION).join((TableLike)rs).on(Tables.REQUIREMENT_VERSION.RES_ID.eq(rs.field("RES_ID", Long.class))).join((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq(rs.field("RES_ID", Long.class))).join((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).join((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).leftJoin(success).on(success.field("ID", Integer.class).eq(rs.field("RES_ID", Integer.class)).and(success.field("SUITE_ID", Long.class).eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID))).leftJoin(failure).on(failure.field("ID", Integer.class).eq(rs.field("RES_ID", Integer.class)).and(failure.field("SUITE_ID", Long.class).eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID))).leftJoin(untestable).on(untestable.field("ID", Integer.class).eq(rs.field("RES_ID", Integer.class)).and(untestable.field("SUITE_ID", Long.class).eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID))).leftJoin(blocked).on(blocked.field("ID", Integer.class).eq(rs.field("RES_ID", Integer.class)).and(blocked.field("SUITE_ID", Long.class).eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID))).leftJoin(settled).on(settled.field("ID", Integer.class).eq(rs.field("RES_ID", Integer.class)).and(settled.field("SUITE_ID", Long.class).eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID))).leftJoin(running).on(running.field("ID", Integer.class).eq(rs.field("RES_ID", Integer.class)).and(running.field("SUITE_ID", Long.class).eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID))).leftJoin(ready).on(ready.field("ID", Integer.class).eq(rs.field("RES_ID", Integer.class)).and(ready.field("SUITE_ID", Long.class).eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID))).where(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.in(testSuiteIds)).orderBy((OrderField)rs.field("NAME"));
        List results = query.fetchInto(QuaCoverageRequirementDto.class);
        return results.stream().collect(Collectors.groupingBy(QuaCoverageRequirementDto::getSuiteId));
    }

    public Table<Record3<Long, Integer, Long>> testSuiteStatusSubquery(List<Long> testSuiteIds, String alias, List<ExecutionStatus> execStatuses) {
        List<String> statuses = execStatuses.stream().map(Enum::toString).toList();
        Condition statusCondition = Tables.TEST_PLAN_ITEM.EXECUTION_STATUS.in(statuses);
        return this.dsl.selectDistinct((SelectField)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID, (SelectField)DSL.count().as("COUNTS"), (SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.as("ID")).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).leftJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID)).leftJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).where(statusCondition.and(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.in(testSuiteIds))).groupBy(new GroupField[]{Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID, Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID}).asTable(alias);
    }
}

