/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.importer;

import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNodeVisitor;
import org.squashtest.tm.service.importer.ImportSummary;
import org.squashtest.tm.service.internal.importer.ImportSummaryImpl;
import org.squashtest.tm.service.internal.library.LibraryUtils;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;

class TestCaseLibraryMerger {
    private TestCaseLibraryNavigationService service;
    private ImportSummaryImpl summary = new ImportSummaryImpl();
    private Deque<FolderPair> nonTreated = new LinkedList<FolderPair>();
    private NodeMerger merger = new NodeMerger();

    public TestCaseLibraryMerger() {
    }

    public TestCaseLibraryMerger(TestCaseLibraryNavigationService service) {
        this();
        this.service = service;
    }

    public void setLibraryService(TestCaseLibraryNavigationService service) {
        this.service = service;
    }

    public ImportSummary getSummary() {
        return this.summary;
    }

    public void mergeIntoLibrary(TestCaseLibrary dest, TestCaseFolder src) {
        this.merger.setMergingContext(this);
        this.merger.setDestination(dest);
        for (TestCaseLibraryNode node : src.getContent()) {
            node.accept((TestCaseLibraryNodeVisitor)this.merger);
        }
        while (!this.nonTreated.isEmpty()) {
            FolderPair pair = this.nonTreated.removeFirst();
            this.merger.setDestination(pair.dest);
            for (TestCaseLibraryNode node : pair.src.getContent()) {
                node.accept((TestCaseLibraryNodeVisitor)this.merger);
            }
        }
    }

    private static List<String> collectNames(Collection<TestCaseLibraryNode> nodes) {
        LinkedList<String> res = new LinkedList<String>();
        for (TestCaseLibraryNode node : nodes) {
            res.add(node.getName());
        }
        return res;
    }

    private static String generateUniqueName(List<String> pickedNames, String baseName) {
        String copyToken = "-import";
        return LibraryUtils.generateUniqueName(pickedNames, baseName, copyToken, 255);
    }

    private static class DestinationManager {
        protected TestCaseLibraryMerger context;
        protected TestCaseLibrary destLibrary;
        protected TestCaseFolder destFolder;

        private DestinationManager() {
        }

        public void setMergingContext(TestCaseLibraryMerger merger) {
            this.context = merger;
        }

        public void setDestination(TestCaseLibrary library) {
            this.destLibrary = library;
            this.destFolder = null;
        }

        public void setDestination(TestCaseFolder folder) {
            this.destFolder = folder;
            this.destLibrary = null;
        }

        protected Collection<TestCaseLibraryNode> getDestinationContent() {
            if (this.destLibrary != null) {
                return this.destLibrary.getRootContent();
            }
            return this.destFolder.getContent();
        }

        protected void persistTestCase(TestCase tc) {
            if (this.destLibrary != null) {
                this.context.service.addTestCaseToLibrary(this.destLibrary.getId(), tc, null);
            } else {
                this.context.service.addTestCaseToFolder(this.destFolder.getId(), tc, null);
            }
        }

        protected void persistFolder(TestCaseFolder folder) {
            if (this.destLibrary != null) {
                this.context.service.addFolderToLibrary((long)this.destLibrary.getId(), folder);
            } else {
                this.context.service.addFolderToFolder((long)this.destFolder.getId(), folder);
            }
        }

        protected void applyConfigurationTo(DestinationManager otherManager) {
            otherManager.setMergingContext(this.context);
            if (this.destLibrary != null) {
                otherManager.setDestination(this.destLibrary);
            } else {
                otherManager.setDestination(this.destFolder);
            }
        }
    }

    private static class FolderMerger
    extends DestinationManager
    implements TestCaseLibraryNodeVisitor {
        private TestCaseFolder toMerge;

        private FolderMerger() {
        }

        public void setTransientFolder(TestCaseFolder folder) {
            this.toMerge = folder;
        }

        public void merge() {
            List<String> names = TestCaseLibraryMerger.collectNames(this.getDestinationContent());
            if (names.contains(this.toMerge.getName())) {
                TestCaseLibraryNode conflictingNode = FolderMerger.getByName(this.getDestinationContent(), this.toMerge.getName());
                conflictingNode.accept((TestCaseLibraryNodeVisitor)this);
            } else {
                this.persistFolder(this.toMerge);
            }
        }

        private static TestCaseLibraryNode getByName(Collection<TestCaseLibraryNode> hayStack, String needle) {
            for (TestCaseLibraryNode node : hayStack) {
                if (!node.getName().equals(needle)) continue;
                return node;
            }
            throw new IllegalArgumentException("that method should never have been called if not preceeded by a preventive call to collectName().contains() or if this preventive call returned false - something is wrong with your code dude ");
        }

        public void visit(TestCase persisted) {
            List<String> allNames = TestCaseLibraryMerger.collectNames(this.getDestinationContent());
            String newName = TestCaseLibraryMerger.generateUniqueName(allNames, this.toMerge.getName());
            this.toMerge.setName(newName);
            this.context.summary.incrRenamed();
            this.persistFolder(this.toMerge);
        }

        public void visit(TestCaseFolder persisted) {
            FolderPair pair = new FolderPair(persisted, this.toMerge);
            this.context.nonTreated.add(pair);
        }
    }

    private static class FolderPair {
        private TestCaseFolder dest;
        private TestCaseFolder src;

        public FolderPair(TestCaseFolder dest, TestCaseFolder src) {
            this.dest = dest;
            this.src = src;
        }
    }

    private static class NodeMerger
    extends DestinationManager
    implements TestCaseLibraryNodeVisitor {
        private TestCaseMerger tcMerger = new TestCaseMerger();
        private FolderMerger fMerger = new FolderMerger();

        private NodeMerger() {
        }

        public void visit(TestCase visited) {
            this.applyConfigurationTo(this.tcMerger);
            this.tcMerger.setTransientTestCase(visited);
            this.tcMerger.merge();
        }

        public void visit(TestCaseFolder visited) {
            this.applyConfigurationTo(this.fMerger);
            this.fMerger.setTransientFolder(visited);
            this.fMerger.merge();
        }
    }

    private static class TestCaseMerger
    extends DestinationManager {
        private TestCase toMerge;

        private TestCaseMerger() {
        }

        public void setTransientTestCase(TestCase tc) {
            this.toMerge = tc;
        }

        public void merge() {
            List<String> names = TestCaseLibraryMerger.collectNames(this.getDestinationContent());
            if (names.contains(this.toMerge.getName())) {
                String newName = TestCaseLibraryMerger.generateUniqueName(names, this.toMerge.getName());
                this.toMerge.setName(newName);
                this.context.summary.incrRenamed();
            }
            try {
                this.persistTestCase(this.toMerge);
            }
            catch (Exception exception) {
                this.context.summary.incrFailures();
            }
        }
    }
}

