/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.execution.remoteissue;

import java.util.List;
import java.util.Locale;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.csp.core.bugtracker.core.BugTrackerManagerException;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.servers.AuthenticationStatus;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.users.PartyPreference;
import org.squashtest.tm.domain.users.preferences.CorePartyPreference;
import org.squashtest.tm.exception.bugtracker.BugTrackerManagerActionException;
import org.squashtest.tm.service.bugtracker.BugTrackersLocalService;
import org.squashtest.tm.service.bugtracker.BugTrackersService;
import org.squashtest.tm.service.bugtracker.knownissues.remote.RemoteKnownIssue;
import org.squashtest.tm.service.bugtracker.knownissues.remote.RemoteKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.BugTrackerConnectorFactory;
import org.squashtest.tm.service.internal.bugtracker.knownissues.remote.RemoteKnownIssuesGridResponseBuilder;
import org.squashtest.tm.service.internal.display.dto.IssuesPanelModel;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.remoteissue.RemoteIssueDisplayService;
import org.squashtest.tm.service.user.PartyPreferenceService;

@Service
@Transactional
public class RemoteIssueDisplayServiceImpl
implements RemoteIssueDisplayService {
    private final BugTrackerConnectorFactory btFactory;
    private final PartyPreferenceService partyPreferenceService;
    private final BugTrackersLocalService bugTrackersLocalService;
    private final BugTrackersService bugTrackersService;
    private final RemoteKnownIssueFinder remoteKnownIssueFinder;
    private final RemoteKnownIssuesGridResponseBuilder remoteKnownIssuesGridResponseBuilder;

    public RemoteIssueDisplayServiceImpl(BugTrackerConnectorFactory btFactory, PartyPreferenceService partyPreferenceService, BugTrackersLocalService bugTrackersLocalService, BugTrackersService bugTrackersService, RemoteKnownIssueFinder remoteKnownIssueFinder, RemoteKnownIssuesGridResponseBuilder remoteKnownIssuesGridResponseBuilder) {
        this.btFactory = btFactory;
        this.partyPreferenceService = partyPreferenceService;
        this.bugTrackersLocalService = bugTrackersLocalService;
        this.bugTrackersService = bugTrackersService;
        this.remoteKnownIssueFinder = remoteKnownIssueFinder;
        this.remoteKnownIssuesGridResponseBuilder = remoteKnownIssuesGridResponseBuilder;
    }

    @Override
    public IssuesPanelModel getIssuesPanelModel(GenericProject project, Locale locale) {
        BugTracker bugtracker = project.findBugTracker();
        AuthenticationStatus status = this.checkStatus(bugtracker, project.getId());
        BugTrackerInterfaceDescriptor descriptor = this.bugTrackersLocalService.getInterfaceDescriptor(bugtracker);
        descriptor.setLocale(locale);
        IssuesPanelModel issuesPanelModel = new IssuesPanelModel();
        issuesPanelModel.setProjectId(project.getId());
        issuesPanelModel.setBugTrackerStatus(status);
        issuesPanelModel.setOslc(this.btFactory.isOslcConnector(bugtracker.getKind()));
        PartyPreference modePreference = this.partyPreferenceService.findPreferenceForCurrentUser(CorePartyPreference.BUGTRACKER_MODE.getPreferenceKey());
        if (modePreference != null) {
            issuesPanelModel.setBugTrackerMode(modePreference.getPreferenceValue());
        }
        return issuesPanelModel;
    }

    @Override
    public GridResponse buildKnownIssuesGrid(String entityType, long entityId, PagingAndSorting sorter, GridRequest gridRequest) {
        List<RemoteKnownIssue> knownIssues = this.remoteKnownIssueFinder.findByEntityType(entityType, entityId, sorter);
        int totalCount = this.remoteKnownIssueFinder.getCountByEntityType(entityType, entityId);
        return this.remoteKnownIssuesGridResponseBuilder.asKnownIssuesGridResponse(knownIssues, gridRequest, totalCount);
    }

    @Override
    public GridResponse buildAllKnownIssuesGrid(String entityType, long entityId) {
        List<RemoteKnownIssue> knownIssues = this.remoteKnownIssueFinder.findAllByEntityType(entityType, entityId);
        int totalCount = this.remoteKnownIssueFinder.getCountByEntityType(entityType, entityId);
        return this.remoteKnownIssuesGridResponseBuilder.asKnownIssuesGridResponseWithoutPaging(knownIssues, totalCount);
    }

    private AuthenticationStatus checkStatus(BugTracker bugTracker, long projectId) {
        AuthenticationStatus status = this.bugTrackersLocalService.checkBugTrackerStatus(projectId);
        if (status == AuthenticationStatus.AUTHENTICATED) {
            try {
                Credentials credentials = this.bugTrackersService.getCredentials(bugTracker);
                this.bugTrackersService.testCredentials(bugTracker, credentials);
            }
            catch (BugTrackerManagerException ex) {
                throw new BugTrackerManagerActionException(ex);
            }
        }
        return status;
    }
}

