/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto;

import org.squashtest.tm.api.plugin.EntityType;

public class TestPlanContextDTO {
    private final String entityType;
    private final String entityName;
    private final String entityPath;
    private final String entityUuid;
    private final String squashTMVersion;

    public TestPlanContextDTO(EntityType entityType, String entityName, String path, String entityUuid, String squashTMVersion) {
        this.entityUuid = entityUuid;
        TestPlanContextDTO.validate(entityType, entityName, path);
        this.entityName = entityName;
        this.entityType = this.normalizeEntityType(entityType);
        this.entityPath = this.getEntityPath(path, entityName);
        this.squashTMVersion = squashTMVersion;
    }

    private static void validate(EntityType entityType, String entityName, String path) {
        if (!entityType.equals((Object)EntityType.ITERATION) && !entityType.equals((Object)EntityType.TEST_SUITE)) {
            throw new IllegalArgumentException("Unsupported type " + String.valueOf(entityType));
        }
        if (path == null || path.isBlank()) {
            throw new IllegalArgumentException("Path cannot be blank.");
        }
        if (entityName == null || entityName.isBlank()) {
            throw new IllegalArgumentException("Entity name cannot be blank.");
        }
    }

    private String normalizeEntityType(EntityType entityType) {
        return entityType.name().toLowerCase().replace("_", " ");
    }

    private String getEntityPath(String path, String entityName) {
        return path + " > " + entityName;
    }

    public String getEntityUuid() {
        return this.entityUuid;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getEntityPath() {
        return this.entityPath;
    }

    public String getSquashTMVersion() {
        return this.squashTMVersion;
    }
}

