/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.sprint;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.synchronisation.SynchronisationKind;
import org.squashtest.tm.domain.users.PartyPreference;
import org.squashtest.tm.domain.users.preferences.CorePartyPreference;
import org.squashtest.tm.service.annotation.CheckEntityExists;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.campaign.SprintStatisticsService;
import org.squashtest.tm.service.customreport.CustomReportDashboardService;
import org.squashtest.tm.service.display.sprint.SprintDisplayService;
import org.squashtest.tm.service.display.sprint.SprintReqVersionDisplayService;
import org.squashtest.tm.service.grid.GridConfigurationService;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.SprintKnownIssueFinder;
import org.squashtest.tm.service.internal.display.campaign.ReadUnassignedTestPlanHelper;
import org.squashtest.tm.service.internal.display.dto.AttachmentListDto;
import org.squashtest.tm.service.internal.display.dto.UserView;
import org.squashtest.tm.service.internal.display.dto.sprint.SprintDto;
import org.squashtest.tm.service.internal.display.dto.sprint.SprintReqVersionDto;
import org.squashtest.tm.service.internal.library.EntityPathHeaderService;
import org.squashtest.tm.service.internal.repository.display.AttachmentDisplayDao;
import org.squashtest.tm.service.internal.repository.display.SprintDisplayDao;
import org.squashtest.tm.service.statistics.sprint.SprintStatisticsBundle;
import org.squashtest.tm.service.testplanitem.TestPlanItemAssignableUserFinder;
import org.squashtest.tm.service.user.PartyPreferenceService;

@Service
@Transactional(readOnly=true)
public class SprintDisplayServiceImpl
implements SprintDisplayService {
    private final SprintDisplayDao sprintDisplayDao;
    private final AttachmentDisplayDao attachmentDisplayDao;
    private final EntityPathHeaderService entityPathHeaderService;
    private final SprintKnownIssueFinder sprintKnownIssueFinder;
    private final TestPlanItemAssignableUserFinder testPlanItemAssignableUserFinder;
    private final ReadUnassignedTestPlanHelper readUnassignedTestPlanHelper;
    private final SprintReqVersionDisplayService sprintReqVersionDisplayService;
    private final CustomReportDashboardService customReportDashboardService;
    private final PartyPreferenceService partyPreferenceService;
    private final SprintStatisticsService sprintStatisticsService;
    private final GridConfigurationService gridConfigurationService;

    public SprintDisplayServiceImpl(SprintDisplayDao sprintDisplayDao, AttachmentDisplayDao attachmentDisplayDao, EntityPathHeaderService entityPathHeaderService, SprintKnownIssueFinder sprintKnownIssueFinder, TestPlanItemAssignableUserFinder testPlanItemAssignableUserFinder, ReadUnassignedTestPlanHelper readUnassignedTestPlanHelper, SprintReqVersionDisplayService sprintReqVersionDisplayService, CustomReportDashboardService customReportDashboardService, PartyPreferenceService partyPreferenceService, SprintStatisticsService sprintStatisticsService, GridConfigurationService gridConfigurationService) {
        this.sprintDisplayDao = sprintDisplayDao;
        this.entityPathHeaderService = entityPathHeaderService;
        this.attachmentDisplayDao = attachmentDisplayDao;
        this.sprintKnownIssueFinder = sprintKnownIssueFinder;
        this.testPlanItemAssignableUserFinder = testPlanItemAssignableUserFinder;
        this.readUnassignedTestPlanHelper = readUnassignedTestPlanHelper;
        this.sprintReqVersionDisplayService = sprintReqVersionDisplayService;
        this.customReportDashboardService = customReportDashboardService;
        this.partyPreferenceService = partyPreferenceService;
        this.sprintStatisticsService = sprintStatisticsService;
        this.gridConfigurationService = gridConfigurationService;
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintId, 'org.squashtest.tm.domain.campaign.Sprint' ,'READ')  or hasRole('ROLE_ADMIN')")
    @CheckEntityExists(entityType=Sprint.class)
    public SprintDto getSprintView(@Id long sprintId) {
        SprintDto sprintDto = this.sprintDisplayDao.getSprintDtoById(sprintId);
        if (SynchronisationKind.XSQUASH4JIRA.getName().equals(sprintDto.getSynchronisationKind())) {
            this.translateJiraRemoteStateIntoSquashStatus(sprintDto);
        }
        AttachmentListDto attachmentList = this.attachmentDisplayDao.findAttachmentListById(sprintDto.getAttachmentListId());
        sprintDto.setAttachmentList(attachmentList);
        sprintDto.setBreadcrumbs(this.entityPathHeaderService.getCampaignLibraryNodeHeaderBreadcrumbs(sprintId, true));
        List<SprintReqVersionDto> sprintReqVersions = this.sprintReqVersionDisplayService.findSprintReqVersionDtosBySprintId(sprintId);
        sprintDto.setSprintReqVersions(sprintReqVersions);
        int nbIssues = this.sprintKnownIssueFinder.countKnownIssues(sprintId);
        sprintDto.setNbIssues(nbIssues);
        sprintDto.setNbTestPlanItems(this.countTestPlanItems(sprintId));
        sprintDto.setAssignableUsers(UserView.fromEntities(this.testPlanItemAssignableUserFinder.findAssignableUsersByCampaignLibraryId(sprintDto.getCampaignLibraryId())));
        List<String> activeColumnIds = this.gridConfigurationService.findActiveColumnIdsForUserWithProjectId("sprint-req-versions-linked", sprintDto.getProjectId());
        sprintDto.setActiveColumnIds(activeColumnIds);
        this.setFavoriteDashboardPreferencesOnSprintDto(sprintDto);
        return sprintDto;
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintId, 'org.squashtest.tm.domain.campaign.Sprint' ,'READ')  or hasRole('ROLE_ADMIN')")
    public SprintStatisticsBundle getSprintStatistics(long sprintId, String syncPluginId, boolean lastExecutionScope) {
        return this.sprintStatisticsService.gatherSprintStatisticsBundle(sprintId, syncPluginId, lastExecutionScope);
    }

    private void setFavoriteDashboardPreferencesOnSprintDto(SprintDto sprintDto) {
        sprintDto.setCanShowFavoriteDashboard(this.customReportDashboardService.canShowDashboardInWorkspace(Workspace.CAMPAIGN));
        sprintDto.setShouldShowFavoriteDashboard(this.customReportDashboardService.shouldShowFavoriteDashboardInWorkspace(Workspace.CAMPAIGN));
        PartyPreference preference = this.partyPreferenceService.findPreferenceForCurrentUser(CorePartyPreference.FAVORITE_DASHBOARD_CAMPAIGN.getPreferenceKey());
        if (preference != null) {
            Long dashboardId = Long.valueOf(preference.getPreferenceValue());
            sprintDto.setFavoriteDashboardId(dashboardId);
        }
    }

    private void translateJiraRemoteStateIntoSquashStatus(SprintDto sprintDto) {
        SprintStatus remoteState = sprintDto.getRemoteState();
        if (remoteState == SprintStatus.FUTURE) {
            sprintDto.setRemoteState(SprintStatus.UPCOMING);
        } else if (remoteState == SprintStatus.ACTIVE) {
            sprintDto.setRemoteState(SprintStatus.OPEN);
        }
    }

    private int countTestPlanItems(long sprintId) {
        String userToRestrictTo = this.readUnassignedTestPlanHelper.getUserToRestrictTo(sprintId, Sprint.class.getName());
        return this.sprintDisplayDao.countTestPlanItems(sprintId, userToRestrictTo);
    }
}

