/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.profile;

import jakarta.persistence.EntityNotFoundException;
import java.util.List;
import java.util.Objects;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.acl.AclGroup;
import org.squashtest.tm.service.annotation.CheckEntityExists;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.display.profile.ProfileDisplayService;
import org.squashtest.tm.service.internal.display.dto.PermissionsDto;
import org.squashtest.tm.service.internal.display.dto.ProfileAdminViewDto;
import org.squashtest.tm.service.internal.display.dto.ProfileDto;
import org.squashtest.tm.service.internal.display.dto.ProfilePermissionsDto;
import org.squashtest.tm.service.internal.repository.display.ProfileDisplayDao;
import org.squashtest.tm.service.license.UltimateLicenseAvailabilityService;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service
@Transactional(readOnly=true)
public class ProfileDisplayServiceImpl
implements ProfileDisplayService {
    private final ProfileDisplayDao profileDisplayDao;
    private final PermissionEvaluationService permissionEvaluationService;
    private final UltimateLicenseAvailabilityService ultimateLicenseService;

    public ProfileDisplayServiceImpl(ProfileDisplayDao profileDisplayDao, PermissionEvaluationService permissionEvaluationService, UltimateLicenseAvailabilityService ultimateLicenseService) {
        this.profileDisplayDao = profileDisplayDao;
        this.permissionEvaluationService = permissionEvaluationService;
        this.ultimateLicenseService = ultimateLicenseService;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public List<ProfileDto> findAll() {
        return this.profileDisplayDao.findAll();
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @CheckEntityExists(entityType=AclGroup.class)
    public ProfileAdminViewDto getProfileView(@Id long profileId) {
        ProfileAdminViewDto profile = this.profileDisplayDao.findProfileAdminViewDto(profileId);
        if (Objects.isNull(profile)) {
            throw new EntityNotFoundException(String.format("%s %d %s", "Profile with id", profileId, "not found."));
        }
        profile.setPermissions(this.profileDisplayDao.fetchProfilePermissions(profileId));
        profile.setPartyProfileAuthorizations(this.profileDisplayDao.fetchPartyProfileAuthorizations(profileId));
        return profile;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public List<PermissionsDto> getPermissions(long profileId) {
        return this.profileDisplayDao.fetchProfilePermissions(profileId);
    }

    @Override
    public List<ProfilePermissionsDto> getProfilesAndPermissions() {
        this.permissionEvaluationService.checkAtLeastOneClearanceManagementPermissionOrAdmin();
        List<ProfilePermissionsDto> profilesAndPermissions = this.profileDisplayDao.fetchProfilesAndPermissions();
        if (this.ultimateLicenseService.isAvailable()) {
            return profilesAndPermissions;
        }
        return profilesAndPermissions.stream().filter(profile -> AclGroup.isSystem((String)profile.profileName())).toList();
    }
}

