/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.search;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectSeekStepN;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.grid.AbstractGrid;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridSort;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;
import org.squashtest.tm.service.internal.display.grid.filters.collector.FilterRequirementSearchCollector;
import org.squashtest.tm.service.internal.display.grid.search.FieldTestCaseSearchSort;

public class TestCaseThroughRequirementGrid
extends AbstractGrid {
    private final Map<EntityType, List<Long>> entityReferenceFromScope;

    public TestCaseThroughRequirementGrid(Map<EntityType, List<Long>> entityReferenceFromScope) {
        this.entityReferenceFromScope = entityReferenceFromScope;
    }

    @Override
    protected Field<?> getIdentifier() {
        return Tables.TEST_CASE.TCLN_ID.as("ID");
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID;
    }

    @Override
    protected List<GridColumn> getColumns() {
        return List.of(new GridColumn((Field<?>)Tables.REQUIREMENT_VERSION.RES_ID.as("ID"), (Field<?>)Tables.REQUIREMENT_VERSION.RES_ID), new GridColumn((Field<?>)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.as("ID_LIST"), (Field<?>)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID), new GridColumn((Field<?>)Tables.REQUIREMENT_VERSION.REFERENCE), new GridColumn((Field<?>)Tables.RESOURCE.NAME), new GridColumn((Field<?>)Tables.RESOURCE.DESCRIPTION), new GridColumn((Field<?>)Tables.RESOURCE.CREATED_ON), new GridColumn((Field<?>)Tables.RESOURCE.CREATED_BY), new GridColumn((Field<?>)Tables.RESOURCE.LAST_MODIFIED_ON.as("MODIFIED_ON"), (Field<?>)Tables.RESOURCE.LAST_MODIFIED_ON), new GridColumn((Field<?>)Tables.RESOURCE.LAST_MODIFIED_BY.as("MODIFIED_BY"), (Field<?>)Tables.RESOURCE.LAST_MODIFIED_BY), new GridColumn((Field<?>)Tables.REQUIREMENT_VERSION.CRITICALITY), new GridColumn((Field<?>)Tables.REQUIREMENT_VERSION.CATEGORY), new GridColumn((Field<?>)Tables.REQUIREMENT_VERSION.REQUIREMENT_STATUS.as("STATUS"), (Field<?>)Tables.REQUIREMENT_VERSION.REQUIREMENT_STATUS), new GridColumn((Field<?>)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.as("HIGH_LEVEL_REQUIREMENT_ID"), (Field<?>)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID), new GridColumn((Field<?>)Tables.MILESTONE.MILESTONE_ID.as("MILESTONE_LABEL"), (Field<?>)Tables.MILESTONE.MILESTONE_ID), new GridColumn((Field<?>)Tables.MILESTONE.STATUS.as("MILESTONE_STATUS"), (Field<?>)Tables.MILESTONE.STATUS), new GridColumn((Field<?>)Tables.MILESTONE.END_DATE.as("MILESTONE_END_DATE"), (Field<?>)Tables.MILESTONE.END_DATE));
    }

    @Override
    protected Table<?> getTable() {
        return DSL.select((SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID, (SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).union((Select)DSL.select((SelectField)Tables.TEST_CASE.TCLN_ID, (SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).join((TableLike)Tables.CALL_TEST_STEP).on(Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID)).join((TableLike)Tables.TEST_CASE_STEPS).on(Tables.CALL_TEST_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID)).join((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE_STEPS.TEST_CASE_ID.eq((Field)Tables.TEST_CASE.TCLN_ID))).asTable();
    }

    @Override
    protected SelectSeekStepN<?> createQuery(GridRequest request, DSLContext dslContext) {
        List<FieldTestCaseSearchSort<?>> fieldTestCaseSearchSorts = this.getFieldTestCaseSearchSorts(request);
        List<Field> selectFields = fieldTestCaseSearchSorts.stream().map(FieldTestCaseSearchSort::getAliasField).toList();
        List<SortField> sortFields = fieldTestCaseSearchSorts.stream().map(FieldTestCaseSearchSort::getSortField).toList();
        return dslContext.select(selectFields).from(this.getTable()).join((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq(this.getTable().field((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID))).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).join((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq(this.getTable().field((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID))).join((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).join((TableLike)Tables.PROJECT).on(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).join((TableLike)Tables.RESOURCE).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).join((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).leftJoin((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID)).leftJoin((TableLike)Tables.SCRIPTED_TEST_CASE).on(Tables.SCRIPTED_TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.KEYWORD_TEST_CASE).on(Tables.KEYWORD_TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.EXPLORATORY_TEST_CASE).on(Tables.EXPLORATORY_TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID.eq((Field)Tables.TEST_CASE.AUTOMATION_REQUEST_ID)).leftJoin((TableLike)Tables.AUTOMATED_TEST).on(Tables.AUTOMATED_TEST.TEST_ID.eq((Field)Tables.TEST_CASE.TA_TEST)).leftJoin((TableLike)Tables.AUTOMATED_TEST_TECHNOLOGY).on(Tables.TEST_CASE.AUTOMATED_TEST_TECHNOLOGY.eq((Field)Tables.AUTOMATED_TEST_TECHNOLOGY.AT_TECHNOLOGY_ID)).leftJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).leftJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.MILESTONE_ID)).where(this.craftInvariantFilter()).and(this.craftVariableFilters(request)).groupBy(new GroupField[]{Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, Tables.TEST_CASE.TCLN_ID, Tables.PROJECT.PROJECT_ID, Tables.AUTOMATION_REQUEST.AUTOMATION_PRIORITY, Tables.AUTOMATION_REQUEST.TRANSMITTED_ON, Tables.AUTOMATION_REQUEST.REQUEST_STATUS, Tables.SCRIPTED_TEST_CASE.TCLN_ID, Tables.KEYWORD_TEST_CASE.TCLN_ID, Tables.EXPLORATORY_TEST_CASE.TCLN_ID, Tables.SCRIPTED_TEST_CASE.SCRIPT, Tables.AUTOMATED_TEST_TECHNOLOGY.NAME, Tables.AUTOMATED_TEST.TEST_ID}).orderBy(sortFields);
    }

    private List<FieldTestCaseSearchSort<?>> getFieldTestCaseSearchSorts(GridRequest request) {
        List<FieldTestCaseSearchSort<?>> fieldTestCaseSearchSorts = request.getSort().stream().map(FieldTestCaseSearchSort::getTestCaseSelectSearch).collect(Collectors.toList());
        this.addMissingField(fieldTestCaseSearchSorts, this.getIdentifier());
        this.addMissingField(fieldTestCaseSearchSorts, this.getProjectIdentifier());
        return fieldTestCaseSearchSorts;
    }

    private void addMissingField(List<FieldTestCaseSearchSort<?>> fieldSorts, Field<?> field) {
        boolean containsField;
        if (field != null && !(containsField = fieldSorts.stream().anyMatch(fieldSort -> fieldSort.getAliasField().equals((Object)field)))) {
            fieldSorts.add(new FieldTestCaseSearchSort(field, GridSort.SortDirection.ASC));
        }
    }

    @Override
    protected Condition craftInvariantFilter() {
        Map groupedIds = this.entityReferenceFromScope.entrySet().stream().collect(Collectors.groupingBy(entry -> this.convertToField((EntityType)entry.getKey()), Collectors.flatMapping(entry -> ((List)entry.getValue()).stream(), Collectors.toList())));
        return groupedIds.entrySet().stream().map(entry -> ((Field)entry.getKey()).in((Collection)entry.getValue())).reduce(DSL.noCondition(), Condition::or);
    }

    private Field<Long> convertToField(EntityType entityType) {
        return switch (entityType) {
            case EntityType.REQUIREMENT_LIBRARY -> Tables.PROJECT.RL_ID;
            case EntityType.HIGH_LEVEL_REQUIREMENT, EntityType.REQUIREMENT, EntityType.REQUIREMENT_FOLDER -> Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID;
            default -> throw new IllegalArgumentException("Unsupported entity type: " + String.valueOf(entityType));
        };
    }

    @Override
    protected Long countRows(DSLContext dslContext, GridRequest request) {
        return this.createQuery(request, dslContext).fetchStream().count();
    }

    @Override
    protected Condition craftVariableFilters(GridRequest request) {
        if (request.getFilterValues().isEmpty()) {
            return DSL.noCondition();
        }
        return request.getFilterValues().stream().collect(new FilterRequirementSearchCollector(this.aliasToFieldDictionary, request.isSearchOnMultiColumns()));
    }
}

