/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.execution;

import jakarta.persistence.EntityManager;
import java.util.List;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.ExploratorySessionOverview;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.exception.UnknownEntityException;
import org.squashtest.tm.service.display.execution.ExploratorySessionOverviewDisplayService;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.ExploratorySessionOverviewKnownIssueFinder;
import org.squashtest.tm.service.internal.display.dto.UserView;
import org.squashtest.tm.service.internal.display.dto.execution.ExploratorySessionOverviewView;
import org.squashtest.tm.service.internal.display.dto.execution.SessionNoteDto;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.campaign.ExploratorySessionExecutionGrid;
import org.squashtest.tm.service.internal.display.grid.campaign.TestPlanGridHelpers;
import org.squashtest.tm.service.internal.library.EntityPathHeaderService;
import org.squashtest.tm.service.internal.repository.display.AttachmentDisplayDao;
import org.squashtest.tm.service.internal.repository.display.ExploratorySessionOverviewDisplayDao;
import org.squashtest.tm.service.internal.repository.display.MilestoneDisplayDao;
import org.squashtest.tm.service.internal.repository.display.SessionNoteDisplayDao;
import org.squashtest.tm.service.internal.repository.display.SprintDisplayDao;
import org.squashtest.tm.service.testplanitem.TestPlanItemAssignableUserFinder;

@Service
@Transactional(readOnly=true)
public class ExploratorySessionOverviewDisplayServiceImpl
implements ExploratorySessionOverviewDisplayService {
    private final ExploratorySessionOverviewDisplayDao exploratorySessionOverviewDisplayDao;
    private final ExploratorySessionOverviewKnownIssueFinder exploratorySessionOverviewKnownIssueFinder;
    private final EntityPathHeaderService entityPathHeaderService;
    private final EntityManager entityManager;
    private final AttachmentDisplayDao attachmentDisplayDao;
    private final SessionNoteDisplayDao sessionNoteDisplayDao;
    private final MilestoneDisplayDao milestoneDisplayDao;
    private final SprintDisplayDao sprintDisplayDao;
    private final DSLContext dslContext;
    private final MessageSource messageSource;
    private final TestPlanItemAssignableUserFinder testPlanItemAssignableUserFinder;

    public ExploratorySessionOverviewDisplayServiceImpl(ExploratorySessionOverviewDisplayDao exploratorySessionOverviewDisplayDao, @Qualifier(value="exploratorySessionOverviewKnownIssueFinder") ExploratorySessionOverviewKnownIssueFinder exploratorySessionOverviewKnownIssueFinder, EntityPathHeaderService entityPathHeaderService, EntityManager entityManager, AttachmentDisplayDao attachmentDisplayDao, SessionNoteDisplayDao sessionNoteDisplayDao, MilestoneDisplayDao milestoneDisplayDao, SprintDisplayDao sprintDisplayDao, DSLContext dslContext, MessageSource messageSource, TestPlanItemAssignableUserFinder testPlanItemAssignableUserFinder) {
        this.exploratorySessionOverviewDisplayDao = exploratorySessionOverviewDisplayDao;
        this.exploratorySessionOverviewKnownIssueFinder = exploratorySessionOverviewKnownIssueFinder;
        this.entityPathHeaderService = entityPathHeaderService;
        this.entityManager = entityManager;
        this.attachmentDisplayDao = attachmentDisplayDao;
        this.sessionNoteDisplayDao = sessionNoteDisplayDao;
        this.milestoneDisplayDao = milestoneDisplayDao;
        this.dslContext = dslContext;
        this.messageSource = messageSource;
        this.testPlanItemAssignableUserFinder = testPlanItemAssignableUserFinder;
        this.sprintDisplayDao = sprintDisplayDao;
    }

    @Override
    public ExploratorySessionOverviewView findById(long overviewId) {
        ExploratorySessionOverviewView view = this.exploratorySessionOverviewDisplayDao.findById(overviewId);
        view.setBreadcrumbs(this.entityPathHeaderService.getExploratorySessionOverviewHeaderBreadcrumbs(overviewId));
        List<UserView> assignableUsers = UserView.fromEntities(this.testPlanItemAssignableUserFinder.findAssignableUsersByExploratorySessionOverviewId(overviewId));
        view.setAssignableUsers(assignableUsers);
        view.setInferredSessionReviewStatus(this.exploratorySessionOverviewDisplayDao.inferReviewStatus(overviewId));
        view.setNbIssues(this.exploratorySessionOverviewKnownIssueFinder.countKnownIssues(overviewId));
        view.setNbExecutions(this.getNbExecutions(overviewId));
        view.setNbNotes(this.getAllSessionNotes(overviewId).size());
        view.setAttachmentList(this.attachmentDisplayDao.findAttachmentListById(view.getAttachmentListId()));
        view.setMilestones(this.milestoneDisplayDao.getMilestonesBySessionOverviewId(view.getId()));
        view.setSprintStatus(this.sprintDisplayDao.getSprintStatusBySessionOverviewId(overviewId));
        return view;
    }

    private Integer getNbExecutions(long overviewId) {
        Integer executionCount = this.exploratorySessionOverviewDisplayDao.countExecutions(overviewId);
        return executionCount == null ? 0 : executionCount;
    }

    @Override
    public GridResponse getExecutionGrid(Long overviewId, GridRequest gridRequest) {
        ExploratorySessionExecutionGrid grid = new ExploratorySessionExecutionGrid(overviewId);
        GridResponse gridResponse = grid.getRows(gridRequest, this.dslContext);
        for (DataRow row : gridResponse.getDataRows()) {
            TestPlanGridHelpers.formatDeactivatedUserNameInRowData(row, this.messageSource);
        }
        return gridResponse;
    }

    @Override
    public Project findProjectBySessionOverviewId(Long overviewId) {
        Long projectId = this.exploratorySessionOverviewDisplayDao.findProjectIdBySessionOverviewId(overviewId);
        if (projectId == null) {
            throw new UnknownEntityException(overviewId.longValue(), ExploratorySessionOverview.class);
        }
        return (Project)this.entityManager.find(Project.class, (Object)projectId);
    }

    @Override
    public List<SessionNoteDto> getAllSessionNotes(Long overviewId) {
        return this.sessionNoteDisplayDao.fetchSessionNotesByOverviewId(overviewId);
    }

    @Override
    public List<UserView> getUnassignedUsers(Long overviewId) {
        List<Long> alreadyAssigned = this.exploratorySessionOverviewDisplayDao.findAlreadyAssignedUserIds(overviewId);
        List<User> assignableUsers = this.testPlanItemAssignableUserFinder.findAssignableUsersByExploratorySessionOverviewId(overviewId);
        return UserView.fromEntities(assignableUsers).stream().filter(user -> !alreadyAssigned.contains(user.getId())).toList();
    }
}

