/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.copier;

import com.google.common.collect.Lists;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.copier.CopierService;
import org.squashtest.tm.service.copier.StrategyCopierService;
import org.squashtest.tm.service.internal.copier.ChildEntityDtoResult;
import org.squashtest.tm.service.internal.copier.NodeCopierDto;
import org.squashtest.tm.service.internal.copier.copyloading.CopyLoadingEntities;
import org.squashtest.tm.service.internal.repository.hibernate.utils.HibernateConfig;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service
@Transactional
public class StrategyCopierServiceImpl
implements StrategyCopierService {
    private final PermissionEvaluationService permissionService;
    private final CopierService copierService;
    @PersistenceContext
    private EntityManager entityManager;

    public StrategyCopierServiceImpl(PermissionEvaluationService permissionService, CopierService copierService) {
        this.permissionService = permissionService;
        this.copierService = copierService;
    }

    @Override
    public Map<NodeType, List<Long>> getNodeIdsByNodeTypeToPaste(ClipboardPayload clipboardPayload) {
        return clipboardPayload.getSelectedNode().stream().collect(Collectors.groupingBy(NodeReference::getNodeType, Collectors.mapping(NodeReference::getId, Collectors.toList())));
    }

    @Override
    public void verifyPermission(Map<NodeType, List<Long>> nodePastes) {
        nodePastes.forEach((nodeType, nodeIds) -> this.permissionService.checkPermission((List<Long>)nodeIds, Permissions.READ.name(), nodeType.toEntityType().getEntityClass().getName()));
    }

    @Override
    public <CONTAINER, NODE extends TreeNode> void copyNodeToContainer(Long destinationId, NodeType nodeType, CopyLoadingEntities<CONTAINER, NODE> copyLoadingEntities) {
        NodeCopierDto nodeCopierDto = new NodeCopierDto();
        Map<NodeType, List<Long>> nodePastes = Map.of(nodeType, copyLoadingEntities.getClipboardPayload().getSelectedNodeIds());
        this.copyNodeToContainer(destinationId, nodePastes, copyLoadingEntities, nodeCopierDto);
    }

    @Override
    public <CONTAINER, NODE extends TreeNode> void copyNodeToContainer(Long destinationId, Map<NodeType, List<Long>> nodePastes, CopyLoadingEntities<CONTAINER, NODE> copyLoadingEntities) {
        NodeCopierDto nodeCopierDto = new NodeCopierDto();
        this.copyNodeToContainer(destinationId, nodePastes, copyLoadingEntities, nodeCopierDto);
    }

    @Override
    public <CONTAINER, NODE extends TreeNode> void copyNodeToContainer(Long destinationId, Map<NodeType, List<Long>> nodePastes, CopyLoadingEntities<CONTAINER, NODE> copyLoadingEntities, NodeCopierDto nodeCopierDto) {
        HibernateConfig.enableBatch(this.entityManager, StrategyCopierService.MAX_BATCH_SIZE);
        HashMap<String, Map<Long, Long>> pairingIdsSourceCopyNode = new HashMap<String, Map<Long, Long>>();
        CONTAINER container = copyLoadingEntities.loadContainer(destinationId);
        int countIds = 0;
        for (Map.Entry<NodeType, List<Long>> entry : nodePastes.entrySet()) {
            for (List ids : Lists.partition(entry.getValue(), (int)StrategyCopierService.MAX_BATCH_SIZE)) {
                if (countIds > 200) {
                    this.entityManager.clear();
                    container = copyLoadingEntities.loadContainer(destinationId);
                    countIds = 0;
                }
                List<NODE> nodes = copyLoadingEntities.loadNodes(entry.getKey().getTypeName(), ids);
                this.copierService.copyNodeToContainer((NodeContainer)container, nodes, pairingIdsSourceCopyNode, nodeCopierDto);
                countIds += StrategyCopierService.MAX_BATCH_SIZE.intValue();
            }
        }
        this.entityManager.clear();
        this.copyAllChildren(pairingIdsSourceCopyNode, nodeCopierDto, copyLoadingEntities);
    }

    private <CONTAINER, NODE extends TreeNode> void copyAllChildren(Map<String, Map<Long, Long>> pairingIdsSourceCopyNode, NodeCopierDto nodeCopierDto, CopyLoadingEntities<CONTAINER, NODE> copyLoadingEntities) {
        if (pairingIdsSourceCopyNode.isEmpty()) {
            return;
        }
        HashMap<String, Map<Long, Long>> pairingIdsSourceCopyNodeChild = new HashMap<String, Map<Long, Long>>();
        for (Map.Entry<String, Map<Long, Long>> entry : pairingIdsSourceCopyNode.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            Lists.partition(new ArrayList<Map.Entry<Long, Long>>(entry.getValue().entrySet()), (int)1000).forEach(entries -> {
                Map<Long, Long> pairs = entries.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                this.copyChildByEntities((String)entry.getKey(), pairs, pairingIdsSourceCopyNodeChild, nodeCopierDto, copyLoadingEntities);
            });
            entry.getValue().clear();
        }
        pairingIdsSourceCopyNode.clear();
        this.copyAllChildren(pairingIdsSourceCopyNodeChild, nodeCopierDto, copyLoadingEntities);
    }

    private <CONTAINER, NODE extends TreeNode> void copyChildByEntities(String entityClassName, Map<Long, Long> pairs, Map<String, Map<Long, Long>> pairingIdsSourceCopyNodeChild, NodeCopierDto nodeCopierDto, CopyLoadingEntities<CONTAINER, NODE> copyLoadingEntities) {
        ChildEntityDtoResult childEntityDtoResult;
        int offset = 0;
        do {
            childEntityDtoResult = copyLoadingEntities.loadChildNode(entityClassName, pairs.keySet(), offset);
            List<Long> ids = childEntityDtoResult.childEntityDtos().stream().map(childEntityDto -> {
                Long targetContainerId = (Long)pairs.get(childEntityDto.getParentId());
                childEntityDto.setTargetContainerId(targetContainerId);
                return targetContainerId;
            }).toList();
            Map<Long, NodeContainer> containers = copyLoadingEntities.loadChildContainer(entityClassName, ids).stream().collect(Collectors.toMap(Identified::getId, container -> container));
            childEntityDtoResult.childEntityDtos().forEach(childEntityDto -> childEntityDto.setTargetContainer((NodeContainer<TreeNode>)((NodeContainer)containers.get(childEntityDto.getTargetContainerId()))));
            this.copierService.copyNodeToMultipleContainers(childEntityDtoResult.childEntityDtos(), pairingIdsSourceCopyNodeChild, nodeCopierDto);
            offset += StrategyCopierService.MAX_BATCH_SIZE.intValue();
            this.entityManager.clear();
        } while (childEntityDtoResult.hasMore());
        pairs.clear();
    }
}

