/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.copier;

import jakarta.persistence.EntityManager;
import java.util.List;
import java.util.Map;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.copier.CopierService;
import org.squashtest.tm.service.internal.copier.ChildEntityDto;
import org.squashtest.tm.service.internal.copier.NodeCopierDto;
import org.squashtest.tm.service.internal.copier.NodeCopierVisitor;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;

@Service
@Transactional
public class CopierServiceImpl
implements CopierService {
    private final PrivateCustomFieldValueService customFieldValueManagerService;
    private final AttachmentManagerService attachmentManagerService;
    private final MessageSource messageSource;
    private final EntityManager entityManager;

    public CopierServiceImpl(PrivateCustomFieldValueService customFieldValueManagerService, AttachmentManagerService attachmentManagerService, MessageSource messageSource, EntityManager entityManager) {
        this.customFieldValueManagerService = customFieldValueManagerService;
        this.attachmentManagerService = attachmentManagerService;
        this.messageSource = messageSource;
        this.entityManager = entityManager;
    }

    @Override
    public <ENTITY extends TreeNode, NODE extends ENTITY> void copyNodeToContainer(NodeContainer<ENTITY> container, List<NODE> nodes, Map<String, Map<Long, Long>> pairingIdsSourceCopyNode, NodeCopierDto nodeCopierDto) {
        String copySuffix = this.messageSource.getMessage("label.CopySuffix", null, LocaleContextHolder.getLocale());
        NodeCopierVisitor nodeCopierVisitor = new NodeCopierVisitor(this.entityManager, this.attachmentManagerService, container, copySuffix, pairingIdsSourceCopyNode, nodeCopierDto);
        nodes.forEach(source -> {
            boolean projectChanged = !source.getProject().getId().equals(container.getProject().getId());
            nodeCopierVisitor.setProjectChanged(projectChanged);
            nodeCopierVisitor.performCopy((TreeNode)source);
        });
        this.handleCustomField(nodeCopierVisitor, container.getProject().getId());
        this.entityManager.flush();
        nodes.stream().filter(node -> !container.getContent().contains(node)).forEach(arg_0 -> ((EntityManager)this.entityManager).detach(arg_0));
    }

    @Override
    public void copyNodeToMultipleContainers(List<ChildEntityDto> childEntityDtos, Map<String, Map<Long, Long>> pairingIdsSourceCopyNode, NodeCopierDto nodeCopierDto) {
        if (childEntityDtos.isEmpty()) {
            return;
        }
        String copySuffix = this.messageSource.getMessage("label.CopySuffix", null, LocaleContextHolder.getLocale());
        NodeCopierVisitor nodeCopierVisitor = new NodeCopierVisitor(this.entityManager, this.attachmentManagerService, null, copySuffix, pairingIdsSourceCopyNode, nodeCopierDto);
        childEntityDtos.forEach(childEntityDto -> {
            nodeCopierVisitor.setDestination(childEntityDto.getTargetContainer());
            childEntityDto.getChildren().forEach(source -> {
                boolean projectChanged = !source.getProject().getId().equals(childEntityDto.getTargetContainer().getProject().getId());
                nodeCopierVisitor.setProjectChanged(projectChanged);
                nodeCopierVisitor.performCopy((TreeNode)source);
            });
        });
        this.handleCustomField(nodeCopierVisitor, childEntityDtos.getFirst().getTargetContainer().getProject().getId());
        this.entityManager.flush();
    }

    private void handleCustomField(NodeCopierVisitor nodeCopierVisitor, Long projectId) {
        this.customFieldValueManagerService.copyCustomFieldValues(nodeCopierVisitor.getBoundEntityCopies());
        this.customFieldValueManagerService.copyCustomFieldValuesOnProjectChanged(nodeCopierVisitor.getBoundEntityCopiesProjectChanged(), projectId);
        if (!nodeCopierVisitor.getBoundEntityCreation().isEmpty()) {
            nodeCopierVisitor.getBoundEntityCreation().forEach((bindableEntity, boundEntities) -> this.customFieldValueManagerService.batchFolderCustomFieldValuesCreation(boundEntities, (BindableEntity)bindableEntity, projectId));
        }
    }
}

