/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.chart;

import com.querydsl.core.Tuple;
import com.querydsl.core.group.GroupBy;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.chart.ChartDefinition;
import org.squashtest.tm.domain.chart.ChartInstance;
import org.squashtest.tm.domain.chart.ChartSeries;
import org.squashtest.tm.domain.customreport.CustomReportCustomExport;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.domain.customreport.CustomReportFolder;
import org.squashtest.tm.domain.customreport.CustomReportLibrary;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntity;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntityVisitor;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.query.QQueryColumnPrototype;
import org.squashtest.tm.domain.query.QueryColumnPrototype;
import org.squashtest.tm.domain.report.ReportDefinition;
import org.squashtest.tm.service.chart.ChartModificationService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.internal.chart.ChartToConfiguredQueryConverter;
import org.squashtest.tm.service.internal.chart.TupleProcessor;
import org.squashtest.tm.service.internal.display.dto.WorkbenchData;
import org.squashtest.tm.service.internal.query.QueryProcessingServiceImpl;
import org.squashtest.tm.service.query.ConfiguredQuery;

@Transactional
@Service(value="squashtest.tm.service.ChartModificationService")
public class ChartModificationServiceImpl
implements ChartModificationService {
    @PersistenceContext
    private EntityManager em;
    @Inject
    private Provider<ChartToConfiguredQueryConverter> converterProvider;
    @Inject
    private QueryProcessingServiceImpl dataFinder;
    @Inject
    private CustomReportLibraryNodeService customReportLibraryNodeService;
    @Inject
    private Provider<TupleProcessor> tupleProcessorProvider;

    @Override
    public void persist(ChartDefinition newChartDefinition) {
        this.em.persist((Object)newChartDefinition);
    }

    @Override
    public ChartDefinition findById(long id) {
        return (ChartDefinition)this.em.find(ChartDefinition.class, (Object)id);
    }

    @Override
    @Transactional(readOnly=true)
    public WorkbenchData getWorkbenchData(Long customReportLibraryNodeId) {
        CustomReportLibraryNode node = this.customReportLibraryNodeService.findCustomReportLibraryNodeById(customReportLibraryNodeId);
        Long projectId = node.getLibrary().getProject().getId();
        Long containerId = this.findContainerId(node);
        return new WorkbenchData(this.getColumnPrototypes(), containerId, projectId);
    }

    private Long findContainerId(final CustomReportLibraryNode node) {
        final Long[] customReportLibraryNodeIds = new Long[1];
        CustomReportTreeEntityVisitor treeEntityVisitor = new CustomReportTreeEntityVisitor(){

            public void visit(CustomReportFolder crf) {
                customReportLibraryNodeIds[0] = node.getId();
            }

            public void visit(CustomReportLibrary crl) {
                customReportLibraryNodeIds[0] = node.getId();
            }

            public void visit(CustomReportDashboard crf) {
                customReportLibraryNodeIds[0] = node.getParent().getId();
            }

            public void visit(ChartDefinition chartDefinition) {
                customReportLibraryNodeIds[0] = node.getParent().getId();
            }

            public void visit(ReportDefinition reportDefinition) {
                customReportLibraryNodeIds[0] = node.getParent().getId();
            }

            public void visit(CustomReportCustomExport crce) {
                customReportLibraryNodeIds[0] = node.getParent().getId();
            }
        };
        node.getEntity().accept(treeEntityVisitor);
        return customReportLibraryNodeIds[0];
    }

    @Override
    public Map<EntityType, Set<QueryColumnPrototype>> getColumnPrototypes() {
        JPAQueryFactory factory = new JPAQueryFactory(this.em);
        QQueryColumnPrototype prototype = QQueryColumnPrototype.queryColumnPrototype;
        Map prototypes = (Map)((JPAQuery)((JPAQuery)factory.from((EntityPath)prototype).where((Predicate)prototype.business.eq(Boolean.valueOf(true)))).orderBy(prototype.id.asc())).transform(GroupBy.groupBy((Expression)prototype.specializedType.entityType).as((Expression)GroupBy.set((Expression)prototype)));
        return prototypes;
    }

    @Override
    public void update(ChartDefinition chartDef) {
        this.em.merge((Object)chartDef);
    }

    @Override
    public ChartInstance generateChart(long chartDefId, List<EntityReference> dynamicScope, Long dashboardId) {
        ChartDefinition def = this.findById(chartDefId);
        return this.generateChart(def, dynamicScope, dashboardId);
    }

    @Override
    public ChartInstance generateChart(ChartDefinition chartDefinition, List<EntityReference> dynamicScope, Long dashboardId) {
        ChartToConfiguredQueryConverter converter = (ChartToConfiguredQueryConverter)this.converterProvider.get();
        ConfiguredQuery configuredQuery = converter.withDefinition(chartDefinition).forDynamicScope(dynamicScope).forDashboard(dashboardId).convert();
        return this.generateChart(chartDefinition, configuredQuery);
    }

    @Override
    public ChartInstance generateChart(ChartDefinition chartDefinition, List<EntityReference> dynamicScope, Long dashboardId, boolean isCampaignLastExecScope) {
        ChartToConfiguredQueryConverter converter = (ChartToConfiguredQueryConverter)this.converterProvider.get();
        ConfiguredQuery configuredQuery = converter.withDefinition(chartDefinition).forDynamicScope(dynamicScope).forDashboard(dashboardId).forScopeFilter(isCampaignLastExecScope).convert();
        return this.generateChart(chartDefinition, configuredQuery);
    }

    @Override
    public ChartInstance generateChart(ChartDefinition chartDef, Long projectId) {
        if (chartDef.getProject() == null) {
            Project project = (Project)this.em.find(Project.class, (Object)projectId);
            chartDef.setProject(project);
        }
        ChartToConfiguredQueryConverter converter = (ChartToConfiguredQueryConverter)this.converterProvider.get();
        ConfiguredQuery configuredQuery = converter.withDefinition(chartDef).convert();
        return this.generateChart(chartDef, configuredQuery);
    }

    @Override
    @PreAuthorize(value="hasPermission(#definition.id, 'org.squashtest.tm.domain.chart.ChartDefinition' ,'WRITE')  or hasRole('ROLE_ADMIN')")
    public void updateDefinition(ChartDefinition definition, Long id) {
        ChartDefinition oldDef = this.customReportLibraryNodeService.findChartDefinitionByNodeId(id);
        definition.setProject(oldDef.getProject());
        definition.setCreatedBy(oldDef.getCreatedBy());
        definition.setCreatedOn(oldDef.getCreatedOn());
        if (!definition.getName().equals(oldDef.getName())) {
            CustomReportLibraryNode node = this.customReportLibraryNodeService.findNodeFromEntity((CustomReportTreeEntity)oldDef);
            node.renameNode(definition.getName());
        }
        this.em.merge((Object)definition);
    }

    @Override
    public ChartInstance generateChartForMilestoneDashboard(ChartDefinition chart, Long milestoneId, Workspace workspace, boolean isCampaignLastExecScope) {
        ChartToConfiguredQueryConverter converter = (ChartToConfiguredQueryConverter)this.converterProvider.get();
        ConfiguredQuery configuredQuery = converter.withDefinition(chart).forMilestone(milestoneId).forWorkspace(workspace).forScopeFilter(isCampaignLastExecScope).convert();
        return this.generateChart(chart, configuredQuery);
    }

    @Override
    public ChartInstance generateChartInMilestoneMode(ChartDefinition chart, List<EntityReference> scope, Workspace workspace, boolean isCampaignLastExecScope) {
        ChartToConfiguredQueryConverter converter = (ChartToConfiguredQueryConverter)this.converterProvider.get();
        ConfiguredQuery configuredQuery = converter.withDefinition(chart).forCurrentActiveMilestone().forDynamicScope(scope).forWorkspace(workspace).forScopeFilter(isCampaignLastExecScope).convert();
        return this.generateChart(chart, configuredQuery);
    }

    private ChartInstance generateChart(ChartDefinition definition, ConfiguredQuery configuredQuery) {
        List<Tuple> tuples = this.dataFinder.executeQuery(configuredQuery);
        TupleProcessor processor = (TupleProcessor)this.tupleProcessorProvider.get();
        ChartSeries series = processor.setDefinition(definition).initialize().process(tuples).createChartSeries();
        return new ChartInstance(definition, series);
    }
}

