/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.actionword;

import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.actionword.ActionWordLibraryNode;
import org.squashtest.tm.domain.actionword.ActionWordTreeDefinition;
import org.squashtest.tm.domain.tree.TreeLibraryNode;
import org.squashtest.tm.service.internal.dto.json.JsTreeNode;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Component(value="actionWord.nodeBuilder")
public class ActionWordTreeNodeBuilder {
    private static final String[] PERM_NAMES = new String[]{Permissions.WRITE.name(), Permissions.CREATE.name(), Permissions.DELETE.name(), Permissions.EXECUTE.name(), Permissions.EXPORT.name()};
    private static final Permissions[] NODE_PERMISSIONS = new Permissions[]{Permissions.WRITE, Permissions.CREATE, Permissions.DELETE, Permissions.EXECUTE, Permissions.EXPORT};
    public static final String ACTION_WORD_LIBRARY_ID_BUILDER = "ActionWordLibrary-";
    public static final String ACTION_WORD_ID_BUILDER = "ActionWord-";
    private final PermissionEvaluationService permissionEvaluationService;

    @Inject
    public ActionWordTreeNodeBuilder(PermissionEvaluationService permissionEvaluationService) {
        this.permissionEvaluationService = permissionEvaluationService;
    }

    public List<JsTreeNode> build(List<ActionWordLibraryNode> nodes) {
        return nodes.stream().map(this::build).toList();
    }

    public JsTreeNode build(ActionWordLibraryNode awln) {
        JsTreeNode builtNode = new JsTreeNode();
        builtNode.setTitle(HtmlUtils.htmlEscape((String)awln.getName()));
        builtNode.addAttr("resId", String.valueOf(awln.getId()));
        builtNode.addAttr("name", HtmlUtils.htmlEscape((String)awln.getName()));
        this.doPermissionCheck(builtNode, awln);
        ActionWordTreeDefinition entityType = awln.getEntityType();
        switch (entityType) {
            case LIBRARY: {
                this.doLibraryBuild(builtNode, awln);
                break;
            }
            case ACTION_WORD: {
                this.doActionWordBuild(builtNode, awln);
                break;
            }
            case FOLDER: {
                throw new UnsupportedOperationException("To be continued...");
            }
            default: {
                throw new UnsupportedOperationException("The node builder isn't implemented for node of type : " + String.valueOf(entityType));
            }
        }
        return builtNode;
    }

    private void doPermissionCheck(JsTreeNode builtNode, ActionWordLibraryNode awln) {
        Map<String, Boolean> permByName = this.permissionEvaluationService.hasRoleOrPermissionsOnObject("ROLE_ADMIN", PERM_NAMES, awln);
        Permissions[] permissionsArray = NODE_PERMISSIONS;
        int n = NODE_PERMISSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            Permissions perm = permissionsArray[n2];
            builtNode.addAttr(perm.name(), permByName.get(perm.name()).toString());
            ++n2;
        }
    }

    private void doLibraryBuild(JsTreeNode builtNode, ActionWordLibraryNode awln) {
        this.setNodeHTMLId(builtNode, ACTION_WORD_LIBRARY_ID_BUILDER + String.valueOf(awln.getId()));
        this.setNodeRel(builtNode, "drive");
        this.setNodeResType(builtNode, "action-word-libraries");
        this.setStateForNodeContainer(builtNode, (TreeLibraryNode)awln);
    }

    private void setNodeHTMLId(JsTreeNode builtNode, String id) {
        builtNode.addAttr("id", id);
    }

    private void setNodeRel(JsTreeNode builtNode, String rel) {
        builtNode.addAttr("rel", rel);
    }

    private void setNodeResType(JsTreeNode builtNode, String resType) {
        builtNode.addAttr("resType", resType);
    }

    private void setStateForNodeContainer(JsTreeNode builtNode, TreeLibraryNode tln) {
        if (tln.hasContent()) {
            builtNode.setState(JsTreeNode.State.closed);
        } else {
            builtNode.setState(JsTreeNode.State.leaf);
        }
    }

    private void doActionWordBuild(JsTreeNode builtNode, ActionWordLibraryNode awln) {
        this.setNodeHTMLId(builtNode, ACTION_WORD_ID_BUILDER + String.valueOf(awln.getId()));
        this.setNodeRel(builtNode, "action-word");
        this.setNodeResType(builtNode, "action-words");
        this.setStateForNodeContainer(builtNode, (TreeLibraryNode)awln);
    }
}

