/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.actionword;

import java.util.List;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.actionword.ActionWordLibraryNode;
import org.squashtest.tm.domain.actionword.ActionWordTreeLibraryNode;
import org.squashtest.tm.service.internal.repository.ActionWordLibraryNodeDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Component
public class ActionWordLibraryNodeMover {
    private final PermissionEvaluationService permissionEvaluationService;
    private final ActionWordLibraryNodeDao actionWordLibraryNodeDao;

    public ActionWordLibraryNodeMover(PermissionEvaluationService permissionEvaluationService, ActionWordLibraryNodeDao actionWordLibraryNodeDao) {
        this.permissionEvaluationService = permissionEvaluationService;
        this.actionWordLibraryNodeDao = actionWordLibraryNodeDao;
    }

    public void moveNodes(List<ActionWordLibraryNode> nodes, ActionWordLibraryNode target, boolean caseInsensitivity) {
        if (this.userCanMoveNodesToTarget(target)) {
            this.moveFirstLayerNodes(nodes, target, caseInsensitivity);
        }
    }

    private void moveFirstLayerNodes(List<ActionWordLibraryNode> nodes, ActionWordLibraryNode target, boolean caseInsensitivity) {
        List allCanBeCopiedNodeIds = this.actionWordLibraryNodeDao.findAllCanBeCopiedNodesInTarget(nodes, target, caseInsensitivity);
        for (ActionWordLibraryNode node : nodes) {
            if (!this.targetIsNotOriginalParent(target, node) || !this.targetIsNotSelf(target, node) || !allCanBeCopiedNodeIds.contains(node.getId())) continue;
            this.moveOneFirstLayerNode(target, node, caseInsensitivity);
        }
    }

    private void moveOneFirstLayerNode(ActionWordLibraryNode target, ActionWordLibraryNode node, boolean caseInsensitivity) {
        if (this.userCanDeleteMovedNode(node)) {
            ActionWordTreeLibraryNode parent = node.getParent();
            parent.removeChild((ActionWordTreeLibraryNode)node);
            this.changeNodeLibrary(node, target);
            target.addChild((ActionWordTreeLibraryNode)node, caseInsensitivity);
        }
    }

    private void changeNodeLibrary(ActionWordLibraryNode node, ActionWordLibraryNode target) {
        node.setLibrary(target.getLibrary());
        node.getEntity().setProject(target.getLibrary().getProject());
    }

    private boolean userCanDeleteMovedNode(ActionWordLibraryNode node) {
        return this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", "DELETE", node);
    }

    private boolean targetIsNotSelf(ActionWordLibraryNode target, ActionWordLibraryNode node) {
        return !target.equals(node);
    }

    private boolean targetIsNotOriginalParent(ActionWordLibraryNode target, ActionWordLibraryNode node) {
        return !node.getParent().equals(target);
    }

    private boolean userCanMoveNodesToTarget(ActionWordLibraryNode target) {
        return this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", "CREATE", target);
    }
}

