/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase.scripted;

import jakarta.inject.Inject;
import java.util.Date;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.internal.repository.ScriptedTestCaseDao;
import org.squashtest.tm.service.internal.testcase.scripted.gherkin.GherkinStepGenerator;
import org.squashtest.tm.service.internal.testcase.scripted.gherkin.GherkinTestCaseParser;
import org.squashtest.tm.service.testcase.scripted.ScriptedTestCaseService;

@Service
@Transactional
public class ScriptedTestCaseServiceImpl
implements ScriptedTestCaseService {
    @Inject
    private ScriptedTestCaseDao scriptedTestCaseDao;

    @Override
    @CheckBlockingMilestone(entityType=TestCase.class)
    public void updateTcScript(@Id Long testCaseId, String script) {
        ScriptedTestCase scriptedTestCase = (ScriptedTestCase)this.scriptedTestCaseDao.getReferenceById(testCaseId);
        scriptedTestCase.setScript(script);
        ScriptedTestCase auditable = scriptedTestCase;
        auditable.setLastModifiedOn(new Date());
        auditable.setLastModifiedBy(UserContextHolder.getUsername());
    }

    @Override
    public void validateScript(String script) {
        ScriptedTestCase scriptedTestCase = new ScriptedTestCase();
        scriptedTestCase.setScript(script);
        GherkinTestCaseParser parser = new GherkinTestCaseParser(new GherkinStepGenerator());
        parser.validateScript(scriptedTestCase);
    }
}

